/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.ServerTask;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexRebuildTaskIT
extends BaseTest {
    protected static String TENANT1 = "tenant1";
    private static RegionCoprocessorEnvironment TaskRegionEnvironment;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = new HashMap();
        IndexRebuildTaskIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        TaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)IndexRebuildTaskIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    private String generateDDL(String format) {
        StringBuilder optionsBuilder = new StringBuilder();
        if (optionsBuilder.length() != 0) {
            optionsBuilder.append(",");
        }
        optionsBuilder.append("MULTI_TENANT=true");
        return String.format(format, "TENANT_ID VARCHAR NOT NULL, ", "TENANT_ID, ", optionsBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexRebuildTask() throws Throwable {
        String baseTable = IndexRebuildTaskIT.generateUniqueName();
        String viewName = IndexRebuildTaskIT.generateUniqueName();
        Connection conn = null;
        Connection tenantConn = null;
        try {
            conn = DriverManager.getConnection(IndexRebuildTaskIT.getUrl());
            conn.setAutoCommit(false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            props.setProperty("TenantId", TENANT1);
            tenantConn = DriverManager.getConnection(IndexRebuildTaskIT.getUrl(), props);
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( %s PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (%s PK2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            conn.commit();
            String viewDDL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + baseTable;
            tenantConn.createStatement().execute(viewDDL);
            String indexName = IndexRebuildTaskIT.generateUniqueName();
            String idxSDDL = String.format("CREATE INDEX %s ON %s (V1)", indexName, viewName);
            tenantConn.createStatement().execute(idxSDDL);
            int numOfValues = 1000;
            for (int i = 0; i < numOfValues; ++i) {
                tenantConn.createStatement().execute(String.format("UPSERT INTO %s VALUES('%s', '%s', '%s')", viewName, String.valueOf(i), "y", "z"));
            }
            tenantConn.commit();
            TestUtil.waitForIndexRebuild(conn, indexName, PIndexState.ACTIVE);
            String viewIndexTableName = MetaDataUtil.getViewIndexPhysicalName((String)baseTable);
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Table indexHTable = queryServices.getTable(Bytes.toBytes((String)viewIndexTableName));
            int count = IndexRebuildTaskIT.getUtility().countRows(indexHTable);
            Assert.assertEquals((long)numOfValues, (long)count);
            tenantConn.createStatement().execute(String.format("ALTER INDEX %s ON %s UNUSABLE", indexName, viewName));
            tenantConn.commit();
            Admin admin = queryServices.getAdmin();
            TableName tableName = TableName.valueOf((String)viewIndexTableName);
            admin.disableTable(tableName);
            admin.truncateTable(tableName, false);
            count = IndexRebuildTaskIT.getUtility().countRows(indexHTable);
            Assert.assertEquals((long)0L, (long)count);
            String data = "{\"IndexName\":\"" + indexName + "\"}";
            TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(TaskRegionEnvironment, 1800000L);
            Timestamp startTs = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            ServerTask.addTask((SystemTaskParams)new SystemTaskParams.SystemTaskParamsBuilder().setConn(conn.unwrap(PhoenixConnection.class)).setTaskType(PTable.TaskType.INDEX_REBUILD).setTenantId(TENANT1).setSchemaName(null).setTableName(viewName).setTaskStatus(PTable.TaskStatus.CREATED.toString()).setData(data).setPriority(null).setStartTs(startTs).setEndTs(null).setAccessCheckEnabled(true).build());
            task.run();
            IndexRebuildTaskIT.waitForTaskState(conn, PTable.TaskType.INDEX_REBUILD, viewName, PTable.TaskStatus.COMPLETED);
            count = IndexRebuildTaskIT.getUtility().countRows(indexHTable);
            Assert.assertEquals((long)numOfValues, (long)count);
        }
        finally {
            if (conn != null) {
                conn.createStatement().execute("DELETE  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TABLE_NAME ='" + viewName + "'");
                conn.commit();
                conn.close();
            }
            if (tenantConn != null) {
                tenantConn.close();
            }
        }
    }

    public static void waitForTaskState(Connection conn, PTable.TaskType taskType, String expectedTableName, PTable.TaskStatus expectedTaskStatus) throws InterruptedException, SQLException {
        int maxTries = 200;
        int nTries = 0;
        String taskStatus = "";
        String taskData = "";
        do {
            Thread.sleep(2000L);
            String stmt = "SELECT *  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TASK_TYPE = " + taskType.getSerializedValue();
            if (expectedTableName != null) {
                stmt = stmt + " AND TABLE_NAME='" + expectedTableName + "'";
            }
            ResultSet rs = conn.createStatement().executeQuery(stmt);
            while (rs.next()) {
                taskStatus = rs.getString("TASK_STATUS");
                taskData = rs.getString("TASK_DATA");
                boolean matchesExpected = expectedTaskStatus.toString().equals(taskStatus);
                if (!matchesExpected) continue;
                return;
            }
        } while (++nTries < maxTries);
        Assert.fail((String)String.format("Ran out of time waiting for current task state %s to become %s. TaskData: %s", taskStatus, expectedTaskStatus, taskData));
    }
}

