/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ImmutableTablePropertiesIT
extends ParallelStatsDisabledIT {
    @Test
    public void testImmutableKeyword() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String immutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        String mutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ImmutableTablePropertiesIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            String ddl = "CREATE IMMUTABLE TABLE  " + immutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) STORE_NULLS=true";
            stmt.execute(ddl);
            ddl = "CREATE TABLE  " + mutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) STORE_NULLS=true";
            stmt.execute(ddl);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable immutableTable = phxConn.getTable(new PTableKey(null, immutableDataTableFullName));
            Assert.assertTrue((String)"IMMUTABLE_ROWS should be set to true", (boolean)immutableTable.isImmutableRows());
            PTable mutableTable = phxConn.getTable(new PTableKey(null, mutableDataTableFullName));
            Assert.assertFalse((String)"IMMUTABLE_ROWS should be set to false", (boolean)mutableTable.isImmutableRows());
        }
    }

    @Test
    public void testImmutableProperty() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String immutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        String mutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ImmutableTablePropertiesIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            String ddl = "CREATE TABLE  " + immutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) IMMUTABLE_ROWS=true";
            stmt.execute(ddl);
            ddl = "CREATE TABLE  " + mutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string))  IMMUTABLE_ROWS=false";
            stmt.execute(ddl);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable immutableTable = phxConn.getTable(new PTableKey(null, immutableDataTableFullName));
            Assert.assertTrue((String)"IMMUTABLE_ROWS should be set to true", (boolean)immutableTable.isImmutableRows());
            PTable mutableTable = phxConn.getTable(new PTableKey(null, mutableDataTableFullName));
            Assert.assertFalse((String)"IMMUTABLE_ROWS should be set to false", (boolean)mutableTable.isImmutableRows());
        }
    }

    @Test
    public void testImmutableKeywordAndProperty() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String immutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        String mutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ImmutableTablePropertiesIT.getUrl(), props);){
            String ddl;
            Statement stmt = conn.createStatement();
            try {
                ddl = "CREATE IMMUTABLE TABLE  " + immutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) IMMUTABLE_ROWS=true";
                stmt.execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.IMMUTABLE_TABLE_PROPERTY_INVALID.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                ddl = "CREATE IMMUTABLE TABLE  " + mutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string))  IMMUTABLE_ROWS=false";
                stmt.execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.IMMUTABLE_TABLE_PROPERTY_INVALID.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testImmutableTableWithStorageSchemeAndColumnEncodingProps() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String immutableDataTableFullName = SchemaUtil.getTableName((String)"", (String)ImmutableTablePropertiesIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ImmutableTablePropertiesIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            try {
                String ddl = "CREATE IMMUTABLE TABLE  " + immutableDataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) COLUMN_ENCODED_BYTES=0, IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS;
                stmt.execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }
}

