/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class GetSetObjectIT
extends ParallelStatsDisabledIT {
    @Test
    public void testNonNumeric() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = GetSetObjectIT.generateUniqueName();
        byte[] bytes = new byte[]{1, 2};
        String characters = "11";
        try (Connection conn = DriverManager.getConnection(GetSetObjectIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement insertStmt = conn.prepareStatement("upsert into " + tableName + "(id, binary_col, varbinary_col, boolean_col, char_col, varchar_col) values (?,?,?,?,?,?)");){
            stmt.executeUpdate("CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, BINARY_COL BINARY(2), VARBINARY_COL VARBINARY, BOOLEAN_COL BOOLEAN, CHAR_COL CHAR(2), VARCHAR_COL VARCHAR)");
            insertStmt.setInt(1, 1);
            insertStmt.setObject(2, bytes);
            insertStmt.setObject(3, bytes);
            insertStmt.setObject(4, Boolean.TRUE);
            insertStmt.setObject(5, characters);
            insertStmt.setObject(6, characters);
            insertStmt.executeUpdate();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select * from " + tableName);
            while (rs.next()) {
                Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(2));
                Assert.assertArrayEquals((byte[])bytes, (byte[])((byte[])rs.getObject(2)));
                Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getObject(2, byte[].class));
                try {
                    rs.getObject(2, Long.class);
                    Assert.fail((String)"We only implement byte[]");
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
                }
                Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(3));
                Assert.assertArrayEquals((byte[])bytes, (byte[])((byte[])rs.getObject(3)));
                Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getObject(3, byte[].class));
                try {
                    rs.getObject(3, Long.class);
                    Assert.fail((String)"We only implement byte[]");
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
                }
                Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getBoolean(4));
                Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject(4));
                Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject(4, Boolean.class));
                try {
                    Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject(3, Long.class));
                    Assert.fail((String)"We only implement Boolean");
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
                }
                Assert.assertEquals((Object)characters, (Object)rs.getString(5));
                Assert.assertEquals((Object)characters, (Object)rs.getObject(5));
                Assert.assertEquals((Object)characters, (Object)rs.getObject(5, String.class));
                try {
                    Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject(5, Boolean.class));
                    Assert.fail((String)"We only implement String");
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
                }
                Assert.assertEquals((Object)characters, (Object)rs.getString(6));
                Assert.assertEquals((Object)characters, (Object)rs.getObject(6));
                Assert.assertEquals((Object)characters, (Object)rs.getObject(6, String.class));
                try {
                    Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject(6, Boolean.class));
                    Assert.fail((String)"We only implement String");
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
                }
            }
        }
    }

    @Test
    public void testNumeric() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = GetSetObjectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(GetSetObjectIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement insertStmt = conn.prepareStatement("upsert into " + tableName + "(id, TINY_COL, SMALL_COL, INT_COL, BIG_COL, FLOAT_COL, DOUBLE_COL, DECIMAL_COL) values (?,?,?,?,?,?,?,?)");){
            stmt.executeUpdate("CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, TINY_COL TINYINT, SMALL_COL SMALLINT, INT_COL INTEGER, BIG_COL BIGINT, FLOAT_COL FLOAT, DOUBLE_COL DOUBLE, DECIMAL_COL DECIMAL)");
            insertStmt.setInt(1, 1);
            insertStmt.setObject(2, Byte.valueOf("1"));
            insertStmt.setObject(3, Short.valueOf("1"));
            insertStmt.setObject(4, Integer.valueOf("1"));
            insertStmt.setObject(5, Long.valueOf("1"));
            insertStmt.setObject(6, Float.valueOf("1.0"));
            insertStmt.setObject(7, Double.valueOf("1.0"));
            insertStmt.setObject(8, BigDecimal.ONE);
            insertStmt.executeUpdate();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)Byte.valueOf("1"), (Object)rs.getObject(2));
            Assert.assertEquals((Object)Short.valueOf("1"), (Object)rs.getObject(3));
            Assert.assertEquals((Object)Integer.valueOf("1"), (Object)rs.getObject(4));
            Assert.assertEquals((Object)Long.valueOf("1"), (Object)rs.getObject(5));
            Assert.assertEquals((Object)Float.valueOf("1.0"), (Object)rs.getObject(6));
            Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)rs.getObject(7));
            Assert.assertEquals((Object)BigDecimal.ONE, (Object)rs.getObject(8));
            for (int i = 2; i <= 8; ++i) {
                Assert.assertEquals((Object)Byte.valueOf("1"), (Object)rs.getByte(i));
                Assert.assertEquals((Object)Byte.valueOf("1"), (Object)rs.getObject(i, Byte.class));
                Assert.assertEquals((Object)Short.valueOf("1"), (Object)rs.getShort(i));
                Assert.assertEquals((Object)Short.valueOf("1"), (Object)rs.getObject(i, Short.class));
                Assert.assertEquals((Object)Integer.valueOf("1"), (Object)rs.getInt(i));
                Assert.assertEquals((Object)Integer.valueOf("1"), (Object)rs.getObject(i, Integer.class));
                Assert.assertEquals((Object)Long.valueOf("1"), (Object)rs.getLong(i));
                Assert.assertEquals((Object)Long.valueOf("1"), (Object)rs.getObject(i, Long.class));
                Assert.assertEquals((Object)Float.valueOf("1.0"), (Object)Float.valueOf(rs.getFloat(i)));
                Assert.assertEquals((Object)Float.valueOf("1.0"), (Object)rs.getObject(i, Float.class));
                Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)rs.getDouble(i));
                Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)rs.getObject(i, Double.class));
                Assert.assertTrue((BigDecimal.ONE.abs().compareTo(rs.getBigDecimal(i)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.ONE.abs().compareTo(rs.getObject(i, BigDecimal.class)) == 0 ? 1 : 0) != 0);
                try {
                    rs.getObject(i, Boolean.class);
                    Assert.fail((String)"Non-numeric types are not supported");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

