/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class GetSetByteBitFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private String TABLE_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        this.TABLE_NAME = GetSetByteBitFunctionEnd2EndIT.generateUniqueName();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(GetSetByteBitFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.TABLE_NAME + " (k VARCHAR NOT NULL PRIMARY KEY, b BINARY(4), vb VARBINARY)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    @Test
    public void test() throws Exception {
        Connection conn = DriverManager.getConnection(GetSetByteBitFunctionEnd2EndIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.TABLE_NAME + " VALUES (?, ?, ?)");
        stmt.setString(1, KEY);
        stmt.setBytes(2, new byte[]{1, 2, 3, 4});
        stmt.setBytes(3, new byte[]{1, 2, 3, 4});
        stmt.executeUpdate();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT GET_BYTE(vb, 1), GET_BYTE(b, 1) FROM " + this.TABLE_NAME + " WHERE GET_BYTE(vb, 1)=2 and GET_BYTE(b, 1)=2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT GET_BIT(b, 0),GET_BIT(b, 9) FROM " + this.TABLE_NAME + " WHERE GET_BIT(vb, 0)=1 and GET_BIT(vb, 9)=1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT SET_BYTE(vb, 1, 1), SET_BYTE(b, 1, 1) FROM " + this.TABLE_NAME);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])new byte[]{1, 1, 3, 4}, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])new byte[]{1, 1, 3, 4}, (byte[])rs.getBytes(2));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT SET_BIT(vb, 8, 1), SET_BIT(b, 8, 1) FROM " + this.TABLE_NAME);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])new byte[]{1, 3, 3, 4}, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])new byte[]{1, 3, 3, 4}, (byte[])rs.getBytes(2));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }
}

