/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ExplainPlanWithStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ExplainPlanWithStatsDisabledIT
extends ParallelStatsDisabledIT {
    private static void initData(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("CREATE TABLE " + tableName + " ( k INTEGER, c1.a bigint,c2.b bigint CONSTRAINT pk PRIMARY KEY (k)) GUIDE_POSTS_WIDTH = 0");
        conn.createStatement().execute("upsert into " + tableName + " values (100,1,3)");
        conn.createStatement().execute("upsert into " + tableName + " values (101,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (102,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (103,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (104,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (105,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (106,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (107,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (108,2,4)");
        conn.createStatement().execute("upsert into " + tableName + " values (109,2,4)");
        conn.commit();
        conn.createStatement().execute("UPDATE STATISTICS " + tableName);
    }

    @Test
    public void testBytesRowsForSelect() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT * FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForUnion() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String tableB = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT * FROM " + tableA + " UNION ALL SELECT * FROM " + tableB;
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            ExplainPlanWithStatsDisabledIT.initData(conn, tableB);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, Lists.newArrayList(), conn);
        }
    }

    @Test
    public void testBytesRowsForHashJoin() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String tableB = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT ta.c1.a, ta.c2.b FROM " + tableA + " ta JOIN " + tableB + " tb ON ta.k = tb.k";
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            ExplainPlanWithStatsDisabledIT.initData(conn, tableB);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, Lists.newArrayList(), conn);
        }
    }

    @Test
    public void testBytesRowsForSortMergeJoin() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String tableB = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT /*+ USE_SORT_MERGE_JOIN */ ta.c1.a, ta.c2.b FROM " + tableA + " ta JOIN " + tableB + " tb ON ta.k = tb.k";
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            ExplainPlanWithStatsDisabledIT.initData(conn, tableB);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, Lists.newArrayList(), conn);
        }
    }

    @Test
    public void testBytesRowsForAggregateQuery() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT count(*) FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForUpsertSelectServerSide() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "UPSERT INTO " + tableA + " SELECT * FROM " + tableA;
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(true);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForUpsertSelectClientSide() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "UPSERT INTO " + tableA + " SELECT * FROM " + tableA;
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(false);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForUpsertValues() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "UPSERT INTO " + tableA + " VALUES (?, ?, ?)";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        binds.add(99);
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            this.assertEstimatesAreZero(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForDeleteServerSide() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "DELETE FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(true);
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForDeleteClientSideExecutedSerially() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "DELETE FROM " + tableA + " where k >= ? LIMIT 2";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(false);
            ExplainPlanWithStatsEnabledIT.Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)200L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimatedRows > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForPointDelete() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "DELETE FROM " + tableA + " where k = ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(100);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(false);
            this.assertEstimatesAreZero(sql, binds, conn);
        }
    }

    @Test
    public void testBytesRowsForSelectExecutedSerially() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String sql = "SELECT * FROM " + tableA + " LIMIT 2";
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            conn.setAutoCommit(false);
            ExplainPlanWithStatsEnabledIT.Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)200L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimatedRows > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEstimatesForUnionWithTablesWithNullAndLargeGpWidth() throws Exception {
        String tableA = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String tableWithLargeGPWidth = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());){
            ExplainPlanWithStatsDisabledIT.initData(conn, tableA);
            long guidePostWidth = 1000000L;
            conn.createStatement().execute("CREATE TABLE " + tableWithLargeGPWidth + " ( k INTEGER, c1.a bigint,c2.b bigint CONSTRAINT pk PRIMARY KEY (k)) GUIDE_POSTS_WIDTH=" + guidePostWidth);
            conn.createStatement().execute("upsert into " + tableWithLargeGPWidth + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + tableWithLargeGPWidth + " values (101,2,4)");
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + tableWithLargeGPWidth);
        }
        conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl());
        try {
            String sql = "SELECT * FROM " + tableA + " UNION ALL SELECT * FROM " + tableWithLargeGPWidth;
            ExplainPlanWithStatsDisabledIT.assertEstimatesAreNull(sql, Lists.newArrayList(), conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testDescTimestampAtBoundary() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)new Properties());
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE FOO(\n                a VARCHAR NOT NULL,\n                b TIMESTAMP NOT NULL,\n                c VARCHAR,\n                CONSTRAINT pk PRIMARY KEY (a, b DESC, c)\n              ) IMMUTABLE_ROWS=true\n                ,SALT_BUCKETS=20");
            String query = "select * from foo where a = 'a' and b >= timestamp '2016-01-28 00:00:00' and b < timestamp '2016-01-29 00:00:00'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)"CLIENT PARALLEL 20-WAY RANGE SCAN OVER FOO [X'00','a',~'2016-01-28 23:59:59.999'] - [X'13','a',~'2016-01-28 00:00:00.000']\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT", (Object)queryPlan);
        }
    }

    @Test
    public void testUseOfRoundRobinIteratorSurfaced() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)new Properties());
        props.put("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl(), props);){
            String tableName = "testUseOfRoundRobinIteratorSurfaced".toUpperCase();
            conn.createStatement().execute("CREATE TABLE " + tableName + "(\n                a VARCHAR NOT NULL,\n                b TIMESTAMP NOT NULL,\n                c VARCHAR,\n                CONSTRAINT pk PRIMARY KEY (a, b DESC, c)\n              ) IMMUTABLE_ROWS=true\n                ,SALT_BUCKETS=20");
            String query = "select * from " + tableName + " where a = 'a' and b >= timestamp '2016-01-28 00:00:00' and b < timestamp '2016-01-29 00:00:00'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 20-WAY ROUND ROBIN RANGE SCAN OVER " + tableName + " [X'00','a',~'2016-01-28 23:59:59.999'] - [X'13','a',~'2016-01-28 00:00:00.000']\n    SERVER FILTER BY FIRST KEY ONLY"), (Object)queryPlan);
        }
    }

    @Test
    public void testRangeScanWithMetadataLookup() throws Exception {
        String tableName = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)new Properties());
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl(), props);){
            String pk1Val;
            int i;
            conn.createStatement().execute("CREATE TABLE " + tableName + "(PK1 VARCHAR NOT NULL, PK2 VARCHAR, COL1 VARCHAR CONSTRAINT pk PRIMARY KEY (PK1, PK2)) SPLIT ON ('b', 'c', 'd')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('0123A', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('#0123A', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('_0123A', 'pk20', 'col10')");
            for (i = 0; i < 25; ++i) {
                pk1Val = "a" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2a', 'col10a')");
                pk1Val = "ab" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2ab', 'col10ab')");
            }
            for (i = 0; i < 25; ++i) {
                pk1Val = "b" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2b', 'col10b')");
                pk1Val = "bc" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2bc', 'col10bc')");
            }
            for (i = 0; i < 25; ++i) {
                pk1Val = "c" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2c', 'col10c')");
                pk1Val = "cd" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2cd', 'col10cd')");
            }
            for (i = 0; i < 25; ++i) {
                pk1Val = "d" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2d', 'col10d')");
                pk1Val = "de" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2de', 'col10de')");
            }
            for (i = 0; i < 25; ++i) {
                pk1Val = "e" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2e', 'col10e')");
                pk1Val = "ef" + i;
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + pk1Val + "', 'pk2ef', 'col10ef')");
            }
            conn.commit();
            String query = "select count(*) from " + tableName + " where PK1 <= 'b'";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)53L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " [*] - ['b']\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)queryPlan);
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes planAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((long)2L, (long)planAttributes.getNumRegionLocationLookups());
            query = "select count(*) from " + tableName + " where PK1 <= 'cd'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)128L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " [*] - ['cd']\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)queryPlan);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            planAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((long)3L, (long)planAttributes.getNumRegionLocationLookups());
            query = "select count(*) from " + tableName + " where PK1 LIKE 'ef%'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)25L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['ef'] - ['eg']\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)queryPlan);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            planAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((long)1L, (long)planAttributes.getNumRegionLocationLookups());
            query = "select count(*) from " + tableName + " where PK1 > 'de'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['de'] - [*]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)queryPlan);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            planAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((long)1L, (long)planAttributes.getNumRegionLocationLookups());
        }
    }

    @Test
    public void testMultiTenantWithMetadataLookup() throws Exception {
        String tableName = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String view01 = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String view02 = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String view03 = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        String view04 = ExplainPlanWithStatsDisabledIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)new Properties());
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl(), props);){
            ExplainPlanAttributes planAttributes;
            ExplainPlan plan;
            String queryPlan;
            ResultSet rs;
            String query;
            String pk2Val;
            int i;
            conn.createStatement().execute("CREATE TABLE " + tableName + "(TENANT_ID VARCHAR NOT NULL, PK2 VARCHAR, COL1 VARCHAR CONSTRAINT pk PRIMARY KEY (TENANT_ID, PK2)) MULTI_TENANT = true SPLIT ON ('b', 'c', 'd')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('0123A', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('#0123A', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('_0123A', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('bcde', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('cdef', 'pk20', 'col10')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('defg', 'pk20', 'col10')");
            conn.commit();
            try (Connection tenantConn = this.getTenantConnection("ab12");){
                tenantConn.createStatement().execute("CREATE VIEW " + view01 + " (COL2 VARCHAR) AS SELECT * FROM " + tableName);
                for (i = 0; i < 25; ++i) {
                    pk2Val = "012" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view01 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col101', 'col201')");
                    pk2Val = "ab" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view01 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col1010', 'col2010')");
                }
                tenantConn.commit();
            }
            tenantConn = this.getTenantConnection("bc12");
            try {
                tenantConn.createStatement().execute("CREATE VIEW " + view02 + " (COL2 VARCHAR) AS SELECT * FROM " + tableName);
                for (i = 0; i < 25; ++i) {
                    pk2Val = "012" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view02 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col101', 'col201')");
                    pk2Val = "ab" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view02 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col1010', 'col2010')");
                }
                tenantConn.commit();
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            tenantConn = this.getTenantConnection("cd12");
            try {
                tenantConn.createStatement().execute("CREATE VIEW " + view03 + " (COL2 VARCHAR) AS SELECT * FROM " + tableName);
                for (i = 0; i < 25; ++i) {
                    pk2Val = "012" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view03 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col101', 'col201')");
                    pk2Val = "ab" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view03 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col1010', 'col2010')");
                }
                tenantConn.commit();
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            tenantConn = this.getTenantConnection("de12");
            try {
                tenantConn.createStatement().execute("CREATE VIEW " + view04 + " (COL2 VARCHAR) AS SELECT * FROM " + tableName);
                for (i = 0; i < 25; ++i) {
                    pk2Val = "012" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view04 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col101', 'col201')");
                    pk2Val = "ab" + i;
                    tenantConn.createStatement().execute("UPSERT INTO " + view04 + "(PK2, COL1, COL2) VALUES ('" + pk2Val + "', 'col1010', 'col2010')");
                }
                tenantConn.commit();
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            tenantConn = this.getTenantConnection("ab12");
            try {
                query = "select count(*) from " + view01;
                rs = tenantConn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)50L, (long)rs.getInt(1));
                rs = tenantConn.createStatement().executeQuery("EXPLAIN " + query);
                queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['ab12']\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)queryPlan);
                plan = tenantConn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                planAttributes = plan.getPlanStepsAsAttributes();
                Assert.assertEquals((long)1L, (long)planAttributes.getNumRegionLocationLookups());
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            tenantConn = this.getTenantConnection("cd12");
            try {
                query = "select * from " + view03 + " order by col2";
                rs = tenantConn.createStatement().executeQuery("EXPLAIN " + query);
                queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['cd12']\n    SERVER SORTED BY [COL2]\nCLIENT MERGE SORT"), (Object)queryPlan);
                plan = tenantConn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                planAttributes = plan.getPlanStepsAsAttributes();
                Assert.assertEquals((long)1L, (long)planAttributes.getNumRegionLocationLookups());
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            tenantConn = this.getTenantConnection("de12");
            try {
                query = "select * from " + view04 + " where col1='col101'";
                rs = tenantConn.createStatement().executeQuery(query);
                int c = 0;
                while (rs.next()) {
                    ++c;
                }
                Assert.assertEquals((long)25L, (long)c);
                rs = tenantConn.createStatement().executeQuery("EXPLAIN " + query);
                String queryPlan2 = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['de12']\n    SERVER FILTER BY COL1 = 'col101'"), (Object)queryPlan2);
                ExplainPlan plan2 = tenantConn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                ExplainPlanAttributes planAttributes2 = plan2.getPlanStepsAsAttributes();
                Assert.assertEquals((long)1L, (long)planAttributes2.getNumRegionLocationLookups());
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
        }
    }

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(ExplainPlanWithStatsDisabledIT.getUrl(), tenantProps);
    }

    public static void assertEstimatesAreNull(String sql, List<Object> binds, Connection conn) throws Exception {
        ExplainPlanWithStatsEnabledIT.Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
        Assert.assertNull((Object)info.estimatedBytes);
        Assert.assertNull((Object)info.estimatedRows);
        Assert.assertNull((Object)info.estimateInfoTs);
    }

    private void assertEstimatesAreZero(String sql, List<Object> binds, Connection conn) throws Exception {
        ExplainPlanWithStatsEnabledIT.Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
        Assert.assertEquals((Object)0L, (Object)info.estimatedBytes);
        Assert.assertEquals((Object)0L, (Object)info.estimatedRows);
        Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
    }
}

