/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ExpFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private static final double ZERO = 1.0E-8;
    private String signedTableName;
    private String unsignedTableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        this.signedTableName = ExpFunctionEnd2EndIT.generateUniqueName();
        this.unsignedTableName = ExpFunctionEnd2EndIT.generateUniqueName();
        try {
            conn = DriverManager.getConnection(ExpFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.signedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub DOUBLE, fl FLOAT, inte INTEGER, lon BIGINT, smalli SMALLINT, tinyi TINYINT)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE TABLE " + this.unsignedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub UNSIGNED_DOUBLE, fl UNSIGNED_FLOAT, inte UNSIGNED_INT, lon UNSIGNED_LONG, smalli UNSIGNED_SMALLINT, tinyi UNSIGNED_TINYINT)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateSignedTable(Connection conn, double data) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.signedTableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setDouble(2, d);
        stmt.setFloat(3, d.floatValue());
        stmt.setInt(4, d.intValue());
        stmt.setLong(5, d.longValue());
        stmt.setShort(6, d.shortValue());
        stmt.setByte(7, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void updateUnsignedTable(Connection conn, double data) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.unsignedTableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setDouble(2, d);
        stmt.setFloat(3, d.floatValue());
        stmt.setInt(4, d.intValue());
        stmt.setLong(5, d.longValue());
        stmt.setShort(6, d.shortValue());
        stmt.setByte(7, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void testSignedNumberSpec(Connection conn, double data) throws Exception {
        this.updateSignedTable(conn, data);
        ResultSet rs = conn.createStatement().executeQuery("SELECT EXP(doub),EXP(fl),EXP(inte),EXP(lon),EXP(smalli),EXP(tinyi) FROM " + this.signedTableName);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertTrue((Math.abs(rs.getDouble(1) - Math.exp(d)) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(2) - Math.exp(d.floatValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(3) - Math.exp(d.intValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(4) - Math.exp(d.longValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(5) - Math.exp(d.shortValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(6) - Math.exp(d.byteValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    private void testUnsignedNumberSpec(Connection conn, double data) throws Exception {
        this.updateUnsignedTable(conn, data);
        ResultSet rs = conn.createStatement().executeQuery("SELECT EXP(doub),EXP(fl),EXP(inte),EXP(lon),EXP(smalli),EXP(tinyi) FROM " + this.unsignedTableName);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertTrue((Math.abs(rs.getDouble(1) - Math.exp(d)) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(2) - Math.exp(d.floatValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(3) - Math.exp(d.intValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(4) - Math.exp(d.longValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(5) - Math.exp(d.shortValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(rs.getDouble(6) - Math.exp(d.byteValue())) < 1.0E-8 ? 1 : 0) != 0);
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void testSignedNumber() throws Exception {
        Connection conn = DriverManager.getConnection(ExpFunctionEnd2EndIT.getUrl());
        for (double d : new double[]{0.0, 1.0, 123.1234}) {
            this.testSignedNumberSpec(conn, d);
        }
    }

    @Test
    public void testUnsignedNumber() throws Exception {
        Connection conn = DriverManager.getConnection(ExpFunctionEnd2EndIT.getUrl());
        for (double d : new double[]{0.0, 1.0, 123.1234}) {
            this.testUnsignedNumberSpec(conn, d);
        }
    }

    @Test
    public void testExpForLeadingPK() throws Exception {
        Connection conn = DriverManager.getConnection(ExpFunctionEnd2EndIT.getUrl());
        String ddl = "create table test (id integer primary key)";
        conn.createStatement().execute(ddl);
        String dml = "upsert into test values (?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        for (int i = 1; i <= 5; ++i) {
            stmt.setInt(1, i);
            stmt.execute();
        }
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("select ID, exp(ID) from test where exp(ID) < 10");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

