/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ExecuteStatementsIT
extends ParallelStatsDisabledIT {
    @Test
    public void testExecuteStatements() throws Exception {
        String tenantId = ExecuteStatementsIT.getOrganizationId();
        String tableName = ExecuteStatementsIT.initATableValues(tenantId, ExecuteStatementsIT.getDefaultSplits(tenantId), ExecuteStatementsIT.getUrl());
        String ptsdbTableName = ExecuteStatementsIT.generateUniqueName();
        String statements = "create table if not exists " + tableName + "   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    a_string varchar(100),\n    b_string varchar(100)\n    CONSTRAINT pk PRIMARY KEY (organization_id,entity_id));\ncreate table " + ptsdbTableName + "   (inst varchar null,\n    host varchar null,\n    \"DATE\" date not null,\n    val decimal\n    CONSTRAINT pk PRIMARY KEY (inst,host,\"DATE\"))\n    split on ('a','j','s');\nalter table " + ptsdbTableName + " add if not exists val decimal;\nalter table " + ptsdbTableName + " drop column if exists blah;\ndrop table if exists FOO.BAR;\nUPSERT INTO " + ptsdbTableName + "(\"DATE\", val, host)     SELECT current_date(), x_integer+2, entity_id FROM " + tableName + " WHERE a_integer >= ?;UPSERT INTO " + ptsdbTableName + "(\"DATE\", val, inst)\n    SELECT \"DATE\"+1, val*10, host FROM " + ptsdbTableName + ";";
        Date now = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(ExecuteStatementsIT.getUrl());
        conn.setAutoCommit(true);
        List<Object> binds = Arrays.asList(6);
        int nStatements = PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), binds);
        Assert.assertEquals((long)7L, (long)nStatements);
        Date then = new Date(System.currentTimeMillis() + 86400000L);
        String query = "SELECT host,inst,\"DATE\",val FROM " + ptsdbTableName + " where inst is not null";
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
        Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
        Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
        Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(70L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
        Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(60L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
        Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(50L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharPadding() throws Exception {
        Connection conn = DriverManager.getConnection(ExecuteStatementsIT.getUrl());
        String tableName = ExecuteStatementsIT.generateUniqueName();
        String rowKey = "hello";
        String testString = "world";
        String query = "create table " + tableName + "(a_id integer not null, \na_string char(10) not null, \nb_string char(8)\nCONSTRAINT my_pk PRIMARY KEY (a_id, a_string))";
        PreparedStatement statement = conn.prepareStatement(query);
        statement.execute();
        statement = conn.prepareStatement("upsert into " + tableName + "    (a_id,     a_string,     b_string)VALUES (?, ?, ?)");
        statement.setInt(1, 1);
        statement.setString(2, rowKey);
        statement.setString(3, testString);
        statement.execute();
        conn.commit();
        String btableName = ExecuteStatementsIT.generateUniqueName();
        ExecuteStatementsIT.ensureTableCreated(ExecuteStatementsIT.getUrl(), btableName, "BTABLE");
        statement = conn.prepareStatement("upsert into " + btableName + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        statement.setString(1, "abc");
        statement.setString(2, "xyz");
        statement.setString(3, "x");
        statement.setInt(4, 9);
        statement.setString(5, "ab");
        statement.setInt(6, 1);
        statement.setInt(7, 1);
        statement.setString(8, "ab");
        statement.setString(9, "morning1");
        statement.execute();
        conn.commit();
        try {
            query = "select a_string, b_string from " + tableName;
            this.assertCharacterPadding(conn.prepareStatement(query), rowKey, testString);
            query = "select a_string, b_string from " + tableName + " where a_id = 1 and a_string = '" + rowKey + "'";
            this.assertCharacterPadding(conn.prepareStatement(query), rowKey, testString);
            query = "select a_string, b_string from " + tableName + " where b_string = '" + testString + "'";
            this.assertCharacterPadding(conn.prepareStatement(query), rowKey, testString);
            query = "select a_string, b_string from " + tableName + " where a_id = 1 and a_string = '" + rowKey + "'";
            this.assertCharacterPadding(conn.prepareStatement(query), rowKey, testString);
            query = "select a_string, b_string from " + tableName + " where a_id = 1 and a_string  = '" + rowKey + testString + "'";
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            query = "select a_string, b_string from " + tableName + " where a_id = 1 and a_string  = 'he'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            String rowKey2 = "good";
            String testString2 = "morning";
            String testString8Char = "morning1";
            String testString10Char = "morning123";
            String upsert = "UPSERT INTO " + tableName + " values (2, '" + rowKey2 + "', '" + testString2 + "') ";
            statement = conn.prepareStatement(upsert);
            statement.execute();
            conn.commit();
            String tenantId = ExecuteStatementsIT.getOrganizationId();
            String atableName = ExecuteStatementsIT.initATableValues(tenantId, ExecuteStatementsIT.getDefaultSplits(tenantId), ExecuteStatementsIT.getUrl());
            upsert = "UPSERT INTO " + tableName + "(a_id, a_string, b_string) SELECT A_INTEGER, A_STRING, B_STRING FROM " + atableName + " WHERE a_string = ?";
            statement = conn.prepareStatement(upsert);
            statement.setString(1, "a");
            int rowsInserted = statement.executeUpdate();
            Assert.assertEquals((long)4L, (long)rowsInserted);
            conn.commit();
            query = "select a_string, b_string from " + tableName + " where a_string  = 'a'";
            this.assertCharacterPadding(conn.prepareStatement(query), "a", "b");
            upsert = "UPSERT INTO " + tableName + " values (3, '" + testString2 + "', '" + testString2 + "') ";
            statement = conn.prepareStatement(upsert);
            statement.execute();
            conn.commit();
            query = "select a_string, b_string from " + tableName + "  where a_id = 3 and a_string = b_string";
            this.assertCharacterPadding(conn.prepareStatement(query), testString2, testString2);
            query = "select a_string, b_string from " + tableName + "  where a_id = 3 and b_string = a_string";
            statement = conn.prepareStatement(query);
            statement.executeQuery();
            this.assertCharacterPadding(conn.prepareStatement(query), testString2, testString2);
            upsert = "UPSERT INTO " + tableName + " values (4, '" + rowKey2 + "', '" + rowKey2 + "') ";
            statement = conn.prepareStatement(upsert);
            statement.execute();
            conn.commit();
            query = "select a_string, b_string from " + tableName + "  where a_id = 4 and b_string = a_string";
            this.assertCharacterPadding(conn.prepareStatement(query), rowKey2, rowKey2);
            upsert = "UPSERT INTO " + tableName + " values (5, '" + testString10Char + "', '" + testString8Char + "') ";
            statement = conn.prepareStatement(upsert);
            statement.execute();
            conn.commit();
            query = "select a_string, b_string from " + tableName + "  where a_id = 5 and b_string = a_string";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            try {
                upsert = "UPSERT INTO " + tableName + "(a_id, a_string, b_string) SELECT x_integer, organization_id, b_string FROM " + atableName + " WHERE a_string = ?";
                statement = conn.prepareStatement(upsert);
                statement.setString(1, "a");
                statement.executeUpdate();
                Assert.fail((String)"Should fail when bigger than expected character is inserted");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)ex.getErrorCode());
            }
            try {
                upsert = "UPSERT INTO " + tableName + "(a_id, a_string, b_string) SELECT y_integer, a_string, entity_id FROM " + atableName + " WHERE a_string = ?";
                statement = conn.prepareStatement(upsert);
                statement.setString(1, "a");
                statement.executeUpdate();
                Assert.fail((String)"Should fail when bigger than expected character is inserted");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)ex.getErrorCode());
            }
            upsert = "UPSERT INTO " + tableName + "(a_id, a_string, b_string) SELECT a_integer, e_string, a_id FROM " + btableName;
            statement = conn.prepareStatement(upsert);
            rowsInserted = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)rowsInserted);
            conn.commit();
            query = "select a_string, b_string from " + tableName + " where a_string  = 'morning1'";
            this.assertCharacterPadding(conn.prepareStatement(query), "morning1", "xyz");
        }
        finally {
            conn.close();
        }
    }

    private void assertCharacterPadding(PreparedStatement statement, String rowKey, String testString) throws SQLException {
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rowKey, (Object)rs.getString(1));
        Assert.assertEquals((Object)testString, (Object)rs.getString(2));
    }
}

