/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClassFinder;
import org.apache.hadoop.hbase.ClassTestFinder;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class End2EndTestDriver
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(End2EndTestDriver.class);
    private static Option SHORT_REGEX_OPTION = new Option("r", true, "Java regex to use selecting tests to run: e.g. .*TestBig.* will select all tests that include TestBig in their name.  Default: .*end2end.*");
    private static Option SKIP_TESTS_OPTION = new Option("n", false, "Print list of End2End test suits without running them.");
    private End2EndTestFilter end2endTestFilter = new End2EndTestFilter();
    private boolean skipTests = false;

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new End2EndTestDriver(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        try {
            this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
            return -1;
        }
        this.setConf(HBaseConfiguration.addHbaseResources((Configuration)this.getConf()));
        return this.doWork();
    }

    @VisibleForTesting
    public CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        String testFilterString = cmdLine.getOptionValue(SHORT_REGEX_OPTION);
        if (testFilterString != null) {
            this.end2endTestFilter.setPattern(testFilterString);
        }
        this.skipTests = cmdLine.hasOption(SKIP_TESTS_OPTION);
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(SHORT_REGEX_OPTION);
        options.addOption(SKIP_TESTS_OPTION);
        return options;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    private Class<?>[] findEnd2EndTestClasses() throws ClassNotFoundException, LinkageError, IOException {
        End2EndFileNameFilter nameFilter = new End2EndFileNameFilter();
        ClassFinder classFinder = new ClassFinder(null, (ClassFinder.FileNameFilter)nameFilter, (ClassFinder.ClassFilter)this.end2endTestFilter);
        Set classes = classFinder.findClasses("org.apache.phoenix.end2end", true);
        return classes.toArray(new Class[classes.size()]);
    }

    protected int doWork() throws Exception {
        IntegrationTestingUtility.setUseDistributedCluster((Configuration)this.getConf());
        Class[] classes = this.findEnd2EndTestClasses();
        System.out.println("Found " + classes.length + " end2end tests to run:");
        for (Class<?> clazz : classes) {
            System.out.println("  " + clazz);
        }
        if (this.skipTests) {
            return 0;
        }
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new End2EndTestListenter(System.out));
        Result result = junit.run(classes);
        return result.wasSuccessful() ? 0 : 1;
    }

    public class End2EndTestFilter
    extends ClassTestFinder.TestClassFilter {
        private Pattern testFilterRe = Pattern.compile(".*end2end.*");

        public void setPattern(String pattern) {
            try {
                this.testFilterRe = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                LOGGER.error("Failed to find tests using pattern '" + pattern + "'. Is it a valid Java regular expression?", (Throwable)e);
                throw e;
            }
        }

        public boolean isCandidateClass(Class<?> c) {
            Annotation[] annotations;
            for (Annotation curAnnotation : annotations = c.getAnnotations()) {
                if (!curAnnotation.toString().contains("NeedsOwnMiniClusterTest")) continue;
                return false;
            }
            return this.testFilterRe.matcher(c.getName()).find() && super.isCandidateClass(c);
        }
    }

    public static class End2EndFileNameFilter
    implements ClassFinder.FileNameFilter {
        public boolean isCandidateFile(String fileName, String absFilePath) {
            return fileName.contains("IT");
        }
    }

    public static class End2EndTestListenter
    extends TextListener {
        private final PrintStream fWriter;
        List<String> completes = new ArrayList<String>();

        public End2EndTestListenter(PrintStream writer) {
            super(writer);
            this.fWriter = writer;
        }

        protected void printHeader(long runTime) {
            this.fWriter.println();
            this.fWriter.println("=========== Test Result ===========");
            this.fWriter.println("Time: " + this.elapsedTimeAsString(runTime));
        }

        public void testStarted(Description description) {
            this.fWriter.println();
            this.fWriter.println("===> " + description.getDisplayName() + " starts");
        }

        public void testFinished(Description description) throws Exception {
            super.testFinished(description);
            this.completes.add(description.getDisplayName());
        }

        void printSummary(Result result) {
            HashSet<String> failures = new HashSet<String>();
            for (Failure f : result.getFailures()) {
                failures.add(f.getTestHeader());
            }
            this.fWriter.println();
            this.fWriter.println("==== Test Summary ====");
            for (String curTest : this.completes) {
                String status = "passed";
                if (failures.contains(curTest)) {
                    status = "failed";
                }
                this.fWriter.println(curTest + "   " + status + "!");
            }
        }

        public void testRunFinished(Result result) {
            this.printHeader(result.getRunTime());
            this.printFailures(result);
            this.printSummary(result);
            this.fWriter.println();
            this.printFooter(result);
        }
    }
}

