/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class EmptyColumnIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmptyColumnIT.class);
    private static int DEFAULT_NUM_ROWS = 5;

    private void assertAllHBaseRowsHaveEmptyColumnCell(byte[] hbaseTableName, byte[] emptyColumnFamilyName, byte[] emptyColumnName, long minTimestamp, int expectedRows) throws IOException, SQLException {
        try (Table tbl = driver.getConnectionQueryServices(EmptyColumnIT.getUrl(), TestUtil.TEST_PROPERTIES).getTable(hbaseTableName);){
            Scan allRows = new Scan();
            allRows.setTimeRange(minTimestamp, minTimestamp + Integer.MAX_VALUE);
            ResultScanner scanner = tbl.getScanner(allRows);
            int numMatchingRows = this.getNumRowsWithEmptyColumnAndMaxTimestamp(scanner, emptyColumnFamilyName, emptyColumnName);
            Assert.assertEquals((String)String.format("Expected rows do match for table = %s at timestamp %d", Bytes.toString((byte[])hbaseTableName), minTimestamp), (long)expectedRows, (long)numMatchingRows);
        }
    }

    private int getNumRowsWithEmptyColumnAndMaxTimestamp(ResultScanner scanner, byte[] emptyColumnFamilyName, byte[] emptyColumnName) {
        int numMatchingRows = 0;
        try {
            Result result = scanner.next();
            while (result != null) {
                boolean emptyColumnHasMaxTimestamp = true;
                if (result.containsColumn(emptyColumnFamilyName, emptyColumnName)) {
                    Cell emptyColumnCell = result.getColumnLatestCell(emptyColumnFamilyName, emptyColumnName);
                    CellScanner cellScanner = result.cellScanner();
                    while (cellScanner.advance()) {
                        Cell current = cellScanner.current();
                        if (CellComparator.getInstance().compareTimestamps(current, emptyColumnCell) >= 0) continue;
                        emptyColumnHasMaxTimestamp &= false;
                    }
                    if (emptyColumnHasMaxTimestamp) {
                        ++numMatchingRows;
                    }
                }
                result = scanner.next();
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getLocalizedMessage());
        }
        return numMatchingRows;
    }

    @Ignore(value="fails with java.lang.ArrayIndexOutOfBoundsException: -1 , fails for both Table and GlobalView indexes")
    public void testWithBasicTenantViewAndTableIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.OtherOptions otherOptions = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        otherOptions.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTablePKColumns().add("ID");
        tableOptions.getTablePKColumnTypes().add("CHAR(15)");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions();
        globalViewOptions.setGlobalViewColumns(PhoenixTestBuilder.DDLDefaults.GLOBAL_VIEW_COLUMNS);
        globalViewOptions.setGlobalViewColumnTypes(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES);
        otherOptions.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withSimpleTenantView().withOtherOptions(otherOptions).build();
        schemaBuilder.withTableIndexDefaults().build();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String id = String.format("00A0y000%07d", rowIndex);
                String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        String tenantConnectUrl = EmptyColumnIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection connection = DriverManager.getConnection(tenantConnectUrl);){
            connection.setAutoCommit(true);
            dataWriter.setConnection(connection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6"}));
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, DEFAULT_NUM_ROWS, 0);
            this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, null);
        }
    }

    @Ignore
    public void testWhenCustomTenantViewWithPKAndGlobalIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
        schemaBuilder.withTableDefaults().withGlobalViewDefaults().withGlobalViewIndexDefaults().withTenantViewDefaults().build();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                String id = String.format("00A0y000%07d", rowIndex);
                String zid = String.format("0050z000%07d", rowIndex);
                return Lists.newArrayList((Object[])new Object[]{id, zid, "a", "b", "c", "d", "e", "f", "g", "h", "i"});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        String tenantConnectUrl = EmptyColumnIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection connection = DriverManager.getConnection(tenantConnectUrl);){
            connection.setAutoCommit(true);
            dataWriter.setConnection(connection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"}));
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
            this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, null);
        }
    }

    @Test
    public void testWithBasicTableAndNoAdditionalCols() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTablePKColumns().add("ID");
        tableOptions.getTablePKColumnTypes().add("CHAR(15)");
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        final PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).build();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
            final String orgId;
            final String kp;
            {
                this.orgId = String.format("00D0x000%s", schemaBuilder.getDataOptions().getUniqueName());
                this.kp = SchemaUtil.normalizeIdentifier((String)schemaBuilder.getEntityKeyPrefix());
            }

            @Override
            public List<Object> getValues(int rowIndex) {
                String id = String.format("00A0y000%07d", rowIndex);
                return Lists.newArrayList((Object[])new Object[]{this.orgId, this.kp, id});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        try (Connection connection = DriverManager.getConnection(EmptyColumnIT.getUrl());){
            connection.setAutoCommit(true);
            dataWriter.setConnection(connection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"OID", "KP", "ID"}));
            dataWriter.setTargetEntity(schemaBuilder.getEntityTableName());
            ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
            this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, null);
        }
    }

    @Test
    public void testWithGlobalViewAndNoAdditionalCols() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.getGlobalViewColumns().clear();
        globalViewOptions.getGlobalViewColumnTypes().clear();
        final PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).build();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
            final String orgId;
            final String kp;
            {
                this.orgId = String.format("00D0x000%s", schemaBuilder.getDataOptions().getUniqueName());
                this.kp = SchemaUtil.normalizeIdentifier((String)schemaBuilder.getEntityKeyPrefix());
            }

            @Override
            public List<Object> getValues(int rowIndex) {
                String id = String.format("00A0y000%07d", rowIndex);
                return Lists.newArrayList((Object[])new Object[]{this.orgId, this.kp, id});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        try (Connection connection = DriverManager.getConnection(EmptyColumnIT.getUrl());){
            connection.setAutoCommit(true);
            dataWriter.setConnection(connection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"OID", "KP", "ID"}));
            dataWriter.setTargetEntity(schemaBuilder.getEntityGlobalViewName());
            ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
            this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, null);
        }
    }

    @Test
    public void testWithCustomTenantViewAndTenantOnlyColumns() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        final PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withTenantViewDefaults().build();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
            final String orgId;
            final String kp;
            {
                this.orgId = String.format("00D0x000%s", schemaBuilder.getDataOptions().getUniqueName());
                this.kp = SchemaUtil.normalizeIdentifier((String)schemaBuilder.getEntityKeyPrefix());
            }

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format("00A0y000%07d", rowIndex);
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{this.orgId, this.kp, zid, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        String tenantConnectUrl = EmptyColumnIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection connection = DriverManager.getConnection(tenantConnectUrl);){
            connection.setAutoCommit(true);
            dataWriter.setConnection(connection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID", "COL7", "COL8", "COL9"}));
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            ArrayList columnsForPartialUpdates = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 5});
            ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
            this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, columnsForPartialUpdates);
        }
    }

    @Test
    public void testWhenTableWithNoIndexAndVariousOptions() throws Exception {
        for (String additionalProps : Lists.newArrayList((Object[])new String[]{"COLUMN_ENCODED_BYTES=0", "DEFAULT_COLUMN_FAMILY='Z'"})) {
            StringBuilder withTableProps = new StringBuilder();
            withTableProps.append("MULTI_TENANT=true,").append(additionalProps);
            for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableColumnFamilyOptions()) {
                PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
                tableOptions.getTablePKColumns().add("ID");
                tableOptions.getTablePKColumnTypes().add("CHAR(15)");
                tableOptions.setTableProps(withTableProps.toString());
                final PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
                schemaBuilder.withTableOptions(tableOptions).withOtherOptions(options).build();
                PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
                    final String orgId;
                    final String kp;
                    {
                        this.orgId = String.format("00D0x000%s", schemaBuilder.getDataOptions().getUniqueName());
                        this.kp = SchemaUtil.normalizeIdentifier((String)schemaBuilder.getEntityKeyPrefix());
                    }

                    @Override
                    public List<Object> getValues(int rowIndex) {
                        Random rnd = new Random();
                        String id = String.format("00A0y000%07d", rowIndex);
                        String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                        String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                        String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                        return Lists.newArrayList((Object[])new Object[]{this.orgId, this.kp, id, col1, col2, col3});
                    }
                };
                PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                Connection connection = DriverManager.getConnection(EmptyColumnIT.getUrl());
                try {
                    connection.setAutoCommit(true);
                    dataWriter.setConnection(connection);
                    dataWriter.setDataSupplier(dataSupplier);
                    dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"OID", "KP", "ID", "COL1", "COL2", "COL3"}));
                    dataWriter.setTargetEntity(schemaBuilder.getEntityTableName());
                    ArrayList columnsForPartialUpdates = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 5});
                    ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
                    this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, columnsForPartialUpdates);
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
        }
    }

    @Test
    public void testWhenTableWithIndexAndVariousOptions() throws Exception {
        for (String additionalProps : Lists.newArrayList((Object[])new String[]{"COLUMN_ENCODED_BYTES=0", "DEFAULT_COLUMN_FAMILY='Z'"})) {
            StringBuilder withTableProps = new StringBuilder();
            withTableProps.append("MULTI_TENANT=true,").append(additionalProps);
            Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
            while (iterator.hasNext()) {
                boolean isTableIndexLocal = (Boolean)iterator.next();
                for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableColumnFamilyOptions()) {
                    PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
                    tableOptions.getTablePKColumns().add("ID");
                    tableOptions.getTablePKColumnTypes().add("CHAR(15)");
                    tableOptions.setTableProps(withTableProps.toString());
                    PhoenixTestBuilder.SchemaBuilder.TableIndexOptions tableIndexOptions = PhoenixTestBuilder.SchemaBuilder.TableIndexOptions.withDefaults();
                    tableIndexOptions.setLocal(isTableIndexLocal);
                    final PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
                    schemaBuilder.withTableOptions(tableOptions).withTableIndexOptions(tableIndexOptions).withOtherOptions(options).build();
                    PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
                        final String orgId;
                        final String kp;
                        {
                            this.orgId = String.format("00D0x000%s", schemaBuilder.getDataOptions().getUniqueName());
                            this.kp = SchemaUtil.normalizeIdentifier((String)schemaBuilder.getEntityKeyPrefix());
                        }

                        @Override
                        public List<Object> getValues(int rowIndex) {
                            Random rnd = new Random();
                            String id = String.format("00A0y000%07d", rowIndex);
                            String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                            String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                            String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                            return Lists.newArrayList((Object[])new Object[]{this.orgId, this.kp, id, col1, col2, col3});
                        }
                    };
                    PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                    Connection connection = DriverManager.getConnection(EmptyColumnIT.getUrl());
                    try {
                        connection.setAutoCommit(true);
                        dataWriter.setConnection(connection);
                        dataWriter.setDataSupplier(dataSupplier);
                        dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"OID", "KP", "ID", "COL1", "COL2", "COL3"}));
                        dataWriter.setTargetEntity(schemaBuilder.getEntityTableName());
                        ArrayList columnsForPartialUpdates = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 5});
                        ArrayList includeColumnPositionOfIndexes = Lists.newArrayList((Object[])new Integer[]{2, null, null});
                        ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, DEFAULT_NUM_ROWS, 0);
                        this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, columnsForPartialUpdates, includeColumnPositionOfIndexes);
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
            }
        }
    }

    @Test
    public void testWhenCustomTenantViewWithNoIndexAndVariousOptions() throws Exception {
        for (String additionalProps : Lists.newArrayList((Object[])new String[]{"COLUMN_ENCODED_BYTES=0", "DEFAULT_COLUMN_FAMILY='Z'"})) {
            StringBuilder withTableProps = new StringBuilder();
            withTableProps.append("MULTI_TENANT=true,").append(additionalProps);
            for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableAndGlobalAndTenantColumnFamilyOptions()) {
                PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
                tableOptions.setTableProps(withTableProps.toString());
                PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
                tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
                schemaBuilder.withTableOptions(tableOptions).withGlobalViewDefaults().withTenantViewOptions(tenantViewOptions).withOtherOptions(options).build();
                PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                    @Override
                    public List<Object> getValues(int rowIndex) {
                        Random rnd = new Random();
                        String id = String.format("00A0y000%07d", rowIndex);
                        String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                        String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                        String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                        String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                        String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                        String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                        String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                        String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                        String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                        return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, col7, col8, col9});
                    }
                };
                PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                String tenantConnectUrl = EmptyColumnIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
                Connection connection = DriverManager.getConnection(tenantConnectUrl);
                try {
                    connection.setAutoCommit(true);
                    dataWriter.setConnection(connection);
                    dataWriter.setDataSupplier(dataSupplier);
                    dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"}));
                    dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    ArrayList columnsForPartialUpdates = Lists.newArrayList((Object[])new Integer[]{0, 7, 9});
                    ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, 0);
                    this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, columnsForPartialUpdates);
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Fails with - Expected rows do match for table = xxxx at timestamp xxx expected:<5> but was:<10>")
    public void testWhenCustomTenantViewWithIndexAndVariousOptions() throws Exception {
        for (String additionalProps : Lists.newArrayList((Object[])new String[]{"COLUMN_ENCODED_BYTES=0", "DEFAULT_COLUMN_FAMILY='Z'"})) {
            StringBuilder withTableProps = new StringBuilder();
            withTableProps.append("MULTI_TENANT=true,").append(additionalProps);
            Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
            while (iterator.hasNext()) {
                boolean isGlobalViewLocal = (Boolean)iterator.next();
                Iterator iterator2 = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
                while (iterator2.hasNext()) {
                    boolean isTenantViewLocal = (Boolean)iterator2.next();
                    for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableAndGlobalAndTenantColumnFamilyOptions()) {
                        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
                        tableOptions.setTableProps(withTableProps.toString());
                        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
                        globalViewIndexOptions.setLocal(isGlobalViewLocal);
                        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
                        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
                        tenantViewIndexOptions.setLocal(isTenantViewLocal);
                        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(EmptyColumnIT.getUrl());
                        schemaBuilder.withTableOptions(tableOptions).withGlobalViewDefaults().withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withTenantViewIndexOptions(tenantViewIndexOptions).withOtherOptions(options).build();
                        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                            @Override
                            public List<Object> getValues(int rowIndex) {
                                Random rnd = new Random();
                                String id = String.format("00A0y000%07d", rowIndex);
                                String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                                String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                                String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                                return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, col7, col8, col9});
                            }
                        };
                        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                        String tenantConnectUrl = EmptyColumnIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
                        Connection connection = DriverManager.getConnection(tenantConnectUrl);
                        try {
                            connection.setAutoCommit(true);
                            dataWriter.setConnection(connection);
                            dataWriter.setDataSupplier(dataSupplier);
                            dataWriter.setUpsertColumns(Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"}));
                            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                            ArrayList columnsForPartialUpdates = Lists.newArrayList((Object[])new Integer[]{0, 7, 9});
                            ArrayList includeColumnPositionOfIndexes = Lists.newArrayList((Object[])new Integer[]{null, 2, 0});
                            try {
                                boolean cfsAreNotNullButEqual;
                                LOGGER.debug(String.format("### BEGIN %s", schemaBuilder.getOtherOptions().getTestName()));
                                ExpectedTestResults expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, DEFAULT_NUM_ROWS);
                                boolean colocated = !(isGlobalViewLocal ^ isTenantViewLocal);
                                boolean cfsAreNull = options.getGlobalViewCFs().get(2) == null && options.getGlobalViewCFs().get(2) == options.getTenantViewCFs().get(0);
                                boolean bl = cfsAreNotNullButEqual = !cfsAreNull && options.getGlobalViewCFs().get(2).equalsIgnoreCase(options.getTenantViewCFs().get(0));
                                if (colocated && (cfsAreNull || cfsAreNotNullButEqual)) {
                                    expectedTestResults = new ExpectedTestResults(DEFAULT_NUM_ROWS, 0, DEFAULT_NUM_ROWS * 2);
                                }
                                this.upsertDataAndRunValidations(DEFAULT_NUM_ROWS, expectedTestResults, dataWriter, schemaBuilder, columnsForPartialUpdates, includeColumnPositionOfIndexes);
                                LOGGER.debug(String.format("### Case => [GlobalView (local) = %b, TenantView (local) = %b] : %s", isGlobalViewLocal, isTenantViewLocal, "Passed"));
                            }
                            catch (AssertionError ae) {
                                try {
                                    LOGGER.debug(String.format("### Case => [GlobalView (local) = %b, TenantView (local) = %b] : %s", isGlobalViewLocal, isTenantViewLocal, ((Throwable)((Object)ae)).getMessage()));
                                }
                                catch (Throwable throwable) {
                                    LOGGER.debug(String.format("### END %s", schemaBuilder.getOtherOptions().getTestName()));
                                    throw throwable;
                                }
                                LOGGER.debug(String.format("### END %s", schemaBuilder.getOtherOptions().getTestName()));
                                continue;
                            }
                            LOGGER.debug(String.format("### END %s", schemaBuilder.getOtherOptions().getTestName()));
                        }
                        finally {
                            if (connection == null) continue;
                            connection.close();
                        }
                    }
                }
            }
        }
    }

    private void upsertDataAndRunValidations(int numRowsToUpsert, ExpectedTestResults expectedTestResults, PhoenixTestBuilder.DataWriter dataWriter, PhoenixTestBuilder.SchemaBuilder schemaBuilder, List<Integer> overriddenColumnsPositions) throws Exception {
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, Lists.newArrayList((Object[])new Integer[0]));
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, Lists.newArrayList((Object[])new Integer[0]));
        if (overriddenColumnsPositions != null && overriddenColumnsPositions.size() > 0) {
            dataWriter.setColumnPositionsToUpdate(overriddenColumnsPositions);
        }
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, Lists.newArrayList((Object[])new Integer[0]));
    }

    private void upsertDataAndRunValidations(int numRowsToUpsert, ExpectedTestResults expectedTestResults, PhoenixTestBuilder.DataWriter dataWriter, PhoenixTestBuilder.SchemaBuilder schemaBuilder, List<Integer> overriddenColumnsPositions, List<Integer> indexedCFPositions) throws Exception {
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, indexedCFPositions);
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, indexedCFPositions);
        if (overriddenColumnsPositions != null && overriddenColumnsPositions.size() > 0) {
            dataWriter.setColumnPositionsToUpdate(overriddenColumnsPositions);
        }
        this.validateEmptyColumnsAreUpdated(this.upsertData(dataWriter, numRowsToUpsert), expectedTestResults, schemaBuilder, indexedCFPositions);
    }

    private long upsertData(PhoenixTestBuilder.DataWriter dataWriter, int numRowsToUpsert) throws Exception {
        long earliestTimestamp = System.currentTimeMillis();
        for (int i = 0; i < numRowsToUpsert; ++i) {
            dataWriter.upsertRow(i);
        }
        return earliestTimestamp;
    }

    private void validateEmptyColumnsAreUpdated(long earliestTimestamp, ExpectedTestResults expectedTestResults, PhoenixTestBuilder.SchemaBuilder schemaBuilder, List<Integer> indexedCFPositions) throws IOException, SQLException {
        String viewIndexSchemaName;
        String dataColumnFamilyName;
        String testDataColumnFamilyName;
        PTable table = schemaBuilder.getBaseTable();
        byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily((PTable)table);
        byte[] emptyColumnName = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME.intValue());
        byte[] hbaseBaseTableName = SchemaUtil.getTableNameAsBytes((String)table.getSchemaName().getString(), (String)table.getTableName().getString());
        byte[] hbaseIndexTableName = Bytes.toBytes((String)"");
        byte[] indexColumnFamilyName = Bytes.toBytes((String)"");
        byte[] hbaseGlobalViewIndexTableName = Bytes.toBytes((String)"");
        byte[] globalViewIndexCFName = Bytes.toBytes((String)"");
        byte[] hbaseTenantViewIndexTableName = Bytes.toBytes((String)"");
        byte[] tenantViewIndexCFName = Bytes.toBytes((String)"");
        boolean assertOnIndexTable = false;
        boolean assertOnGlobalIndexTable = false;
        boolean assertOnTenantIndexTable = false;
        if (schemaBuilder.isTableIndexEnabled() && schemaBuilder.isTableIndexCreated() && indexedCFPositions.size() > 0) {
            String tableIndexName = String.format("IDX_%s", table.getTableName().getString());
            hbaseIndexTableName = schemaBuilder.getTableIndexOptions().isLocal() ? hbaseBaseTableName : SchemaUtil.getTableNameAsBytes((String)table.getSchemaName().getString(), (String)tableIndexName);
            testDataColumnFamilyName = schemaBuilder.getOtherOptions().getTableCFs().get(indexedCFPositions.get(0));
            dataColumnFamilyName = testDataColumnFamilyName == null ? Bytes.toString((byte[])emptyColumnFamilyName) : testDataColumnFamilyName;
            indexColumnFamilyName = Bytes.toBytes((String)(schemaBuilder.getTableIndexOptions().isLocal() ? IndexUtil.getLocalIndexColumnFamily((String)dataColumnFamilyName) : dataColumnFamilyName));
            LOGGER.debug(String.format("### Table Index CF name : %s, Table Index table name : %s", Bytes.toString((byte[])indexColumnFamilyName), Bytes.toString((byte[])hbaseIndexTableName)));
            assertOnIndexTable = true;
        }
        if (schemaBuilder.isGlobalViewIndexEnabled() && schemaBuilder.isGlobalViewIndexCreated() && indexedCFPositions.size() > 0) {
            viewIndexSchemaName = String.format("_IDX_%s", table.getSchemaName().getString());
            hbaseGlobalViewIndexTableName = schemaBuilder.getGlobalViewIndexOptions().isLocal() ? hbaseBaseTableName : SchemaUtil.getTableNameAsBytes((String)viewIndexSchemaName, (String)table.getTableName().getString());
            testDataColumnFamilyName = schemaBuilder.getOtherOptions().getGlobalViewCFs().get(indexedCFPositions.get(1));
            dataColumnFamilyName = testDataColumnFamilyName == null ? Bytes.toString((byte[])emptyColumnFamilyName) : testDataColumnFamilyName;
            globalViewIndexCFName = Bytes.toBytes((String)(schemaBuilder.getGlobalViewIndexOptions().isLocal() ? IndexUtil.getLocalIndexColumnFamily((String)dataColumnFamilyName) : dataColumnFamilyName));
            LOGGER.info(String.format("### Global View Index CF name : %s, Global View Index table name : %s", Bytes.toString((byte[])indexColumnFamilyName), Bytes.toString((byte[])hbaseGlobalViewIndexTableName)));
            assertOnGlobalIndexTable = true;
        }
        if (schemaBuilder.isTenantViewIndexEnabled() && schemaBuilder.isTenantViewIndexCreated() && indexedCFPositions.size() > 0) {
            viewIndexSchemaName = String.format("_IDX_%s", table.getSchemaName().getString());
            hbaseTenantViewIndexTableName = schemaBuilder.getTenantViewIndexOptions().isLocal() ? hbaseBaseTableName : SchemaUtil.getTableNameAsBytes((String)viewIndexSchemaName, (String)table.getTableName().getString());
            testDataColumnFamilyName = schemaBuilder.getOtherOptions().getTenantViewCFs().get(indexedCFPositions.get(2));
            dataColumnFamilyName = testDataColumnFamilyName == null ? Bytes.toString((byte[])emptyColumnFamilyName) : testDataColumnFamilyName;
            tenantViewIndexCFName = Bytes.toBytes((String)(schemaBuilder.getTenantViewIndexOptions().isLocal() ? IndexUtil.getLocalIndexColumnFamily((String)dataColumnFamilyName) : dataColumnFamilyName));
            LOGGER.info(String.format("### Tenant Index CF name : %s, Tenant Index table name : %s", Bytes.toString((byte[])indexColumnFamilyName), Bytes.toString((byte[])hbaseTenantViewIndexTableName)));
            assertOnTenantIndexTable = true;
        }
        this.assertAllHBaseRowsHaveEmptyColumnCell(hbaseBaseTableName, emptyColumnFamilyName, emptyColumnName, earliestTimestamp, expectedTestResults.numTableRowsExpected);
        if (assertOnIndexTable) {
            this.assertAllHBaseRowsHaveEmptyColumnCell(hbaseIndexTableName, indexColumnFamilyName, emptyColumnName, earliestTimestamp, expectedTestResults.numTableIndexRowsExpected);
        }
        if (assertOnGlobalIndexTable) {
            this.assertAllHBaseRowsHaveEmptyColumnCell(hbaseGlobalViewIndexTableName, globalViewIndexCFName, emptyColumnName, earliestTimestamp, expectedTestResults.numViewIndexRowsExpected);
        }
        if (assertOnTenantIndexTable) {
            this.assertAllHBaseRowsHaveEmptyColumnCell(hbaseTenantViewIndexTableName, tenantViewIndexCFName, emptyColumnName, earliestTimestamp, expectedTestResults.numViewIndexRowsExpected);
        }
    }

    private List<PhoenixTestBuilder.SchemaBuilder.ConnectOptions> getConnectOptions() {
        ArrayList testCases = Lists.newArrayList();
        PhoenixTestBuilder.SchemaBuilder.ConnectOptions defaultConnectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
        testCases.add(defaultConnectOptions);
        PhoenixTestBuilder.SchemaBuilder.ConnectOptions globalOnlyConnectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
        globalOnlyConnectOptions.setUseGlobalConnectionOnly(true);
        testCases.add(globalOnlyConnectOptions);
        PhoenixTestBuilder.SchemaBuilder.ConnectOptions tenantOnlyConnectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
        tenantOnlyConnectOptions.setUseTenantConnectionForGlobalView(true);
        testCases.add(tenantOnlyConnectOptions);
        return testCases;
    }

    private List<PhoenixTestBuilder.SchemaBuilder.OtherOptions> getTableColumnFamilyOptions() {
        ArrayList testCases = Lists.newArrayList();
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatch = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatch.setTestName("testCaseWhenAllCFMatch");
        testCaseWhenAllCFMatch.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCases.add(testCaseWhenAllCFMatch);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenManyCFs = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenManyCFs.setTestName("testCaseWhenManyCFs");
        testCaseWhenManyCFs.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCases.add(testCaseWhenManyCFs);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFsAreSpecified = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFsAreSpecified.setTestName("testCaseWhenAllCFsAreSpecified");
        testCaseWhenAllCFsAreSpecified.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCases.add(testCaseWhenAllCFsAreSpecified);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenDefaultCFs = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenDefaultCFs.setTestName("testCaseWhenDefaultCFs");
        testCaseWhenDefaultCFs.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCases.add(testCaseWhenDefaultCFs);
        return testCases;
    }

    private List<PhoenixTestBuilder.SchemaBuilder.OtherOptions> getTableAndGlobalAndTenantColumnFamilyOptions() {
        ArrayList testCases = Lists.newArrayList();
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCases.add(testCaseWhenAllCFMatchAndAllDefault);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndSame = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndSame.setTestName("testCaseWhenAllCFMatchAndSame");
        testCaseWhenAllCFMatchAndSame.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCaseWhenAllCFMatchAndSame.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCaseWhenAllCFMatchAndSame.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCases.add(testCaseWhenAllCFMatchAndSame);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatch = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatch.setTestName("testCaseWhenAllCFMatch");
        testCaseWhenAllCFMatch.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCaseWhenAllCFMatch.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCaseWhenAllCFMatch.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCases.add(testCaseWhenAllCFMatch);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenTableCFsAreDiff = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenTableCFsAreDiff.setTestName("testCaseWhenTableCFsAreDiff");
        testCaseWhenTableCFsAreDiff.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCaseWhenTableCFsAreDiff.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCaseWhenTableCFsAreDiff.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCases.add(testCaseWhenTableCFsAreDiff);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenGlobalAndTenantCFsAreDiff = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenGlobalAndTenantCFsAreDiff.setTestName("testCaseWhenGlobalAndTenantCFsAreDiff");
        testCaseWhenGlobalAndTenantCFsAreDiff.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
        testCaseWhenGlobalAndTenantCFsAreDiff.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCaseWhenGlobalAndTenantCFsAreDiff.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"B", "B", "B"}));
        testCases.add(testCaseWhenGlobalAndTenantCFsAreDiff);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenNoDefaultCF = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenNoDefaultCF.setTestName("testCaseWhenNoDefaultCF");
        testCaseWhenNoDefaultCF.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCaseWhenNoDefaultCF.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCaseWhenNoDefaultCF.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCases.add(testCaseWhenNoDefaultCF);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff.setTestName("testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff");
        testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
        testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"B", "B", "B"}));
        testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCases.add(testCaseWhenNoDefaultCFAndGlobalAndTenantCFsAreDiff);
        return testCases;
    }

    private static class ExpectedTestResults {
        int numTableRowsExpected;
        int numTableIndexRowsExpected;
        int numViewIndexRowsExpected;

        public ExpectedTestResults(int numTableRowsExpected, int numTableIndexRowsExpected, int numViewIndexRowsExpected) {
            this.numTableRowsExpected = numTableRowsExpected;
            this.numTableIndexRowsExpected = numTableIndexRowsExpected;
            this.numViewIndexRowsExpected = numViewIndexRowsExpected;
        }
    }
}

