/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DynamicColumnWildcardIT
extends BaseTest {
    private final boolean mutableTable;
    private final PTable.ImmutableStorageScheme storageScheme;

    @Parameterized.Parameters(name="DynamicColumnWildcardIT_mutable={0}, storageScheme={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, null}, {false, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN});
    }

    public DynamicColumnWildcardIT(boolean mutableTable, PTable.ImmutableStorageScheme storageScheme) {
        this.mutableTable = mutableTable;
        this.storageScheme = storageScheme;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.query.wildcard.dynamicColumns", "true");
        DynamicColumnWildcardIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS, new ReadOnlyProps((Map)clientProps));
    }

    private String generateTableCreateDDL(String tableName, String schema) {
        StringBuilder sb = new StringBuilder("CREATE ");
        if (!this.mutableTable) {
            sb.append("IMMUTABLE ");
        }
        sb.append("TABLE ").append(tableName).append(schema);
        if (!this.mutableTable && this.storageScheme != null) {
            sb.append(" ").append("IMMUTABLE_STORAGE_SCHEME").append("=").append(this.storageScheme);
            sb.append(", ").append("COLUMN_ENCODED_BYTES").append("=1");
        }
        return sb.toString();
    }

    @Test
    public void testOnlySinglePkWithDynamicColumns() throws SQLException {
        Connection conn = DriverManager.getConnection(DynamicColumnWildcardIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicColumnWildcardIT.generateUniqueName();
        conn.createStatement().execute(this.generateTableCreateDDL(tableName, " (A INTEGER PRIMARY KEY)"));
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A) VALUES(10)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, DYN1 INTEGER) VALUES(90, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, DYN1 VARCHAR) VALUES(100, 'test')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        int rsCounter = 0;
        while (rs.next()) {
            ResultSetMetaData rmd = rs.getMetaData();
            int count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter == 0 ? 1L : 2L), (long)count);
            for (int i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)10, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)90, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 2) continue;
                    Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)3, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 2) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)100, (Object)rs.getObject(i));
                    continue;
                }
                if (i != 2) continue;
                Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)"test", (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
    }

    @Test
    public void testSinglePkAndOtherColsWithDynamicColumns() throws SQLException {
        Connection conn = DriverManager.getConnection(DynamicColumnWildcardIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicColumnWildcardIT.generateUniqueName();
        conn.createStatement().execute(this.generateTableCreateDDL(tableName, " (A INTEGER PRIMARY KEY, B VARCHAR)"));
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B) VALUES(10, 'test1')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, DYN1 INTEGER) VALUES(90, 'test2', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, DYN1 INTEGER, DYN2 VARCHAR) VALUES(100, 5, 'test3')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        int rsCounter = 0;
        while (rs.next()) {
            ResultSetMetaData rmd = rs.getMetaData();
            int count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter == 0 ? 2L : (rsCounter == 1 ? 3L : 4L)), (long)count);
            for (int i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)10, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 2) continue;
                    Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test1", (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)90, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)"test2", (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)3, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 2) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)100, (Object)rs.getObject(i));
                    continue;
                }
                if (i == 2) {
                    Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals(null, (Object)rs.getObject(i));
                    continue;
                }
                if (i == 3) {
                    Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)5, (Object)rs.getObject(i));
                    continue;
                }
                if (i != 4) continue;
                Assert.assertEquals((Object)"DYN2", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)"test3", (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
    }

    @Test
    public void testCompositeKeyWithDynamicColumns() throws SQLException {
        Connection conn = DriverManager.getConnection(DynamicColumnWildcardIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicColumnWildcardIT.generateUniqueName();
        conn.createStatement().execute(this.generateTableCreateDDL(tableName, " (A INTEGER NOT NULL, B INTEGER NOT NULL CONSTRAINT PK PRIMARY KEY (A, B))"));
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B) VALUES(10, 500)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, DYN1 INTEGER) VALUES(90, 100, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, DYN2 VARCHAR) VALUES(999, 50, 'test1')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        int rsCounter = 0;
        while (rs.next()) {
            ResultSetMetaData rmd = rs.getMetaData();
            int count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter == 0 ? 2L : 3L), (long)count);
            for (int i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)10, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 2) continue;
                    Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)500, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)90, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)100, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)3, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 2) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)999, (Object)rs.getObject(i));
                    continue;
                }
                if (i == 2) {
                    Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)50, (Object)rs.getObject(i));
                    continue;
                }
                if (i != 3) continue;
                Assert.assertEquals((Object)"DYN2", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)"test1", (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
    }

    @Test
    public void testCompositeKeyAndOtherColsWithDynamicColumns() throws SQLException {
        Connection conn = DriverManager.getConnection(DynamicColumnWildcardIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicColumnWildcardIT.generateUniqueName();
        conn.createStatement().execute(this.generateTableCreateDDL(tableName, " (A INTEGER NOT NULL, B INTEGER NOT NULL, C VARCHAR CONSTRAINT PK PRIMARY KEY (A, B))"));
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B) VALUES(10, 500)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C) VALUES(20, 7, 'test1')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, DYN1 INTEGER) VALUES(30, 100, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, DYN2 VARCHAR, DYN3 BIGINT) VALUES(40, 60, 'test1', 'test2', 8)");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        int rsCounter = 0;
        while (rs.next()) {
            ResultSetMetaData rmd = rs.getMetaData();
            int count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter <= 1 ? 3L : (rsCounter == 2 ? 4L : 5L)), (long)count);
            for (int i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)10, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)500, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals(null, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)20, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)7, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test1", (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 2) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)30, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)100, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 3) {
                        Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                        Assert.assertEquals(null, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 4) continue;
                    Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)3, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 3) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"A", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)40, (Object)rs.getObject(i));
                    continue;
                }
                if (i == 2) {
                    Assert.assertEquals((Object)"B", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)60, (Object)rs.getObject(i));
                    continue;
                }
                if (i == 3) {
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test1", (Object)rs.getObject(i));
                    continue;
                }
                if (i == 4) {
                    Assert.assertEquals((Object)"DYN2", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test2", (Object)rs.getObject(i));
                    continue;
                }
                if (i != 5) continue;
                Assert.assertEquals((Object)"DYN3", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)-5L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)8L, (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
    }

    @Test
    public void testColumnFamilyWildcards() throws SQLException {
        int i;
        int count;
        ResultSetMetaData rmd;
        Connection conn = DriverManager.getConnection(DynamicColumnWildcardIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicColumnWildcardIT.generateUniqueName();
        conn.createStatement().execute(this.generateTableCreateDDL(tableName, " (A INTEGER PRIMARY KEY, B VARCHAR, CF1.C INTEGER, CF2.D VARCHAR)"));
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, D) VALUES(10, 'test1', 2, 'test2')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, D, DYN0 INTEGER) VALUES(20, 'test3', 4, 'test4', 100)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, D, CF1.DYN1 VARCHAR, CF1.DYN2 INTEGER) VALUES(30, 'test5', 5, 'test6', 'test7', 70)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, D, CF2.DYN1 VARCHAR, CF2.DYN2 INTEGER) VALUES(40, 'test8', 6, 'test9', 'test10', 80)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (A, B, C, D, CF1.DYN3 VARCHAR, CF2.DYN4 INTEGER) VALUES(50, 'test11', 7, 'test12', 'test13', 90)");
        ResultSet rs = conn.createStatement().executeQuery("SELECT CF1.* FROM " + tableName);
        int rsCounter = 0;
        while (rs.next()) {
            rmd = rs.getMetaData();
            count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter <= 1 || rsCounter == 3 ? 1L : (rsCounter == 2 ? 3L : 2L)), (long)count);
            for (i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)2, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)4, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 2) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)5, (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)"test7", (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"DYN2", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)70, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 3) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)6, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 4) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"C", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)7, (Object)rs.getObject(i));
                    continue;
                }
                if (i != 2) continue;
                Assert.assertEquals((Object)"DYN3", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)"test13", (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
        rs = conn.createStatement().executeQuery("SELECT CF2.* FROM " + tableName);
        rsCounter = 0;
        while (rs.next()) {
            rmd = rs.getMetaData();
            count = rmd.getColumnCount();
            Assert.assertEquals((long)(rsCounter <= 2 ? 1L : (rsCounter == 3 ? 3L : 2L)), (long)count);
            for (i = 1; i <= count; ++i) {
                if (rsCounter == 0) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"D", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test2", (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 1) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"D", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test4", (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 2) {
                    if (i != 1) continue;
                    Assert.assertEquals((Object)"D", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test6", (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter == 3) {
                    if (i == 1) {
                        Assert.assertEquals((Object)"D", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)"test9", (Object)rs.getObject(i));
                        continue;
                    }
                    if (i == 2) {
                        Assert.assertEquals((Object)"DYN1", (Object)rmd.getColumnName(i));
                        Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                        Assert.assertEquals((Object)"test10", (Object)rs.getObject(i));
                        continue;
                    }
                    if (i != 3) continue;
                    Assert.assertEquals((Object)"DYN2", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)80, (Object)rs.getObject(i));
                    continue;
                }
                if (rsCounter != 4) continue;
                if (i == 1) {
                    Assert.assertEquals((Object)"D", (Object)rmd.getColumnName(i));
                    Assert.assertEquals((long)12L, (long)rmd.getColumnType(i));
                    Assert.assertEquals((Object)"test12", (Object)rs.getObject(i));
                    continue;
                }
                if (i != 2) continue;
                Assert.assertEquals((Object)"DYN4", (Object)rmd.getColumnName(i));
                Assert.assertEquals((long)4L, (long)rmd.getColumnType(i));
                Assert.assertEquals((Object)90, (Object)rs.getObject(i));
            }
            ++rsCounter;
        }
    }
}

