/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class DropTableWithViewsIT
extends SplitSystemCatalogIT {
    private final boolean isMultiTenant;
    private final boolean columnEncoded;
    private final String TENANT_SPECIFIC_URL1 = DropTableWithViewsIT.getUrl() + ";TenantId=" + TENANT1;
    public static final Logger LOGGER = LoggerFactory.getLogger(DropTableWithViewsIT.class);
    private static RegionCoprocessorEnvironment TaskRegionEnvironment;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        serverProps.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        SplitSystemCatalogIT.doSetup(serverProps);
        TaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)DropTableWithViewsIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    public DropTableWithViewsIT(boolean isMultiTenant, boolean columnEncoded) {
        this.isMultiTenant = isMultiTenant;
        this.columnEncoded = columnEncoded;
    }

    @Parameterized.Parameters(name="DropTableWithViewsIT_multiTenant={0}, columnEncoded={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    private String generateDDL(String format) {
        return this.generateDDL("", format);
    }

    private String generateDDL(String options, String format) {
        StringBuilder optionsBuilder = new StringBuilder(options);
        if (!this.columnEncoded) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (this.isMultiTenant) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("MULTI_TENANT=true");
        }
        return String.format(format, this.isMultiTenant ? "TENANT_ID VARCHAR NOT NULL, " : "", this.isMultiTenant ? "TENANT_ID, " : "", optionsBuilder.toString());
    }

    @Test
    public void testDropTableWithChildViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)DropTableWithViewsIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(DropTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            conn.setAutoCommit(true);
            viewConn.setAutoCommit(true);
            conn.createStatement().execute("DELETE  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( %s PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (%s PK2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            for (int i = 0; i < 4; ++i) {
                String childView = SchemaUtil.getTableName((String)SCHEMA2, (String)DropTableWithViewsIT.generateUniqueName());
                String childViewDDL = "CREATE VIEW " + childView + " AS SELECT * FROM " + baseTable;
                viewConn.createStatement().execute(childViewDDL);
                for (int j = 0; j < 4; ++j) {
                    String grandChildView = SchemaUtil.getTableName((String)SCHEMA2, (String)DropTableWithViewsIT.generateUniqueName());
                    String grandChildViewDDL = "CREATE VIEW " + grandChildView + " AS SELECT * FROM " + childView;
                    viewConn.createStatement().execute(grandChildViewDDL);
                }
            }
            String dropTable = String.format("DROP TABLE IF EXISTS %s CASCADE", baseTable);
            conn.createStatement().execute(dropTable);
            TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(TaskRegionEnvironment, 1800000L);
            task.run();
            task.run();
            DropTableWithViewsIT.assertTaskColumns(conn, PTable.TaskStatus.COMPLETED.toString(), PTable.TaskType.DROP_CHILD_VIEWS, null, null, null, null, null);
            TableName linkTable = TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES);
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            ViewUtil.findAllRelatives((Table)DropTableWithViewsIT.getUtility().getConnection().getTable(linkTable), (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])SchemaUtil.getSchemaNameFromFullName((String)baseTable).getBytes(), (byte[])SchemaUtil.getTableNameFromFullName((String)baseTable).getBytes(), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)childViewsResult);
            Assert.assertTrue((childViewsResult.getLinks().size() == 0 ? 1 : 0) != 0);
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_SCHEM = '" + SCHEMA2 + "'");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public static void assertTaskColumns(Connection conn, String expectedStatus, PTable.TaskType taskType, String expectedTableName, String expectedTenantId, String expectedSchema, Timestamp expectedTs, String expectedIndexName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT *  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TASK_TYPE = " + taskType.getSerializedValue());
        Assert.assertTrue((boolean)rs.next());
        String taskStatus = rs.getString("TASK_STATUS");
        Assert.assertEquals((Object)expectedStatus, (Object)taskStatus);
        if (expectedTableName != null) {
            String tableName = rs.getString("TABLE_NAME");
            Assert.assertEquals((Object)expectedTableName, (Object)tableName);
        }
        if (expectedTenantId != null) {
            String tenantId = rs.getString("TENANT_ID");
            Assert.assertEquals((Object)expectedTenantId, (Object)tenantId);
        }
        if (expectedSchema != null) {
            String schema = rs.getString("TABLE_SCHEM");
            Assert.assertEquals((Object)expectedSchema, (Object)schema);
        }
        if (expectedTs != null) {
            Timestamp ts = rs.getTimestamp("TASK_TS");
            Assert.assertEquals((Object)expectedTs, (Object)ts);
        }
        if (expectedIndexName != null) {
            String data = rs.getString("TASK_DATA");
            Assert.assertEquals((Object)true, (Object)data.contains("\"IndexName\":\"" + expectedIndexName));
        }
    }
}

