/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class DropIndexedColsIT
extends SplitSystemCatalogIT {
    private static final String CREATE_TABLE_COL_QUERY = " (%s k VARCHAR NOT NULL, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR, v4 VARCHAR, v5 VARCHAR CONSTRAINT PK PRIMARY KEY(%s k))%s";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static final String CREATE_VIEW = "CREATE VIEW ";
    private static final String CREATE_INDEX = "CREATE INDEX ";
    private static final String SELECT_ALL_FROM = "SELECT * FROM ";
    private static final String UPSERT_INTO = "UPSERT INTO ";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private final boolean salted;
    private final String TENANT_SPECIFIC_URL = DropIndexedColsIT.getUrl() + ";TenantId=" + TENANT1;

    public DropIndexedColsIT(boolean salted) {
        this.salted = salted;
    }

    @Parameterized.Parameters(name="DropIndexedColsIT_salted={0}")
    public static Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    @Test
    public void testDropIndexedColsMultiTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(DropIndexedColsIT.getUrl());
             Connection viewConn = DriverManager.getConnection(this.TENANT_SPECIFIC_URL);){
            String tableWithView1 = SchemaUtil.getTableName((String)SCHEMA1, (String)DropIndexedColsIT.generateUniqueName());
            String tableWithView2 = SchemaUtil.getTableName((String)SCHEMA3, (String)DropIndexedColsIT.generateUniqueName());
            String viewOfTable1 = SchemaUtil.getTableName((String)SCHEMA2, (String)DropIndexedColsIT.generateUniqueName());
            String viewOfTable2 = SchemaUtil.getTableName((String)SCHEMA4, (String)DropIndexedColsIT.generateUniqueName());
            String viewSchemaName1 = SchemaUtil.getSchemaNameFromFullName((String)viewOfTable1);
            String viewSchemaName2 = SchemaUtil.getSchemaNameFromFullName((String)viewOfTable2);
            String viewIndex1 = DropIndexedColsIT.generateUniqueName();
            String viewIndex2 = DropIndexedColsIT.generateUniqueName();
            String viewIndex3 = DropIndexedColsIT.generateUniqueName();
            String viewIndex4 = DropIndexedColsIT.generateUniqueName();
            String viewIndex5 = DropIndexedColsIT.generateUniqueName();
            String fullNameViewIndex1 = SchemaUtil.getTableName((String)viewSchemaName1, (String)viewIndex1);
            String fullNameViewIndex2 = SchemaUtil.getTableName((String)viewSchemaName1, (String)viewIndex2);
            String fullNameViewIndex3 = SchemaUtil.getTableName((String)viewSchemaName2, (String)viewIndex3);
            String fullNameViewIndex4 = SchemaUtil.getTableName((String)viewSchemaName2, (String)viewIndex4);
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            String ddlFormat = CREATE_TABLE + tableWithView1 + CREATE_TABLE_COL_QUERY;
            String ddlFormat2 = CREATE_TABLE + tableWithView2 + CREATE_TABLE_COL_QUERY;
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            conn.createStatement().execute(this.generateDDL(ddlFormat2));
            viewConn.createStatement().execute(CREATE_VIEW + viewOfTable1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableWithView1);
            viewConn.createStatement().execute(CREATE_VIEW + viewOfTable2 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableWithView2);
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex1 + " ON " + viewOfTable1 + "(v2) INCLUDE (v4)");
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex2 + " ON " + viewOfTable1 + "(v1) INCLUDE (v4)");
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex3 + " ON " + viewOfTable2 + "(v2) INCLUDE (v4)");
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex4 + " ON " + viewOfTable2 + "(v1) INCLUDE (v4)");
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex5 + " ON " + viewOfTable2 + "(v3) INCLUDE (v4)");
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex1);
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex2);
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex3);
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex4);
            PreparedStatement stmt = viewConn.prepareStatement(UPSERT_INTO + viewOfTable1 + " VALUES(?,?,?,?,?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "b");
            stmt.setString(3, "c");
            stmt.setString(4, "d");
            stmt.setString(5, "e");
            stmt.setString(6, "f");
            stmt.setInt(7, 1);
            stmt.setString(8, "g");
            stmt.execute();
            viewConn.commit();
            stmt = viewConn.prepareStatement(UPSERT_INTO + viewOfTable2 + " VALUES(?,?,?,?,?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "b");
            stmt.setString(3, "c");
            stmt.setString(4, "d");
            stmt.setString(5, "e");
            stmt.setString(6, "f");
            stmt.setInt(7, 1);
            stmt.setString(8, "g");
            stmt.execute();
            viewConn.commit();
            PhoenixConnection pconn = viewConn.unwrap(PhoenixConnection.class);
            PName tenantId = PNameFactory.newName((String)TENANT1);
            PTable view = pconn.getTable(new PTableKey(tenantId, viewOfTable1));
            PTable viewIndex = pconn.getTable(new PTableKey(tenantId, fullNameViewIndex1));
            Assert.assertNotNull((String)"Can't find view index", (Object)viewIndex);
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)2L, (long)view.getIndexes().size());
            Assert.assertEquals((String)"Unexpected index", (long)3L, (long)pconn.getTable(new PTableKey(tenantId, viewOfTable2)).getIndexes().size());
            conn.createStatement().execute(ALTER_TABLE + tableWithView1 + " DROP COLUMN v2, v3, v5 ");
            conn.createStatement().execute(ALTER_TABLE + tableWithView2 + " DROP COLUMN v1, v2, v3, v5 ");
            this.droppedColumnTest(conn, "v2", tableWithView1);
            this.droppedColumnTest(conn, "v3", tableWithView1);
            this.droppedColumnTest(conn, "v5", tableWithView1);
            this.droppedColumnTest(conn, "v1", tableWithView2);
            this.droppedColumnTest(conn, "v2", tableWithView2);
            this.droppedColumnTest(conn, "v3", tableWithView2);
            this.droppedColumnTest(conn, "v5", tableWithView2);
        }
    }

    @Test
    public void testDropIndexedColsSingleTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(DropIndexedColsIT.getUrl());
             Connection viewConn = DriverManager.getConnection(this.TENANT_SPECIFIC_URL);){
            String tableWithView = SchemaUtil.getTableName((String)SCHEMA1, (String)DropIndexedColsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)DropIndexedColsIT.generateUniqueName());
            String viewSchemaName = SchemaUtil.getSchemaNameFromFullName((String)viewOfTable);
            String viewIndex1 = DropIndexedColsIT.generateUniqueName();
            String viewIndex2 = DropIndexedColsIT.generateUniqueName();
            String fullNameViewIndex1 = SchemaUtil.getTableName((String)viewSchemaName, (String)viewIndex1);
            String fullNameViewIndex2 = SchemaUtil.getTableName((String)viewSchemaName, (String)viewIndex2);
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            String ddlFormat = CREATE_TABLE + tableWithView + CREATE_TABLE_COL_QUERY;
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            viewConn.createStatement().execute(CREATE_VIEW + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableWithView);
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex1 + " ON " + viewOfTable + "(v2) INCLUDE (v4)");
            viewConn.createStatement().execute(CREATE_INDEX + viewIndex2 + " ON " + viewOfTable + "(v1) INCLUDE (v4)");
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex1);
            viewConn.createStatement().execute(SELECT_ALL_FROM + fullNameViewIndex2);
            PreparedStatement stmt = viewConn.prepareStatement(UPSERT_INTO + viewOfTable + " VALUES(?,?,?,?,?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "b");
            stmt.setString(3, "c");
            stmt.setString(4, "d");
            stmt.setString(5, "e");
            stmt.setString(6, "f");
            stmt.setInt(7, 1);
            stmt.setString(8, "g");
            stmt.execute();
            viewConn.commit();
            PhoenixConnection pconn = viewConn.unwrap(PhoenixConnection.class);
            PName tenantId = PNameFactory.newName((String)TENANT1);
            conn.createStatement().execute(ALTER_TABLE + tableWithView + " DROP COLUMN v2, v3, v5 ");
            this.droppedColumnTest(conn, "v2", tableWithView);
            this.droppedColumnTest(conn, "v3", tableWithView);
            this.droppedColumnTest(conn, "v5", tableWithView);
        }
    }

    private String generateDDL(String format) {
        StringBuilder ddlGeneratorBuilder = new StringBuilder();
        if (ddlGeneratorBuilder.length() != 0) {
            ddlGeneratorBuilder.append(",");
        }
        ddlGeneratorBuilder.append("MULTI_TENANT=true");
        if (this.salted) {
            if (ddlGeneratorBuilder.length() != 0) {
                ddlGeneratorBuilder.append(",");
            }
            ddlGeneratorBuilder.append("SALT_BUCKETS=4");
        }
        return String.format(format, "TENANT_ID VARCHAR NOT NULL, ", "TENANT_ID, ", ddlGeneratorBuilder.toString());
    }

    private void droppedColumnTest(Connection conn, String column, String table) throws SQLException {
        try {
            conn.createStatement().execute("SELECT " + column + " FROM " + table);
            Assert.fail((String)"Column should have been dropped");
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            // empty catch block
        }
    }
}

