/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DistinctCountIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountOnColumn() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT count(DISTINCT A_STRING) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountOnRKColumn() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT count(DISTINCT ORGANIZATION_ID) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountWithGroupBy() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT A_STRING, count(DISTINCT B_STRING) FROM " + tableName + " group by A_STRING";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountWithGroupByAndOrderBy() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT A_STRING, count(DISTINCT B_STRING) FROM " + tableName + " group by A_STRING order by A_STRING desc";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountWithGroupByAndOrderByOnDistinctCount() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT A_STRING, count(DISTINCT B_STRING) as COUNT_B_STRING FROM " + tableName + " group by A_STRING order by COUNT_B_STRING";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountWithGroupByOrdered() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tenantId2 = "00D400000000XHP";
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, tenantId2, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT organization_id, count(DISTINCT A_STRING) FROM " + tableName + " group by organization_id";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId2, (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountOn2Columns() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT count(DISTINCT A_STRING), count(DISTINCT B_STRING) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountONE() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(tenantId, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT count(DISTINCT 1) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountOneWithEmptyResult() throws Exception {
        String tenantId = DistinctCountIT.getOrganizationId();
        String tableName = DistinctCountIT.generateUniqueName();
        DistinctCountIT.initATableValues(null, null, DistinctCountIT.getDefaultSplits(tenantId), null, tableName);
        String query = "SELECT count(DISTINCT 1) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initATableValues(String tenantId1, String tenantId2, byte[][] splits, Date date, String tableName) throws Exception {
        DistinctCountIT.ensureTableCreated(DistinctCountIT.getUrl(), tableName, "ATABLE", splits, null);
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_STRING,     B_STRING,     A_INTEGER,     A_DATE,     X_DECIMAL,     X_LONG,     X_INTEGER,    Y_INTEGER)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if (tenantId1 != null) {
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A123122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 1);
                stmt.setDate(6, date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A223122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 2);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A323122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 3);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A423122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 4);
                stmt.setDate(6, date == null ? null : date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B523122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 5);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B623122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 6);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B723122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 7);
                stmt.setDate(6, date == null ? null : date);
                stmt.setBigDecimal(7, BigDecimal.valueOf(0.1));
                stmt.setLong(8, 5L);
                stmt.setInt(9, 5);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B823122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 8);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, BigDecimal.valueOf(3.9));
                long l = -2147483649L;
                assert (l < Integer.MIN_VALUE);
                stmt.setLong(8, l);
                stmt.setInt(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00C923122312312");
                stmt.setString(3, "c");
                stmt.setString(4, "c");
                stmt.setInt(5, 9);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, BigDecimal.valueOf(3.3));
                l = 0x80000000L;
                assert (l > Integer.MAX_VALUE);
                stmt.setLong(8, l);
                stmt.setInt(9, 3);
                stmt.setInt(10, 300);
                stmt.execute();
            }
            if (tenantId2 != null) {
                stmt.setString(1, tenantId2);
                stmt.setString(2, "00A123122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 1);
                stmt.setDate(6, date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId2);
                stmt.setString(2, "00A223122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 2);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
            }
            conn.commit();
        }
    }

    @Test
    public void testDistinctCountOnIndexTab() throws Exception {
        String tableName = DistinctCountIT.generateUniqueName();
        String indexName = DistinctCountIT.generateUniqueName();
        String ddl = "create table " + tableName + " (id integer not null, first_name char(15),\n    last_name char(15), CONSTRAINT pk PRIMARY KEY (id))";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement(ddl);
        stmt.execute(ddl);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(first_name)");
        stmt = conn.prepareStatement("upsert into " + tableName + " (id, first_name, last_name) VALUES (?, ?, ?)");
        stmt.setInt(1, 1);
        stmt.setString(2, "NAME1");
        stmt.setString(3, "LN");
        stmt.execute();
        stmt.setInt(1, 2);
        stmt.setString(2, "NAME1");
        stmt.setString(3, "LN2");
        stmt.execute();
        stmt.setInt(1, 3);
        stmt.setString(2, "NAME2");
        stmt.setString(3, "LN3");
        stmt.execute();
        conn.commit();
        String query = "SELECT COUNT (DISTINCT first_name) FROM " + tableName;
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctCountLimitBug5217() throws Exception {
        try (Connection conn = null;){
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(DistinctCountIT.getUrl(), props);
            String tableName = DistinctCountIT.generateUniqueName();
            String sql = "create table " + tableName + "(  pk1 integer not null ,  pk2 integer not null,  v integer,  CONSTRAINT TEST_PK PRIMARY KEY (pk1,pk2))";
            conn.createStatement().execute(sql);
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk1,pk2,v) VALUES (1,1,1)");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk1,pk2,v) VALUES (2,2,2)");
            conn.commit();
            sql = "select count(distinct pk1) from " + tableName + " limit 1";
            ResultSet rs = conn.prepareStatement(sql).executeQuery();
            TestUtil.assertResultSet(rs, new Object[][]{{2L}});
        }
    }
}

