/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DescOrderKeysIT
extends ParallelStatsDisabledIT {
    @Test
    public void testVarCharDescOrderPKs() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR, COL2 VARCHAR CONSTRAINT PK PRIMARY KEY (COL1 DESC, COL2)) ");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('h1uniq1', 'val1')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('41efh', 'val2')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('c49ghd', 'val3')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('4232jfjg', 'val4')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('zsw4tg', 'val5')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('93hgwef', 'val6')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) VALUES ('3jfytw', 'val7')");
            String sql = "select COL1, COL2 from " + tableName;
            ResultSet rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)plan.getScans().size());
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)((List)plan.getScans().get(0)).size());
            Assert.assertEquals((Object)"zsw4tg", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val5", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"h1uniq1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val1", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c49ghd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val3", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"93hgwef", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val6", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"4232jfjg", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val4", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"41efh", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val2", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3jfytw", (Object)rs.getString(1));
            Assert.assertEquals((Object)"val7", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testVarCharDescOrderMultiplePKs() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR, COL2 VARCHAR, COL3 VARCHAR CONSTRAINT PK PRIMARY KEY (COL1 DESC, COL2 DESC, COL3)) ");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('h1uniq1', 'key1', 'val1')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('41efh', 'key2', 'val2')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('c49ghd', 'key3', 'val3')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('zsw4tg', 'key5', 'val5')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('zsw4tg', 'key4', 'val4')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('h1uniq1', 'key6', 'val6')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('93hgwef', 'key7', 'val7')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('3jfytw', 'key8', 'val8')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES ('4232jfjg', 'key9', 'val9')");
            String sql = "select COL1, COL2, COL3 from " + tableName;
            ResultSet rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)plan.getScans().size());
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)((List)plan.getScans().get(0)).size());
            Assert.assertEquals((Object)"zsw4tg", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key5", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val5", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"zsw4tg", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key4", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val4", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"h1uniq1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key6", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val6", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"h1uniq1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c49ghd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key3", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val3", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"93hgwef", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key7", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val7", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"4232jfjg", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key9", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val9", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"41efh", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3jfytw", (Object)rs.getString(1));
            Assert.assertEquals((Object)"key8", (Object)rs.getString(2));
            Assert.assertEquals((Object)"val8", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testIntDescOrderMultiplePKs() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 INTEGER NOT NULL, COL2 INTEGER NOT NULL, COL3 VARCHAR NOT NULL CONSTRAINT PK PRIMARY KEY (COL1 DESC, COL2 DESC, COL3)) ");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234, 3957, 'val1')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453, 234, 'val2')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (3463, 345561, 'val3')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (34534, 345657, 'val4')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453, 92374, 'val5')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375, 11037, 'val6')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375, 455, 'val7')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375, 7712, 'val8')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234, 3956, 'val9')");
            String sql = "select COL1, COL2, COL3 from " + tableName;
            ResultSet rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)plan.getScans().size());
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)((List)plan.getScans().get(0)).size());
            Assert.assertEquals((long)34534L, (long)rs.getInt(1));
            Assert.assertEquals((long)345657L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val4", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9375L, (long)rs.getInt(1));
            Assert.assertEquals((long)11037L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val6", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9375L, (long)rs.getInt(1));
            Assert.assertEquals((long)7712L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val8", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9375L, (long)rs.getInt(1));
            Assert.assertEquals((long)455L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val7", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3463L, (long)rs.getInt(1));
            Assert.assertEquals((long)345561L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val3", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2453L, (long)rs.getInt(1));
            Assert.assertEquals((long)92374L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val5", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2453L, (long)rs.getInt(1));
            Assert.assertEquals((long)234L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1234L, (long)rs.getInt(1));
            Assert.assertEquals((long)3957L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1234L, (long)rs.getInt(1));
            Assert.assertEquals((long)3956L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"val9", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDoubleDescOrderMultiplePKs() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 DOUBLE NOT NULL, COL2 DOUBLE NOT NULL, COL3 VARCHAR NOT NULL CONSTRAINT PK PRIMARY KEY (COL1 DESC, COL2 DESC, COL3)) ");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234.39, 3957.124, 'val1')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453.97, 234.112, 'val2')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (3463.384, 345561.124, 'val3')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (34534.9191, 345657.913, 'val4')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453.89, 92374.11, 'val5')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.729, 'val6')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.8, 'val7')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.72888, 'val8')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234.39, 3957.123999, 'val9')");
            String sql = "select COL1, COL2, COL3 from " + tableName;
            ResultSet rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)plan.getScans().size());
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)((List)plan.getScans().get(0)).size());
            Assert.assertEquals((double)34534.9191, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)345657.913, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val4", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)9375.23, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)11037.8, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val7", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)9375.23, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)11037.729, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val6", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)9375.23, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)11037.72888, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val8", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)3463.384, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)345561.124, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val3", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)2453.97, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)234.112, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)2453.89, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)92374.11, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val5", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)1234.39, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)3957.124, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)1234.39, (double)rs.getDouble(1), (double)0.0);
            Assert.assertEquals((double)3957.123999, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"val9", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDecimalDescOrderMultiplePKs() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 DECIMAL NOT NULL, COL2 DECIMAL NOT NULL, COL3 VARCHAR NOT NULL CONSTRAINT PK PRIMARY KEY (COL1 DESC, COL2 DESC, COL3)) ");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234.39, 3957.124, 'val1')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453.97, 234.112, 'val2')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (3463.384, 345561.124, 'val3')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (34534.9191, 345657.913, 'val4')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (2453.89, 92374.11, 'val5')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.729, 'val6')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.8, 'val7')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (9375.23, 11037.72888, 'val8')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2, COL3) VALUES (1234.39, 3957.123999, 'val9')");
            String sql = "select COL1, COL2, COL3 from " + tableName;
            ResultSet rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)plan.getScans().size());
            Assert.assertEquals((String)"Expected a single scan ", (long)1L, (long)((List)plan.getScans().get(0)).size());
            Assert.assertEquals((Object)BigDecimal.valueOf(34534.9191), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(345657.913), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val4", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(9375.23), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(11037.8), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val7", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(9375.23), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(11037.729), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val6", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(9375.23), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(11037.72888), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val8", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(3463.384), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(345561.124), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val3", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(2453.97), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(234.112), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(2453.89), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(92374.11), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val5", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1234.39), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(3957.124), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1234.39), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(3957.123999), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)"val9", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewWithIntDescPkColumn() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 INTEGER NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1 DESC)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) NOT NULL, COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 1");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 2, 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', -2, 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', -1, 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 1, 'col3_07', 'col4_07', 'col5_07')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view01);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0004", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0005", (Object)rs.getString(2));
            Assert.assertEquals((long)-2L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0006", (Object)rs.getString(2));
            Assert.assertEquals((long)-1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewWithCharDescPkColumn() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1 DESC)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) NOT NULL, COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 'vcol2', 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 'vcol-2', 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 'vcol-1', 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 'vcol1', 'col3_07', 'col4_07', 'col5_07')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view01);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0004", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0005", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol-2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0006", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol-1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view01 + " ORDER BY VCOL1 DESC, COL2 ASC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0004", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0005", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol-2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0006", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol-1", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02 + " ORDER BY VCOL2 DESC, VCOL1 DESC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewWithDoubleDescPkColumn() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 DOUBLE NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1 DESC)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) NOT NULL, COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 234.75");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 236.49, 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 17.053, 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 98.8452, 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 234.75, 'col3_07', 'col4_07', 'col5_07')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view01);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0004", (Object)rs.getString(2));
            Assert.assertEquals((double)236.49, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0005", (Object)rs.getString(2));
            Assert.assertEquals((double)17.053, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0006", (Object)rs.getString(2));
            Assert.assertEquals((double)98.8452, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view01 + " ORDER BY VCOL1 DESC, COL2 ASC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0004", (Object)rs.getString(2));
            Assert.assertEquals((double)236.49, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0006", (Object)rs.getString(2));
            Assert.assertEquals((double)98.8452, (double)rs.getDouble(3), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0005", (Object)rs.getString(2));
            Assert.assertEquals((double)17.053, (double)rs.getDouble(3), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02 + " ORDER BY VCOL2 DESC, VCOL1 DESC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((double)234.75, (double)rs.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewWithCharDescPkColumnAndViewIndex() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1 ASC, COL2 DESC))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8), COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 'vcol2', 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 'vcol-2', 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 'vcol-1', 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 'vcol1', 'col3_07', 'col4_07', 'col5_07')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0008', 'vcol2_08', 'col5_08', 'col6_02')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0008", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((Object)"col3_07", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col4_07", (Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(6));
            Assert.assertNull((Object)rs.getString(7));
            Assert.assertNull((Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(8));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + view02 + " WHERE COL6 = 'col6_02'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1, COL6 FROM " + view02 + " WHERE COL6 = 'col6_02'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewWithTimestampDescPkColumnAndViewIndex() throws Exception {
        String tableName = DescOrderKeysIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(DescOrderKeysIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 TIMESTAMP NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1 ASC, COL2 DESC))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8), COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL1 = TO_TIMESTAMP('2023-01-20 00:10:00')");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 'vcol2', 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 'vcol-2', 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 'vcol-1', 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 'vcol1', 'col3_07', 'col4_07', 'col5_07')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0008', 'vcol2_08', 'col5_08', 'col6_02')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0008", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(4));
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(4));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0007", (Object)rs.getString(2));
            Assert.assertEquals((Object)"col3_07", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col4_07", (Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_07", (Object)rs.getString(6));
            Assert.assertNull((Object)rs.getString(7));
            Assert.assertNull((Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_03", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_03", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_03", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0001", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_01", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_01", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_01", (Object)rs.getString(8));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + view02 + " WHERE COL6 = 'col6_02'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_08", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_08", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"col5_02", (Object)rs.getString(6));
            Assert.assertEquals((Object)"vcol2_02", (Object)rs.getString(7));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(8));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT COL1, COL2, VCOL1, COL6 FROM " + view02 + " WHERE COL6 = 'col6_02'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0008", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2023-01-20T00:10:00Z", (Object)rs.getTimestamp(1).toInstant().toString());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"col6_02", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

