/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class DerivedTableIT
extends ParallelStatsDisabledIT {
    private static final String tenantId = DerivedTableIT.getOrganizationId();
    private static final String dynamicTableName = "_TABLENAME_REPLACEABLE_";
    @Rule
    public TestName name = new TestName();
    private String[] indexDDL;
    private String[] plans;
    private String tableName;
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivedTableIT.class);

    public DerivedTableIT(String[] indexDDL, String[] plans) {
        this.indexDDL = indexDDL;
        this.plans = plans;
    }

    @Before
    public void initTable() throws Exception {
        if (this.tableName != null) {
            throw new RuntimeException("Test has not been cleaned up.");
        }
        this.tableName = DerivedTableIT.generateUniqueName();
        DerivedTableIT.initATableValues(this.tableName, tenantId, DerivedTableIT.getDefaultSplits(tenantId), null, null, DerivedTableIT.getUrl(), null);
        if (this.indexDDL != null && this.indexDDL.length > 0) {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);
            for (String ddl : this.indexDDL) {
                ddl = ddl.replace(dynamicTableName, this.tableName);
                conn.createStatement().execute(ddl);
            }
        }
        String[] newplan = new String[this.plans.length];
        if (this.plans != null && this.plans.length > 0) {
            for (int i = 0; i < this.plans.length; ++i) {
                newplan[i] = this.plans[i].replace(dynamicTableName, this.tableName);
            }
            this.plans = newplan;
        }
    }

    @After
    public void cleanUp() throws Exception {
        boolean refCountLeaked = DerivedTableIT.isAnyStoreRefCountLeaked();
        this.tableName = null;
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Parameterized.Parameters(name="DerivedTableIT_{index}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new String[][]{{"CREATE INDEX _TABLENAME_REPLACEABLE__DERIVED_IDX ON _TABLENAME_REPLACEABLE_ (a_byte) INCLUDE (A_STRING, B_STRING)"}, {"CLIENT PARALLEL 1-WAY FULL SCAN OVER _TABLENAME_REPLACEABLE__DERIVED_IDX \n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"A_STRING\", \"B_STRING\"]\nCLIENT MERGE SORT\nCLIENT SORTED BY [\"B_STRING\"]\nCLIENT SORTED BY [A]\nCLIENT AGGREGATE INTO DISTINCT ROWS BY [A]\nCLIENT SORTED BY [A DESC]", "CLIENT PARALLEL 1-WAY FULL SCAN OVER _TABLENAME_REPLACEABLE__DERIVED_IDX \n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"A_STRING\", \"B_STRING\"]\nCLIENT MERGE SORT\nCLIENT AGGREGATE INTO ORDERED DISTINCT ROWS BY [A]\nCLIENT DISTINCT ON [COLLECTDISTINCT(B)]\nCLIENT SORTED BY [A DESC]"}});
        testCases.add(new String[][]{new String[0], {"CLIENT PARALLEL 4-WAY FULL SCAN OVER _TABLENAME_REPLACEABLE_ \n    SERVER AGGREGATE INTO DISTINCT ROWS BY [A_STRING, B_STRING]\nCLIENT MERGE SORT\nCLIENT SORTED BY [B_STRING]\nCLIENT SORTED BY [A]\nCLIENT AGGREGATE INTO DISTINCT ROWS BY [A]\nCLIENT SORTED BY [A DESC]", "CLIENT PARALLEL 4-WAY FULL SCAN OVER _TABLENAME_REPLACEABLE_ \n    SERVER AGGREGATE INTO DISTINCT ROWS BY [A_STRING, B_STRING]\nCLIENT MERGE SORT\nCLIENT AGGREGATE INTO ORDERED DISTINCT ROWS BY [A]\nCLIENT DISTINCT ON [COLLECTDISTINCT(B)]\nCLIENT SORTED BY [A DESC]"}});
        return testCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithWhere() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + " WHERE a_byte + 1 < 9) AS t";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)11L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)12L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)13L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)14L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)15L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)16L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)17L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + ") AS t WHERE t.b = 'c'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)12L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)15L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)18L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + " WHERE a_byte + 1 < 9) AS t WHERE t.b = 'c'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)12L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)15L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.a, t.c, t.m FROM (SELECT a_string a, count(*) c, max(a_byte) m FROM " + this.tableName + " WHERE a_byte != 8 GROUP BY a_string) AS t WHERE t.c > 1";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertEquals((long)4L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)7L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.a, t.c, t.m FROM (SELECT a_string a, count(*) c, max(a_byte) m FROM " + this.tableName + " WHERE a_byte != 8 GROUP BY a_string HAVING count(*) >= 2) AS t WHERE t.a != 'a'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)7L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + " LIMIT 2) AS t WHERE t.b = 'c'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT u.eid FROM (SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + " WHERE a_string = 'b' LIMIT 5) AS t WHERE t.b = 'c' LIMIT 4) AS u WHERE u.eid >= '00A123122312312' LIMIT 3";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.c FROM (SELECT count(*) c FROM " + this.tableName + ") AS t WHERE t.c > 0";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + " LIMIT 1 OFFSET 1 ) AS t WHERE t.b = 'c' OFFSET 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + " WHERE a_byte + 1 < 9 ) AS t OFFSET 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)13L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)14L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)15L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)16L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)17L, (long)rs.getInt(2));
            query = "SELECT t.eid, t.x + 9 FROM (SELECT entity_id eid, b_string b, a_byte + 1 x FROM " + this.tableName + " OFFSET 4) AS t WHERE t.b = 'c'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)15L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)18L, (long)rs.getInt(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithGroupBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT t.a, count(*), max(t.s) FROM (SELECT a_string a, a_byte s FROM " + this.tableName + " WHERE a_byte != 8) AS t GROUP BY t.a HAVING count(*) > 1";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertEquals((long)4L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)7L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.c, count(*) FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t GROUP BY t.c";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.c, count(*) FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t GROUP BY t.c ORDER BY count(*) DESC";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.a, COLLECTDISTINCT(t.b) FROM (SELECT b_string b, a_string a FROM " + this.tableName + " GROUP BY a_string, b_string ORDER BY b_string) AS t GROUP BY t.a ORDER BY t.a DESC";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Object[] b = new String[]{"e"};
            Array array = conn.createArrayOf("VARCHAR", b);
            Assert.assertEquals((Object)array, (Object)rs.getArray(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            b = new String[]{"b", "c", "e"};
            array = conn.createArrayOf("VARCHAR", b);
            Assert.assertEquals((Object)array, (Object)rs.getArray(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)array, (Object)rs.getArray(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN WITH REGIONS " + query);
            String explainPlanOutput = QueryUtil.getExplainPlan((ResultSet)rs);
            LOGGER.info("Explain plan output: {}", (Object)explainPlanOutput);
            String[] splitExplainPlan = explainPlanOutput.split("\\n \\(region locations = \\[region=");
            String[] secondSplitExplainPlan = splitExplainPlan[1].split("]\\)");
            Assert.assertEquals((Object)this.plans[0], (Object)(splitExplainPlan[0] + secondSplitExplainPlan[1]));
            query = "SELECT DISTINCT COLLECTDISTINCT(t.b) FROM (SELECT b_string b, a_string a FROM " + this.tableName + " GROUP BY a_string, b_string) AS t GROUP BY t.a ORDER BY t.a DESC";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            b = new String[]{"e"};
            array = conn.createArrayOf("VARCHAR", b);
            Assert.assertEquals((Object)array, (Object)rs.getArray(1));
            Assert.assertTrue((boolean)rs.next());
            b = new String[]{"b", "c", "e"};
            array = conn.createArrayOf("VARCHAR", b);
            Assert.assertEquals((Object)array, (Object)rs.getArray(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN WITH REGIONS " + query);
            explainPlanOutput = QueryUtil.getExplainPlan((ResultSet)rs);
            LOGGER.info("Explain plan output: {}", (Object)explainPlanOutput);
            splitExplainPlan = explainPlanOutput.split("\\n \\(region locations = \\[region=");
            secondSplitExplainPlan = splitExplainPlan[1].split("]\\)");
            Assert.assertEquals((Object)this.plans[1], (Object)(splitExplainPlan[0] + secondSplitExplainPlan[1]));
            query = "SELECT t.a_string, count(*) FROM (SELECT * FROM " + this.tableName + " order by a_integer) AS t where a_byte != 8 group by t.a_string";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.c, count(*) FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t GROUP BY t.c ORDER BY count(*) DESC OFFSET 1";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithOrderBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + " ORDER BY b, eid) AS t";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + ") AS t ORDER BY t.b, t.eid";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + " ORDER BY b, eid) AS t ORDER BY t.b DESC, t.eid DESC";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid, b_string b FROM " + this.tableName + " LIMIT 2) AS t ORDER BY t.b DESC, t.eid";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithLimit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 2) AS t";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + ") AS t LIMIT 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 2) AS t LIMIT 4";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 4) AS t LIMIT 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT ?) AS t LIMIT ?";
            statement = conn.prepareStatement(query);
            statement.setInt(1, 4);
            statement.setInt(2, 2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a, s FROM (SELECT a_string a, sum(a_byte) s FROM " + this.tableName + " GROUP BY a_string ORDER BY sum(a_byte)) LIMIT 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)9L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a_string, count(*) FROM (SELECT a_string FROM " + this.tableName + " where a_byte < 4 union all SELECT a_string FROM " + this.tableName + " where a_byte > 8) group by a_string limit 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithOffset() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 2 OFFSET 1) AS t";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " OFFSET 1) AS t LIMIT 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 2 OFFSET 1) AS t LIMIT 4 OFFSET 1";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT 4 OFFSET 1) AS t LIMIT 2";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t.eid FROM (SELECT entity_id eid FROM " + this.tableName + " LIMIT ? OFFSET ?) AS t LIMIT ? OFFSET ?";
            statement = conn.prepareStatement(query);
            statement.setInt(1, 4);
            statement.setInt(2, 2);
            statement.setInt(3, 2);
            statement.setInt(4, 2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a, s FROM (SELECT a_string a, sum(a_byte) s FROM " + this.tableName + " GROUP BY a_string ORDER BY sum(a_byte) OFFSET 1)";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)26L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a_string, count(*) FROM (SELECT a_string FROM " + this.tableName + " where a_byte < 4 union all SELECT a_string FROM " + this.tableName + " where a_byte > 8 OFFSET 1) group by a_string";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithDistinct() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT * FROM (SELECT DISTINCT a_string, b_string FROM " + this.tableName + ") AS t WHERE t.b_string != 'c' ORDER BY t.b_string, t.a_string";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT DISTINCT t.a, t.b FROM (SELECT a_string a, b_string b FROM " + this.tableName + ") AS t WHERE t.b != 'c' ORDER BY t.b, t.a";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT DISTINCT t.a FROM (SELECT DISTINCT a_string a, b_string b FROM " + this.tableName + ") AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT distinct t.c FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT distinct t.c FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t ORDER BY t.c DESC";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT DISTINCT t.a, t.b FROM (SELECT a_string a, b_string b FROM " + this.tableName + " LIMIT 2) AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithAggregate() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT * FROM (SELECT count(*) FROM " + this.tableName + " WHERE a_byte != 8) AS t";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(*) FROM (SELECT a_byte FROM " + this.tableName + ") AS t WHERE t.a_byte != 8";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(*) FROM (SELECT DISTINCT a_string FROM " + this.tableName + ") AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(*) FROM (SELECT count(*) c FROM " + this.tableName + " GROUP BY a_string) AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(*) FROM (SELECT entity_id FROM " + this.tableName + " LIMIT 2) AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(*) FROM (SELECT * FROM " + this.tableName + " WHERE (organization_id, entity_id) in (SELECT organization_id, entity_id FROM " + this.tableName + " WHERE a_byte != 8)) AS t";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(a_byte) FROM (SELECT * FROM " + this.tableName + " order by a_integer) AS t where a_byte != 8";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerivedTableWithJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String query = "SELECT q.id1, count(q.id2) FROM (SELECT t1.entity_id id1, t2.entity_id id2, t2.a_byte b2 FROM " + this.tableName + " t1 JOIN " + this.tableName + " t2 ON t1.a_string = t2.b_string WHERE t1.a_byte >= 8) AS q WHERE q.b2 != 5 GROUP BY q.id1";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT DISTINCT q.id1 FROM (SELECT t1.entity_id id1, t2.a_byte b2 FROM " + this.tableName + " t1 JOIN " + this.tableName + " t2 ON t1.a_string = t2.b_string WHERE t1.a_byte >= 8) AS q WHERE q.b2 != 5";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT COUNT(*) FROM (SELECT t2.a_byte b2 FROM " + this.tableName + " t1 JOIN " + this.tableName + " t2 ON t1.a_string = t2.b_string WHERE t1.a_byte >= 8) AS q WHERE q.b2 != 5";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedDerivedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DerivedTableIT.getUrl(), props);){
            String ddl = "CREATE INDEX IF NOT EXISTS " + this.tableName + "_DERIVED_IDX ON " + this.tableName + " (a_byte) INCLUDE (A_STRING, B_STRING)";
            conn.createStatement().execute(ddl);
            String query = "SELECT q.id, q.x10 * 10 FROM (SELECT t.eid id, t.x + 9 x10, t.astr a, t.bstr b FROM (SELECT entity_id eid, a_string astr, b_string bstr, a_byte + 1 x FROM " + this.tableName + " WHERE a_byte + 1 < ?) AS t ORDER BY b, id) AS q WHERE q.a = ? OR q.b = ? OR q.b = ?";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setInt(1, 9);
            statement.setString(2, "a");
            statement.setString(3, "c");
            statement.setString(4, "e");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)110L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)140L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)120L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)150L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)130L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertEquals((long)160L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT q1.id, q2.id FROM (SELECT t.eid id, t.astr a, t.bstr b FROM (SELECT entity_id eid, a_string astr, b_string bstr, a_byte abyte FROM " + this.tableName + ") AS t WHERE t.abyte >= ?) AS q1 JOIN (SELECT t.eid id, t.astr a, t.bstr b, t.abyte x FROM (SELECT entity_id eid, a_string astr, b_string bstr, a_byte abyte FROM " + this.tableName + ") AS t) AS q2 ON q1.a = q2.b WHERE q2.x != ? ORDER BY q1.id, q2.id DESC";
            statement = conn.prepareStatement(query);
            statement.setInt(1, 8);
            statement.setInt(2, 5);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

