/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.DeleteCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class DeleteIT
extends ParallelStatsDisabledIT {
    private static final int NUMBER_OF_ROWS = 20;
    private static final int NTH_ROW_NULL = 5;
    private final String allowServerSideMutations;

    public DeleteIT(String allowServerSideMutations) {
        this.allowServerSideMutations = allowServerSideMutations;
    }

    @Parameterized.Parameters(name="DeleteIT_allowServerSideMutations={0}")
    public static synchronized Object[] data() {
        return new Object[]{"true", "false"};
    }

    private static String initTableValues(Connection conn) throws SQLException {
        String tableName = DeleteIT.generateUniqueName();
        DeleteIT.ensureTableCreated(DeleteIT.getUrl(), tableName, "IntIntKeyTest");
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES(?,?)";
        PreparedStatement stmt = conn.prepareStatement(upsertStmt);
        for (int i = 0; i < 20; ++i) {
            stmt.setInt(1, i);
            if (i % 5 != 0) {
                stmt.setInt(2, i * 10);
            } else {
                stmt.setNull(2, 4);
            }
            stmt.execute();
        }
        conn.commit();
        return tableName;
    }

    @Test
    public void testDeleteFilterNoAutoCommit() throws Exception {
        this.testDeleteFilter(false);
    }

    @Test
    public void testDeleteFilterAutoCommit() throws Exception {
        this.testDeleteFilter(true);
    }

    private void testDeleteFilter(boolean autoCommit) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);
        String tableName = DeleteIT.initTableValues(conn);
        this.assertTableCount(conn, tableName, 20);
        conn.setAutoCommit(autoCommit);
        String deleteStmt = "DELETE FROM " + tableName + " WHERE 20 = j";
        Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(deleteStmt));
        if (!autoCommit) {
            conn.commit();
        }
        this.assertTableCount(conn, tableName, 19);
    }

    @Test
    public void testDeleteByRowAndFilterAutoCommit() throws SQLException {
        this.testDeleteByFilterAndRow(true);
    }

    @Test
    public void testDeleteByRowAndFilterNoAutoCommit() throws SQLException {
        this.testDeleteByFilterAndRow(false);
    }

    private void testDeleteByFilterAndRow(boolean autoCommit) throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);
        String tableName = DeleteIT.initTableValues(conn);
        this.assertTableCount(conn, tableName, 20);
        conn.setAutoCommit(autoCommit);
        Statement stmt = conn.createStatement();
        Assert.assertEquals((long)0L, (long)stmt.executeUpdate("DELETE FROM " + tableName + " WHERE i = 1 AND j = 1"));
        if (!autoCommit) {
            conn.commit();
        }
        this.assertTableCount(conn, tableName, 20);
        Assert.assertEquals((long)0L, (long)stmt.executeUpdate("DELETE FROM " + tableName + " WHERE i = -1 AND j = 20"));
        if (!autoCommit) {
            conn.commit();
        }
        this.assertTableCount(conn, tableName, 20);
        Assert.assertEquals((long)1L, (long)stmt.executeUpdate("DELETE FROM " + tableName + " WHERE i = 1 AND j = 10"));
        if (!autoCommit) {
            conn.commit();
        }
        this.assertTableCount(conn, tableName, 19);
    }

    private void assertTableCount(Connection conn, String tableName, int expectedNumberOfRows) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)expectedNumberOfRows, (long)rs.getInt(1));
        rs.close();
    }

    private static void assertIndexUsed(Connection conn, String query, String indexName, boolean expectedToBeUsed, boolean local) throws SQLException {
        DeleteIT.assertIndexUsed(conn, query, Collections.emptyList(), indexName, expectedToBeUsed, local);
    }

    private static void assertIndexUsed(Connection conn, String query, List<Object> binds, String indexName, boolean expectedToBeUsed, boolean local) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("EXPLAIN " + query);
        for (int i = 0; i < binds.size(); ++i) {
            stmt.setObject(i + 1, binds.get(i));
        }
        ResultSet rs = stmt.executeQuery();
        String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        if (local) {
            Assert.assertEquals((Object)expectedToBeUsed, (Object)(explainPlan.contains(indexName + " [1]") || explainPlan.contains(indexName + " [1,") ? 1 : 0));
        } else {
            Assert.assertEquals((Object)expectedToBeUsed, (Object)explainPlan.contains(" SCAN OVER " + indexName));
        }
    }

    private void testDeleteRange(boolean autoCommit, boolean createIndex) throws Exception {
        this.testDeleteRange(autoCommit, createIndex, false);
    }

    private void testDeleteRange(boolean autoCommit, boolean createIndex, boolean local) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);
        String tableName = DeleteIT.initTableValues(conn);
        String indexName = DeleteIT.generateUniqueName();
        String localIndexName = DeleteIT.generateUniqueName();
        Object indexInUse = indexName;
        if (createIndex) {
            if (local) {
                conn.createStatement().execute("CREATE LOCAL INDEX IF NOT EXISTS " + localIndexName + " ON " + tableName + "(j)");
                indexInUse = localIndexName + "(" + tableName + ")";
            } else {
                conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexName + " ON " + tableName + "(j)");
            }
        }
        ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)20L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT i FROM " + tableName + " WHERE j IS NULL");
        int i = 0;
        int isNullCount = 0;
        while (rs.next()) {
            Assert.assertEquals((long)i, (long)rs.getInt(1));
            i += 5;
            ++isNullCount;
        }
        rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName + " WHERE j IS NOT NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)(20 - isNullCount), (long)rs.getInt(1));
        conn.setAutoCommit(autoCommit);
        String deleteStmt = "DELETE FROM " + tableName + " WHERE i >= ? and i < ?";
        DeleteIT.assertIndexUsed(conn, deleteStmt, Arrays.asList(5, 10), (String)indexInUse, false, local);
        PreparedStatement stmt = conn.prepareStatement(deleteStmt);
        stmt.setInt(1, 5);
        stmt.setInt(2, 10);
        stmt.execute();
        if (!autoCommit) {
            conn.commit();
        }
        String query = "SELECT count(*) FROM " + tableName;
        DeleteIT.assertIndexUsed(conn, query, (String)indexInUse, createIndex, local);
        query = "SELECT count(*) FROM " + tableName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)15L, (long)rs.getInt(1));
        deleteStmt = "DELETE FROM " + tableName + " WHERE j IS NULL";
        stmt = conn.prepareStatement(deleteStmt);
        DeleteIT.assertIndexUsed(conn, deleteStmt, (String)indexInUse, createIndex, local);
        int deleteCount = stmt.executeUpdate();
        Assert.assertEquals((long)3L, (long)deleteCount);
        if (!autoCommit) {
            conn.commit();
        }
        rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)(15 - isNullCount + 1), (long)rs.getInt(1));
    }

    @Test
    public void testDeleteRangeNoAutoCommitNoIndex() throws Exception {
        this.testDeleteRange(false, false);
    }

    @Test
    public void testDeleteRangeAutoCommitNoIndex() throws Exception {
        this.testDeleteRange(true, false);
    }

    @Test
    public void testDeleteRangeNoAutoCommitWithIndex() throws Exception {
        this.testDeleteRange(false, true, false);
    }

    @Test
    public void testDeleteRangeNoAutoCommitWithLocalIndexIndex() throws Exception {
        this.testDeleteRange(false, true, true);
    }

    @Test
    public void testDeleteRangeAutoCommitWithIndex() throws Exception {
        this.testDeleteRange(true, true, false);
    }

    @Test
    public void testDeleteRangeAutoCommitWithLocalIndex() throws Exception {
        this.testDeleteRange(true, true, true);
    }

    @Test
    public void testDeleteAllFromTableWithIndexAutoCommitSalting() throws Exception {
        this.testDeleteAllFromTableWithIndex(true, true, false);
    }

    @Test
    public void testDeleteAllFromTableWithLocalIndexAutoCommitSalting() throws Exception {
        this.testDeleteAllFromTableWithIndex(true, true, true);
    }

    @Test
    public void testDeleteAllFromTableWithIndexAutoCommitNoSalting() throws Exception {
        this.testDeleteAllFromTableWithIndex(true, false);
    }

    @Test
    public void testDeleteAllFromTableWithIndexNoAutoCommitNoSalting() throws Exception {
        this.testDeleteAllFromTableWithIndex(false, false);
    }

    @Test
    public void testDeleteAllFromTableWithIndexNoAutoCommitSalted() throws Exception {
        this.testDeleteAllFromTableWithIndex(false, true, false);
    }

    @Test
    public void testDeleteAllFromTableWithLocalIndexNoAutoCommitSalted() throws Exception {
        this.testDeleteAllFromTableWithIndex(false, true, true);
    }

    private void testDeleteAllFromTableWithIndex(boolean autoCommit, boolean isSalted) throws Exception {
        this.testDeleteAllFromTableWithIndex(autoCommit, isSalted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAllFromTableWithIndex(boolean autoCommit, boolean isSalted, boolean localIndex) throws Exception {
        Connection con = null;
        try {
            Properties props = new Properties();
            props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
            con = DriverManager.getConnection(DeleteIT.getUrl(), props);
            con.setAutoCommit(autoCommit);
            Statement stm = con.createStatement();
            String tableName = DeleteIT.generateUniqueName();
            String s = "CREATE TABLE IF NOT EXISTS " + tableName + "(HOST CHAR(2) NOT NULL,DOMAIN VARCHAR NOT NULL, FEATURE VARCHAR NOT NULL, \"DATE\" DATE NOT NULL, \nUSAGE.CORE BIGINT,USAGE.DB BIGINT,STATS.ACTIVE_VISITOR INTEGER CONSTRAINT PK PRIMARY KEY (HOST, DOMAIN, FEATURE, \"DATE\"))" + (isSalted ? " SALT_BUCKETS=3" : "");
            stm.execute(s);
            String localIndexName = DeleteIT.generateUniqueName();
            String indexName = DeleteIT.generateUniqueName();
            if (localIndex) {
                stm.execute("CREATE LOCAL INDEX " + localIndexName + " ON " + tableName + " (CORE,DB,ACTIVE_VISITOR)");
            } else {
                stm.execute("CREATE INDEX " + indexName + " ON " + tableName + " (CORE,DB,ACTIVE_VISITOR)");
            }
            stm.close();
            PreparedStatement psInsert = con.prepareStatement("UPSERT INTO " + tableName + "(HOST, DOMAIN, FEATURE, \"DATE\", CORE, DB, ACTIVE_VISITOR) VALUES(?,?, ? , ?, ?, ?, ?)");
            psInsert.setString(1, "AA");
            psInsert.setString(2, "BB");
            psInsert.setString(3, "CC");
            psInsert.setDate(4, new Date(0L));
            psInsert.setLong(5, 1L);
            psInsert.setLong(6, 2L);
            psInsert.setLong(7, 3L);
            psInsert.execute();
            psInsert.close();
            if (!autoCommit) {
                con.commit();
            }
            con.createStatement().execute("DELETE FROM " + tableName);
            if (!autoCommit) {
                con.commit();
            }
            ResultSet rs = con.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            rs = localIndex ? con.createStatement().executeQuery("SELECT count(*) FROM " + localIndexName) : con.createStatement().executeQuery("SELECT count(*) FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testDeleteRowFromTableWithImmutableIndex() throws Exception {
        this.testDeleteRowFromTableWithImmutableIndex(false, true);
    }

    @Test
    public void testDeleteRowFromTableWithImmutableLocalIndex() throws Exception {
        this.testDeleteRowFromTableWithImmutableIndex(true, false);
    }

    @Test
    public void testPointDeleteRowFromTableWithImmutableIndex() throws Exception {
        this.testPointDeleteRowFromTableWithImmutableIndex(false, false);
    }

    @Test
    public void testPointDeleteRowFromTableWithLocalImmutableIndex() throws Exception {
        this.testPointDeleteRowFromTableWithImmutableIndex(true, false);
    }

    @Test
    public void testPointDeleteRowFromTableWithImmutableIndex2() throws Exception {
        this.testPointDeleteRowFromTableWithImmutableIndex(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPointDeleteRowFromTableWithImmutableIndex(boolean localIndex, boolean addNonPKIndex) throws Exception {
        Connection con = null;
        try {
            boolean autoCommit = false;
            Properties props = new Properties();
            props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
            con = DriverManager.getConnection(DeleteIT.getUrl(), props);
            con.setAutoCommit(autoCommit);
            Statement stm = con.createStatement();
            String tableName = DeleteIT.generateUniqueName();
            String indexName1 = DeleteIT.generateUniqueName();
            String indexName2 = DeleteIT.generateUniqueName();
            String indexName3 = addNonPKIndex ? DeleteIT.generateUniqueName() : null;
            stm.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (HOST CHAR(2) NOT NULL,DOMAIN VARCHAR NOT NULL, FEATURE VARCHAR NOT NULL, \"DATE\" DATE NOT NULL, \nUSAGE.CORE BIGINT,USAGE.DB BIGINT,STATS.ACTIVE_VISITOR INTEGER CONSTRAINT PK PRIMARY KEY (HOST, DOMAIN, FEATURE, \"DATE\")) IMMUTABLE_ROWS=true");
            stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName1 + " ON " + tableName + " (\"DATE\", FEATURE)");
            stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName2 + " ON " + tableName + " (FEATURE, DOMAIN)");
            if (addNonPKIndex) {
                stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName3 + " ON " + tableName + " (\"DATE\", FEATURE, USAGE.DB)");
            }
            Date date = new Date(0L);
            PreparedStatement psInsert = con.prepareStatement("UPSERT INTO " + tableName + "(HOST, DOMAIN, FEATURE, \"DATE\", CORE, DB, ACTIVE_VISITOR) VALUES(?,?, ? , ?, ?, ?, ?)");
            psInsert.setString(1, "AA");
            psInsert.setString(2, "BB");
            psInsert.setString(3, "CC");
            psInsert.setDate(4, date);
            psInsert.setLong(5, 1L);
            psInsert.setLong(6, 2L);
            psInsert.setLong(7, 3L);
            psInsert.execute();
            if (!autoCommit) {
                con.commit();
            }
            String dml = "DELETE FROM " + tableName + " WHERE (HOST, DOMAIN, FEATURE, \"DATE\") = (?,?,?,?)";
            PreparedStatement psDelete = con.prepareStatement(dml);
            psDelete.setString(1, "AA");
            psDelete.setString(2, "BB");
            psDelete.setString(3, "CC");
            psDelete.setDate(4, date);
            psDelete.execute();
            if (!autoCommit) {
                con.commit();
            }
            psDelete = con.prepareStatement("EXPLAIN " + dml);
            psDelete.setString(1, "AA");
            psDelete.setString(2, "BB");
            psDelete.setString(3, "CC");
            psDelete.setDate(4, date);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)psDelete.executeQuery());
            if (addNonPKIndex) {
                Assert.assertNotEquals((Object)"DELETE SINGLE ROW", (Object)explainPlan);
            } else {
                Assert.assertEquals((Object)"DELETE SINGLE ROW", (Object)explainPlan);
            }
            DeleteIT.assertDeleted(con, tableName, indexName1, indexName2, indexName3);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteRowFromTableWithImmutableIndex(boolean localIndex, boolean useCoveredIndex) throws Exception {
        Connection con = null;
        try {
            boolean autoCommit = false;
            Properties props = new Properties();
            props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
            con = DriverManager.getConnection(DeleteIT.getUrl(), props);
            con.setAutoCommit(autoCommit);
            Statement stm = con.createStatement();
            String tableName = DeleteIT.generateUniqueName();
            String indexName1 = DeleteIT.generateUniqueName();
            String indexName2 = DeleteIT.generateUniqueName();
            String indexName3 = useCoveredIndex ? DeleteIT.generateUniqueName() : null;
            stm.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (HOST CHAR(2) NOT NULL,DOMAIN VARCHAR NOT NULL, FEATURE VARCHAR NOT NULL, \"DATE\" DATE NOT NULL, \nUSAGE.CORE BIGINT,USAGE.DB BIGINT,STATS.ACTIVE_VISITOR INTEGER CONSTRAINT PK PRIMARY KEY (HOST, DOMAIN, FEATURE, \"DATE\")) IMMUTABLE_ROWS=true");
            stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName1 + " ON " + tableName + " (\"DATE\", FEATURE)");
            stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName2 + " ON " + tableName + " (\"DATE\", FEATURE, USAGE.DB)");
            if (useCoveredIndex) {
                stm.execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName3 + " ON " + tableName + " (STATS.ACTIVE_VISITOR) INCLUDE (USAGE.CORE, USAGE.DB)");
            }
            stm.close();
            Date date = new Date(0L);
            PreparedStatement psInsert = con.prepareStatement("UPSERT INTO " + tableName + "(HOST, DOMAIN, FEATURE, \"DATE\", CORE, DB, ACTIVE_VISITOR) VALUES(?,?, ? , ?, ?, ?, ?)");
            psInsert.setString(1, "AA");
            psInsert.setString(2, "BB");
            psInsert.setString(3, "CC");
            psInsert.setDate(4, date);
            psInsert.setLong(5, 1L);
            psInsert.setLong(6, 2L);
            psInsert.setLong(7, 3L);
            psInsert.execute();
            if (!autoCommit) {
                con.commit();
            }
            PreparedStatement psDelete = con.prepareStatement("DELETE FROM " + tableName + " WHERE (HOST, DOMAIN, FEATURE, \"DATE\") = (?,?,?,?)");
            psDelete.setString(1, "AA");
            psDelete.setString(2, "BB");
            psDelete.setString(3, "CC");
            psDelete.setDate(4, date);
            psDelete.execute();
            if (!autoCommit) {
                con.commit();
            }
            DeleteIT.assertDeleted(con, tableName, indexName1, indexName2, indexName3);
            psInsert.execute();
            if (!autoCommit) {
                con.commit();
            }
            psDelete = con.prepareStatement("DELETE FROM " + tableName + " WHERE  USAGE.DB=2");
            psDelete.execute();
            if (!autoCommit) {
                con.commit();
            }
            DeleteIT.assertDeleted(con, tableName, indexName1, indexName2, indexName3);
            psInsert.execute();
            if (!autoCommit) {
                con.commit();
            }
            psDelete = con.prepareStatement("DELETE FROM " + tableName + " WHERE  ACTIVE_VISITOR=3");
            psDelete.execute();
            if (!autoCommit) {
                con.commit();
            }
            DeleteIT.assertDeleted(con, tableName, indexName1, indexName2, indexName3);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void assertDeleted(Connection con, String tableName, String indexName1, String indexName2, String indexName3) throws SQLException {
        ResultSet rs = con.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        rs = con.createStatement().executeQuery("SELECT count(*) FROM " + indexName1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        rs = con.createStatement().executeQuery("SELECT count(*) FROM " + indexName2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        if (indexName3 != null) {
            rs = con.createStatement().executeQuery("SELECT count(*) FROM " + indexName3);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
        }
    }

    @Test
    public void testDeleteAllFromTableNoAutoCommit() throws SQLException {
        this.testDeleteAllFromTable(false);
    }

    @Test
    public void testDeleteAllFromTableAutoCommit() throws SQLException {
        this.testDeleteAllFromTable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAllFromTable(boolean autoCommit) throws SQLException {
        Connection con = null;
        try {
            Properties props = new Properties();
            props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
            con = DriverManager.getConnection(DeleteIT.getUrl(), props);
            con.setAutoCommit(autoCommit);
            String tableName = DeleteIT.generateUniqueName();
            Statement stm = con.createStatement();
            stm.execute("CREATE TABLE IF NOT EXISTS " + tableName + "( HOST CHAR(2) NOT NULL,DOMAIN VARCHAR NOT NULL, FEATURE VARCHAR NOT NULL, \"DATE\" DATE NOT NULL, \nUSAGE.CORE BIGINT,USAGE.DB BIGINT,STATS.ACTIVE_VISITOR INTEGER CONSTRAINT PK PRIMARY KEY (HOST, DOMAIN, FEATURE, \"DATE\"))");
            stm.close();
            PreparedStatement psInsert = con.prepareStatement("UPSERT INTO " + tableName + "(HOST, DOMAIN, FEATURE, \"DATE\", CORE, DB, ACTIVE_VISITOR) VALUES(?,?, ? , ?, ?, ?, ?)");
            psInsert.setString(1, "AA");
            psInsert.setString(2, "BB");
            psInsert.setString(3, "CC");
            psInsert.setDate(4, new Date(0L));
            psInsert.setLong(5, 1L);
            psInsert.setLong(6, 2L);
            psInsert.setLong(7, 3L);
            psInsert.execute();
            psInsert.close();
            if (!autoCommit) {
                con.commit();
            }
            con.createStatement().execute("DELETE FROM " + tableName);
            if (!autoCommit) {
                con.commit();
            }
            ResultSet rs = con.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testDeleteForTableWithRowTimestampColServer() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        this.testDeleteForTableWithRowTimestampCol(true, tableName);
    }

    @Test
    public void testDeleteForTableWithRowTimestampColClient() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        this.testDeleteForTableWithRowTimestampCol(false, tableName);
    }

    private void testDeleteForTableWithRowTimestampCol(boolean autoCommit, String tableName) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(autoCommit);
            Statement stm = conn.createStatement();
            stm.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (HOST CHAR(2) NOT NULL,STAT_DATE DATE NOT NULL, \nUSAGE.CORE BIGINT,USAGE.DB BIGINT,CONSTRAINT PK PRIMARY KEY (HOST, STAT_DATE ROW_TIMESTAMP))");
            stm.close();
            PreparedStatement psInsert = conn.prepareStatement("UPSERT INTO " + tableName + " (HOST, STAT_DATE, CORE, DB) VALUES(?,?,?,?)");
            psInsert.setString(1, "AA");
            psInsert.setDate(2, new Date(100L));
            psInsert.setLong(3, 1L);
            psInsert.setLong(4, 2L);
            psInsert.execute();
            psInsert.close();
            if (!autoCommit) {
                conn.commit();
            }
            conn.createStatement().execute("DELETE FROM " + tableName);
            if (!autoCommit) {
                conn.commit();
            }
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            psInsert = conn.prepareStatement("UPSERT INTO " + tableName + " (HOST, CORE, DB) VALUES(?,?,?)");
            psInsert.setString(1, "BB");
            psInsert.setLong(2, 1L);
            psInsert.setLong(3, 2L);
            psInsert.execute();
            psInsert.close();
            if (!autoCommit) {
                conn.commit();
            }
            conn.createStatement().execute("DELETE FROM " + tableName);
            if (!autoCommit) {
                conn.commit();
            }
            rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
        }
    }

    @Test
    public void testServerSideDeleteAutoCommitOn() throws Exception {
        this.testDeleteCount(true, null);
    }

    @Test
    public void testClientSideDeleteCountAutoCommitOff() throws Exception {
        this.testDeleteCount(false, null);
    }

    @Test
    public void testClientSideDeleteAutoCommitOn() throws Exception {
        this.testDeleteCount(true, 1000);
    }

    @Test
    public void testPointDeleteWithMultipleImmutableIndexes() throws Exception {
        this.testPointDeleteWithMultipleImmutableIndexes(false);
    }

    @Test
    public void testPointDeleteWithMultipleImmutableIndexesAfterAlter() throws Exception {
        this.testPointDeleteWithMultipleImmutableIndexes(true);
    }

    private void testPointDeleteWithMultipleImmutableIndexes(boolean alterTable) throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String commands = "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INTEGER PRIMARY KEY,double_id DOUBLE,varchar_id VARCHAR (30)) " + (String)(alterTable ? ";ALTER TABLE " + tableName + " set " : "") + "IMMUTABLE_ROWS=true;CREATE INDEX IF NOT EXISTS index_column_varchar_id ON " + tableName + "(varchar_id);CREATE INDEX IF NOT EXISTS index_column_double_id ON " + tableName + "(double_id);UPSERT INTO " + tableName + " VALUES (9000000,0.5,'Sample text extra');";
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(true);
            Statement stm = conn.createStatement();
            for (String sql : commands.split(";")) {
                stm.execute(sql);
            }
            ResultSet rs = stm.executeQuery("select id,varchar_id,double_id from " + tableName + " WHERE ID=9000000");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9000000L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"Sample text extra", (Object)rs.getString(2));
            Assert.assertEquals((double)0.5, (double)rs.getDouble(3), (double)0.01);
            stm.execute("DELETE FROM " + tableName + " WHERE ID=9000000");
            DeleteIT.assertDeleted(conn, tableName, "index_column_varchar_id", "index_column_double_id", null);
            stm.close();
        }
    }

    private void testDeleteCount(boolean autoCommit, Integer limit) throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 DECIMAL NOT NULL, v1 VARCHAR CONSTRAINT PK PRIMARY KEY (pk1))";
        int numRecords = 1010;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            Statement stmt = conn.createStatement();
            for (int i = 0; i < numRecords; ++i) {
                stmt.executeUpdate("UPSERT INTO " + tableName + " (pk1, v1) VALUES (" + i + ",'value')");
            }
            conn.commit();
            conn.setAutoCommit(autoCommit);
            String delete = "DELETE FROM " + tableName + " WHERE (pk1) <= (" + numRecords + ")" + (String)(limit == null ? "" : " limit " + limit);
            try (PreparedStatement pstmt = conn.prepareStatement(delete);){
                int numberOfDeletes = pstmt.executeUpdate();
                Assert.assertEquals((long)(limit == null ? (long)numRecords : (long)limit.intValue()), (long)numberOfDeletes);
                if (!autoCommit) {
                    conn.commit();
                }
            }
        }
    }

    @Test
    public void testClientSideDeleteShouldNotFailWhenSameColumnPresentInMultipleIndexes() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String indexName1 = DeleteIT.generateUniqueName();
        String indexName2 = DeleteIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 DECIMAL NOT NULL, v1 VARCHAR, v2 VARCHAR CONSTRAINT PK PRIMARY KEY (pk1))";
        String idx1 = "CREATE INDEX " + indexName1 + " ON " + tableName + "(v1)";
        String idx2 = "CREATE INDEX " + indexName2 + " ON " + tableName + "(v1, v2)";
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.delete.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(idx1);
            conn.createStatement().execute(idx2);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES (1,'value', 'value2')");
            conn.commit();
            conn.setAutoCommit(false);
            try {
                conn.createStatement().execute("DELETE FROM " + tableName + " WHERE pk1 > 0");
            }
            catch (Exception e) {
                Assert.fail((String)"Should not throw any exception");
            }
        }
    }

    @Test
    public void testDeleteShouldNotFailWhenTheRowsMoreThanMaxMutationSize() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String indexName1 = DeleteIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 DECIMAL NOT NULL, v1 VARCHAR, v2 VARCHAR CONSTRAINT PK PRIMARY KEY (pk1)) IMMUTABLE_ROWS=true";
        String idx1 = "CREATE INDEX " + indexName1 + " ON " + tableName + "(v1)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.maxSize", Integer.toString(10));
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(idx1);
            Statement stmt = conn.createStatement();
            for (int i = 0; i < 20; ++i) {
                stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES (" + i + ",'value" + i + "', 'value2')");
                if (i % 10 != 0) continue;
                conn.commit();
            }
            conn.commit();
            conn.setAutoCommit(true);
            try {
                conn.createStatement().execute("DELETE FROM " + tableName);
            }
            catch (Exception e) {
                Assert.fail((String)"Should not throw any exception");
            }
        }
    }

    @Test
    public void testDeleteFilterWithMultipleIndexes() throws Exception {
        Statement statement;
        String tableName = DeleteIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (PKEY1 CHAR(15) NOT NULL, PKEY2 CHAR(15) NOT NULL, VAL1 CHAR(15), VAL2 CHAR(15), CONSTRAINT PK PRIMARY KEY (PKEY1, PKEY2)) ";
        String indexName1 = DeleteIT.generateUniqueName();
        String indexDdl1 = "CREATE INDEX IF NOT EXISTS " + indexName1 + " ON " + tableName + " (VAL1)";
        String indexName2 = DeleteIT.generateUniqueName();
        String indexDdl2 = "CREATE INDEX IF NOT EXISTS " + indexName2 + " ON " + tableName + " (VAL2)";
        String delete = "DELETE FROM " + tableName + " WHERE VAL1 = '000000000000000' limit 1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(true);
            statement = conn.createStatement();
            try {
                statement.execute(ddl);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            conn.createStatement().execute("upsert into " + tableName + " values ('PKEY1', 'PKEY2', '000000000000000', 'VAL2')");
            conn.commit();
            statement = conn.createStatement();
            try {
                statement.execute(indexDdl1);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        conn = DriverManager.getConnection(DeleteIT.getUrl(), props);
        try {
            String explainPlan;
            ResultSet rs;
            conn.setAutoCommit(true);
            statement = conn.createStatement();
            try {
                rs = statement.executeQuery("EXPLAIN " + delete);
                explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                IndexToolIT.assertExplainPlan(false, explainPlan, tableName, indexName1);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = conn.createStatement();
            try {
                statement.execute(indexDdl2);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = conn.createStatement();
            try {
                rs = statement.executeQuery("EXPLAIN " + delete);
                explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                IndexToolIT.assertExplainPlan(false, explainPlan, tableName, indexName1);
                statement.executeUpdate(delete);
                String query = "SELECT COUNT(*) from " + tableName;
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)0L, (long)rs.getInt(1));
                query = "SELECT COUNT(*) from " + indexName1;
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)0L, (long)rs.getInt(1));
                query = "SELECT COUNT(*) from " + indexName2;
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)0L, (long)rs.getInt(1));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testDeleteClientDeleteMutationPlan() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String indexName = DeleteIT.generateUniqueName();
        String tagValue = "customer-delete";
        String delete = "DELETE FROM " + tableName + " WHERE v1 = 'foo'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.source.operation", tagValue);
        this.createAndUpsertTable(tableName, indexName, props, false);
        this.verifyDeletePlan(delete, DeleteCompiler.ClientSelectDeleteMutationPlan.class, props);
        this.executeDelete(delete, props, 1);
        String startRowKeyForBaseTable = "1";
        String startRowKeyForIndexTable = "foo";
        this.checkTagPresentInDeleteMarker(tableName, startRowKeyForBaseTable, true, tagValue);
        this.checkTagPresentInDeleteMarker(indexName, startRowKeyForIndexTable, false, null);
    }

    @Test
    public void testDeleteServerDeleteMutationPlan() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String indexName = DeleteIT.generateUniqueName();
        String tagValue = "customer-delete";
        String delete = "DELETE FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.source.operation", tagValue);
        this.createAndUpsertTable(tableName, indexName, props, false);
        this.verifyDeletePlan(delete, DeleteCompiler.ServerSelectDeleteMutationPlan.class, props);
        this.executeDelete(delete, props, 2);
        String startRowKeyForBaseTable = "1";
        String startRowKeyForIndexTable = "foo";
        this.checkTagPresentInDeleteMarker(tableName, startRowKeyForBaseTable, true, tagValue);
        this.checkTagPresentInDeleteMarker(indexName, startRowKeyForIndexTable, false, null);
    }

    @Test
    public void testDeleteMultiRowDeleteMutationPlan() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String tagValue = "customer-delete";
        String delete = "DELETE FROM " + tableName + " WHERE k = 1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.source.operation", tagValue);
        this.createAndUpsertTable(tableName, null, props, false);
        this.verifyDeletePlan(delete, DeleteCompiler.MultiRowDeleteMutationPlan.class, props);
        this.executeDelete(delete, props, 1);
        String startRowKeyForBaseTable = "1";
        this.checkTagPresentInDeleteMarker(tableName, startRowKeyForBaseTable, true, tagValue);
    }

    private void verifyDeletePlan(String delete, Class<? extends MutationPlan> planClass, Properties props) throws SQLException {
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(true);
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            SQLParser parser = new SQLParser(delete);
            DeleteStatement deleteStmt = (DeleteStatement)parser.parseStatement();
            DeleteCompiler compiler = new DeleteCompiler(stmt, null);
            MutationPlan plan = compiler.compile(deleteStmt);
            Assert.assertEquals(planClass, plan.getClass());
        }
    }

    private void createAndUpsertTable(String tableName, String indexName, Properties props, boolean useOldCoproc) throws Exception {
        String ddl = "CREATE TABLE " + tableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)";
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(true);
            try (Statement statement = conn.createStatement();){
                statement.execute(ddl);
                if (indexName != null) {
                    String indexDdl1 = "CREATE INDEX " + indexName + " ON " + tableName + "(v1,v2)";
                    statement.execute(indexDdl1);
                }
                if (useOldCoproc) {
                    Admin admin = ((PhoenixConnection)conn).getQueryServices().getAdmin();
                    IndexTestUtil.downgradeCoprocs(tableName, indexName, admin);
                }
                statement.execute("upsert into " + tableName + " values (1, 'foo', 'foo1')");
                statement.execute("upsert into " + tableName + " values (2, 'bar', 'bar1')");
                conn.commit();
            }
        }
    }

    private void executeDelete(String delete, Properties props, int deleteRowCount) throws SQLException {
        try (Connection conn = DriverManager.getConnection(DeleteIT.getUrl(), props);){
            conn.setAutoCommit(true);
            try (Statement statement = conn.createStatement();){
                int rs = statement.executeUpdate(delete);
                Assert.assertEquals((long)deleteRowCount, (long)rs);
            }
        }
    }

    private void checkTagPresentInDeleteMarker(String tableName, String startRowKey, boolean tagPresent, String tagValue) throws IOException {
        ArrayList values = new ArrayList();
        TableName table = TableName.valueOf((String)tableName);
        for (HRegion region : DeleteIT.getUtility().getHBaseCluster().getRegions(table)) {
            Scan scan = new Scan();
            scan.setRaw(true);
            scan.withStartRow(Bytes.toBytes((String)startRowKey));
            RegionScannerImpl scanner = region.getScanner(scan);
            scanner.next(values);
            if (values.isEmpty()) continue;
            break;
        }
        Assert.assertFalse((String)"Values shouldn't be empty", (boolean)values.isEmpty());
        Cell first = (Cell)values.get(0);
        Assert.assertTrue((String)"First cell should be delete marker ", (boolean)CellUtil.isDelete((Cell)first));
        List tags = PrivateCellUtil.getTags((Cell)first);
        if (tagPresent) {
            Assert.assertEquals((long)1L, (long)tags.size());
            RawCell rawCell = (RawCell)first;
            Optional optional = rawCell.getTag((byte)65);
            Assert.assertTrue((boolean)optional.isPresent());
            Tag sourceOfOperationTag = (Tag)optional.get();
            Assert.assertEquals((Object)tagValue, (Object)Tag.getValueAsString((Tag)sourceOfOperationTag));
        } else {
            Assert.assertEquals((long)0L, (long)tags.size());
        }
    }

    @Test
    public void testDeleteTagsWithOldIndexCoproc() throws Exception {
        String tableName = DeleteIT.generateUniqueName();
        String tagValue = "customer-delete";
        String delete = "DELETE FROM " + tableName + " WHERE k = 1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.source.operation", tagValue);
        this.createAndUpsertTable(tableName, null, props, true);
        this.executeDelete(delete, props, 1);
        String startRowKeyForBaseTable = "1";
        this.checkTagPresentInDeleteMarker(tableName, startRowKeyForBaseTable, true, tagValue);
    }
}

