/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DecodeBinaryFunctionIT
extends ParallelStatsDisabledIT {
    private static String testTable;
    private static final String helloPhoenixString = "HelloPhoenix";
    private static final byte[] helloPhoenixBytes;
    private static final String base64Chunk = "SGVsbG9QaG9lbml4";
    private static final String hex48String = "48656c6c6f";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        testTable = DecodeBinaryFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (id INTEGER PRIMARY KEY, data VARCHAR)";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (1, ?)");
        ps.setString(1, helloPhoenixString);
        ps.execute();
        conn.commit();
        conn.close();
    }

    @Test
    public void testDecodeHBaseFromHexLiteral() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY('\\x48\\x65\\x6C\\x6C\\x6F\\x50\\x68\\x6F\\x65\\x6E\\x69\\x78', 'HBASE') FROM " + testTable);
        Assert.assertTrue((boolean)rs.next());
        byte[] actualBytes = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals(helloPhoenixBytes, actualBytes));
    }

    @Test
    public void testNullAndEmptyStringDecoding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(data, 'HBASE') FROM " + testTable + " WHERE ID=-10");
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (6, ?)");
        ps.setString(1, "");
        ps.execute();
        conn.commit();
        ResultSet rs2 = conn.createStatement().executeQuery("SELECT DECODE_BINARY(data, 'HEX') FROM " + testTable + " WHERE ID=6");
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals(null, (Object)rs2.getString(1));
    }

    @Test
    public void testLongBase64Decoding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        StringBuilder base64String = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            base64String.append(base64Chunk);
        }
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (3, ?)");
        ps.setString(1, base64String.toString());
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(data, 'BASE64') FROM " + testTable + " WHERE ID=3");
        Assert.assertTrue((boolean)rs.next());
        StringBuilder expectedString = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            expectedString.append(helloPhoenixString);
        }
        byte[] actualBytes = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals(expectedString.toString().getBytes(), actualBytes));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDecodeBase64WithPadding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (7, ?)");
        ps.setString(1, "SQ==");
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(data, 'BASE64') FROM " + testTable + " WHERE ID=7");
        Assert.assertTrue((boolean)rs.next());
        byte[] actualBytes = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals("I".getBytes(), actualBytes));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDecodeEncodeRoundHex() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (4, ?)");
        ps.setString(1, hex48String);
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(DECODE_BINARY(data, 'HEX'), 'HEX') FROM " + testTable + " WHERE ID=4");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)hex48String, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDecodeEncodeRoundBase64() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (5, ?)");
        ps.setString(1, base64Chunk);
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(DECODE_BINARY(data, 'BASE64'), 'BASE64') FROM " + testTable + " WHERE ID=5");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)base64Chunk, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDecodeEncodeRoundHbase() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(DECODE_BINARY(data, 'HBASE'), 'HBASE') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)helloPhoenixString, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    static {
        helloPhoenixBytes = helloPhoenixString.getBytes();
    }
}

