/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DateArithmeticIT
extends ParallelStatsDisabledIT {
    @Test
    public void testValidArithmetic() throws Exception {
        String[] queries;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        String tableName = DateArithmeticIT.initATableValues(DateArithmeticIT.generateUniqueName(), DateArithmeticIT.getOrganizationId(), DateArithmeticIT.getDefaultSplits(DateArithmeticIT.getOrganizationId()), date, null, DateArithmeticIT.getUrl(), "COLUMN_ENCODED_BYTES=0");
        for (String query : queries = new String[]{"SELECT entity_id,organization_id FROM " + tableName + " where (A_DATE - A_DATE) * 5 < 0", "SELECT entity_id,organization_id FROM " + tableName + " where 1 + A_DATE  < A_DATE", "SELECT entity_id,organization_id FROM " + tableName + " where A_DATE - 1 < A_DATE"}) {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.executeQuery();
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateAdd() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        String tableName = DateArithmeticIT.initATableValues(DateArithmeticIT.generateUniqueName(), DateArithmeticIT.getOrganizationId(), DateArithmeticIT.getDefaultSplits(DateArithmeticIT.getOrganizationId()), date, null, DateArithmeticIT.getUrl(), "COLUMN_ENCODED_BYTES=0");
        String query = "SELECT entity_id, b_string FROM " + tableName + " WHERE a_date + CAST(0.5 AS DOUBLE) < ?";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setDate(1, new Date(System.currentTimeMillis() + 86400000L));
            ResultSet rs = statement.executeQuery();
            ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList("00A123122312312", "b"), Arrays.asList("00A423122312312", "b"), Arrays.asList("00B723122312312", "b")});
            DateArithmeticIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateSubtract() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        String tableName = DateArithmeticIT.initATableValues(DateArithmeticIT.generateUniqueName(), DateArithmeticIT.getOrganizationId(), DateArithmeticIT.getDefaultSplits(DateArithmeticIT.getOrganizationId()), date, null, DateArithmeticIT.getUrl(), "COLUMN_ENCODED_BYTES=0");
        String query = "SELECT entity_id, b_string FROM " + tableName + " WHERE a_date - CAST(0.5 AS DOUBLE) > ?";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setDate(1, new Date(System.currentTimeMillis() + 86400000L));
            ResultSet rs = statement.executeQuery();
            ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList("00A323122312312", "e"), Arrays.asList("00B623122312312", "e"), Arrays.asList("00C923122312312", "e")});
            DateArithmeticIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateDateSubtract() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        String tableName = DateArithmeticIT.initATableValues(DateArithmeticIT.generateUniqueName(), DateArithmeticIT.getOrganizationId(), DateArithmeticIT.getDefaultSplits(DateArithmeticIT.getOrganizationId()), date, null, DateArithmeticIT.getUrl(), "COLUMN_ENCODED_BYTES=0");
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO  " + tableName + " (organization_id,entity_id,a_time) VALUES(?,?,?)");
        statement.setString(1, DateArithmeticIT.getOrganizationId());
        statement.setString(2, "00A223122312312");
        statement.setDate(3, date);
        statement.execute();
        statement.setString(2, "00A323122312312");
        statement.setDate(3, date);
        statement.execute();
        statement.setString(2, "00A423122312312");
        statement.setDate(3, new Date(date.getTime() + 86400000L - 1L));
        statement.execute();
        statement.setString(2, "00B623122312312");
        statement.setDate(3, new Date(date.getTime() + 86400000L - 1L));
        statement.execute();
        statement.setString(2, "00C923122312312");
        statement.setDate(3, date);
        statement.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(url, props);
        try {
            statement = conn.prepareStatement("SELECT entity_id, b_string FROM " + tableName + " WHERE a_date - a_time > 1");
            ResultSet rs = statement.executeQuery();
            ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList("00A323122312312", "e"), Arrays.asList("00B623122312312", "e"), Arrays.asList("00C923122312312", "e")});
            DateArithmeticIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testAddTimeStamp() throws Exception {
        String tName = DateArithmeticIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        conn.createStatement().execute("create table " + tName + " (ts timestamp primary key)");
        conn.close();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tName + " values (?)");
        stmt.setTimestamp(1, new Timestamp(95, 4, 2, 1, 1, 1, 1));
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ts FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-02 01:01:01.000000001", (Object)rs.getTimestamp(1).toString());
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT ts + 1 FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-03 01:01:01.000000001", (Object)rs.getTimestamp(1).toString());
    }

    @Test
    public void testSubtractTimeStamp() throws Exception {
        String tName = DateArithmeticIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        conn.createStatement().execute("create table " + tName + " (ts timestamp primary key)");
        conn.close();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tName + " values (?)");
        stmt.setTimestamp(1, new Timestamp(95, 4, 2, 1, 1, 1, 1));
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ts FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-02 01:01:01.000000001", (Object)rs.getTimestamp(1).toString());
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT ts - 1 FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-01 01:01:01.000000001", (Object)rs.getTimestamp(1).toString());
    }

    @Test
    public void testAddTime() throws Exception {
        String tName = DateArithmeticIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        conn.createStatement().execute("create table " + tName + " (ts time primary key)");
        conn.close();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tName + " values (?)");
        Time time = new Time(95, 4, 2);
        stmt.setTime(1, time);
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ts FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)time.getTime(), (long)rs.getTimestamp(1).getTime());
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT ts + 1 FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)(time.getTime() + 86400000L), (long)rs.getTimestamp(1).getTime());
    }

    @Test
    public void testSubtractTime() throws Exception {
        String tName = DateArithmeticIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        conn.createStatement().execute("create table " + tName + " (ts time primary key)");
        conn.close();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tName + " values (?)");
        Time time = new Time(95, 4, 2);
        stmt.setTime(1, time);
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ts FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)time.getTime(), (long)rs.getTimestamp(1).getTime());
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT ts - 1 FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)(time.getTime() - 86400000L), (long)rs.getTimestamp(1).getTime());
    }

    @Test
    public void testSubtractDate() throws Exception {
        String tName = DateArithmeticIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        conn.createStatement().execute("create table " + tName + " (ts date primary key)");
        conn.close();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tName + " values (?)");
        stmt.setDate(1, new Date(95, 4, 2));
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ts FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-02", (Object)rs.getDate(1).toString());
        conn = DriverManager.getConnection(DateArithmeticIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT ts - 1 FROM " + tName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1995-05-01", (Object)rs.getDate(1).toString());
    }
}

