/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CustomEntityDataIT
extends ParallelStatsDisabledIT {
    private static void initTableValues(Connection conn, String tenantId, String tableName) throws Exception {
        String ddl = "create table " + tableName + "   (organization_id char(15) not null, \n    key_prefix char(3) not null,\n    custom_entity_data_id char(12) not null,\n    created_by varchar,\n    created_date date,\n    currency_iso_code char(3),\n    deleted char(1),\n    division decimal(31,10),\n    last_activity date,\n    last_update date,\n    last_update_by varchar,\n    name varchar(240),\n    owner varchar,\n    record_type_id char(15),\n    setup_owner varchar,\n    system_modstamp date,\n    b.val0 varchar,\n    b.val1 varchar,\n    b.val2 varchar,\n    b.val3 varchar,\n    b.val4 varchar,\n    b.val5 varchar,\n    b.val6 varchar,\n    b.val7 varchar,\n    b.val8 varchar,\n    b.val9 varchar\n    CONSTRAINT pk PRIMARY KEY (organization_id, key_prefix, custom_entity_data_id)) SPLIT ON ('" + tenantId + "00A','" + tenantId + "00B','" + tenantId + "00C')";
        conn.createStatement().execute(ddl);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     KEY_PREFIX,     CUSTOM_ENTITY_DATA_ID,     CREATED_BY,     CREATED_DATE,     CURRENCY_ISO_CODE,     DELETED,     DIVISION,     LAST_UPDATE,     LAST_UPDATE_BY,    NAME,    OWNER,    SYSTEM_MODSTAMP,    VAL0,    VAL1,    VAL2,    VAL3,    VAL4,    VAL5,    VAL6,    VAL7,    VAL8,    VAL9)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A223122312312".substring(0, 3));
        stmt.setString(3, "00A223122312312".substring(3));
        stmt.setString(4, "Curly");
        stmt.setDate(5, new Date(1L));
        stmt.setString(6, "ISO");
        stmt.setString(7, "0");
        stmt.setBigDecimal(8, new BigDecimal(1));
        stmt.setDate(9, new Date(2L));
        stmt.setString(10, "Curly");
        stmt.setString(11, "Curly");
        stmt.setString(12, "Curly");
        stmt.setDate(13, new Date(2L));
        stmt.setString(14, "2");
        stmt.setString(15, "2");
        stmt.setString(16, "2");
        stmt.setString(17, "2");
        stmt.setString(18, "2");
        stmt.setString(19, "2");
        stmt.setString(20, "2");
        stmt.setString(21, "2");
        stmt.setString(22, "2");
        stmt.setString(23, "2");
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B523122312312".substring(0, 3));
        stmt.setString(3, "00B523122312312".substring(3));
        stmt.setString(4, "Moe");
        stmt.setDate(5, new Date(1L));
        stmt.setString(6, "ISO");
        stmt.setString(7, "0");
        stmt.setBigDecimal(8, new BigDecimal(1));
        stmt.setDate(9, new Date(2L));
        stmt.setString(10, "Moe");
        stmt.setString(11, "Moe");
        stmt.setString(12, "Moe");
        stmt.setDate(13, new Date(2L));
        stmt.setString(14, "5");
        stmt.setString(15, "5");
        stmt.setString(16, "5");
        stmt.setString(17, "5");
        stmt.setString(18, "5");
        stmt.setString(19, "5");
        stmt.setString(20, "5");
        stmt.setString(21, "5");
        stmt.setString(22, "5");
        stmt.setString(23, "5");
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00C923122312312".substring(0, 3));
        stmt.setString(3, "00C923122312312".substring(3));
        stmt.setString(4, "Larry");
        stmt.setDate(5, new Date(1L));
        stmt.setString(6, "ISO");
        stmt.setString(7, "0");
        stmt.setBigDecimal(8, new BigDecimal(1));
        stmt.setDate(9, new Date(2L));
        stmt.setString(10, "Larry");
        stmt.setString(11, "Larry");
        stmt.setString(12, "Larry");
        stmt.setDate(13, new Date(2L));
        stmt.setString(14, "v9");
        stmt.setString(15, "v9");
        stmt.setString(16, "v9");
        stmt.setString(17, "v9");
        stmt.setString(18, "v9");
        stmt.setString(19, "v9");
        stmt.setString(20, "v9");
        stmt.setString(21, "v9");
        stmt.setString(22, "v9");
        stmt.setString(23, "v9");
        stmt.execute();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUngroupedAggregation() throws Exception {
        String tenantId = CustomEntityDataIT.getOrganizationId();
        String tableName = CustomEntityDataIT.generateUniqueName();
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id=?";
        try (Connection conn = DriverManager.getConnection(CustomEntityDataIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            CustomEntityDataIT.initTableValues(conn, tenantId, tableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScan() throws Exception {
        String tenantId = CustomEntityDataIT.getOrganizationId();
        String tableName = CustomEntityDataIT.generateUniqueName();
        String query = "SELECT CREATED_BY,CREATED_DATE,CURRENCY_ISO_CODE,DELETED,DIVISION,LAST_UPDATE,LAST_UPDATE_BY,NAME,OWNER,SYSTEM_MODSTAMP,VAL0,VAL1,VAL2,VAL3,VAL4,VAL5,VAL6,VAL7,VAL8,VAL9 FROM " + tableName + " WHERE organization_id=?";
        try (Connection conn = DriverManager.getConnection(CustomEntityDataIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            CustomEntityDataIT.initTableValues(conn, tenantId, tableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Curly", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Moe", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Larry", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhereStringConcatExpression() throws Exception {
        String tenantId = CustomEntityDataIT.getOrganizationId();
        String tableName = CustomEntityDataIT.generateUniqueName();
        String query = "SELECT KEY_PREFIX||CUSTOM_ENTITY_DATA_ID FROM " + tableName + " where '00A'||val0 LIKE '00A2%'";
        try (Connection conn = DriverManager.getConnection(CustomEntityDataIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            CustomEntityDataIT.initTableValues(conn, tenantId, tableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

