/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.SchemaAlreadyExistsException;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CreateSchemaIT
extends ParallelStatsDisabledIT {
    @Test
    public void testCreateSchema() throws Exception {
        Admin admin;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        String schemaName = CreateSchemaIT.generateUniqueName();
        String schemaName1 = schemaName.toLowerCase();
        String schemaName2 = schemaName.toLowerCase();
        String ddl1 = "CREATE SCHEMA \"" + schemaName1 + "\"";
        String ddl2 = "CREATE SCHEMA " + schemaName2;
        try (Connection conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);){
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            try {
                conn.createStatement().execute(ddl1);
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)schemaName1));
                conn.createStatement().execute(ddl2);
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)schemaName2.toUpperCase()));
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        try {
            conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);
            try {
                conn.createStatement().execute(ddl1);
                Assert.fail();
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SchemaAlreadyExistsException conn2) {
            // empty catch block
        }
        conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);
        try {
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            try {
                try {
                    conn.createStatement().execute("CREATE SCHEMA \"default\"");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.SCHEMA_NOT_ALLOWED.getErrorCode(), (long)e.getErrorCode());
                }
                try {
                    conn.createStatement().execute("CREATE SCHEMA \"hbase\"");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.SCHEMA_NOT_ALLOWED.getErrorCode(), (long)e.getErrorCode());
                }
                conn.createStatement().execute("CREATE SCHEMA \"" + "default".toUpperCase() + "\"");
                conn.createStatement().execute("CREATE SCHEMA \"" + "hbase".toUpperCase() + "\"");
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)"default".toUpperCase()));
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)"hbase".toUpperCase()));
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

