/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CostBasedDecisionIT
extends BaseTest {
    private final String testTable500 = CostBasedDecisionIT.initTestTableValues(500);
    private final String testTable990 = CostBasedDecisionIT.initTestTableValues(990);
    private final String testTable1000 = CostBasedDecisionIT.initTestTableValues(1000);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.stats.guidepost.width", Long.toString(20L));
        props.put("phoenix.stats.updateFrequency", Long.toString(5L));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        props.put("phoenix.costbased.optimizer.enabled", Boolean.toString(true));
        props.put("phoenix.query.maxServerCacheBytes", Long.toString(150000L));
        CostBasedDecisionIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrdering1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 VARCHAR,\nc2 VARCHAR)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_idx ON " + tableName + " (c1)");
            String query = "SELECT rowkey, c1, c2 FROM " + tableName + " where c1 LIKE 'X0%' ORDER BY rowkey";
            CostBasedDecisionIT.verifyQueryPlan(query, "FULL SCAN");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2) VALUES (?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                int c1 = i % 16;
                stmt.setString(1, "k" + i);
                stmt.setString(2, "X" + Integer.toHexString(c1) + c1);
                stmt.setString(3, "c");
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            CostBasedDecisionIT.verifyQueryPlan(query, "RANGE SCAN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrdering2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName = tableName + "_IDX";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 VARCHAR,\nc2 VARCHAR)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + " (c1)");
            String query = "SELECT c1, max(rowkey), max(c2) FROM " + tableName + " where rowkey <= 'z' GROUP BY c1";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [*] - ['z']", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER AGGREGATE INTO DISTINCT ROWS BY [C1]", (Object)explainPlanAttributes.getServerAggregate());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2) VALUES (?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                int c1 = i % 16;
                stmt.setString(1, "k" + i);
                stmt.setString(2, "X" + Integer.toHexString(c1) + c1);
                stmt.setString(3, "c");
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexName + "(" + tableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY AND \"ROWKEY\" <= 'z'", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"C1\"]", (Object)explainPlanAttributes.getServerAggregate());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrdering3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName1 = tableName + "_IDX1";
            String indexName2 = tableName + "_IDX2";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 INTEGER,\nc2 INTEGER,\nc3 INTEGER)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName1 + " ON " + tableName + " (c1) INCLUDE (c2, c3)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName2 + " ON " + tableName + " (c2, c3) INCLUDE (c1)");
            String query = "SELECT * FROM " + tableName + " where c1 BETWEEN 10 AND 20 AND c2 < 9000 AND C3 < 5000";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexName2 + "(" + tableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [2,*] - [2,9,000]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY ((\"C1\" >= 10 AND \"C1\" <= 20) AND TO_INTEGER(\"C3\") < 5000)", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2, c3) VALUES (?, ?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                stmt.setString(1, "k" + i);
                stmt.setInt(2, i);
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexName1 + "(" + tableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1,10] - [1,20]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY (\"C2\" < 9000 AND \"C3\" < 5000)", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrderingInUpsertQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName1 = tableName + "_IDX1";
            String indexName2 = tableName + "_IDX2";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 INTEGER,\nc2 INTEGER,\nc3 INTEGER)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName1 + " ON " + tableName + "(c1) INCLUDE (c2, c3)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName2 + " ON " + tableName + " (c2, c3) INCLUDE (c1)");
            String query = "UPSERT INTO " + tableName + " SELECT * FROM " + tableName + " where c1 BETWEEN 10 AND 20 AND c2 < 9000 AND C3 < 5000";
            CostBasedDecisionIT.verifyQueryPlan(query, "UPSERT SELECT\nCLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName2 + "(" + tableName + ") [2,*] - [2,9,000]\n    SERVER FILTER BY ((\"C1\" >= 10 AND \"C1\" <= 20) AND TO_INTEGER(\"C3\") < 5000)\nCLIENT MERGE SORT");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2, c3) VALUES (?, ?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                stmt.setString(1, "k" + i);
                stmt.setInt(2, i);
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            CostBasedDecisionIT.verifyQueryPlan(query, "UPSERT SELECT\nCLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName1 + "(" + tableName + ") [1,10] - [1,20]\n    SERVER FILTER BY (\"C2\" < 9000 AND \"C3\" < 5000)\nCLIENT MERGE SORT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrderingInDeleteQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName1 = tableName + "_IDX1";
            String indexName2 = tableName + "_IDX2";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 INTEGER,\nc2 INTEGER,\nc3 INTEGER)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName1 + " ON " + tableName + " (c1) INCLUDE (c2, c3)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName2 + " ON " + tableName + " (c2, c3) INCLUDE (c1)");
            String query = "DELETE FROM " + tableName + " where c1 BETWEEN 10 AND 20 AND c2 < 9000 AND C3 < 5000";
            CostBasedDecisionIT.verifyQueryPlan(query, "DELETE ROWS CLIENT SELECT\nCLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName2 + "(" + tableName + ") [2,*] - [2,9,000]\n    SERVER FILTER BY ((\"C1\" >= 10 AND \"C1\" <= 20) AND TO_INTEGER(\"C3\") < 5000)\nCLIENT MERGE SORT");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2, c3) VALUES (?, ?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                stmt.setString(1, "k" + i);
                stmt.setInt(2, i);
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            CostBasedDecisionIT.verifyQueryPlan(query, "DELETE ROWS CLIENT SELECT\nCLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName1 + "(" + tableName + ") [1,10] - [1,20]\n    SERVER FILTER BY (\"C2\" < 9000 AND \"C3\" < 5000)\nCLIENT MERGE SORT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrderingInUnionQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName = tableName + "_IDX";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 VARCHAR,\nc2 VARCHAR)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + " (c1)");
            String query = "SELECT c1, max(rowkey), max(c2) FROM " + tableName + " where rowkey <= 'z' GROUP BY c1 UNION ALL SELECT c1, max(rowkey), max(c2) FROM " + tableName + " where rowkey >= 'a' GROUP BY c1";
            CostBasedDecisionIT.verifyQueryPlan(query, "UNION ALL OVER 2 QUERIES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " [*] - ['z']\n        SERVER AGGREGATE INTO DISTINCT ROWS BY [C1]\n    CLIENT MERGE SORT\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " ['a'] - [*]\n        SERVER AGGREGATE INTO DISTINCT ROWS BY [C1]\n    CLIENT MERGE SORT");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2) VALUES (?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                int c1 = i % 16;
                stmt.setString(1, "k" + i);
                stmt.setString(2, "X" + Integer.toHexString(c1) + c1);
                stmt.setString(3, "c");
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            CostBasedDecisionIT.verifyQueryPlan(query, "UNION ALL OVER 2 QUERIES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1]\n        SERVER MERGE [0.C2]\n        SERVER FILTER BY FIRST KEY ONLY AND \"ROWKEY\" <= 'z'\n        SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"C1\"]\n    CLIENT MERGE SORT\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1]\n        SERVER MERGE [0.C2]\n        SERVER FILTER BY FIRST KEY ONLY AND \"ROWKEY\" >= 'a'\n        SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"C1\"]\n    CLIENT MERGE SORT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCostOverridesStaticPlanOrderingInJoinQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            String indexName = tableName + "_IDX";
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey VARCHAR PRIMARY KEY,\nc1 VARCHAR,\nc2 VARCHAR)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_idx ON " + tableName + " (c1)");
            String query = "SELECT t1.rowkey, t1.c1, t1.c2, t2.c1, mc2 FROM " + tableName + " t1 JOIN (SELECT c1, max(rowkey) mrk, max(c2) mc2 FROM " + tableName + " where rowkey <= 'z' GROUP BY c1) t2 ON t1.rowkey = t2.mrk WHERE t1.c1 LIKE 'X0%' ORDER BY t1.rowkey";
            CostBasedDecisionIT.verifyQueryPlan(query, "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + tableName + "\n    SERVER FILTER BY C1 LIKE 'X0%'\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + tableName + " [*] - ['z']\n            SERVER AGGREGATE INTO DISTINCT ROWS BY [C1]\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY T1.ROWKEY IN (T2.MRK)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2) VALUES (?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                int c1 = i % 16;
                stmt.setString(1, "k" + i);
                stmt.setString(2, "X" + Integer.toHexString(c1) + c1);
                stmt.setString(3, "c");
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            CostBasedDecisionIT.verifyQueryPlan(query, "CLIENT PARALLEL 626-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1,'X0'] - [1,'X1']\n    SERVER MERGE [0.C2]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER SORTED BY [\"T1.:ROWKEY\"]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1]\n            SERVER MERGE [0.C2]\n            SERVER FILTER BY FIRST KEY ONLY AND \"ROWKEY\" <= 'z'\n            SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"C1\"]\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"T1.:ROWKEY\" IN (T2.MRK)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHintOverridesCost() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = BaseTest.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nrowkey INTEGER PRIMARY KEY,\nc1 VARCHAR,\nc2 VARCHAR)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_idx ON " + tableName + " (c1)");
            String query = "SELECT rowkey, c1, c2 FROM " + tableName + " where rowkey between 1 and 10 ORDER BY c1";
            String hintedQuery = query.replaceFirst("SELECT", "SELECT  /*+ INDEX(" + tableName + " " + tableName + "_idx) */");
            String dataPlan = "[C1]";
            String indexPlan = "SERVER FILTER BY FIRST KEY ONLY AND (\"ROWKEY\" >= 1 AND \"ROWKEY\" <= 10)";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)indexPlan, (Object)explainPlanAttributes.getServerWhereFilter());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (rowkey, c1, c2) VALUES (?, ?, ?)");
            for (int i = 0; i < 10000; ++i) {
                int c1 = i % 16;
                stmt.setInt(1, i);
                stmt.setString(2, "X" + Integer.toHexString(c1) + c1);
                stmt.setString(3, "c");
                stmt.execute();
            }
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)dataPlan, (Object)explainPlanAttributes.getServerSortedBy());
            plan = conn.prepareStatement(hintedQuery).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)indexPlan, (Object)explainPlanAttributes.getServerWhereFilter());
        }
    }

    @Test
    public void testJoinStrategy() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.ID";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            ExplainPlan plan = conn.prepareStatement(q).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"SORT-MERGE-JOIN (INNER)", (Object)explainPlanAttributes.getAbstractExplainPlan());
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)this.testTable500, (Object)explainPlanAttributes.getTableName());
            ExplainPlanAttributes rhsTable = explainPlanAttributes.getRhsJoinQueryExplainPlan();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)rhsTable.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)rhsTable.getExplainScanType());
            Assert.assertEquals((Object)this.testTable1000, (Object)rhsTable.getTableName());
        }
    }

    @Test
    public void testJoinStrategy2() throws Exception {
        String q = "SELECT count(*)\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.ID\nWHERE t1.COL1 < 200";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            ExplainPlan plan = conn.prepareStatement(q).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"SORT-MERGE-JOIN (INNER)", (Object)explainPlanAttributes.getAbstractExplainPlan());
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY COL1 < 200", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)this.testTable500, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"CLIENT AGGREGATE INTO SINGLE ROW", (Object)explainPlanAttributes.getClientAggregate());
            ExplainPlanAttributes rhsTable = explainPlanAttributes.getRhsJoinQueryExplainPlan();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)rhsTable.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)rhsTable.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)rhsTable.getServerWhereFilter());
            Assert.assertEquals((Object)this.testTable1000, (Object)rhsTable.getTableName());
        }
    }

    @Test
    public void testJoinStrategy3() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.COL1 = t2.ID\nWHERE t1.ID > 200";
        String expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]\n    DYNAMIC SERVER FILTER BY T2.ID IN (T1.COL1)";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy4() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable990 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.COL1";
        String expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable990 + "\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    DYNAMIC SERVER FILTER BY T1.ID IN (T2.COL1)";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy5() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.COL1\nWHERE t1.ID > 200";
        String expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy6() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.COL1 = t2.COL1\nWHERE t1.ID > 200";
        String expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy7() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.ID\nORDER BY t1.COL1";
        String expected = "CLIENT PARALLEL 1001-WAY FULL SCAN OVER " + this.testTable1000 + "\n    SERVER SORTED BY [T1.COL1]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable500 + "\n    DYNAMIC SERVER FILTER BY T2.ID IN (T1.ID)";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy8() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable500 + " t1 JOIN " + this.testTable1000 + " t2\nON t1.ID = t2.ID\nORDER BY t1.COL1 LIMIT 5";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            ExplainPlan plan = conn.prepareStatement(q).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"SORT-MERGE-JOIN (INNER)", (Object)explainPlanAttributes.getAbstractExplainPlan());
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)this.testTable500, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"[T1.COL1]", (Object)explainPlanAttributes.getClientSortedBy());
            Assert.assertEquals((Object)new Integer(5), (Object)explainPlanAttributes.getClientRowLimit());
            ExplainPlanAttributes rhsTable = explainPlanAttributes.getRhsJoinQueryExplainPlan();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)rhsTable.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)rhsTable.getExplainScanType());
            Assert.assertEquals((Object)this.testTable1000, (Object)rhsTable.getTableName());
        }
    }

    @Test
    public void testJoinStrategy9() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable1000 + " t1 LEFT JOIN " + this.testTable500 + " t2\nON t1.ID = t2.ID AND t2.ID > 200\nLEFT JOIN " + this.testTable990 + " t3\nON t1.ID = t3.ID AND t3.ID < 100";
        String expected = "SORT-MERGE-JOIN (LEFT) TABLES\n    SORT-MERGE-JOIN (LEFT) TABLES\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    AND\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]\nAND\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable990 + " [*] - [100]";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy10() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable1000 + " t1 JOIN " + this.testTable500 + " t2\nON t1.ID = t2.COL1 AND t2.ID > 200\nJOIN " + this.testTable990 + " t3\nON t1.ID = t3.ID AND t3.ID < 100";
        String expected = "SORT-MERGE-JOIN (INNER) TABLES\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n        PARALLEL INNER-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]\n        DYNAMIC SERVER FILTER BY T1.ID IN (T2.COL1)\nAND\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable990 + " [*] - [100]";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy11() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable1000 + " t1 JOIN " + this.testTable500 + " t2\nON t1.COL2 = t2.COL1 AND t2.ID > 200\nJOIN " + this.testTable990 + " t3\nON t1.COL1 = t3.COL2 AND t3.ID < 100";
        String expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable1000 + "\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable500 + " [201] - [*]\n    PARALLEL INNER-JOIN TABLE 1\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.testTable990 + " [*] - [100]";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    @Test
    public void testJoinStrategy12() throws Exception {
        String q = "SELECT *\nFROM " + this.testTable1000 + " t1 JOIN " + this.testTable990 + " t2\nON t1.COL2 = t2.COL1\nJOIN " + this.testTable990 + " t3\nON t1.COL1 = t3.COL2";
        String expected = "SORT-MERGE-JOIN (INNER) TABLES\n    CLIENT PARALLEL 1001-WAY FULL SCAN OVER " + this.testTable1000 + "\n        SERVER SORTED BY [T1.COL1]\n    CLIENT MERGE SORT\n        PARALLEL INNER-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.testTable990 + "\nAND\n    CLIENT PARALLEL 991-WAY FULL SCAN OVER " + this.testTable990 + "\n        SERVER SORTED BY [T3.COL2]\n    CLIENT MERGE SORT";
        CostBasedDecisionIT.verifyQueryPlan(q, expected);
    }

    private static void verifyQueryPlan(String query, String expected) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("explain " + query);
        String plan = QueryUtil.getExplainPlan((ResultSet)rs);
        Assert.assertTrue((String)("Expected '" + expected + "' in the plan:\n" + plan + "."), (boolean)plan.contains(expected));
    }

    private static String initTestTableValues(int rows) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CostBasedDecisionIT.getUrl(), props);){
            String tableName = CostBasedDecisionIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + tableName + " (\nID INTEGER NOT NULL PRIMARY KEY,\nCOL1 INTEGER,COL2 INTEGER)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?, ?, ?)");
            for (int i = 0; i < rows; ++i) {
                stmt.setInt(1, i + 1);
                stmt.setInt(2, rows - i);
                stmt.setInt(3, rows + i);
                stmt.execute();
            }
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
            String string = tableName;
            return string;
        }
    }
}

