/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.query.BaseTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ConnectionUtilIT {
    private static HBaseTestingUtility hbaseTestUtil;
    private static Configuration conf;

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        hbaseTestUtil = new HBaseTestingUtility();
        conf = hbaseTestUtil.getConfiguration();
        BaseTest.setUpConfigForMiniCluster(conf);
        conf.set("zookeeper.znode.parent", "/hbase-test");
        hbaseTestUtil.startMiniCluster();
        Class.forName(PhoenixDriver.class.getName());
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
    }

    @Test
    public void testInputAndOutputConnections() throws SQLException {
        Connection inputConnection = ConnectionUtil.getInputConnection((Configuration)conf);
        Statement stmt = inputConnection.createStatement();
        stmt.execute("create table t(a integer primary key,b varchar)");
        stmt.execute("upsert into t values(1,'foo')");
        inputConnection.commit();
        ResultSet rs = stmt.executeQuery("select count(*) from t");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Connection outputConnection = ConnectionUtil.getOutputConnection((Configuration)conf);
        stmt = outputConnection.createStatement();
        stmt.execute("create table t1(a integer primary key,b varchar)");
        stmt.execute("upsert into t1 values(1,'foo')");
        outputConnection.commit();
        rs = stmt.executeQuery("select count(*) from t1");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
    }
}

