/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcController;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionService;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.transaction.TransactionServiceManager;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesTestImpl
extends ConnectionQueryServicesImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesTestImpl.class);
    private Set<PhoenixConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PhoenixTransactionService[] txServices = new PhoenixTransactionService[TransactionFactory.Provider.values().length];

    public ConnectionQueryServicesTestImpl(QueryServices services, ConnectionInfo info, Properties props) throws SQLException {
        super(services, info, props);
    }

    public void addConnection(PhoenixConnection connection) throws SQLException {
        this.connections.add(connection);
        super.addConnection(connection);
    }

    public void removeConnection(PhoenixConnection connection) throws SQLException {
        this.connections.remove(connection);
        super.removeConnection(connection);
    }

    public RpcController getController() {
        return super.getController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            ArrayList<PhoenixConnection> connections;
            ConnectionQueryServicesTestImpl connectionQueryServicesTestImpl = this;
            synchronized (connectionQueryServicesTestImpl) {
                connections = new ArrayList<PhoenixConnection>(this.connections);
                this.connections = Sets.newHashSet();
                for (PhoenixTransactionService service : this.txServices) {
                    if (service == null) continue;
                    try {
                        service.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            SQLCloseables.closeAll(connections);
            long unfreedBytes = this.clearCache();
            Assert.assertEquals((String)"Found unfreed bytes in server-side cache", (long)0L, (long)unfreedBytes);
        }
        finally {
            super.close();
        }
    }

    public synchronized PhoenixTransactionClient initTransactionClient(TransactionFactory.Provider provider) throws SQLException {
        PhoenixTransactionService txService = this.txServices[provider.ordinal()];
        if (txService == null) {
            int port = TestUtil.getRandomPort();
            PhoenixTransactionService phoenixTransactionService = TransactionServiceManager.startTransactionService(provider, this.config, this.connectionInfo, port);
            this.txServices[provider.ordinal()] = phoenixTransactionService;
            txService = phoenixTransactionService;
        }
        return super.initTransactionClient(provider);
    }
}

