/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.query.ITGuidePostsCacheFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class ConfigurableCacheIT
extends ParallelStatsEnabledIT {
    static String table;

    @BeforeClass
    public static synchronized void initTables() throws Exception {
        table = ConfigurableCacheIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ConfigurableCacheIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + table + " (k INTEGER PRIMARY KEY, c1.a bigint, c2.b bigint) GUIDE_POSTS_WIDTH=20");
            conn.createStatement().execute("upsert into " + table + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + table + " values (101,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (102,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (103,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (104,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (105,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (106,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (107,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (108,2,4)");
            conn.createStatement().execute("upsert into " + table + " values (109,2,4)");
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + table);
            conn.commit();
        }
    }

    private Connection getCacheFactory(String principal, String cacheFactoryString) throws Exception {
        String url = ConfigurableCacheIT.getUrl();
        url = url.replace(";test=true", "");
        url = ConnectionInfo.create((String)url, null, null).withPrincipal(principal).toUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.guide.posts.cache.factory.class", cacheFactoryString);
        props.put("phoenix.stats.guidepost.width", Long.toString(20L));
        props.put("phoenix.stats.updateFrequency", Long.toString(5L));
        props.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(url, props);
        return conn;
    }

    @Test
    public void testWithDefaults() throws Exception {
        int initialCount = ITGuidePostsCacheFactory.getCount();
        try (Connection conn = DriverManager.getConnection(ConfigurableCacheIT.getUrl());){
            conn.createStatement().executeQuery("SELECT * FROM " + table);
        }
        Assert.assertEquals((long)initialCount, (long)ITGuidePostsCacheFactory.getCount());
    }

    @Test
    public void testWithSingle() throws Exception {
        int initialCount = ITGuidePostsCacheFactory.getCount();
        try (Connection conn = this.getCacheFactory("User1", ITGuidePostsCacheFactory.class.getTypeName());){
            conn.createStatement().executeQuery("SELECT * FROM " + table);
        }
        conn = this.getCacheFactory("User1", ITGuidePostsCacheFactory.class.getTypeName());
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + table);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertEquals((long)(initialCount + 1), (long)ITGuidePostsCacheFactory.getCount());
    }

    @Test
    public void testWithMultiple() throws Exception {
        int initialCount = ITGuidePostsCacheFactory.getCount();
        try (Connection conn = this.getCacheFactory("User4", ITGuidePostsCacheFactory.class.getTypeName());){
            conn.createStatement().executeQuery("SELECT * FROM " + table);
        }
        conn = this.getCacheFactory("User6", ITGuidePostsCacheFactory.class.getTypeName());
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + table);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertEquals((long)(initialCount + 2), (long)ITGuidePostsCacheFactory.getCount());
    }

    @Test(expected=Exception.class)
    public void testBadCache() throws Exception {
        Connection conn = this.getCacheFactory("User8", "org.notreal.class");
        if (conn != null) {
            conn.close();
        }
        Assert.fail();
    }
}

