/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ColumnProjectionOptimizationIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelect() throws Exception {
        String tenantId = ColumnProjectionOptimizationIT.getOrganizationId();
        String tableName = ColumnProjectionOptimizationIT.initATableValues(tenantId, ColumnProjectionOptimizationIT.getDefaultSplits(tenantId));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT * FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT A_STRING, A_INTEGER FROM " + tableName;
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)5L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)6L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)7L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)8L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)9L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT B_STRING, A_SHORT FROM " + tableName + " WHERE X_INTEGER = ?";
            statement = conn.prepareStatement(query);
            statement.setInt(1, 4);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)135L, (long)rs.getShort(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT X_LONG, X_INTEGER, Y_INTEGER FROM " + tableName + " WHERE B_STRING = ?";
            statement = conn.prepareStatement(query);
            statement.setString(1, "e");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0x80000000L, (long)rs.getLong(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)300L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT A_STRING, A_INTEGER FROM " + tableName + " WHERE A_INTEGER = ?";
            statement = conn.prepareStatement(query);
            statement.setInt(1, 9);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)9L, (long)rs.getInt(2));
            query = "SELECT * FROM " + tableName + " ORDER BY A_INTEGER";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
            Assert.assertEquals((Object)"c", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectFromViewOnExistingTable() throws Exception {
        PhoenixConnection pconn = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        byte[] cfB = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"b"));
        byte[] cfC = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"c"));
        byte[][] familyNames = new byte[][]{cfB, cfC};
        String table = ColumnProjectionOptimizationIT.generateUniqueName();
        byte[] htableName = SchemaUtil.getTableNameAsBytes((String)"", (String)table);
        Admin admin = pconn.getQueryServices().getAdmin();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])htableName));
        for (byte[] familyName : familyNames) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])familyName));
        }
        admin.createTable(builder.build());
        Properties props = new Properties();
        Connection conn1 = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), props);
        String createStmt = "create view " + table + " (id integer not null primary key, b.col1 integer, c.col2 bigint, c.col3 varchar(20))";
        conn1.createStatement().execute(createStmt);
        conn1.close();
        PhoenixConnection conn2 = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), props).unwrap(PhoenixConnection.class);
        byte[] c1 = Bytes.toBytes((String)"COL1");
        byte[] c2 = Bytes.toBytes((String)"COL2");
        byte[] c3 = Bytes.toBytes((String)"COL3");
        Table htable = null;
        try {
            htable = conn2.getQueryServices().getTable(htableName);
            Put put = new Put(PInteger.INSTANCE.toBytes((Object)1));
            put.addColumn(cfB, c1, PInteger.INSTANCE.toBytes((Object)1));
            put.addColumn(cfC, c2, PLong.INSTANCE.toBytes((Object)2));
            htable.put(put);
            put = new Put(PInteger.INSTANCE.toBytes((Object)2));
            put.addColumn(cfC, c2, PLong.INSTANCE.toBytes((Object)10));
            put.addColumn(cfC, c3, PVarchar.INSTANCE.toBytes((Object)"abcd"));
            htable.put(put);
            put = new Put(PInteger.INSTANCE.toBytes((Object)3));
            put.addColumn(cfB, c1, PInteger.INSTANCE.toBytes((Object)3));
            put.addColumn(cfC, c2, PLong.INSTANCE.toBytes((Object)10));
            put.addColumn(cfC, c3, PVarchar.INSTANCE.toBytes((Object)"abcd"));
            htable.put(put);
            conn2.close();
            Connection conn7 = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), props);
            String select = "SELECT id, b.col1 FROM " + table + " WHERE c.col2=?";
            PreparedStatement ps = conn7.prepareStatement(select);
            ps.setInt(1, 10);
            ResultSet rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            select = "SELECT b.* FROM " + table + " WHERE c.col2=?";
            ps = conn7.prepareStatement(select);
            ps.setInt(1, 10);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            select = "SELECT b.* FROM " + table;
            ps = conn7.prepareStatement(select);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (htable != null) {
                htable.close();
            }
            admin.disableTable(TableName.valueOf((byte[])htableName));
            admin.deleteTable(TableName.valueOf((byte[])htableName));
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initMultiCFTable() throws Exception {
        String url = ColumnProjectionOptimizationIT.getUrl();
        String tableName = ColumnProjectionOptimizationIT.generateUniqueName();
        Properties props = new Properties();
        String ddl = "create table " + tableName + "   (id char(15) not null primary key,\n    a.unique_user_count integer,\n    b.unique_org_count integer,\n    c.db_cpu_utilization decimal(31,10),\n    d.transaction_count bigint,\n    e.cpu_utilization decimal(31,10),\n    f.response_time bigint,\n    g.response_time bigint)";
        try (Connection conn = DriverManager.getConnection(url, props);){
            conn.createStatement().execute(ddl);
        }
        props = new Properties();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    id,     a.unique_user_count,     b.unique_org_count,     c.db_cpu_utilization) VALUES (?, ?, ?, ?)");
            stmt.setString(1, "id1");
            stmt.setInt(2, 1);
            stmt.setInt(3, 1);
            stmt.setBigDecimal(4, BigDecimal.valueOf(40.1));
            stmt.execute();
            stmt.setString(1, "id2");
            stmt.setInt(2, 2);
            stmt.setInt(3, 2);
            stmt.setBigDecimal(4, BigDecimal.valueOf(20.9));
            stmt.execute();
            conn.commit();
            String string = tableName;
            return string;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithConditionOnMultiCF() throws Exception {
        String tableName = ColumnProjectionOptimizationIT.initMultiCFTable();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(ColumnProjectionOptimizationIT.getUrl(), props);){
            String query = "SELECT c.db_cpu_utilization FROM " + tableName + " WHERE a.unique_user_count = ? and b.unique_org_count = ?";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setInt(1, 1);
            statement.setInt(2, 1);
            ResultSet rs = statement.executeQuery();
            boolean b = rs.next();
            Assert.assertTrue((boolean)b);
            Assert.assertEquals((Object)BigDecimal.valueOf(40.1), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

