/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ClientHashAggregateIT
extends ParallelStatsDisabledIT {
    @Test
    public void testSalted() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ClientHashAggregateIT.getUrl(), props);){
            String table = this.createSalted(conn);
            this.testTable(conn, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsalted() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ClientHashAggregateIT.getUrl(), props);){
            String table = this.createUnsalted(conn);
            this.testTable(conn, table);
        }
    }

    private void testTable(Connection conn, String table) throws Exception {
        this.verifyExplain(conn, table, false, false);
        this.verifyExplain(conn, table, false, true);
        this.verifyExplain(conn, table, true, false);
        this.verifyExplain(conn, table, true, true);
        this.verifyResults(conn, table, 13, 0, false, false);
        this.verifyResults(conn, table, 13, 0, false, true);
        this.verifyResults(conn, table, 13, 0, true, false);
        this.verifyResults(conn, table, 13, 0, true, true);
        this.verifyResults(conn, table, 13, 17, false, true);
        this.verifyResults(conn, table, 13, 17, true, true);
        this.dropTable(conn, table);
    }

    private String createSalted(Connection conn) throws Exception {
        String table = "SALTED_" + ClientHashAggregateIT.generateUniqueName();
        String create = "CREATE TABLE " + table + " ( keyA BIGINT NOT NULL, keyB BIGINT NOT NULL, val SMALLINT, CONSTRAINT pk PRIMARY KEY (keyA, keyB)) SALT_BUCKETS = 4";
        conn.createStatement().execute(create);
        return table;
    }

    private String createUnsalted(Connection conn) throws Exception {
        String table = "UNSALTED_" + ClientHashAggregateIT.generateUniqueName();
        String create = "CREATE TABLE " + table + " ( keyA BIGINT NOT NULL, keyB BIGINT NOT NULL, val SMALLINT, CONSTRAINT pk PRIMARY KEY (keyA, keyB))";
        conn.createStatement().execute(create);
        return table;
    }

    private String getQuery(String table, boolean hash, boolean swap, boolean sort) {
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN" + (hash ? " HASH_AGGREGATE" : "") + " */ t1.val v1, t2.val v2, COUNT(*) c FROM " + table + " t1 JOIN " + table + " t2 ON (t1.keyB = t2.keyB) WHERE t1.keyA = 10 AND t2.keyA = 20 GROUP BY " + (swap ? "t2.val, t1.val" : "t1.val, t2.val") + (sort ? " ORDER BY t1.val, t2.val" : "");
        return query;
    }

    private void verifyExplain(Connection conn, String table, boolean swap, boolean sort) throws Exception {
        String query = "EXPLAIN " + this.getQuery(table, true, swap, sort);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        String plan = QueryUtil.getExplainPlan((ResultSet)rs);
        rs.close();
        Assert.assertTrue((plan != null && plan.contains("CLIENT HASH AGGREGATE") ? 1 : 0) != 0);
        Assert.assertTrue((plan != null && sort == plan.contains("CLIENT SORTED BY") ? 1 : 0) != 0);
    }

    private void verifyResults(Connection conn, String table, int c1, int c2, boolean swap, boolean sort) throws Exception {
        int i;
        String upsert = "UPSERT INTO " + table + "(keyA, keyB, val) VALUES(?, ?, ?)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        for (i = 0; i < c1; ++i) {
            upsertStmt.setInt(1, 10);
            upsertStmt.setInt(2, 100 + i);
            upsertStmt.setInt(3, 1);
            upsertStmt.execute();
            upsertStmt.setInt(1, 20);
            upsertStmt.setInt(2, 100 + i);
            upsertStmt.setInt(3, 2);
            upsertStmt.execute();
        }
        for (i = 0; i < c2; ++i) {
            upsertStmt.setInt(1, 10);
            upsertStmt.setInt(2, 200 + i);
            upsertStmt.setInt(3, 2);
            upsertStmt.execute();
            upsertStmt.setInt(1, 20);
            upsertStmt.setInt(2, 200 + i);
            upsertStmt.setInt(3, 1);
            upsertStmt.execute();
        }
        conn.commit();
        String hashQuery = this.getQuery(table, true, swap, sort);
        String sortQuery = this.getQuery(table, false, swap, sort);
        Statement stmt = conn.createStatement();
        try (ResultSet hrs = stmt.executeQuery(hashQuery);){
            if (c1 > 0) {
                Assert.assertTrue((boolean)hrs.next());
                Assert.assertEquals((long)hrs.getInt("v1"), (long)1L);
                Assert.assertEquals((long)hrs.getInt("v2"), (long)2L);
                Assert.assertEquals((long)hrs.getInt("c"), (long)c1);
            }
            if (c2 > 0) {
                Assert.assertTrue((boolean)hrs.next());
                Assert.assertEquals((long)hrs.getInt("v1"), (long)2L);
                Assert.assertEquals((long)hrs.getInt("v2"), (long)1L);
                Assert.assertEquals((long)hrs.getInt("c"), (long)c2);
            }
            Assert.assertFalse((boolean)hrs.next());
        }
        try (ResultSet srs = stmt.executeQuery(sortQuery);){
            if (c1 > 0) {
                Assert.assertTrue((boolean)srs.next());
                Assert.assertEquals((long)srs.getInt("v1"), (long)1L);
                Assert.assertEquals((long)srs.getInt("v2"), (long)2L);
                Assert.assertEquals((long)srs.getInt("c"), (long)c1);
            }
            if (c2 > 0) {
                Assert.assertTrue((boolean)srs.next());
                Assert.assertEquals((long)srs.getInt("v1"), (long)2L);
                Assert.assertEquals((long)srs.getInt("v2"), (long)1L);
                Assert.assertEquals((long)srs.getInt("c"), (long)c2);
            }
            Assert.assertFalse((boolean)srs.next());
        }
    }

    private void dropTable(Connection conn, String table) throws Exception {
        String drop = "DROP TABLE " + table;
        Statement stmt = conn.createStatement();
        stmt.execute(drop);
        stmt.close();
    }
}

