/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CaseStatementIT
extends BaseQueryIT {
    public CaseStatementIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) {
        super(indexDDL, columnEncoded, keepDeletedCells);
    }

    @Parameterized.Parameters(name="CaseStatementIT_{index}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleCaseStatement() throws Exception {
        String query = "SELECT CASE a_integer WHEN 1 THEN 'a' WHEN 2 THEN 'b' WHEN 3 THEN 'c' ELSE 'd' END, entity_id AS a FROM " + tableName + " WHERE organization_id=? AND a_integer < 6";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList("a", "00A123122312312"), Arrays.asList("b", "00A223122312312"), Arrays.asList("c", "00A323122312312"), Arrays.asList("d", "00A423122312312"), Arrays.asList("d", "00B523122312312")});
            CaseStatementIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiCondCaseStatement() throws Exception {
        String query = "SELECT CASE WHEN a_integer <= 2 THEN 1.5 WHEN a_integer = 3 THEN 2 WHEN a_integer <= 6 THEN 4.5 ELSE 5 END AS a FROM " + tableName + " WHERE organization_id=?";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialEvalCaseStatement() throws Exception {
        String query = "SELECT entity_id FROM " + tableName + " WHERE organization_id=? and CASE WHEN 1234 = a_integer THEN 1 WHEN x_integer = 5 THEN 2 ELSE 3 END = 2";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFoundIndexOnPartialEvalCaseStatement() throws Exception {
        String query = "SELECT entity_id FROM " + tableName + " WHERE organization_id=? and CASE WHEN a_integer = 1234 THEN 1 WHEN x_integer = 3 THEN y_integer ELSE 3 END = 300";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnfoundMultiColumnCaseStatement() throws Exception {
        String query = "SELECT entity_id, b_string FROM " + tableName + " WHERE organization_id=? and CASE WHEN a_integer = 1234 THEN 1 WHEN a_date < ? THEN y_integer WHEN x_integer = 4 THEN 4 ELSE 3 END = 4";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, new Date(System.currentTimeMillis()));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonNullMultiCondCaseStatement() throws Exception {
        String query = "SELECT CASE WHEN entity_id = '000000000000000' THEN 1 WHEN entity_id = '000000000000001' THEN 2 ELSE 3 END FROM " + tableName + " WHERE organization_id=?";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            Assert.assertEquals((long)0L, (long)rsm.isNullable(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullMultiCondCaseStatement() throws Exception {
        String query = "SELECT CASE WHEN entity_id = '000000000000000' THEN 1 WHEN entity_id = '000000000000001' THEN 2 END FROM " + tableName + " WHERE organization_id=?";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            Assert.assertEquals((long)1L, (long)rsm.isNullable(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullabilityMultiCondCaseStatement() throws Exception {
        String query = "SELECT CASE WHEN a_integer <= 2 THEN ? WHEN a_integer = 3 THEN ? WHEN a_integer <= ? THEN ? ELSE 5 END AS a FROM " + tableName + " WHERE organization_id=?";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setBigDecimal(1, BigDecimal.valueOf(1.5));
            statement.setInt(2, 2);
            statement.setInt(3, 6);
            statement.setBigDecimal(4, BigDecimal.valueOf(4.5));
            statement.setString(5, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(1.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(4.5), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void zTestUnfoundSingleColumnCaseStatement() throws Exception {
        String query = "SELECT entity_id, b_string FROM " + tableName + " WHERE organization_id=? and CASE WHEN a_integer = 0 or a_integer != 0 THEN 1 ELSE 0 END = 0";
        String url = CaseStatementIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        Connection upsertConn = DriverManager.getConnection(url, props);
        String upsertStmt = "upsert into " + tableName + " (    ENTITY_ID,     ORGANIZATION_ID,     A_INTEGER) VALUES ('00B523122312312','" + tenantId + "', null)";
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement(upsertStmt);
        stmt.execute();
        upsertConn.close();
        PreparedStatement statement = conn.prepareStatement(query);
        statement.setString(1, tenantId);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }
}

