/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.CDCBaseIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ParallelStatsDisabledTest.class})
public class CDCDefinitionIT
extends CDCBaseIT {
    private final boolean forView;

    public CDCDefinitionIT(boolean forView) {
        this.forView = forView;
    }

    @Parameterized.Parameters(name="forView={0}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testCreate() throws Exception {
        String cdc_sql;
        String cdcName;
        String tableName;
        Connection conn;
        block11: {
            conn = this.newConnection();
            String datatableName = tableName = CDCDefinitionIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE) TTL=100");
            if (this.forView) {
                String viewName = CDCDefinitionIT.generateUniqueName();
                conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
                tableName = viewName;
            }
            cdcName = CDCDefinitionIT.generateUniqueName();
            try {
                conn.createStatement().execute("CREATE CDC " + cdcName + " ON NON_EXISTENT_TABLE");
                Assert.fail((String)"Expected to fail due to non-existent table");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            }
            cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
            this.createCDC(conn, cdc_sql, null);
            this.assertCDCState(conn, cdcName, null, 3);
            this.assertNoResults(conn, cdcName);
            try {
                conn.createStatement().execute(cdc_sql);
                Assert.fail((String)"Expected to fail due to duplicate index");
            }
            catch (SQLException e) {
                if (this.forView) {
                    Assert.assertEquals((long)SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode(), (long)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().endsWith(cdcName));
                }
                Assert.assertEquals((long)SQLExceptionCode.CDC_ALREADY_ENABLED.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("CREATE CDC IF NOT EXISTS " + cdcName + " ON " + tableName + " INCLUDE (pre, post)");
            }
            catch (SQLException e) {
                if (this.forView) break block11;
                Assert.assertEquals((long)SQLExceptionCode.CDC_ALREADY_ENABLED.getErrorCode(), (long)e.getErrorCode());
            }
        }
        cdcName = CDCDefinitionIT.generateUniqueName();
        cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName + " INCLUDE (pre, post)";
        try {
            this.createCDC(conn, cdc_sql);
        }
        catch (SQLException e) {
            if (!this.forView) {
                Assert.assertEquals((long)SQLExceptionCode.CDC_ALREADY_ENABLED.getErrorCode(), (long)e.getErrorCode());
            }
            Assert.fail((String)"Multiple CDCs should be allowed on views.");
        }
        conn.close();
    }

    @Test
    public void testCreateDropCaseSensitiveTable() throws Exception {
        Connection conn = this.newConnection();
        String tableName = "\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\"";
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE) TTL=100");
        if (this.forView) {
            String viewName = "\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\"";
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            tableName = viewName;
        }
        String cdcName = "\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\"";
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(cdc_sql);
        conn.createStatement().executeQuery("SELECT * FROM " + cdcName);
        String drop_sql = this.forView ? "DROP VIEW " + tableName : "DROP TABLE " + tableName;
        conn.createStatement().execute(drop_sql);
        String drop_cdc_sql = "DROP CDC " + cdcName + " ON " + tableName;
        try {
            conn.createStatement().execute(drop_cdc_sql);
            Assert.fail((String)"Expected to fail as cdc table doesn't exist");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith(SchemaUtil.getUnEscapedFullName((String)cdcName)));
        }
    }

    @Test
    public void testCreateDropCaseSensitiveSchemaAndTable() throws Exception {
        Connection conn = this.newConnection();
        String schemaName = "\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\"";
        String tableName = SchemaUtil.getTableName((String)schemaName, (String)("\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\""));
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE) TTL=100");
        if (this.forView) {
            String viewName = SchemaUtil.getTableName((String)schemaName, (String)("\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\""));
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            tableName = viewName;
        }
        String cdcName = "\"" + CDCDefinitionIT.generateUniqueName().toLowerCase() + "\"";
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(cdc_sql);
        String cdcFullName = SchemaUtil.getTableName((String)schemaName, (String)cdcName);
        conn.createStatement().executeQuery("SELECT * FROM " + cdcFullName);
        String drop_sql = this.forView ? "DROP VIEW " + tableName : "DROP TABLE " + tableName;
        conn.createStatement().execute(drop_sql);
        String drop_cdc_sql = "DROP CDC " + cdcName + " ON " + tableName;
        try {
            conn.createStatement().execute(drop_cdc_sql);
            Assert.fail((String)"Expected to fail as cdc table doesn't exist");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith(SchemaUtil.getUnEscapedFullName((String)cdcName)));
        }
    }

    @Test
    public void testCreateWithSchemaName() throws Exception {
        String tableName;
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String schemaName = CDCDefinitionIT.generateUniqueName();
        String datatableName = tableName = SchemaUtil.getTableName((String)schemaName, (String)CDCDefinitionIT.generateUniqueName());
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE)");
        if (this.forView) {
            String viewName = SchemaUtil.getTableName((String)schemaName, (String)CDCDefinitionIT.generateUniqueName());
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            tableName = viewName;
        }
        String cdcName = CDCDefinitionIT.generateUniqueName();
        try {
            conn.createStatement().execute("CREATE CDC " + cdcName + " ON NON_EXISTENT_TABLE");
            Assert.fail((String)"Expected to fail due to non-existent table");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
        }
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        this.createCDC(conn, cdc_sql);
        this.assertCDCState(conn, cdcName, null, 3);
        this.assertPTable(cdcName, null, tableName, datatableName);
    }

    @Test
    public void testCreateCDCMultitenant() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " (tenantId INTEGER NOT NULL, k INTEGER NOT NULL, v1 INTEGER, v2 DATE, CONSTRAINT pk PRIMARY KEY (tenantId, k)) MULTI_TENANT=true");
        String cdcName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE CDC " + cdcName + " ON " + tableName);
        PTable indexTable = PhoenixRuntime.getTable((Connection)conn, (String)CDCUtil.getCDCIndexName((String)cdcName));
        Assert.assertEquals((Object)true, (Object)indexTable.isMultiTenant());
        List idxPkColumns = indexTable.getPKColumns();
        Assert.assertEquals((Object)":TENANTID", (Object)((PColumn)idxPkColumns.get(0)).getName().getString());
        Assert.assertEquals((Object)": PARTITION_ID()", (Object)((PColumn)idxPkColumns.get(1)).getName().getString());
        Assert.assertEquals((Object)": PHOENIX_ROW_TIMESTAMP()", (Object)((PColumn)idxPkColumns.get(2)).getName().getString());
        Assert.assertEquals((Object)":K", (Object)((PColumn)idxPkColumns.get(3)).getName().getString());
        PTable cdcTable = PhoenixRuntime.getTable((Connection)conn, (String)cdcName);
        Assert.assertEquals((Object)true, (Object)cdcTable.isMultiTenant());
        List cdcPkColumns = cdcTable.getPKColumns();
        Assert.assertEquals((Object)"TENANTID", (Object)((PColumn)cdcPkColumns.get(0)).getName().getString());
        Assert.assertEquals((Object)"K", (Object)((PColumn)cdcPkColumns.get(1)).getName().getString());
    }

    @Test
    public void testCreateWithNonDefaultColumnEncoding() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE)");
        if (this.forView) {
            String viewName = CDCDefinitionIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            tableName = viewName;
        }
        String cdcName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE CDC " + cdcName + " ON " + tableName + " COLUMN_ENCODED_BYTES=" + String.valueOf(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS.getSerializedMetadataValue()));
        PTable indexTable = PhoenixRuntime.getTable((Connection)conn, (String)CDCUtil.getCDCIndexName((String)cdcName));
        Assert.assertEquals((Object)indexTable.getEncodingScheme(), (Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS);
    }

    @Test
    public void testDropCDC() throws SQLException {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE)");
        String cdcName = CDCDefinitionIT.generateUniqueName();
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(cdc_sql);
        String drop_cdc_sql = "DROP CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(drop_cdc_sql);
        try (ResultSet rs = conn.createStatement().executeQuery("SELECT cdc_include FROM system.catalog WHERE table_name = '" + cdcName + "' AND column_name IS NULL and column_family IS NULL");){
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
        rs = conn.createStatement().executeQuery("SELECT index_type FROM system.catalog WHERE table_name = '" + CDCUtil.getCDCIndexName((String)cdcName) + "' AND column_name IS NULL and column_family IS NULL");
        try {
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        try {
            conn.createStatement().execute(drop_cdc_sql);
            Assert.fail((String)"Expected to fail as cdc table doesn't exist");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith(cdcName));
        }
    }

    @Test
    public void testDropCDCIndex() throws SQLException {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE)");
        String cdcName = CDCDefinitionIT.generateUniqueName();
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(cdc_sql);
        this.assertCDCState(conn, cdcName, null, 3);
        String drop_cdc_index_sql = "DROP INDEX \"" + CDCUtil.getCDCIndexName((String)cdcName) + "\" ON " + tableName;
        try {
            conn.createStatement().execute(drop_cdc_index_sql);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_CDC_INDEX.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith(CDCUtil.getCDCIndexName((String)cdcName)));
        }
    }

    @Test
    public void testDropTable() throws SQLException {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CDCDefinitionIT.getUrl(), props);
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER, v2 DATE)");
        String cdcName = CDCDefinitionIT.generateUniqueName();
        String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
        conn.createStatement().execute(cdc_sql);
        String drop_table_sql = "DROP TABLE " + tableName;
        conn.createStatement().execute(drop_table_sql);
        try (ResultSet rs = conn.createStatement().executeQuery("SELECT index_type FROM system.catalog WHERE table_name = '" + CDCUtil.getCDCIndexName((String)cdcName) + "' AND column_name IS NULL and column_family IS NULL");){
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
        rs = conn.createStatement().executeQuery("SELECT cdc_include FROM system.catalog WHERE table_name = '" + cdcName + "' AND column_name IS NULL and column_family IS NULL");
        try {
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        String drop_cdc_sql = "DROP CDC " + cdcName + " ON " + tableName;
        try {
            conn.createStatement().execute(drop_cdc_sql);
            Assert.fail((String)"Expected to fail as cdc table doesn't exist");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith(cdcName));
        }
    }

    @Test
    public void testSelectCDCBadIncludeSpec() throws Exception {
        Connection conn = this.newConnection();
        String tableName = CDCDefinitionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + tableName + " ( k INTEGER PRIMARY KEY, v1 INTEGER)");
        if (this.forView) {
            String viewName = CDCDefinitionIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            tableName = viewName;
        }
        String cdcName = CDCDefinitionIT.generateUniqueName();
        String cdc_sql = "CREATE CDC  " + cdcName + " ON " + tableName;
        this.createCDC(conn, cdc_sql);
        try {
            conn.createStatement().executeQuery("SELECT /*+ CDC_INCLUDE(DUMMY) */ * FROM " + cdcName);
            Assert.fail((String)"Expected to fail due to invalid CDC INCLUDE hint");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.UNKNOWN_INCLUDE_CHANGE_SCOPE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith("DUMMY"));
        }
    }
}

