/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class Bson6IT
extends ParallelStatsDisabledIT {
    private final boolean columnEncoded;

    public Bson6IT(boolean columnEncoded) {
        this.columnEncoded = columnEncoded;
    }

    @Parameterized.Parameters(name="Bson6IT_columnEncoded={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    private static String getJsonString(String jsonFilePath) throws IOException {
        URL fileUrl = Bson6IT.class.getClassLoader().getResource(jsonFilePath);
        Preconditions.checkArgument((fileUrl != null ? 1 : 0) != 0, (Object)("File path " + jsonFilePath + " seems invalid"));
        return FileUtils.readFileToString((File)new File(fileUrl.getFile()), (Charset)Charset.defaultCharset());
    }

    @Test
    public void testBsonValueFunction() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson6IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson6IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute(ddl);
            String sample1 = Bson6IT.getJsonString("json/sample_01.json");
            String sample2 = Bson6IT.getJsonString("json/sample_02.json");
            String sample3 = Bson6IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson6IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            PreparedStatement ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') = ?");
            ps.setDouble(1, 52.3736);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            BsonDocument actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument3, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE', '345.89405') = ?");
            ps.setDouble(1, 345.89405);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument1, (Object)actualDoc);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument2, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') = ?");
            ps.setString(1, "personal");
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument2, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("rather[3].outline.clock", (BsonValue)new BsonString("personal2"))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            String conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            conn.commit();
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') = ?");
            ps.setString(1, "personal");
            rs = ps.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, C1, BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR', 'personal-0001') FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR', 'personal') = 'personal'");
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            Assert.assertEquals((Object)"personal-0001", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            Assert.assertEquals((Object)"personal-0001", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, C1, BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR', 'personal') FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR', 'personal') != ?");
            ps.setString(1, "personal");
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            Assert.assertEquals((Object)"personal2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') = ?");
            ps.setDouble(1, 52.37);
            rs = ps.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("SELECT PK1, COL, BSON_VALUE(COL, 'result[10].location.coordinates.longitude', 'BIGINT', '9223372036854775807') FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[10].location.coordinates.longitude', 'DOUBLE', '52.37') = ?");
            ps.setDouble(1, 52.37);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((long)Long.MAX_VALUE, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((long)Long.MAX_VALUE, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((long)Long.MAX_VALUE, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void upsertRows(Connection conn, String tableName, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
        stmt.setString(1, "pk0001");
        stmt.setString(2, "0002");
        stmt.setObject(3, bsonDocument1);
        stmt.executeUpdate();
        stmt.setString(1, "pk1010");
        stmt.setString(2, "1010");
        stmt.setObject(3, bsonDocument2);
        stmt.executeUpdate();
        stmt.setString(1, "pk1011");
        stmt.setString(2, "1011");
        stmt.setObject(3, bsonDocument3);
        stmt.executeUpdate();
    }
}

