/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class Bson3IT
extends ParallelStatsDisabledIT {
    private final boolean columnEncoded;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Bson3IT(boolean columnEncoded) {
        this.columnEncoded = columnEncoded;
    }

    @Parameterized.Parameters(name="Bson3IT_columnEncoded={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    private static String getJsonString(String jsonFilePath) throws IOException {
        URL fileUrl = Bson3IT.class.getClassLoader().getResource(jsonFilePath);
        Preconditions.checkArgument((fileUrl != null ? 1 : 0) != 0, (Object)("File path " + jsonFilePath + " seems invalid"));
        return FileUtils.readFileToString((File)new File(fileUrl.getFile()), (Charset)Charset.defaultCharset());
    }

    @Test
    public void testBsonOpsWithSqlConditionsUpdateSuccess() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        String cdcName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            String sample2 = Bson3IT.getJsonString("json/sample_02.json");
            String sample3 = Bson3IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String conditionExpression = "press = $press AND track[0].shot[2][0].city.standard[50] = $softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$press", (BsonValue)new BsonString("beat")).append("$softly", (BsonValue)new BsonString("softly")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "press = $press AND track[0].shot[2][0].city.standard[5] = $softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$press", (BsonValue)new BsonString("beat")).append("$softly", (BsonValue)new BsonString("softly")));
            query = "SELECT * FROM " + tableName + " WHERE PK1 = ? AND C1 = ? AND BSON_CONDITION_EXPRESSION(COL, ?)";
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setString(1, "pk0001");
            ps.setString(2, "0002");
            ps.setObject(3, conditionDoc);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "result[2].location.coordinates.latitude > $latitude OR (field_exists(result[1].location) AND result[1].location.state != $state AND field_exists(result[4].emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$latitude", (BsonValue)new BsonDouble(0.0)).append("$state", (BsonValue)new BsonString("AK")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCPostUpdate(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            String updatedJson = Bson3IT.getJsonString("json/sample_updated_01.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson3IT.getJsonString("json/sample_updated_02.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson3IT.getJsonString("json/sample_updated_03.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCAfterFirstUpsert(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException, JsonProcessingException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            Map postImage = (Map)map.get("post_image");
            String encodedBytes = (String)postImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r1 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)r1);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r2 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument2, (Object)r2);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r3 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument3, (Object)r3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCPostUpdate(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException, IOException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            String encodedBytes = (String)preImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)preDoc);
            Map postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson3IT.getJsonString("json/sample_updated_01.json")), (Object)postDoc);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            encodedBytes = (String)preImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument2, (Object)preDoc);
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson3IT.getJsonString("json/sample_updated_02.json")), (Object)postDoc);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            encodedBytes = (String)preImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument3, (Object)preDoc);
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson3IT.getJsonString("json/sample_updated_03.json")), (Object)postDoc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCUpdateOneRowChange(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1) throws SQLException, IOException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            String encodedBytes = (String)preImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)preDoc);
            Map postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)postDoc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBsonOpsWithDocumentConditionsUpdateSuccess() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        String cdcName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            String sample2 = Bson3IT.getJsonString("json/sample_02.json");
            String sample3 = Bson3IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            BsonDocument conditionDoc = new BsonDocument();
            BsonArray andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("beat"))));
            andList1.add((BsonValue)new BsonDocument().append("track[0].shot[2][0].city.standard[50]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("softly"))));
            conditionDoc.put("$and", (BsonValue)andList1);
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionDoc = new BsonDocument();
            andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("beat"))));
            andList1.add((BsonValue)new BsonDocument().append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("softly"))));
            conditionDoc.put("$and", (BsonValue)andList1);
            query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionDoc = new BsonDocument();
            andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
            andList1.add((BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
            conditionDoc.put("$and", (BsonValue)andList1);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionDoc = new BsonDocument();
            BsonArray orList1 = new BsonArray();
            andList1 = new BsonArray();
            BsonDocument andDoc1 = new BsonDocument();
            andList1.add((BsonValue)new BsonDocument().append("result[1].location", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
            andList1.add((BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("AK"))));
            andList1.add((BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
            andDoc1.put("$and", (BsonValue)andList1);
            orList1.add((BsonValue)new BsonDocument().append("result[2].location.coordinates.latitude", (BsonValue)new BsonDocument("$gt", (BsonValue)new BsonDouble(0.0))));
            orList1.add((BsonValue)andDoc1);
            conditionDoc.put("$or", (BsonValue)orList1);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCPostUpdate(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            String updatedJson = Bson3IT.getJsonString("json/sample_updated_01.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson3IT.getJsonString("json/sample_updated_02.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson3IT.getJsonString("json/sample_updated_03.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBsonOpsWithSqlConditionsUpdateFailure() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        String cdcName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            String sample2 = Bson3IT.getJsonString("json/sample_02.json");
            String sample3 = Bson3IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            Thread.sleep(100L);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String conditionExpression = "press = $press AND track[0].shot[2][0].city.standard[50] = $softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$press", (BsonValue)new BsonString("beat")).append("$softly", (BsonValue)new BsonString("softly")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "press = $press AND track[0].shot[2][0].city.standard[5] <> $softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$press", (BsonValue)new BsonString("beat")).append("$softly", (BsonValue)new BsonString("softly")));
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][20])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "result[2].location.coordinates.latitude > $latitude OR (field_exists(result[1].location) AND result[1].location.state != $state AND field_not_exists(result[4].emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$latitude", (BsonValue)new BsonDouble(0.0)).append("$state", (BsonValue)new BsonString("AK")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCUpdateOneRowChange(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument2, (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument3, (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBsonOpsWithDocumentConditionsUpdateFailure() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        String cdcName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            String sample2 = Bson3IT.getJsonString("json/sample_02.json");
            String sample3 = Bson3IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            Thread.sleep(100L);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            BsonDocument conditionDoc = new BsonDocument();
            BsonArray andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("beat"))));
            andList1.add((BsonValue)new BsonDocument().append("track[0].shot[2][0].city.standard[50]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("softly"))));
            conditionDoc.put("$and", (BsonValue)andList1);
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionDoc = new BsonDocument();
            andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("beat"))));
            andList1.add((BsonValue)new BsonDocument().append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("softly"))));
            conditionDoc.put("$and", (BsonValue)andList1);
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionDoc = new BsonDocument();
            andList1 = new BsonArray();
            andList1.add((BsonValue)new BsonDocument().append("press", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
            andList1.add((BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][20]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
            conditionDoc.put("$and", (BsonValue)andList1);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionDoc = new BsonDocument();
            BsonArray orList1 = new BsonArray();
            andList1 = new BsonArray();
            BsonDocument andDoc1 = new BsonDocument();
            andList1.add((BsonValue)new BsonDocument().append("result[1].location", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
            andList1.add((BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("AK"))));
            andList1.add((BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
            andDoc1.put("$and", (BsonValue)andList1);
            orList1.add((BsonValue)new BsonDocument().append("result[2].location.coordinates.latitude", (BsonValue)new BsonDocument("$gt", (BsonValue)new BsonDouble(0.0))));
            orList1.add((BsonValue)andDoc1);
            conditionDoc.put("$or", (BsonValue)orList1);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson3IT.testCDCUpdateOneRowChange(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument2, (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument3, (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCDCWithCaseSenstitiveTableAndPks() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String nameQuotes = "test.tableTESt-_123" + Bson3IT.generateUniqueName();
        String tableName = "XYZ.\"" + nameQuotes + "\"";
        String cdcName = "XYZ.\"CDC_" + nameQuotes + "\"";
        String cdcNameWithoutSchema = "\"CDC_" + nameQuotes + "\"";
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (\"hk\" VARCHAR NOT NULL, COL BSON CONSTRAINT pk PRIMARY KEY(\"hk\")) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute(ddl);
            String cdcDdl = "CREATE CDC " + cdcNameWithoutSchema + " ON " + tableName;
            conn.createStatement().execute(cdcDdl);
            String alterDdl = "ALTER TABLE " + tableName + " SET SCHEMA_VERSION = 'NEW_AND_OLD_IMAGES'";
            conn.createStatement().execute(alterDdl);
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            BsonDocument bsonDocument = new BsonDocument().append("field1", (BsonValue)new BsonString("value1")).append("field2", (BsonValue)new BsonInt32(42)).append("field3", (BsonValue)new BsonBoolean(true));
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)");
            stmt.setString(1, "key1");
            stmt.setObject(2, bsonDocument);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            ResultSet rs = conn.createStatement().executeQuery("SELECT DISTINCT PARTITION_ID() FROM " + cdcName);
            Assert.assertTrue((String)"Expected one partition", (boolean)rs.next());
            String partitionId = rs.getString(1);
            Assert.assertFalse((String)"Expected only one partition", (boolean)rs.next());
            String cdcQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PARTITION_ID() = ? AND PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?";
            PreparedStatement ps = conn.prepareStatement(cdcQuery);
            ps.setString(1, partitionId);
            ps.setTimestamp(2, ts1);
            ps.setTimestamp(3, ts2);
            rs = ps.executeQuery();
            Assert.assertTrue((String)"Expected at least one CDC record", (boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            Assert.assertNull((String)"Pre-image should be null for first insert", preImage.get("COL"));
            Map postImage = (Map)map.get("post_image");
            String encodedBytes = (String)postImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument actualDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((String)"Post-image BSON document should match inserted document", (Object)bsonDocument, (Object)actualDoc);
            Assert.assertFalse((String)"Should only have one CDC record", (boolean)rs.next());
            conn.createStatement().execute("DROP TABLE " + tableName + " CASCADE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBsonOpsWithSqlConditionsUpdateSuccessWithTTL() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        String cdcName = Bson3IT.generateUniqueName();
        int ttlSeconds = 10;
        int maxLookbackAge = 5;
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            Map cdcEvent;
            String cdcVal;
            String pk;
            ResultSet ttlRs;
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) TTL=10, \"phoenix.max.lookback.age.seconds\" = 5" + (this.columnEncoded ? "" : ", COLUMN_ENCODED_BYTES=0");
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
            long startTime = System.currentTimeMillis() + 1000L;
            startTime = startTime / 1000L * 1000L;
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
            injectEdge.setValue(startTime);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            String sample2 = Bson3IT.getJsonString("json/sample_02.json");
            String sample3 = Bson3IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            injectEdge.incrementValue(1000L);
            String conditionExpression = "press = $press AND track[0].shot[2][0].city.standard[5] = $softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$press", (BsonValue)new BsonString("beat")).append("$softly", (BsonValue)new BsonString("softly")));
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001'";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "result[2].location.coordinates.latitude > $latitude OR (field_exists(result[1].location) AND result[1].location.state != $state AND field_exists(result[4].emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append("$latitude", (BsonValue)new BsonDouble(0.0)).append("$state", (BsonValue)new BsonString("AK")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            injectEdge.incrementValue(1000L);
            Timestamp beforeTTLTimestamp = new Timestamp(injectEdge.currentTime());
            HashMap<String, Map<String, Object>> lastPostImages = new HashMap<String, Map<String, Object>>();
            String cdcQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() <= ? ORDER BY PHOENIX_ROW_TIMESTAMP() DESC";
            try (PreparedStatement pst = conn.prepareStatement(cdcQuery);){
                pst.setTimestamp(1, beforeTTLTimestamp);
                try (ResultSet cdcRs = pst.executeQuery();){
                    while (cdcRs.next()) {
                        String cdcVal2;
                        Map cdcEvent2;
                        String pk2 = cdcRs.getString(2);
                        if (lastPostImages.containsKey(pk2) || !(cdcEvent2 = (Map)OBJECT_MAPPER.readValue(cdcVal2 = cdcRs.getString(3), HashMap.class)).containsKey("post_image")) continue;
                        lastPostImages.put(pk2, (Map)cdcEvent2.get("post_image"));
                    }
                }
            }
            Assert.assertEquals((String)"Should have post-images for all 3 rows", (long)3L, (long)lastPostImages.size());
            Assert.assertNotNull((String)"Should have post-image for pk0001", lastPostImages.get("pk0001"));
            Assert.assertNotNull((String)"Should have post-image for pk1010", lastPostImages.get("pk1010"));
            Assert.assertNotNull((String)"Should have post-image for pk1011", lastPostImages.get("pk1011"));
            injectEdge.incrementValue(16000L);
            Admin admin = Bson3IT.getUtility().getAdmin();
            EnvironmentEdgeManager.reset();
            admin.flush(TableName.valueOf((String)tableName));
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
            TestUtil.majorCompact(Bson3IT.getUtility(), TableName.valueOf((String)tableName));
            String dataQuery = "SELECT * FROM " + tableName;
            try (ResultSet dataRs = conn.createStatement().executeQuery(dataQuery);){
                Assert.assertFalse((String)"All rows should be expired from data table", (boolean)dataRs.next());
            }
            String ttlDeleteQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() > ?";
            HashMap<String, Map<String, Object>> ttlDeleteEvents = new HashMap<String, Map<String, Object>>();
            try (PreparedStatement pst = conn.prepareStatement(ttlDeleteQuery);){
                pst.setTimestamp(1, beforeTTLTimestamp);
                ttlRs = pst.executeQuery();
                try {
                    while (ttlRs.next()) {
                        pk = ttlRs.getString(2);
                        cdcVal = ttlRs.getString(3);
                        cdcEvent = (Map)OBJECT_MAPPER.readValue(cdcVal, HashMap.class);
                        if (!"ttl_delete".equals(cdcEvent.get("event_type"))) continue;
                        ttlDeleteEvents.put(pk, (Map)cdcEvent.get("pre_image"));
                    }
                }
                finally {
                    if (ttlRs != null) {
                        ttlRs.close();
                    }
                }
            }
            Bson3IT.verifyFinalPreImagesWithLastPostImages(ttlDeleteEvents, lastPostImages);
            ttlDeleteQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() > ? LIMIT 1";
            ttlDeleteEvents = new HashMap();
            pst = conn.prepareStatement(ttlDeleteQuery);
            try {
                pst.setTimestamp(1, beforeTTLTimestamp);
                ttlRs = pst.executeQuery();
                try {
                    while (ttlRs.next()) {
                        pk = ttlRs.getString(2);
                        cdcVal = ttlRs.getString(3);
                        cdcEvent = (Map)OBJECT_MAPPER.readValue(cdcVal, HashMap.class);
                        if (!"ttl_delete".equals(cdcEvent.get("event_type"))) continue;
                        ttlDeleteEvents.put(pk, (Map)cdcEvent.get("pre_image"));
                    }
                }
                finally {
                    if (ttlRs != null) {
                        ttlRs.close();
                    }
                }
            }
            finally {
                if (pst != null) {
                    pst.close();
                }
            }
            Assert.assertEquals((String)"Should have TTL delete events for initial 1 row", (long)1L, (long)ttlDeleteEvents.size());
            ttlDeleteQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() > ? LIMIT 3 OFFSET 1";
            pst = conn.prepareStatement(ttlDeleteQuery);
            try {
                pst.setTimestamp(1, beforeTTLTimestamp);
                ttlRs = pst.executeQuery();
                try {
                    while (ttlRs.next()) {
                        pk = ttlRs.getString(2);
                        cdcVal = ttlRs.getString(3);
                        cdcEvent = (Map)OBJECT_MAPPER.readValue(cdcVal, HashMap.class);
                        if (!"ttl_delete".equals(cdcEvent.get("event_type"))) continue;
                        ttlDeleteEvents.put(pk, (Map)cdcEvent.get("pre_image"));
                    }
                }
                finally {
                    if (ttlRs != null) {
                        ttlRs.close();
                    }
                }
            }
            finally {
                if (pst != null) {
                    pst.close();
                }
            }
            Bson3IT.verifyFinalPreImagesWithLastPostImages(ttlDeleteEvents, lastPostImages);
            ttlDeleteQuery = "SELECT /*+ CDC_INCLUDE(POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() > ?";
            int nonePreImages = 0;
            try (PreparedStatement pst = conn.prepareStatement(ttlDeleteQuery);){
                pst.setTimestamp(1, beforeTTLTimestamp);
                try (ResultSet ttlRs2 = pst.executeQuery();){
                    while (ttlRs2.next()) {
                        cdcVal = ttlRs2.getString(3);
                        cdcEvent = (Map)OBJECT_MAPPER.readValue(cdcVal, HashMap.class);
                        Assert.assertEquals((Object)"ttl_delete", cdcEvent.get("event_type"));
                        Assert.assertNull((String)"Pre-image should not be present", cdcEvent.get("pre_image"));
                        ++nonePreImages;
                    }
                }
            }
            Assert.assertEquals((String)("Total num of TTL_DELETE events without pre-image should be 3 but it is " + nonePreImages), (long)3L, (long)nonePreImages);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testBsonValueWithBsonValueType() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            Object[][] testCases;
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute(ddl);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            conn.commit();
            for (Object[] testCase : testCases = new Object[][]{{"cold", PVarchar.INSTANCE.getSqlTypeName(), "method"}, {"hurry", PDouble.INSTANCE.getSqlTypeName(), -5.932648714436941E8}, {"press", PVarchar.INSTANCE.getSqlTypeName(), "beat"}, {"browserling", PDouble.INSTANCE.getSqlTypeName(), -5.0516934054880095E8}, {"attention", PInteger.INSTANCE.getSqlTypeName(), 166583691}, {"track[0].speed", PVarchar.INSTANCE.getSqlTypeName(), "sun"}, {"track[0].shot[2][0].character", PInteger.INSTANCE.getSqlTypeName(), 413968576}, {"track[0].shot[2][0].earth", PVarchar.INSTANCE.getSqlTypeName(), "helpful"}, {"track[0].shot[2][0].money", PBoolean.INSTANCE.getSqlTypeName(), false}, {"track[0].shot[2][0].city.standard[5]", PVarchar.INSTANCE.getSqlTypeName(), "softly"}, {"track[0].shot[2][0].city.problem[2]", PDouble.INSTANCE.getSqlTypeName(), 1.5270614702690287E9}, {"track[0].shot[2][0].city.problem[3].condition", PVarchar.INSTANCE.getSqlTypeName(), "else"}, {"track[0].shot[2][0].city.problem[3].higher", PDouble.INSTANCE.getSqlTypeName(), 1.462910924088698E9}, {"track[0].shot[2][0].city.problem[3].scene", PBoolean.INSTANCE.getSqlTypeName(), false}, {"track[0].shot[2][0].city.flame", PInteger.INSTANCE.getSqlTypeName(), 1066643931}, {"track[0].shot[2][0].city.brought", PVarchar.INSTANCE.getSqlTypeName(), "rock"}, {"track[0].shot[2][0].height", PBoolean.INSTANCE.getSqlTypeName(), true}, {"track[0].disease", PVarchar.INSTANCE.getSqlTypeName(), "disease"}, {"track[1]", PVarchar.INSTANCE.getSqlTypeName(), "printed"}, {"symbol", PBoolean.INSTANCE.getSqlTypeName(), false}}) {
                String path = (String)testCase[0];
                String expectedType = (String)testCase[1];
                Object expectedValue = testCase[2];
                String typeQuery = "SELECT BSON_VALUE_TYPE(COL, '" + path + "') FROM " + tableName + " WHERE PK1 = 'pk0001'";
                ResultSet rs = conn.createStatement().executeQuery(typeQuery);
                Assert.assertTrue((String)("No result for path " + path), (boolean)rs.next());
                String actualType = rs.getString(1);
                Assert.assertEquals((String)("Wrong type for path " + path), (Object)expectedType, (Object)actualType);
                String valueQuery = "SELECT BSON_VALUE(COL, '" + path + "', '" + actualType + "') FROM " + tableName + " WHERE PK1 = 'pk0001'";
                rs = conn.createStatement().executeQuery(valueQuery);
                Assert.assertTrue((String)("No result for path " + path), (boolean)rs.next());
                if (expectedType.equals(PVarchar.INSTANCE.getSqlTypeName())) {
                    Assert.assertEquals((String)("Wrong value for path " + path), (Object)expectedValue, (Object)rs.getString(1));
                } else if (expectedType.equals(PInteger.INSTANCE.getSqlTypeName())) {
                    Assert.assertEquals((String)("Wrong value for path " + path), (long)((Number)expectedValue).intValue(), (long)rs.getInt(1));
                } else if (expectedType.equals(PLong.INSTANCE.getSqlTypeName())) {
                    Assert.assertEquals((String)("Wrong value for path " + path), (long)((Number)expectedValue).longValue(), (long)rs.getLong(1));
                } else if (expectedType.equals(PDouble.INSTANCE.getSqlTypeName())) {
                    Assert.assertEquals((String)("Wrong value for path " + path), (double)((Number)expectedValue).doubleValue(), (double)rs.getDouble(1), (double)1.0E-6);
                } else if (expectedType.equals(PBoolean.INSTANCE.getSqlTypeName())) {
                    Assert.assertEquals((String)("Wrong value for path " + path), (Object)expectedValue, (Object)rs.getBoolean(1));
                } else if (expectedType.equals(PBson.INSTANCE.getSqlTypeName())) {
                    Assert.assertNotNull((String)("Null value for path " + path), (Object)rs.getObject(1));
                }
                Assert.assertFalse((String)("Too many results for path " + path), (boolean)rs.next());
            }
        }
    }

    @Test
    public void testBsonValueTypeNegativeScenarios() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson3IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson3IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute(ddl);
            String sample1 = Bson3IT.getJsonString("json/sample_01.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT BSON_VALUE_TYPE(COL, 'non_existent_field') FROM " + tableName + " WHERE PK1 = 'pk0001'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"NULL", (Object)rs.getString(1));
            rs = conn.createStatement().executeQuery("SELECT BSON_VALUE_TYPE(COL, 'track[999]') FROM " + tableName + " WHERE PK1 = 'pk0001'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"NULL", (Object)rs.getString(1));
            rs = conn.createStatement().executeQuery("SELECT BSON_VALUE_TYPE(COL, '') FROM " + tableName + " WHERE PK1 = 'pk0001'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            rs = conn.createStatement().executeQuery("SELECT BSON_VALUE_TYPE(COL, NULL) FROM " + tableName + " WHERE PK1 = 'pk0001'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
        }
    }

    private static void verifyFinalPreImagesWithLastPostImages(Map<String, Map<String, Object>> ttlDeleteEvents, Map<String, Map<String, Object>> lastPostImages) {
        Assert.assertEquals((String)"Should have TTL delete events for all 3 rows", (long)3L, (long)ttlDeleteEvents.size());
        for (String pk : Arrays.asList("pk0001", "pk1010", "pk1011")) {
            Map<String, Object> ttlPreImage = ttlDeleteEvents.get(pk);
            Assert.assertNotNull((String)("Should have TTL delete event for " + pk), ttlPreImage);
            Map<String, Object> lastPostImage = lastPostImages.get(pk);
            Assert.assertNotNull((String)("TTL pre-image should not be null for " + pk), ttlPreImage);
            Assert.assertNotNull((String)("Last post-image should not be null for " + pk), lastPostImage);
            Assert.assertEquals((String)("TTL delete pre-image should match last post-image for " + pk), lastPostImage, ttlPreImage);
        }
    }
}

