/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class BinaryStringLiteralIT
extends ParallelStatsDisabledIT {
    private static String EMPTY = "";
    private static String THREE_HEX = "0001AA";
    private static String NINE_HEX = "0102030405607080F0";
    private static String THREE_BIN = "000000000000000110101010";
    private static String NINE_BIN = "000000010000001000000011000001000000010101100000011100001000000011110000";
    private String PARSER_STRESS = "x'0 12 ' --comment \n /* comment */ ' 34 567' \n \n 'aA'";

    private String toHex(String s) {
        return "X'" + s + "'";
    }

    private String toBin(String s) {
        return "B'" + s + "'";
    }

    private void insertRow(Statement stmt, String tableName, int id, String s) throws SQLException {
        stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES (" + id + "," + s + "," + s + ")");
    }

    @Test
    public void testBinary() throws Exception {
        String tableName = BinaryStringLiteralIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(BinaryStringLiteralIT.getUrl());
             Statement stmt = conn.createStatement();){
            String ddl = "CREATE TABLE " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, b BINARY(10), vb VARBINARY)";
            stmt.execute(ddl);
            conn.commit();
            this.insertRow(stmt, tableName, 1, this.toHex(EMPTY));
            this.insertRow(stmt, tableName, 3, this.toHex(THREE_HEX));
            this.insertRow(stmt, tableName, 9, this.toHex(NINE_HEX));
            this.insertRow(stmt, tableName, 10, this.PARSER_STRESS);
            this.insertRow(stmt, tableName, 101, this.toBin(EMPTY));
            this.insertRow(stmt, tableName, 103, this.toBin(THREE_BIN));
            this.insertRow(stmt, tableName, 109, this.toBin(NINE_BIN));
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " ORDER BY ID ASC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"0001aa00000000000000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"0001aa", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"0102030405607080f000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"0102030405607080f0", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"01234567aa0000000000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"01234567aa", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)101L, (long)rs.getInt(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)103L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"0001aa00000000000000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"0001aa", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)109L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"0102030405607080f000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"0102030405607080f0", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBinaryArray() throws Exception {
        String tableName = BinaryStringLiteralIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(BinaryStringLiteralIT.getUrl());
             Statement stmt = conn.createStatement();){
            String ddl = "CREATE TABLE " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, b BINARY(10), a BINARY(10)[])";
            stmt.execute(ddl);
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES (3," + this.toHex(THREE_HEX) + ", ARRAY[" + this.toHex(THREE_HEX) + ", " + this.toHex(THREE_HEX) + ", " + this.toHex(THREE_HEX) + "])");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " ORDER BY ID ASC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0001aa00000000000000", (Object)rs.getString(2));
            Assert.assertEquals((Object)"[X'0001aa00000000000000', X'0001aa00000000000000', X'0001aa00000000000000']", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

