/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class BinaryRowKeyIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableValues(String tableName) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(BinaryRowKeyIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + "   (a_binary binary(10) not null, \n    a_string varchar not null, \n    b_binary varbinary \n    CONSTRAINT pk PRIMARY KEY (a_binary, a_string))\n";
            BinaryRowKeyIT.createTestTable(BinaryRowKeyIT.getUrl(), ddl);
            String query = "UPSERT INTO " + tableName + "(a_binary, a_string) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setBytes(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            stmt.setString(2, "a");
            stmt.execute();
            stmt.setBytes(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
            stmt.setString(2, "b");
            stmt.execute();
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertPaddedBinaryValue() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BinaryRowKeyIT.getUrl(), props);){
            String tableName = BinaryRowKeyIT.generateUniqueName();
            BinaryRowKeyIT.initTableValues(tableName);
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE FROM " + tableName);
            String query = "UPSERT INTO " + tableName + "(a_binary, a_string) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setBytes(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1});
            stmt.setString(2, "a");
            stmt.execute();
            ResultSet rs = conn.createStatement().executeQuery("SELECT a_string FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectValues() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BinaryRowKeyIT.getUrl(), props);){
            String tableName = BinaryRowKeyIT.generateUniqueName();
            BinaryRowKeyIT.initTableValues(tableName);
            String query = "SELECT * FROM " + tableName;
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])rs.getBytes(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, (byte[])rs.getBytes(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectValues() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BinaryRowKeyIT.getUrl(), props);){
            String tableName = BinaryRowKeyIT.generateUniqueName();
            BinaryRowKeyIT.initTableValues(tableName);
            String query = "UPSERT INTO " + tableName + " (a_binary, a_string, b_binary)  SELECT a_binary, a_string, a_binary FROM " + tableName;
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT a_binary, b_binary FROM " + tableName;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])rs.getBytes(1));
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])rs.getBytes(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, (byte[])rs.getBytes(1));
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, (byte[])rs.getBytes(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

