/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ViewTTLIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class BaseViewTTLIT
extends ParallelStatsDisabledIT {
    static final Logger LOGGER = LoggerFactory.getLogger(ViewTTLIT.class);
    static final int VIEW_TTL_10_SECS = 10;
    static final int VIEW_TTL_300_SECS = 300;
    static final int VIEW_TTL_120_SECS = 120;
    static final String ORG_ID_FMT = "00D0x000%s";
    static final String ID_FMT = "00A0y000%07d";
    static final String ZID_FMT = "00B0y000%07d";
    static final String ALTER_TTL_SQL = "ALTER VIEW \"%s\".\"%s\" set TTL='%s'";
    static final String ALTER_SQL_WITH_NO_TTL = "ALTER VIEW \"%s\".\"%s\" ADD IF NOT EXISTS %s CHAR(10)";
    static final int DEFAULT_NUM_ROWS = 5;
    static final String COL1_FMT = "a%05d";
    static final String COL2_FMT = "b%05d";
    static final String COL3_FMT = "c%05d";
    static final String COL4_FMT = "d%05d";
    static final String COL5_FMT = "e%05d";
    static final String COL6_FMT = "f%05d";
    static final String COL7_FMT = "g%05d";
    static final String COL8_FMT = "h%05d";
    static final String COL9_FMT = "i%05d";
    static final int MAX_COMPACTION_CHECKS = 200;
    static final String TTL_HEADER_SQL = "SELECT TTL FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND TABLE_TYPE = '%s'";
    ManualEnvironmentEdge injectEdge;
    private boolean useCondExpression;

    public BaseViewTTLIT(boolean useCondExpression) {
        this.useCondExpression = useCondExpression;
    }

    protected static void setUpTestDriver(ReadOnlyProps props) throws Exception {
        BaseViewTTLIT.setUpTestDriver(props, props);
    }

    @Parameterized.Parameters(name="useCondExpression={0}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void beforeTest() {
        EnvironmentEdgeManager.reset();
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    @After
    public synchronized void afterTest() throws Exception {
        EnvironmentEdgeManager.reset();
    }

    void resetEnvironmentEdgeManager() {
        EnvironmentEdgeManager.reset();
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    public void testResetServerCache() {
        try {
            this.clearCache(true, true, Arrays.asList("00DNA0000000MXY"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private SortOrder[][] getSortOrders() {
        SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}};
        return sortOrders;
    }

    private List<PDataType[]> getTestCases() {
        ArrayList<PDataType[]> testCases = new ArrayList<PDataType[]>();
        testCases.add(new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PLong.INSTANCE, PLong.INSTANCE, PLong.INSTANCE});
        testCases.add(new PDataType[]{PTimestamp.INSTANCE, PTimestamp.INSTANCE, PTimestamp.INSTANCE});
        testCases.add(new PDataType[]{PChar.INSTANCE, PChar.INSTANCE, PChar.INSTANCE});
        testCases.add(new PDataType[]{PDecimal.INSTANCE, PDecimal.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PDate.INSTANCE, PDate.INSTANCE, PDate.INSTANCE});
        testCases.add(new PDataType[]{PVarchar.INSTANCE, PVarchar.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PVarbinaryEncoded.INSTANCE, PVarchar.INSTANCE, PInteger.INSTANCE});
        return testCases;
    }

    private String getWhereClause(String[] pkNames, PDataType[] testPKTypes) {
        StringBuilder builder = new StringBuilder("WHERE ");
        Random rnd = new Random();
        block10: for (int b = 0; b < testPKTypes.length; ++b) {
            if (b > 0) {
                builder.append(" AND ");
            }
            switch (testPKTypes[b].getSqlType()) {
                case 12: {
                    builder.append(pkNames[b]).append(" = ").append("'").append(RandomStringUtils.randomAlphanumeric((int)25)).append("'");
                    continue block10;
                }
                case 1: {
                    builder.append(pkNames[b]).append(" = ").append("'").append(RandomStringUtils.randomAlphanumeric((int)15)).append("'");
                    continue block10;
                }
                case 3: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextDouble());
                    continue block10;
                }
                case 4: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextInt(500000));
                    continue block10;
                }
                case -5: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextLong());
                    continue block10;
                }
                case 91: {
                    builder.append(pkNames[b]).append(" = ").append(" TO_DATE('2022-03-21T15:03:57+00:00') ");
                    continue block10;
                }
                case 93: {
                    builder.append(pkNames[b]).append(" = ").append(" TO_TIMESTAMP('2019-10-27T16:17:57+00:00') ");
                    continue block10;
                }
                case -3: 
                case 9000: {
                    byte[] varBytes = ByteUtil.concat((byte[])RandomStringUtils.randomAlphanumeric((int)25).getBytes(), (byte[][])new byte[][]{Bytes.toBytes((int)rnd.nextInt(50000)), Bytes.toBytes((double)Math.floor((double)rnd.nextInt(50000) * rnd.nextDouble()))});
                    builder.append(pkNames[b]).append(" = ").append(PVarbinary.INSTANCE.toStringLiteral((Object)varBytes));
                    continue block10;
                }
                default: {
                    builder.append(pkNames[b]).append("=").append("'").append(RandomStringUtils.randomAlphanumeric((int)15)).append("'");
                }
            }
        }
        return builder.toString();
    }

    protected String getTTLExpression(int ttl) {
        return this.useCondExpression ? String.format("TO_NUMBER(CURRENT_TIME()) - TO_NUMBER(PHOENIX_ROW_TIMESTAMP()) >= %d", ttl * 1000) : String.valueOf(ttl);
    }

    private void clearCache(boolean globalFixNeeded, boolean tenantFixNeeded, List<String> allTenants) throws SQLException {
        if (globalFixNeeded) {
            try (PhoenixConnection globalConnection = DriverManager.getConnection(BaseViewTTLIT.getUrl()).unwrap(PhoenixConnection.class);){
                BaseViewTTLIT.clearCache((java.sql.Connection)globalConnection, "PLATFORM_ENTITY", "DECISION_TABLE_RECORDSET");
            }
        }
        if (tenantFixNeeded || globalFixNeeded) {
            for (String tenantId : allTenants) {
                String tenantURL = BaseViewTTLIT.getUrl() + ";TenantId=" + tenantId;
                try (java.sql.Connection tenantConnection = DriverManager.getConnection(tenantURL);){
                    BaseViewTTLIT.clearCache(tenantConnection, "PLATFORM_ENTITY", "195");
                }
            }
        }
    }

    private static void clearCache(java.sql.Connection tenantConnection, String schemaName, String tableName) throws SQLException {
        PhoenixConnection currentConnection = tenantConnection.unwrap(PhoenixConnection.class);
        PName tenantIdName = currentConnection.getTenantId();
        String tenantId = tenantIdName == null ? "" : tenantIdName.getString();
        ((PhoenixConnection)currentConnection.unwrap(PhoenixConnection.class)).getQueryServices().clearTableFromCache(Bytes.toBytes((String)tenantId), Bytes.toBytes((String)schemaName), Bytes.toBytes((String)tableName), 0L);
        currentConnection.getMetaDataCache().removeTable(currentConnection.getTenantId(), String.format("%s.%s", schemaName, tableName), null, 0L);
    }

    void assertUsingHBaseRows(byte[] hbaseTableName, long minTimestamp, int expectedRows) throws IOException, SQLException {
        try (Table tbl = driver.getConnectionQueryServices(BaseViewTTLIT.getUrl(), TestUtil.TEST_PROPERTIES).getTable(hbaseTableName);){
            Scan allRows = new Scan();
            allRows.setTimeRange(minTimestamp, Long.MAX_VALUE);
            ResultScanner scanner = tbl.getScanner(allRows);
            int numMatchingRows = 0;
            Result result = scanner.next();
            while (result != null) {
                ++numMatchingRows;
                result = scanner.next();
            }
            Assert.assertEquals((String)String.format("Expected rows do match for table = %s at timestamp %d", Bytes.toString((byte[])hbaseTableName), minTimestamp), (long)expectedRows, (long)numMatchingRows);
        }
    }

    void assertViewHeaderRowsHavePhoenixTTLRelatedCells(String schemaName, long minTimestamp, boolean rawScan, int expectedRows) throws IOException, SQLException {
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        RowFilter schemaNameFilter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator(schemaName));
        QualifierFilter phoenixTTLQualifierFilter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(PhoenixDatabaseMetaData.TTL_BYTES));
        filterList.addFilter((Filter)schemaNameFilter);
        filterList.addFilter((Filter)phoenixTTLQualifierFilter);
        try (Table tbl = driver.getConnectionQueryServices(BaseViewTTLIT.getUrl(), TestUtil.TEST_PROPERTIES).getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);){
            Scan allRows = new Scan();
            allRows.setRaw(rawScan);
            allRows.setTimeRange(minTimestamp, Long.MAX_VALUE);
            allRows.setFilter((Filter)filterList);
            ResultScanner scanner = tbl.getScanner(allRows);
            int numMatchingRows = 0;
            Result result = scanner.next();
            while (result != null) {
                numMatchingRows += result.containsColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TTL_BYTES) ? 1 : 0;
                result = scanner.next();
            }
            Assert.assertEquals((String)String.format("Expected rows do not match for table = %s at timestamp %d", Bytes.toString((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES), minTimestamp), (long)expectedRows, (long)numMatchingRows);
        }
    }

    void assertSyscatHavePhoenixTTLRelatedColumns(String tenantId, String schemaName, String tableName, String tableType, String ttlExpected) throws SQLException {
        try (java.sql.Connection connection = DriverManager.getConnection(BaseViewTTLIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(TTL_HEADER_SQL, tenantClause, schemaName, tableName, tableType);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            String ttlStr = rs.next() ? rs.getString(1) : null;
            LiteralTTLExpression actual = ttlStr != null ? TTLExpressionFactory.create((String)ttlStr) : LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
            TTLExpression expected = TTLExpressionFactory.create((String)ttlExpected);
            Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)expected, (Object)actual);
        }
    }

    String stripQuotes(String name) {
        return name.replace("\"", "");
    }

    protected PhoenixTestBuilder.SchemaBuilder createLevel2TenantViewWithGlobalLevelTTL(PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions, PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions, boolean allowIndex) throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        int viewTTL = 300;
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        if (tenantViewOptions != null) {
            tenantViewWithOverrideOptions = tenantViewOptions;
        }
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        if (tenantViewIndexOptions != null) {
            tenantViewIndexOverrideOptions = tenantViewIndexOptions;
        }
        if (allowIndex) {
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildWithNewTenant();
        } else {
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildWithNewTenant();
        }
        return schemaBuilder;
    }

    protected PhoenixTestBuilder.SchemaBuilder createLevel2TenantViewWithTenantLevelTTL(PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions, PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions) throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        int viewTTL = 300;
        tenantViewWithOverrideOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        if (tenantViewOptions != null) {
            tenantViewWithOverrideOptions = tenantViewOptions;
        }
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        if (tenantViewIndexOptions != null) {
            tenantViewIndexOverrideOptions = tenantViewIndexOptions;
        }
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildWithNewTenant();
        return schemaBuilder;
    }

    protected PhoenixTestBuilder.SchemaBuilder createLevel1TenantView(PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions, PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions) throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        if (tenantViewOptions != null) {
            tenantViewOverrideOptions = tenantViewOptions;
        }
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        if (tenantViewIndexOptions != null) {
            tenantViewIndexOverrideOptions = tenantViewIndexOptions;
        }
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildNewView();
        return schemaBuilder;
    }

    void upsertDataAndRunValidations(long viewTTL, int numRowsToUpsert, PhoenixTestBuilder.DataWriter dataWriter, PhoenixTestBuilder.DataReader dataReader, PhoenixTestBuilder.SchemaBuilder schemaBuilder) throws Exception {
        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, this.upsertData(dataWriter, numRowsToUpsert), dataReader, schemaBuilder);
        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, this.upsertData(dataWriter, numRowsToUpsert), dataReader, schemaBuilder);
    }

    void validateExpiredRowsAreNotReturnedUsingCounts(long viewTTL, PhoenixTestBuilder.DataReader dataReader, PhoenixTestBuilder.SchemaBuilder schemaBuilder) throws IOException, SQLException {
        EnvironmentEdgeManager.reset();
        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (java.sql.Connection readConnection = DriverManager.getConnection(tenantConnectUrl);){
            dataReader.setConnection(readConnection);
            org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            Assert.assertTrue((String)"Rows should exists before expiration", (fetchedData.rowKeySet().size() > 0 ? 1 : 0) != 0);
        }
        long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 2L * viewTTL * 1000L;
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scnTimestamp));
        this.injectEdge.setValue(scnTimestamp);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
        try (java.sql.Connection readConnection = DriverManager.getConnection(tenantConnectUrl, props);){
            dataReader.setConnection(readConnection);
            org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            Assert.assertEquals((String)"Expired rows should not be fetched", (long)0L, (long)fetchedData.rowKeySet().size());
        }
        EnvironmentEdgeManager.reset();
    }

    void validateExpiredRowsAreNotReturnedUsingData(long viewTTL, org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData, PhoenixTestBuilder.DataReader dataReader, PhoenixTestBuilder.SchemaBuilder schemaBuilder) throws SQLException {
        org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData;
        EnvironmentEdgeManager.reset();
        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        Properties props = new Properties();
        long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 1L;
        props.setProperty("CurrentSCN", Long.toString(scnTimestamp));
        props.setProperty("phoenix.query.request.metrics.enabled", String.valueOf(true));
        this.injectEdge.setValue(scnTimestamp);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
        try (java.sql.Connection readConnection = DriverManager.getConnection(tenantConnectUrl, props);){
            dataReader.setConnection(readConnection);
            fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Upserted data should not be null", upsertedData);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            BaseViewTTLIT.verifyRowsBeforeTTLExpiration(upsertedData, fetchedData);
        }
        props.setProperty("CurrentSCN", Long.toString(scnTimestamp + 2L * viewTTL * 1000L));
        this.injectEdge.setValue(scnTimestamp + 2L * viewTTL * 1000L);
        readConnection = DriverManager.getConnection(tenantConnectUrl, props);
        try {
            dataReader.setConnection(readConnection);
            fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            Assert.assertEquals((String)"Expired rows should not be fetched", (long)0L, (long)fetchedData.rowKeySet().size());
        }
        finally {
            if (readConnection != null) {
                readConnection.close();
            }
        }
        EnvironmentEdgeManager.reset();
    }

    void validateRowsAreNotMaskedUsingCounts(long probeTimestamp, PhoenixTestBuilder.DataReader dataReader, PhoenixTestBuilder.SchemaBuilder schemaBuilder) throws SQLException {
        org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData;
        EnvironmentEdgeManager.reset();
        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 1L;
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scnTimestamp));
        this.injectEdge.setValue(scnTimestamp);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
        try (java.sql.Connection readConnection = DriverManager.getConnection(tenantConnectUrl, props);){
            dataReader.setConnection(readConnection);
            fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            Assert.assertTrue((String)"Rows should exists before ttl expiration (now)", (fetchedData.rowKeySet().size() > 0 ? 1 : 0) != 0);
        }
        props.setProperty("CurrentSCN", Long.toString(probeTimestamp));
        this.injectEdge.setValue(probeTimestamp);
        readConnection = DriverManager.getConnection(tenantConnectUrl, props);
        try {
            dataReader.setConnection(readConnection);
            fetchedData = this.fetchData(dataReader);
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            Assert.assertTrue((String)"Rows should exists before ttl expiration (probe-timestamp)", (fetchedData.rowKeySet().size() > 0 ? 1 : 0) != 0);
        }
        finally {
            if (readConnection != null) {
                readConnection.close();
            }
        }
        EnvironmentEdgeManager.reset();
    }

    static void verifyRowsBeforeTTLExpiration(org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData, org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData) {
        Set upsertedRowKeys = upsertedData.rowKeySet();
        Set fetchedRowKeys = fetchedData.rowKeySet();
        Assert.assertNotNull((String)"Upserted row keys should not be null", (Object)upsertedRowKeys);
        Assert.assertNotNull((String)"Fetched row keys should not be null", (Object)fetchedRowKeys);
        Assert.assertEquals((String)String.format("Rows upserted and fetched do not match, upserted=%d, fetched=%d", upsertedRowKeys.size(), fetchedRowKeys.size()), (Object)upsertedRowKeys, (Object)fetchedRowKeys);
        Set fetchedCols = fetchedData.columnKeySet();
        for (String rowKey : fetchedRowKeys) {
            for (String columnKey : fetchedCols) {
                Object upsertedValue = upsertedData.get((Object)rowKey, (Object)columnKey);
                Object fetchedValue = fetchedData.get((Object)rowKey, (Object)columnKey);
                Assert.assertNotNull((String)"Upserted values should not be null", (Object)upsertedValue);
                Assert.assertNotNull((String)"Fetched values should not be null", (Object)fetchedValue);
                Assert.assertEquals((String)"Values upserted and fetched do not match", (Object)upsertedValue, (Object)fetchedValue);
            }
        }
    }

    org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertData(PhoenixTestBuilder.DataWriter dataWriter, int numRowsToUpsert) throws Exception {
        dataWriter.upsertRows(1, numRowsToUpsert);
        Thread.sleep(1L);
        return dataWriter.getDataTable();
    }

    org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchData(PhoenixTestBuilder.DataReader dataReader) throws SQLException {
        dataReader.readRows();
        return dataReader.getDataTable();
    }

    void majorCompact(TableName table, long scnTimestamp, boolean flushOnly) throws Exception {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)BaseViewTTLIT.getUtility().getConfiguration());){
            Admin admin = connection.getAdmin();
            if (!admin.tableExists(table)) {
                return;
            }
            admin.flush(table);
            if (flushOnly) {
                return;
            }
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.injectEdge.setValue(scnTimestamp);
            TestUtil.majorCompact(BaseViewTTLIT.getUtility(), table);
        }
    }

    void validateAfterMajorCompaction(String schemaName, String tableName, boolean isMultiTenantIndexTable, long earliestTimestamp, int ttlInSecs, boolean flushOnly, int expectedHBaseTableRows) throws Exception {
        long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(ttlInSecs * 1000);
        String hbaseBaseTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewIndexSchemaName = String.format("_IDX_%s", schemaName);
        String hbaseViewIndexTableName = SchemaUtil.getTableName((String)viewIndexSchemaName, (String)tableName);
        if (!isMultiTenantIndexTable) {
            LOGGER.info(String.format("########## compacting table = %s", hbaseBaseTableName));
            this.majorCompact(TableName.valueOf((String)hbaseBaseTableName), scnTimestamp, flushOnly);
        } else {
            LOGGER.info(String.format("########## compacting shared index = %s", hbaseViewIndexTableName));
            this.majorCompact(TableName.valueOf((String)hbaseViewIndexTableName), scnTimestamp, flushOnly);
        }
        byte[] hbaseBaseTableNameBytes = SchemaUtil.getTableNameAsBytes((String)schemaName, (String)tableName);
        byte[] hbaseViewIndexTableNameBytes = SchemaUtil.getTableNameAsBytes((String)viewIndexSchemaName, (String)tableName);
        if (!isMultiTenantIndexTable) {
            this.assertUsingHBaseRows(hbaseBaseTableNameBytes, earliestTimestamp, expectedHBaseTableRows);
        } else {
            this.assertUsingHBaseRows(hbaseViewIndexTableNameBytes, earliestTimestamp, expectedHBaseTableRows);
        }
    }

    List<PhoenixTestBuilder.SchemaBuilder.OtherOptions> getTableAndGlobalAndTenantColumnFamilyOptions() {
        ArrayList testCases = Lists.newArrayList();
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCases.add(testCaseWhenAllCFMatchAndAllDefault);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndSame = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndSame.setTestName("testCaseWhenAllCFMatchAndSame");
        testCaseWhenAllCFMatchAndSame.setTableCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCaseWhenAllCFMatchAndSame.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCaseWhenAllCFMatchAndSame.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
        testCases.add(testCaseWhenAllCFMatchAndSame);
        if (!this.useCondExpression) {
            PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatch = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
            testCaseWhenAllCFMatch.setTestName("testCaseWhenAllCFMatch");
            testCaseWhenAllCFMatch.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
            testCaseWhenAllCFMatch.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
            testCaseWhenAllCFMatch.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
            testCases.add(testCaseWhenAllCFMatch);
            PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenTableCFsAreDiff = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
            testCaseWhenTableCFsAreDiff.setTestName("testCaseWhenTableCFsAreDiff");
            testCaseWhenTableCFsAreDiff.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
            testCaseWhenTableCFsAreDiff.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
            testCaseWhenTableCFsAreDiff.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "B"}));
            testCases.add(testCaseWhenTableCFsAreDiff);
            PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenGlobalAndTenantCFsAreDiff = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
            testCaseWhenGlobalAndTenantCFsAreDiff.setTestName("testCaseWhenGlobalAndTenantCFsAreDiff");
            testCaseWhenGlobalAndTenantCFsAreDiff.setTableCFs(Lists.newArrayList((Object[])new String[]{null, "A", "B"}));
            testCaseWhenGlobalAndTenantCFsAreDiff.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{"A", "A", "A"}));
            testCaseWhenGlobalAndTenantCFsAreDiff.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{"B", "B", "B"}));
            testCases.add(testCaseWhenGlobalAndTenantCFsAreDiff);
        }
        return testCases;
    }

    void runValidations(long viewTTL, org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> table, PhoenixTestBuilder.DataReader dataReader, PhoenixTestBuilder.SchemaBuilder schemaBuilder) throws Exception {
        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, table, dataReader, schemaBuilder);
        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, table, dataReader, schemaBuilder);
    }

    protected void testMajorCompactWithSaltedIndexedTenantView() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = "COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0'";
        tableOptions.setTableProps(tableProps);
        tableOptions.setSaltBuckets(3);
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            final boolean isMultiTenant = (Boolean)iterator.next();
            this.resetEnvironmentEdgeManager();
            tableOptions.setMultiTenant(isMultiTenant);
            PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = isMultiTenant ? PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults() : PhoenixTestBuilder.SchemaBuilder.DataOptions.withPrefix("SALTED");
            int tenantNumber = dataOptions.getNextTenantNumber();
            final String orgId = String.format("00T0t%04d%s", tenantNumber, dataOptions.getUniqueName());
            final String keyPrefix = "SLT";
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
            if (isMultiTenant) {
                PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
                tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withTenantViewIndexDefaults().buildWithNewTenant();
            } else {
                PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions();
                globalViewOptions.setSchemaName("TEST_ENTITY");
                globalViewOptions.setGlobalViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                globalViewOptions.setGlobalViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                globalViewOptions.setGlobalViewPKColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_PK_COLUMNS));
                globalViewOptions.setGlobalViewPKColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_PK_TYPES));
                globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions();
                globalViewIndexOptions.setGlobalViewIndexColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INDEX_COLUMNS));
                globalViewIndexOptions.setGlobalViewIncludeColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INCLUDE_COLUMNS));
                globalViewOptions.setGlobalViewCondition(String.format("SELECT * FROM %s.%s WHERE OID = '%s' AND KP = '%s'", dataOptions.getSchemaName(), dataOptions.getTableName(), orgId, keyPrefix));
                PhoenixTestBuilder.SchemaBuilder.ConnectOptions connectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
                connectOptions.setUseGlobalConnectionOnly(true);
                schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withDataOptions(dataOptions).withConnectOptions(connectOptions).withGlobalViewIndexOptions(globalViewIndexOptions).build();
            }
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String oid = orgId;
                    String kp = keyPrefix;
                    String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                    String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                    String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                    String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                    String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                    String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                    String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                    return isMultiTenant ? Lists.newArrayList((Object[])new Object[]{zid, col1, col2, col3, col7, col8, col9}) : Lists.newArrayList((Object[])new Object[]{oid, kp, zid, col1, col2, col3, col7, col8, col9});
                }
            };
            long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID"});
            String connectUrl = isMultiTenant ? BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId() : BaseViewTTLIT.getUrl();
            try (java.sql.Connection writeConnection = DriverManager.getConnection(connectUrl);){
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                dataReader.setValidationColumns(columns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName()));
                dataReader.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                this.upsertDataAndRunValidations(viewTTL, 15, dataWriter, dataReader, schemaBuilder);
            }
            PTable table = schemaBuilder.getBaseTable();
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 0);
        }
    }

    protected void testMajorCompactWithOnlyTenantView() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = "MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0'";
        tableOptions.setTableProps(tableProps);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).buildWithNewTenant();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{zid, col1, col2, col3, col7, col8, col9});
            }
        };
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ZID"});
        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            dataReader.setValidationColumns(columns);
            dataReader.setRowKeyColumns(rowKeyColumns);
            dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.upsertDataAndRunValidations(viewTTL, 5, dataWriter, dataReader, schemaBuilder);
        }
        long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(viewTTL * 1000);
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
    }

    protected void testMajorCompactFromMultipleGlobalIndexes() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = "MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0'";
        tableOptions.setTableProps(tableProps);
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            boolean isIndex1Local = (Boolean)iterator.next();
            Iterator iterator2 = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
            while (iterator2.hasNext()) {
                boolean isIndex2Local = (Boolean)iterator2.next();
                for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableAndGlobalAndTenantColumnFamilyOptions()) {
                    this.resetEnvironmentEdgeManager();
                    PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
                    schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(options).build();
                    try (java.sql.Connection globalConn = DriverManager.getConnection(BaseViewTTLIT.getUrl());
                         Statement statement = globalConn.createStatement();){
                        String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL4");
                        String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityGlobalViewName(), "COL4", "COL5");
                        statement.execute(index1Str);
                        String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL5");
                        String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityGlobalViewName(), "COL5", "COL6");
                        statement.execute(index2Str);
                    }
                    PTable table = schemaBuilder.getBaseTable();
                    String schemaName = table.getSchemaName().getString();
                    String tableName = table.getTableName().getString();
                    long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                    for (int tenant : Arrays.asList(1, 2, 3)) {
                        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = schemaBuilder.getDataOptions();
                        dataOptions.getNextTenantId();
                        schemaBuilder.buildWithNewTenant();
                        String tenantId = schemaBuilder.getDataOptions().getTenantId();
                        LOGGER.debug(String.format("Building new view with tenant id %s on %s.%s", tenantId, schemaName, tableName));
                        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                            @Override
                            public List<Object> getValues(int rowIndex) {
                                Random rnd = new Random();
                                String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                                String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                                String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                                String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                                String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                                String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                                String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                                return Lists.newArrayList((Object[])new Object[]{id, col4, col5, col6, col7, col8, col9});
                            }
                        };
                        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
                        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID"});
                        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + tenantId;
                        java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
                        try {
                            writeConnection.setAutoCommit(true);
                            dataWriter.setConnection(writeConnection);
                            dataWriter.setDataSupplier(dataSupplier);
                            dataWriter.setUpsertColumns(columns);
                            dataWriter.setRowKeyColumns(rowKeyColumns);
                            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                            this.upsertData(dataWriter, 5);
                            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                            dataReader.setValidationColumns(Arrays.asList("num_rows"));
                            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                            dataReader.setDML(String.format("SELECT /* +NO_INDEX */ count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                        }
                        finally {
                            if (writeConnection == null) continue;
                            writeConnection.close();
                        }
                    }
                    long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(viewTTL * 1000);
                    this.validateAfterMajorCompaction(schemaName, tableName, false, earliestTimestamp, 10, false, 0);
                    this.validateAfterMajorCompaction(schemaName, tableName, true, earliestTimestamp, 10, false, 0);
                }
            }
        }
    }

    protected void testMajorCompactFromMultipleTenantIndexes() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = "MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0'";
        tableOptions.setTableProps(tableProps);
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
        tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            boolean isIndex1Local = (Boolean)iterator.next();
            Iterator iterator2 = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
            while (iterator2.hasNext()) {
                boolean isIndex2Local = (Boolean)iterator2.next();
                for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableAndGlobalAndTenantColumnFamilyOptions()) {
                    this.resetEnvironmentEdgeManager();
                    PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
                    schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewOptions).withTenantViewIndexOptions(tenantViewIndexOptions).withOtherOptions(options).build();
                    PTable table = schemaBuilder.getBaseTable();
                    String schemaName = table.getSchemaName().getString();
                    String tableName = table.getTableName().getString();
                    long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                    HashMap mapOfTenantIndexes = Maps.newHashMap();
                    for (int tenant : Arrays.asList(1, 2, 3)) {
                        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = schemaBuilder.getDataOptions();
                        dataOptions.getNextTenantId();
                        schemaBuilder.buildWithNewTenant();
                        String tenantId = schemaBuilder.getDataOptions().getTenantId();
                        LOGGER.debug(String.format("Building new view with tenant id %s on %s.%s", tenantId, schemaName, tableName));
                        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + tenantId;
                        try (java.sql.Connection tenantConn = DriverManager.getConnection(tenantConnectUrl);
                             Statement statement = tenantConn.createStatement();){
                            PhoenixConnection phxConn = tenantConn.unwrap(PhoenixConnection.class);
                            String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL9");
                            String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityTenantViewName(), "COL9", "COL8");
                            statement.execute(index1Str);
                            String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL7");
                            String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityTenantViewName(), "COL7", "COL8");
                            statement.execute(index2Str);
                            String defaultViewIndexName = String.format("IDX_%s", SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
                            mapOfTenantIndexes.put(tenantId, Arrays.asList(defaultViewIndexName, index1Name, index2Name));
                        }
                        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                            @Override
                            public List<Object> getValues(int rowIndex) {
                                Random rnd = new Random();
                                String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                                String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                                String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                                String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                                String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                                String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                                String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                                return Lists.newArrayList((Object[])new Object[]{id, col4, col5, col6, col7, col8, col9});
                            }
                        };
                        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
                        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID"});
                        java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
                        try {
                            writeConnection.setAutoCommit(true);
                            dataWriter.setConnection(writeConnection);
                            dataWriter.setDataSupplier(dataSupplier);
                            dataWriter.setUpsertColumns(columns);
                            dataWriter.setRowKeyColumns(rowKeyColumns);
                            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                            this.upsertData(dataWriter, 5);
                            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                            dataReader.setValidationColumns(Arrays.asList("num_rows"));
                            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                            dataReader.setDML(String.format("SELECT /* +NO_INDEX */ count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                        }
                        finally {
                            if (writeConnection == null) continue;
                            writeConnection.close();
                        }
                    }
                    long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(viewTTL * 1000);
                    this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
                    this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 0);
                }
            }
        }
    }

    protected void testMajorCompactWithSimpleIndexedBaseTables() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = String.format("COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0',TTL='%s'", this.getTTLExpression(viewTTL));
        tableOptions.setTableProps(tableProps);
        tableOptions.getTablePKColumns().add("ZID");
        tableOptions.getTablePKColumnTypes().add("CHAR(15)");
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            final boolean isMultiTenant = (Boolean)iterator.next();
            this.resetEnvironmentEdgeManager();
            tableOptions.setMultiTenant(isMultiTenant);
            PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = isMultiTenant ? PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults() : PhoenixTestBuilder.SchemaBuilder.DataOptions.withPrefix("TABLE1");
            int viewCounter = 1;
            final String orgId = String.format("00T0t%04d%s", viewCounter, dataOptions.getUniqueName());
            final String keyPrefix = "T01";
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
            if (isMultiTenant) {
                PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
                tenantViewOptions.getTenantViewPKColumns().clear();
                tenantViewOptions.getTenantViewPKColumnTypes().clear();
                schemaBuilder.withTableOptions(tableOptions).withTableIndexDefaults().withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withTenantViewIndexDefaults().buildWithNewTenant();
            } else {
                PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions();
                globalViewOptions.setSchemaName("TEST_ENTITY");
                globalViewOptions.setGlobalViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                globalViewOptions.setGlobalViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions();
                globalViewIndexOptions.setGlobalViewIndexColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INDEX_COLUMNS));
                globalViewIndexOptions.setGlobalViewIncludeColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INCLUDE_COLUMNS));
                globalViewOptions.setGlobalViewCondition(String.format("SELECT * FROM %s.%s WHERE OID = '%s' AND KP = '%s'", dataOptions.getSchemaName(), dataOptions.getTableName(), orgId, keyPrefix));
                PhoenixTestBuilder.SchemaBuilder.ConnectOptions connectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
                connectOptions.setUseGlobalConnectionOnly(true);
                schemaBuilder.withTableOptions(tableOptions).withTableIndexDefaults().withGlobalViewOptions(globalViewOptions).withDataOptions(dataOptions).withConnectOptions(connectOptions).withGlobalViewIndexOptions(globalViewIndexOptions).build();
            }
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String oid = orgId;
                    String kp = keyPrefix;
                    String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                    String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                    String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                    String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                    String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                    String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                    String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                    return isMultiTenant ? Lists.newArrayList((Object[])new Object[]{zid, col1, col2, col3, col7, col8, col9}) : Lists.newArrayList((Object[])new Object[]{oid, kp, zid, col1, col2, col3, col7, col8, col9});
                }
            };
            long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID"});
            String connectUrl = isMultiTenant ? BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId() : BaseViewTTLIT.getUrl();
            try (java.sql.Connection writeConnection = DriverManager.getConnection(connectUrl);){
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                dataReader.setValidationColumns(columns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName()));
                dataReader.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                this.upsertDataAndRunValidations(viewTTL, 5, dataWriter, dataReader, schemaBuilder);
            }
            PTable table = schemaBuilder.getBaseTable();
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
            String fullTableIndexName = schemaBuilder.getPhysicalTableIndexName(false);
            this.validateAfterMajorCompaction(SchemaUtil.getSchemaNameFromFullName((String)fullTableIndexName), SchemaUtil.getTableNameFromFullName((String)fullTableIndexName), false, earliestTimestamp, 10, false, 0);
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 0);
        }
    }

    protected void testMajorCompactWithSaltedIndexedBaseTables() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = String.format("COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0',TTL='%s'", this.getTTLExpression(viewTTL));
        tableOptions.setTableProps(tableProps);
        tableOptions.setSaltBuckets(1);
        tableOptions.getTablePKColumns().add("ZID");
        tableOptions.getTablePKColumnTypes().add("CHAR(15)");
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            final boolean isMultiTenant = (Boolean)iterator.next();
            this.resetEnvironmentEdgeManager();
            tableOptions.setMultiTenant(isMultiTenant);
            PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = isMultiTenant ? PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults() : PhoenixTestBuilder.SchemaBuilder.DataOptions.withPrefix("SALTED");
            int viewCounter = 1;
            final String orgId = String.format("00T0t%04d%s", viewCounter, dataOptions.getUniqueName());
            final String keyPrefix = "SLT";
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
            if (isMultiTenant) {
                PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
                tenantViewOptions.getTenantViewPKColumns().clear();
                tenantViewOptions.getTenantViewPKColumnTypes().clear();
                schemaBuilder.withTableOptions(tableOptions).withTableIndexDefaults().withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withTenantViewIndexDefaults().buildWithNewTenant();
            } else {
                PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions();
                globalViewOptions.setSchemaName("TEST_ENTITY");
                globalViewOptions.setGlobalViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                globalViewOptions.setGlobalViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions();
                globalViewIndexOptions.setGlobalViewIndexColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INDEX_COLUMNS));
                globalViewIndexOptions.setGlobalViewIncludeColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INCLUDE_COLUMNS));
                globalViewOptions.setGlobalViewCondition(String.format("SELECT * FROM %s.%s WHERE OID = '%s' AND KP = '%s'", dataOptions.getSchemaName(), dataOptions.getTableName(), orgId, keyPrefix));
                PhoenixTestBuilder.SchemaBuilder.ConnectOptions connectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
                connectOptions.setUseGlobalConnectionOnly(true);
                schemaBuilder.withTableOptions(tableOptions).withTableIndexDefaults().withGlobalViewOptions(globalViewOptions).withDataOptions(dataOptions).withConnectOptions(connectOptions).withGlobalViewIndexOptions(globalViewIndexOptions).build();
            }
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String oid = orgId;
                    String kp = keyPrefix;
                    String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                    String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                    String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                    String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                    String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                    String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                    String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                    return isMultiTenant ? Lists.newArrayList((Object[])new Object[]{zid, col1, col2, col3, col7, col8, col9}) : Lists.newArrayList((Object[])new Object[]{oid, kp, zid, col1, col2, col3, col7, col8, col9});
                }
            };
            long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID", "COL1", "COL2", "COL3", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID"});
            String connectUrl = isMultiTenant ? BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId() : BaseViewTTLIT.getUrl();
            try (java.sql.Connection writeConnection = DriverManager.getConnection(connectUrl);){
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                dataReader.setValidationColumns(columns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName()));
                dataReader.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                this.upsertDataAndRunValidations(viewTTL, 5, dataWriter, dataReader, schemaBuilder);
            }
            PTable table = schemaBuilder.getBaseTable();
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
            String fullTableIndexName = schemaBuilder.getPhysicalTableIndexName(false);
            this.validateAfterMajorCompaction(SchemaUtil.getSchemaNameFromFullName((String)fullTableIndexName), SchemaUtil.getTableNameFromFullName((String)fullTableIndexName), false, earliestTimestamp, 10, false, 0);
            this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 0);
        }
    }

    protected void testMajorCompactWithVariousViewsAndOptions() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        String tableProps = "MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0'";
        tableOptions.setTableProps(tableProps);
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            boolean isGlobalViewLocal = (Boolean)iterator.next();
            Iterator iterator2 = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
            while (iterator2.hasNext()) {
                boolean isTenantViewLocal = (Boolean)iterator2.next();
                for (PhoenixTestBuilder.SchemaBuilder.OtherOptions options : this.getTableAndGlobalAndTenantColumnFamilyOptions()) {
                    if (isGlobalViewLocal && isTenantViewLocal) continue;
                    this.resetEnvironmentEdgeManager();
                    globalViewIndexOptions.setLocal(isGlobalViewLocal);
                    tenantViewIndexOptions.setLocal(isTenantViewLocal);
                    PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
                    schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withTenantViewIndexOptions(tenantViewIndexOptions).withOtherOptions(options).buildWithNewTenant();
                    PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                        @Override
                        public List<Object> getValues(int rowIndex) {
                            Random rnd = new Random();
                            String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                            String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                            String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                            String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                            String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                            String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                            String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                            String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                            String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                            String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                            return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, col7, col8, col9});
                        }
                    };
                    long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                    PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                    PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                    ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
                    ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID"});
                    String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
                    try (java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);){
                        writeConnection.setAutoCommit(true);
                        dataWriter.setConnection(writeConnection);
                        dataWriter.setDataSupplier(dataSupplier);
                        dataWriter.setUpsertColumns(columns);
                        dataWriter.setRowKeyColumns(rowKeyColumns);
                        dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                        dataReader.setValidationColumns(columns);
                        dataReader.setRowKeyColumns(rowKeyColumns);
                        dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
                        dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                        this.upsertDataAndRunValidations(viewTTL, 5, dataWriter, dataReader, schemaBuilder);
                    }
                    PTable table = schemaBuilder.getBaseTable();
                    this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, 0);
                    this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 0);
                }
            }
        }
    }

    protected void testMajorCompactWhenTTLSetForSomeTenants() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewOptions).withDataOptionsDefaults().withOtherOptions(testCaseWhenAllCFMatchAndAllDefault);
        HashMap mapOfTenantIndexes = Maps.newHashMap();
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        HashSet<Integer> hasTTLSet = new HashSet<Integer>(Arrays.asList(2, 3, 7));
        HashSet<Integer> tenantSet = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
        int nonCompactedTenantSet = tenantSet.size() - hasTTLSet.size();
        boolean isIndex1Local = false;
        boolean isIndex2Local = false;
        Iterator iterator = tenantSet.iterator();
        while (iterator.hasNext()) {
            int tenant = (Integer)iterator.next();
            if (hasTTLSet.contains(tenant)) {
                tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
            }
            schemaBuilder.getDataOptions().setTenantId(null);
            schemaBuilder.buildWithNewTenant();
            tenantViewOptions.setTableProps("");
            PTable table = schemaBuilder.getBaseTable();
            String schemaName = table.getSchemaName().getString();
            String tableName = table.getTableName().getString();
            String tenantId = schemaBuilder.getDataOptions().getTenantId();
            LOGGER.debug(String.format("Building new view with tenant id %s on %s.%s", tenantId, schemaName, tableName));
            String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + tenantId;
            try (java.sql.Connection tenantConn = DriverManager.getConnection(tenantConnectUrl);
                 Statement statement = tenantConn.createStatement();){
                PhoenixConnection phxConn = tenantConn.unwrap(PhoenixConnection.class);
                String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL9");
                String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityTenantViewName(), "COL9", "COL8");
                statement.execute(index1Str);
                String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL7");
                String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityTenantViewName(), "COL7", "COL8");
                statement.execute(index2Str);
                String defaultViewIndexName = String.format("IDX_%s", SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
                mapOfTenantIndexes.put(tenantId, Arrays.asList(defaultViewIndexName, index1Name, index2Name));
            }
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                    String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                    String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                    String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                    String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                    String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                    String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                    String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{id, zid, col4, col5, col6, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
            java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.upsertData(dataWriter, 5);
                PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                if (hasTTLSet.contains(tenant)) {
                    this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                } else {
                    this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
                }
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s GROUP BY ID HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                if (hasTTLSet.contains(tenant)) {
                    this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                    continue;
                }
                this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, nonCompactedTenantSet * 5);
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, 2 * nonCompactedTenantSet * 5);
    }

    protected void testMajorCompactWithVariousTenantIdTypesAndRegions(PDataType tenantType) throws Exception {
        this.resetEnvironmentEdgeManager();
        boolean isIndex1Local = false;
        boolean isIndex2Local = false;
        int viewTTL = 10;
        String tenantTypeName = tenantType.getSqlTypeName();
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("");
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true,DEFAULT_COLUMN_FAMILY='0'");
        tableOptions.setTablePKColumns(Arrays.asList("OID", "KP"));
        tableOptions.setTablePKColumnTypes(Arrays.asList(tenantTypeName, "CHAR(3)"));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault);
        int tenantNum = dataOptions.getTenantNumber();
        try (java.sql.Connection globalConnection = DriverManager.getConnection(BaseViewTTLIT.getUrl());){
            String entityTableName = SchemaUtil.getTableName((String)dataOptions.getSchemaName(), (String)dataOptions.getTableName());
            String CO_BASE_TBL_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s (OID %s NOT NULL,KP CHAR(3) NOT NULL, COL1 VARCHAR, COL2 VARCHAR, COL3 VARCHAR CONSTRAINT pk PRIMARY KEY (OID,KP)) MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='0' SPLIT ON (?, ?, ?)";
            String createBaseTableSQL = String.format(CO_BASE_TBL_TEMPLATE, entityTableName, tenantType.getSqlTypeName());
            try (PreparedStatement pstmt = globalConnection.prepareStatement(createBaseTableSQL);){
                switch (tenantType.getSqlType()) {
                    case 1: 
                    case 12: {
                        pstmt.setString(1, String.format("00D0t%04d", tenantNum + 3));
                        pstmt.setString(2, String.format("00D0t%04d", tenantNum + 5));
                        pstmt.setString(3, String.format("00D0t%04d", tenantNum + 7));
                        break;
                    }
                    case 4: {
                        pstmt.setInt(1, 300000);
                        pstmt.setInt(2, 500000);
                        pstmt.setInt(3, 700000);
                        break;
                    }
                    case -5: {
                        pstmt.setLong(1, 30000000000L);
                        pstmt.setLong(2, 50000000000L);
                        pstmt.setLong(3, 70000000000L);
                    }
                }
                pstmt.execute();
            }
            schemaBuilder.setTableCreated();
            PTableKey tableKey = new PTableKey(null, SchemaUtil.normalizeFullTableName((String)entityTableName));
            schemaBuilder.setBaseTable(globalConnection.unwrap(PhoenixConnection.class).getTable(tableKey));
        }
        PhoenixTestBuilder.SchemaBuilder.OtherOptions otherOptions = PhoenixTestBuilder.SchemaBuilder.OtherOptions.withDefaults();
        otherOptions.setTenantViewCFs(Arrays.asList(null, null, null, null));
        HashSet<Integer> globalSet = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4));
        HashSet<Integer> hasGlobalTTLSet = new HashSet<Integer>(Arrays.asList(2, 3));
        HashSet<Integer> tenantSet = new HashSet<Integer>(Arrays.asList(1, 4, 6, 8));
        HashSet<Integer> hasTenantTTLSet = new HashSet<Integer>(Arrays.asList(1, 6));
        int numGlobalIndex = 2;
        int numTenantIndex = 2;
        int nonCompactedGlobalSet = globalSet.size() - hasGlobalTTLSet.size();
        int nonCompactedTenantSet = globalSet.size() * tenantSet.size() - hasGlobalTTLSet.size() * tenantSet.size() - hasTenantTTLSet.size() * nonCompactedGlobalSet;
        int nonCompactedTableRows = nonCompactedTenantSet * 5;
        int nonCompactedTenantIndexRows = nonCompactedTenantSet * 5 * numTenantIndex;
        int nonCompactedGlobalIndexRows = nonCompactedGlobalSet * 5 * numGlobalIndex * tenantSet.size();
        String baseGlobalViewName = dataOptions.getGlobalViewName();
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        Iterator iterator = globalSet.iterator();
        while (iterator.hasNext()) {
            int globalView = (Integer)iterator.next();
            Iterator iterator2 = tenantSet.iterator();
            while (iterator2.hasNext()) {
                int tenant = (Integer)iterator2.next();
                String globalViewName = String.format("%s_%d", baseGlobalViewName, globalView);
                dataOptions.setGlobalViewName(globalViewName);
                dataOptions.setKeyPrefix(String.format("KP%d", globalView));
                dataOptions.setTenantViewName(String.format("Z%d%d", globalView, tenant));
                globalViewOptions.setTableProps("");
                tenantViewOptions.setTableProps("");
                if (hasGlobalTTLSet.contains(globalView)) {
                    globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                } else if (hasTenantTTLSet.contains(tenant)) {
                    tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                }
                if (schemaBuilder.getDataOptions() != null) {
                    switch (tenantType.getSqlType()) {
                        case 1: 
                        case 12: {
                            schemaBuilder.getDataOptions().setTenantId(dataOptions.getNextTenantId());
                            break;
                        }
                        case 4: {
                            schemaBuilder.getDataOptions().setTenantId(Integer.toString(dataOptions.getNextTenantNumber() * 100000));
                            break;
                        }
                        case -5: {
                            schemaBuilder.getDataOptions().setTenantId(Long.toString((long)dataOptions.getNextTenantNumber() * 10000000000L));
                        }
                    }
                }
                schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withOtherOptions(otherOptions).buildWithNewTenant();
                try (java.sql.Connection globalConn = DriverManager.getConnection(BaseViewTTLIT.getUrl());
                     Statement statement = globalConn.createStatement();){
                    String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL4");
                    String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityGlobalViewName(), "COL4", "COL5");
                    statement.execute(index1Str);
                    String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL5");
                    String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityGlobalViewName(), "COL5", "COL6");
                    statement.execute(index2Str);
                }
                String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
                try (java.sql.Connection tenantConn = DriverManager.getConnection(tenantConnectUrl);
                     Statement statement = tenantConn.createStatement();){
                    PhoenixConnection phxConn = tenantConn.unwrap(PhoenixConnection.class);
                    String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL9");
                    String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityTenantViewName(), "COL9", "COL8");
                    statement.execute(index1Str);
                    String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL7");
                    String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityTenantViewName(), "COL7", "COL8");
                    statement.execute(index2Str);
                    String string = String.format("IDX_%s", SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
                }
                PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                    @Override
                    public List<Object> getValues(int rowIndex) {
                        Random rnd = new Random();
                        String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                        String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                        String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                        String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                        String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                        String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                        String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                        String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                        String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                        String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                        String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                        return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, zid, col7, col8, col9});
                    }
                };
                PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "ZID", "COL7", "COL8", "COL9"});
                ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
                java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
                try {
                    writeConnection.setAutoCommit(true);
                    dataWriter.setConnection(writeConnection);
                    dataWriter.setDataSupplier(dataSupplier);
                    dataWriter.setUpsertColumns(columns);
                    dataWriter.setRowKeyColumns(rowKeyColumns);
                    dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData = this.upsertData(dataWriter, 5);
                    dataReader.setValidationColumns(columns);
                    dataReader.setRowKeyColumns(rowKeyColumns);
                    dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
                    dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                    if (hasGlobalTTLSet.contains(globalView) || hasTenantTTLSet.contains(tenant)) {
                        LOGGER.debug("Validating {}, {}, {}", new Object[]{schemaBuilder.getDataOptions().getTenantId(), globalView, tenant});
                        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, upsertedData, dataReader, schemaBuilder);
                    } else {
                        this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
                    }
                    dataReader.setValidationColumns(Arrays.asList("num_rows"));
                    dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                    dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                    dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    if (hasGlobalTTLSet.contains(globalView) || hasTenantTTLSet.contains(tenant)) {
                        LOGGER.debug("Validating {}, {}, {}", new Object[]{schemaBuilder.getDataOptions().getTenantId(), globalView, tenant});
                        this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                    } else {
                        this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
                    }
                    dataReader.setValidationColumns(Arrays.asList("num_rows"));
                    dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                    dataReader.setDML(String.format("SELECT count(1) as num_rows from %s GROUP BY ID HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                    dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    if (hasGlobalTTLSet.contains(globalView) || hasTenantTTLSet.contains(tenant)) {
                        LOGGER.debug("Validating {}, {}, {}", new Object[]{schemaBuilder.getDataOptions().getTenantId(), globalView, tenant});
                        this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                        continue;
                    }
                    this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
                }
                finally {
                    if (writeConnection == null) continue;
                    writeConnection.close();
                }
            }
        }
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, 10, false, nonCompactedTableRows);
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, nonCompactedTenantIndexRows + nonCompactedGlobalIndexRows);
    }

    protected void testMajorCompactTenantViewsWithVariousPKTypesAndSortOrder() throws Exception {
        try {
            List<PDataType[]> testCases = this.getTestCases();
            SortOrder[][] sortOrders = this.getSortOrders();
            for (PDataType[] aCase : testCases) {
                for (SortOrder[] sortOrder : sortOrders) {
                    this.runTenantViewsWithVariousPKTypes(aCase, sortOrder);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info(LogUtil.getCallerStackTrace());
            LOGGER.error(e.getMessage());
        }
    }

    private void runTenantViewsWithVariousPKTypes(PDataType[] pkDataTypes, SortOrder[] sortOrders) throws Exception {
        this.resetEnvironmentEdgeManager();
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("");
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true,DEFAULT_COLUMN_FAMILY='0'");
        tableOptions.setTablePKColumns(Arrays.asList("OID", "KP"));
        tableOptions.setTablePKColumnTypes(Arrays.asList("CHAR(15)", "CHAR(3)"));
        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults();
        dataOptions.setTenantViewName("Z01");
        dataOptions.setKeyPrefix("Z01");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        String[] globalViewPKNames = new String[]{"ID1", "ID2", "ID3"};
        globalViewOptions.setGlobalViewPKColumns(Arrays.asList(globalViewPKNames));
        globalViewOptions.setGlobalViewPKColumnTypes(Arrays.asList(pkDataTypes[0].getSqlTypeName(), pkDataTypes[1].getSqlTypeName(), pkDataTypes[2].getSqlTypeName()));
        globalViewOptions.setGlobalViewPKColumnSort(Arrays.asList(sortOrders[0].name(), sortOrders[1].name(), sortOrders[2].name()));
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTenantViewCondition(String.format("SELECT * FROM %s.%s %s", dataOptions.getSchemaName(), dataOptions.getGlobalViewName(), this.getWhereClause(globalViewPKNames, pkDataTypes)));
        tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions);
        schemaBuilder.withDataOptions(dataOptions).withGlobalViewOptions(globalViewOptions).buildWithNewTenant();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{col1, col2, col3, col4, col5, col6, zid, col7, col8, col9});
            }
        };
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "ZID", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ZID"});
        String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData = this.upsertData(dataWriter, 5);
            dataReader.setValidationColumns(columns);
            dataReader.setRowKeyColumns(rowKeyColumns);
            dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, upsertedData, dataReader, schemaBuilder);
        }
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, viewTTL, false, 0);
    }

    protected void testTenantViewsWithOverlappingRowPrefixes() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("");
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true,DEFAULT_COLUMN_FAMILY='0'");
        tableOptions.setTablePKColumns(Arrays.asList("OID", "OOID"));
        tableOptions.setTablePKColumnTypes(Arrays.asList("CHAR(15)", "CHAR(15)"));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewWithOverrideOptions);
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        for (String keyPrefix : Arrays.asList("00D0t0001000001", "00D0t0002000001")) {
            if (keyPrefix.compareTo("00D0t0001000001") == 0) {
                dataOptions.setGlobalViewName(dataOptions.getGlobalViewName() + "_1");
                dataOptions.setTenantViewName("Z01");
                dataOptions.setKeyPrefix("00D0t0002000001");
                globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
            } else {
                dataOptions.setGlobalViewName(dataOptions.getGlobalViewName() + "_2");
                dataOptions.setTenantViewName("Z02");
                dataOptions.setKeyPrefix("00D0t0001000001");
                globalViewOptions.setTableProps("TTL=NONE");
            }
            schemaBuilder.withDataOptions(dataOptions).withGlobalViewOptions(globalViewOptions).buildWithNewTenant();
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                    String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                    String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                    String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                    String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                    String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                    String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                    String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                    String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                    String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                    String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, zid, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "ZID", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
            String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData = this.upsertData(dataWriter, 5);
                dataReader.setValidationColumns(columns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                if (keyPrefix.compareTo("00D0t0001000001") == 0) {
                    this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, upsertedData, dataReader, schemaBuilder);
                    continue;
                }
                this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, viewTTL, false, 5);
    }

    protected void testMajorCompactWithGlobalAndTenantViewHierarchy() throws Exception {
        int viewTTL = 10;
        boolean isIndex1Local = false;
        boolean isIndex2Local = false;
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(BaseViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("");
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true,DEFAULT_COLUMN_FAMILY='0'");
        tableOptions.setTablePKColumns(Arrays.asList("OID", "KP"));
        tableOptions.setTablePKColumnTypes(Arrays.asList("CHAR(15)", "CHAR(3)"));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("VARCHAR", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.OtherOptions otherOptions = PhoenixTestBuilder.SchemaBuilder.OtherOptions.withDefaults();
        otherOptions.setTenantViewCFs(Arrays.asList(null, null, null, null));
        HashSet<Integer> hasGlobalTTLSet = new HashSet<Integer>(Arrays.asList(2, 3));
        HashSet<Integer> globalSet = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        HashSet<Integer> tenantSet = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4));
        HashSet<Integer> hasTenantTTLSet = new HashSet<Integer>(Arrays.asList(2, 3));
        int numGlobalIndex = 2;
        int numTenantIndex = 2;
        int nonCompactedGlobalSet = globalSet.size() - hasGlobalTTLSet.size();
        int nonCompactedTenantSet = globalSet.size() * tenantSet.size() - hasGlobalTTLSet.size() * tenantSet.size() - hasTenantTTLSet.size() * nonCompactedGlobalSet;
        int nonCompactedTableRows = nonCompactedTenantSet * 5;
        int nonCompactedTenantIndexRows = nonCompactedTenantSet * 5 * numTenantIndex;
        int nonCompactedGlobalIndexRows = nonCompactedGlobalSet * 5 * numGlobalIndex * tenantSet.size();
        HashMap<Integer, String> tenantIds = new HashMap<Integer, String>();
        Iterator iterator = tenantSet.iterator();
        while (iterator.hasNext()) {
            int tenant = (Integer)iterator.next();
            tenantIds.put(tenant, dataOptions.getNextTenantId());
        }
        String baseGlobalViewName = dataOptions.getGlobalViewName();
        long earliestTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        Iterator iterator2 = globalSet.iterator();
        while (iterator2.hasNext()) {
            int globalView = (Integer)iterator2.next();
            Iterator iterator3 = tenantSet.iterator();
            while (iterator3.hasNext()) {
                int tenant = (Integer)iterator3.next();
                String globalViewName = String.format("%s_%d", baseGlobalViewName, globalView);
                dataOptions.setGlobalViewName(globalViewName);
                dataOptions.setKeyPrefix(String.format("KP%d", globalView));
                dataOptions.setTenantViewName(String.format("Z%d%d", globalView, tenant));
                globalViewOptions.setTableProps("");
                tenantViewOptions.setTableProps("");
                if (hasGlobalTTLSet.contains(globalView)) {
                    globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                } else if (hasTenantTTLSet.contains(tenant)) {
                    tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                }
                if (schemaBuilder.getDataOptions() != null) {
                    schemaBuilder.getDataOptions().setTenantId(null);
                }
                dataOptions.setTenantId((String)tenantIds.get(tenant));
                schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withOtherOptions(otherOptions).buildWithNewTenant();
                try (java.sql.Connection globalConn = DriverManager.getConnection(BaseViewTTLIT.getUrl());
                     Statement statement = globalConn.createStatement();){
                    String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL4");
                    String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityGlobalViewName(), "COL4", "COL5");
                    statement.execute(index1Str);
                    String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityGlobalViewName().replaceAll("\\.", "_"), "COL5");
                    String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityGlobalViewName(), "COL5", "COL6");
                    statement.execute(index2Str);
                }
                String tenantConnectUrl = BaseViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
                try (java.sql.Connection tenantConn = DriverManager.getConnection(tenantConnectUrl);
                     Statement statement = tenantConn.createStatement();){
                    PhoenixConnection phxConn = tenantConn.unwrap(PhoenixConnection.class);
                    String index1Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL9");
                    String index1Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex1Local ? "LOCAL" : "", index1Name, schemaBuilder.getEntityTenantViewName(), "COL9", "COL8");
                    statement.execute(index1Str);
                    String index2Name = String.format("IDX_%s_%s", schemaBuilder.getEntityTenantViewName().replaceAll("\\.", "_"), "COL7");
                    String index2Str = String.format("CREATE %s INDEX IF NOT EXISTS %s ON %s (%s) INCLUDE (%s)", isIndex2Local ? "LOCAL" : "", index2Name, schemaBuilder.getEntityTenantViewName(), "COL7", "COL8");
                    statement.execute(index2Str);
                    String string = String.format("IDX_%s", SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
                }
                PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                    @Override
                    public List<Object> getValues(int rowIndex) {
                        Random rnd = new Random();
                        String id = String.format(BaseViewTTLIT.ID_FMT, rowIndex);
                        String zid = String.format(BaseViewTTLIT.ZID_FMT, rowIndex);
                        String col1 = String.format(BaseViewTTLIT.COL1_FMT, rowIndex + rnd.nextInt(10000));
                        String col2 = String.format(BaseViewTTLIT.COL2_FMT, rowIndex + rnd.nextInt(10000));
                        String col3 = String.format(BaseViewTTLIT.COL3_FMT, rowIndex + rnd.nextInt(10000));
                        String col4 = String.format(BaseViewTTLIT.COL4_FMT, rowIndex + rnd.nextInt(10000));
                        String col5 = String.format(BaseViewTTLIT.COL5_FMT, rowIndex + rnd.nextInt(10000));
                        String col6 = String.format(BaseViewTTLIT.COL6_FMT, rowIndex + rnd.nextInt(10000));
                        String col7 = String.format(BaseViewTTLIT.COL7_FMT, rowIndex + rnd.nextInt(10000));
                        String col8 = String.format(BaseViewTTLIT.COL8_FMT, rowIndex + rnd.nextInt(10000));
                        String col9 = String.format(BaseViewTTLIT.COL9_FMT, rowIndex + rnd.nextInt(10000));
                        return Lists.newArrayList((Object[])new Object[]{id, col1, col2, col3, col4, col5, col6, zid, col7, col8, col9});
                    }
                };
                PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
                PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "ZID", "COL7", "COL8", "COL9"});
                ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
                java.sql.Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
                try {
                    writeConnection.setAutoCommit(true);
                    dataWriter.setConnection(writeConnection);
                    dataWriter.setDataSupplier(dataSupplier);
                    dataWriter.setUpsertColumns(columns);
                    dataWriter.setRowKeyColumns(rowKeyColumns);
                    dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData = this.upsertData(dataWriter, 5);
                    dataReader.setValidationColumns(columns);
                    dataReader.setRowKeyColumns(rowKeyColumns);
                    dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
                    dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                    long scnTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                    if (hasGlobalTTLSet.contains(globalView) || hasTenantTTLSet.contains(tenant)) {
                        this.validateExpiredRowsAreNotReturnedUsingData(viewTTL, upsertedData, dataReader, schemaBuilder);
                        continue;
                    }
                    this.validateRowsAreNotMaskedUsingCounts(scnTimestamp, dataReader, schemaBuilder);
                }
                finally {
                    if (writeConnection == null) continue;
                    writeConnection.close();
                }
            }
        }
        PTable table = schemaBuilder.getBaseTable();
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), false, earliestTimestamp, viewTTL, false, nonCompactedTableRows);
        this.validateAfterMajorCompaction(table.getSchemaName().toString(), table.getTableName().toString(), true, earliestTimestamp, 10, false, nonCompactedTenantIndexRows + nonCompactedGlobalIndexRows);
    }
}

