/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsEnabledTest.class})
@RunWith(value=Parameterized.class)
public abstract class BaseViewIT
extends ParallelStatsEnabledIT {
    protected String tableName;
    protected String schemaName;
    protected String fullTableName;
    protected String tableDDLOptions;
    protected String txProvider;

    public BaseViewIT(String txProvider) {
        StringBuilder optionBuilder = new StringBuilder();
        this.txProvider = txProvider;
        if (txProvider != null) {
            optionBuilder.append(" TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "'");
        }
        this.schemaName = "S_" + BaseViewIT.generateUniqueName();
        this.tableDDLOptions = optionBuilder.toString();
        this.tableName = "T_" + BaseViewIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)this.schemaName, (String)this.tableName);
    }

    @Parameterized.Parameters(name="transactionProvider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({"OMID"}, {null});
    }

    protected void testUpdatableViewWithIndex(Integer saltBuckets, boolean localIndex) throws Exception {
        String viewName = this.testUpdatableView(saltBuckets);
        Pair<String, Scan> pair = this.testUpdatableViewIndex(saltBuckets, localIndex, viewName);
        Scan scan = (Scan)pair.getSecond();
        String tableName = (String)pair.getFirst();
        if (saltBuckets == null) {
            try (Connection conn = DriverManager.getConnection(BaseViewIT.getUrl());){
                ResultScanner scanner;
                Result result;
                Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)tableName));
                if (ScanUtil.isLocalIndex((Scan)scan)) {
                    ScanUtil.setLocalIndexAttributes((Scan)scan, (int)0, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])scan.getStartRow(), (byte[])scan.getStopRow());
                }
                Assert.assertTrue(((result = (scanner = htable.getScanner(scan)).next()) != null && !result.isEmpty() ? 1 : 0) != 0);
                conn.createStatement().execute("DROP VIEW " + viewName);
                scanner = htable.getScanner(scan);
                result = scanner.next();
                Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    protected String testUpdatableView(Integer saltBuckets) throws Exception {
        Connection conn = DriverManager.getConnection(BaseViewIT.getUrl());
        if (saltBuckets != null) {
            if (this.tableDDLOptions.length() != 0) {
                this.tableDDLOptions = this.tableDDLOptions + ",";
            }
            this.tableDDLOptions = this.tableDDLOptions + " SALT_BUCKETS=" + saltBuckets;
        }
        String viewName = "V_" + BaseViewIT.generateUniqueName();
        String ddl = "CREATE TABLE " + this.fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, k3 DECIMAL, s VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2, k3))" + this.tableDDLOptions;
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + viewName + " AS SELECT * FROM " + this.fullTableName + " WHERE k1 = 1";
        conn.createStatement().execute(ddl);
        for (int i = 0; i < 10; ++i) {
            conn.createStatement().execute("UPSERT INTO " + this.fullTableName + " VALUES(" + i % 4 + "," + (i + 100) + "," + (i > 5 ? 2 : 1) + ")");
        }
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + this.fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + viewName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT k1, k2, k3 FROM " + viewName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)101L, (long)rs.getInt(2));
        Assert.assertEquals((long)1L, (long)rs.getInt(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)105L, (long)rs.getInt(2));
        Assert.assertEquals((long)1L, (long)rs.getInt(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)109L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,S,k3) VALUES(120,'foo',50.0)");
        conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,S,k3) VALUES(121,'bar',51.0)");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT k1, k2 FROM " + viewName + " WHERE k2 >= 120");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)120L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)121L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
        return viewName;
    }

    protected Pair<String, Scan> testUpdatableViewIndex(Integer saltBuckets, String viewName) throws Exception {
        return this.testUpdatableViewIndex(saltBuckets, false, viewName);
    }

    protected Pair<String, Scan> testUpdatableViewIndex(Integer saltBuckets, boolean localIndex, String viewName) throws Exception {
        String physicalTableName;
        String serverFilterBy;
        String clientSortAlgo;
        String keyRanges;
        String expectedTableName;
        Object iteratorTypeAndScanSize;
        Connection conn = DriverManager.getConnection(BaseViewIT.getUrl());
        String viewIndexName1 = "I_" + BaseViewIT.generateUniqueName();
        String viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName((String)this.fullTableName);
        if (localIndex) {
            conn.createStatement().execute("CREATE LOCAL INDEX " + viewIndexName1 + " on " + viewName + "(k3)");
        } else {
            conn.createStatement().execute("CREATE INDEX " + viewIndexName1 + " on " + viewName + "(k3) include (s)");
        }
        conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,S,k3) VALUES(120,'foo',50.0)");
        conn.commit();
        TestUtil.analyzeTable(conn, viewName);
        List<KeyRange> splits = TestUtil.getAllSplits(conn, viewIndexName1);
        Assert.assertEquals((long)(saltBuckets == null ? 6L : 8L), (long)splits.size());
        String query = "SELECT k1, k2, k3, s FROM " + viewName + " WHERE k3 = 51.0";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)121L, (long)rs.getInt(2));
        Assert.assertTrue((BigDecimal.valueOf(51.0).compareTo(rs.getBigDecimal(3)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"bar", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        if (localIndex) {
            iteratorTypeAndScanSize = "PARALLEL " + (saltBuckets == null ? 1 : saltBuckets) + "-WAY";
            expectedTableName = this.fullTableName;
            keyRanges = "[1,51]";
            clientSortAlgo = "CLIENT MERGE SORT";
            serverFilterBy = "SERVER FILTER BY FIRST KEY ONLY";
        } else {
            iteratorTypeAndScanSize = saltBuckets == null ? "PARALLEL 1-WAY" : "PARALLEL " + saltBuckets + "-WAY";
            expectedTableName = viewIndexPhysicalName;
            keyRanges = saltBuckets == null ? " [-32768,51]" : " [0,-32768,51] - [" + (saltBuckets - 1) + ",-32768,51]";
            clientSortAlgo = saltBuckets == null ? null : "CLIENT MERGE SORT";
            serverFilterBy = null;
        }
        Assert.assertEquals((Object)iteratorTypeAndScanSize, (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)expectedTableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)clientSortAlgo, (Object)explainPlanAttributes.getClientSortAlgo());
        Assert.assertEquals((Object)keyRanges, (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)serverFilterBy, (Object)explainPlanAttributes.getServerWhereFilter());
        String viewIndexName2 = "I_" + BaseViewIT.generateUniqueName();
        if (localIndex) {
            conn.createStatement().execute("CREATE LOCAL INDEX " + viewIndexName2 + " on " + viewName + "(s)");
        } else {
            conn.createStatement().execute("CREATE INDEX " + viewIndexName2 + " on " + viewName + "(s)");
        }
        splits = TestUtil.getAllSplits(conn, viewIndexName2);
        Assert.assertEquals((long)(saltBuckets == null ? 1L : 3L), (long)splits.size());
        TestUtil.analyzeTable(conn, this.fullTableName);
        splits = TestUtil.getAllSplits(conn, viewIndexName2);
        Assert.assertEquals((long)(saltBuckets == null ? 6L : 8L), (long)splits.size());
        query = "SELECT k1, k2, s FROM " + viewName + " WHERE s = 'foo'";
        Statement statement = conn.createStatement();
        rs = statement.executeQuery(query);
        Scan scan = statement.unwrap(PhoenixStatement.class).getQueryPlan().getContext().getScan();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)120L, (long)rs.getInt(2));
        Assert.assertEquals((Object)"foo", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = plan.getPlanStepsAsAttributes();
        if (localIndex) {
            physicalTableName = this.fullTableName;
            iteratorTypeAndScanSize = "PARALLEL " + (saltBuckets == null ? 1 : saltBuckets) + "-WAY";
            keyRanges = " [2,'foo']";
            clientSortAlgo = "CLIENT MERGE SORT";
        } else {
            physicalTableName = viewIndexPhysicalName;
            iteratorTypeAndScanSize = saltBuckets == null ? "PARALLEL 1-WAY" : "PARALLEL " + saltBuckets + "-WAY";
            keyRanges = saltBuckets == null ? " [-32767,'foo']" : " [0,-32767,'foo'] - [" + (saltBuckets - 1) + ",-32767,'foo']";
            clientSortAlgo = saltBuckets == null ? null : "CLIENT MERGE SORT";
        }
        Assert.assertEquals((Object)physicalTableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)iteratorTypeAndScanSize, (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)keyRanges, (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)clientSortAlgo, (Object)explainPlanAttributes.getClientSortAlgo());
        conn.close();
        return new Pair((Object)physicalTableName, (Object)scan);
    }
}

