/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTotalSegmentsFunctionIT
extends ParallelStatsDisabledIT {
    protected String fullTableName;

    @Before
    public void setUp() throws Exception {
        String schemaName = BaseTotalSegmentsFunctionIT.generateUniqueName();
        String tableName = BaseTotalSegmentsFunctionIT.generateUniqueName();
        this.fullTableName = schemaName + "." + tableName;
    }

    protected abstract String getPrimaryKeyColumnType();

    protected abstract String getCompositeKeyColumnType();

    protected abstract String extractPrimaryKeyValue(ResultSet var1) throws SQLException;

    @Test
    public void testTotalSegmentsWithSimpleTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON ('B', 'D', 'F')";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 95";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> queryRegions = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    queryRegions.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Number of regions should match", (long)actualRegions.size(), (long)queryRegions.size());
                for (int i = 0; i < actualRegions.size(); ++i) {
                    HRegionLocation actualRegion = (HRegionLocation)actualRegions.get(i);
                    RegionInfo queryRegion = (RegionInfo)queryRegions.get(i);
                    byte[] expectedStart = actualRegion.getRegion().getStartKey();
                    byte[] expectedEnd = actualRegion.getRegion().getEndKey();
                    Assert.assertArrayEquals((String)("Start key should match for region " + i), (byte[])expectedStart, (byte[])queryRegion.startKey);
                    Assert.assertArrayEquals((String)("End key should match for region " + i), (byte[])expectedEnd, (byte[])queryRegion.endKey);
                }
            }
        }
    }

    @Test
    public void testTotalSegmentsWithCompositeKey() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK1 INTEGER NOT NULL, PK2 " + this.getCompositeKeyColumnType() + " NOT NULL, V1 VARCHAR, CONSTRAINT PK PRIMARY KEY (PK1, PK2)) SPLIT ON ((1,'B'), (2,'A'), (3,'C'))";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 50";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> queryRegions = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    queryRegions.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Number of regions should match", (long)actualRegions.size(), (long)queryRegions.size());
                for (int i = 0; i < actualRegions.size(); ++i) {
                    HRegionLocation actualRegion = (HRegionLocation)actualRegions.get(i);
                    RegionInfo queryRegion = (RegionInfo)queryRegions.get(i);
                    Assert.assertArrayEquals((String)("Start key should match for composite key region " + i), (byte[])actualRegion.getRegion().getStartKey(), (byte[])queryRegion.startKey);
                    Assert.assertArrayEquals((String)("End key should match for composite key region " + i), (byte[])actualRegion.getRegion().getEndKey(), (byte[])queryRegion.endKey);
                }
            }
        }
    }

    @Test
    public void testTotalSegmentsWithSingleRegion() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR)";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Single region table should have one region", (long)1L, (long)actualRegions.size());
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 1";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                Assert.assertTrue((String)"Should have exactly one result row", (boolean)rs.next());
                byte[] queryStartKey = rs.getBytes(1);
                byte[] queryEndKey = rs.getBytes(2);
                queryStartKey = queryStartKey == null ? new byte[]{} : queryStartKey;
                queryEndKey = queryEndKey == null ? new byte[]{} : queryEndKey;
                HRegionLocation singleRegion = (HRegionLocation)actualRegions.get(0);
                byte[] expectedStartKey = singleRegion.getRegion().getStartKey();
                byte[] expectedEndKey = singleRegion.getRegion().getEndKey();
                Assert.assertArrayEquals((String)"Start key should match for single region", (byte[])expectedStartKey, (byte[])queryStartKey);
                Assert.assertArrayEquals((String)"End key should match for single region", (byte[])expectedEndKey, (byte[])queryEndKey);
                Assert.assertTrue((String)"Should have only one result row", (!rs.next() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithManyRegions() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            CharSequence[] splits = new String[]{"'10'", "'20'", "'30'", "'40'", "'50'", "'60'", "'70'", "'80'", "'90'"};
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON (" + String.join((CharSequence)", ", splits) + ")";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Should have 10 regions with 9 splits", (long)10L, (long)actualRegions.size());
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 100";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> queryRegions = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    queryRegions.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 10 regions", (long)10L, (long)queryRegions.size());
                for (int i = 0; i < actualRegions.size(); ++i) {
                    HRegionLocation actualRegion = (HRegionLocation)actualRegions.get(i);
                    RegionInfo queryRegion = (RegionInfo)queryRegions.get(i);
                    Assert.assertArrayEquals((String)("Start key should match for region " + i + " in many-region table"), (byte[])actualRegion.getRegion().getStartKey(), (byte[])queryRegion.startKey);
                    Assert.assertArrayEquals((String)("End key should match for region " + i + " in many-region table"), (byte[])actualRegion.getRegion().getEndKey(), (byte[])queryRegion.endKey);
                }
            }
        }
    }

    @Test
    public void testTotalSegmentsDoesNotGoToServer() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON ('B', 'D')";
            conn.createStatement().execute(createSql);
            try (PreparedStatement insert = conn.prepareStatement("UPSERT INTO " + this.fullTableName + " VALUES (?, ?)");){
                insert.setString(1, "A");
                insert.setString(2, "ValueA");
                insert.executeUpdate();
                insert.setString(1, "C");
                insert.setString(2, "ValueC");
                insert.executeUpdate();
                insert.setString(1, "E");
                insert.setString(2, "ValueE");
                insert.executeUpdate();
                conn.commit();
            }
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 42";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                int regionCount = 0;
                while (rs.next()) {
                    ++regionCount;
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    Assert.assertNotNull((String)"Start key should not be null", (Object)startKey);
                    Assert.assertNotNull((String)"End key should not be null", (Object)endKey);
                }
                Assert.assertEquals((String)"Should return 3 regions from client-side region scan", (long)3L, (long)regionCount);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithRegionBucketing() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            CharSequence[] splits = new String[]{"'10'", "'20'", "'30'", "'40'", "'50'", "'60'", "'70'", "'80'", "'90'", "'A0'", "'B0'"};
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON (" + String.join((CharSequence)", ", splits) + ")";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Should have 12 regions with 11 splits", (long)12L, (long)actualRegions.size());
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 4";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> segments = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    segments.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 4 segments when bucketing 12 regions", (long)4L, (long)segments.size());
                Assert.assertArrayEquals((String)"First segment should start with first region's start key", (byte[])((HRegionLocation)actualRegions.get(0)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)0)).startKey);
                Assert.assertArrayEquals((String)"First segment should end with third region's end key", (byte[])((HRegionLocation)actualRegions.get(2)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)0)).endKey);
                Assert.assertArrayEquals((String)"Second segment should start with fourth region's start key", (byte[])((HRegionLocation)actualRegions.get(3)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)1)).startKey);
                Assert.assertArrayEquals((String)"Second segment should end with sixth region's end key", (byte[])((HRegionLocation)actualRegions.get(5)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)1)).endKey);
                Assert.assertArrayEquals((String)"Third segment should start with seventh region's start key", (byte[])((HRegionLocation)actualRegions.get(6)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)2)).startKey);
                Assert.assertArrayEquals((String)"Third segment should end with ninth region's end key", (byte[])((HRegionLocation)actualRegions.get(8)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)2)).endKey);
                Assert.assertArrayEquals((String)"Fourth segment should start with tenth region's start key", (byte[])((HRegionLocation)actualRegions.get(9)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)3)).startKey);
                Assert.assertArrayEquals((String)"Fourth segment should end with twelfth region's end key", (byte[])((HRegionLocation)actualRegions.get(11)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)3)).endKey);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithUnevenBucketing() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            CharSequence[] splits = new String[]{"'10'", "'20'", "'30'", "'40'", "'50'", "'60'", "'70'", "'80'", "'90'"};
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON (" + String.join((CharSequence)", ", splits) + ")";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Should have 10 regions", (long)10L, (long)actualRegions.size());
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 3";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> segments = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    segments.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 3 segments", (long)3L, (long)segments.size());
                Assert.assertArrayEquals((String)"First segment should start with first region's start key", (byte[])((HRegionLocation)actualRegions.get(0)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)0)).startKey);
                Assert.assertArrayEquals((String)"First segment should end with fourth region's end key", (byte[])((HRegionLocation)actualRegions.get(3)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)0)).endKey);
                Assert.assertArrayEquals((String)"Second segment should start with fifth region's start key", (byte[])((HRegionLocation)actualRegions.get(4)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)1)).startKey);
                Assert.assertArrayEquals((String)"Second segment should end with seventh region's end key", (byte[])((HRegionLocation)actualRegions.get(6)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)1)).endKey);
                Assert.assertArrayEquals((String)"Third segment should start with eighth region's start key", (byte[])((HRegionLocation)actualRegions.get(7)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)2)).startKey);
                Assert.assertArrayEquals((String)"Third segment should end with tenth region's end key", (byte[])((HRegionLocation)actualRegions.get(9)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)2)).endKey);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithLargeTableSmallSegments() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            ArrayList<String> splitList = new ArrayList<String>();
            for (int i = 1; i < 20; ++i) {
                splitList.add(String.format("'%02d'", i * 5));
            }
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON (" + String.join((CharSequence)", ", splitList) + ")";
            conn.createStatement().execute(createSql);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Should have 20 regions", (long)20L, (long)actualRegions.size());
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 6";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> segments = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    segments.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 6 segments when bucketing 20 regions", (long)6L, (long)segments.size());
                Assert.assertArrayEquals((String)"Segment 0 should start with region 0's start key", (byte[])((HRegionLocation)actualRegions.get(0)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)0)).startKey);
                Assert.assertArrayEquals((String)"Segment 0 should end with region 3's end key", (byte[])((HRegionLocation)actualRegions.get(3)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)0)).endKey);
                Assert.assertArrayEquals((String)"Segment 1 should start with region 4's start key", (byte[])((HRegionLocation)actualRegions.get(4)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)1)).startKey);
                Assert.assertArrayEquals((String)"Segment 1 should end with region 7's end key", (byte[])((HRegionLocation)actualRegions.get(7)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)1)).endKey);
                Assert.assertArrayEquals((String)"Segment 2 should start with region 8's start key", (byte[])((HRegionLocation)actualRegions.get(8)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)2)).startKey);
                Assert.assertArrayEquals((String)"Segment 2 should end with region 10's end key", (byte[])((HRegionLocation)actualRegions.get(10)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)2)).endKey);
                Assert.assertArrayEquals((String)"Segment 3 should start with region 11's start key", (byte[])((HRegionLocation)actualRegions.get(11)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)3)).startKey);
                Assert.assertArrayEquals((String)"Segment 3 should end with region 13's end key", (byte[])((HRegionLocation)actualRegions.get(13)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)3)).endKey);
                Assert.assertArrayEquals((String)"Segment 4 should start with region 14's start key", (byte[])((HRegionLocation)actualRegions.get(14)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)4)).startKey);
                Assert.assertArrayEquals((String)"Segment 4 should end with region 16's end key", (byte[])((HRegionLocation)actualRegions.get(16)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)4)).endKey);
                Assert.assertArrayEquals((String)"Segment 5 should start with region 17's start key", (byte[])((HRegionLocation)actualRegions.get(17)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)5)).startKey);
                Assert.assertArrayEquals((String)"Segment 5 should end with region 19's end key", (byte[])((HRegionLocation)actualRegions.get(19)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)5)).endKey);
                for (int i = 0; i < segments.size() - 1; ++i) {
                    Assert.assertTrue((String)"Segments should be ordered correctly", (Bytes.compareTo((byte[])((RegionInfo)segments.get((int)i)).endKey, (byte[])((RegionInfo)segments.get((int)(i + 1))).startKey) <= 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testTotalSegmentsEdgeCase() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            CharSequence[] splits = new String[]{"'20'", "'40'", "'60'", "'80'"};
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR) SPLIT ON (" + String.join((CharSequence)", ", splits) + ")";
            conn.createStatement().execute(createSql);
            String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 1";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                Assert.assertTrue((String)"Should have exactly one result", (boolean)rs.next());
                byte[] startKey = rs.getBytes(1);
                byte[] endKey = rs.getBytes(2);
                startKey = startKey == null ? new byte[]{} : startKey;
                endKey = endKey == null ? new byte[]{} : endKey;
                PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
                ConnectionQueryServices services = phoenixConn.getQueryServices();
                byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
                List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
                Assert.assertArrayEquals((String)"Single segment should start with first region's start key", (byte[])((HRegionLocation)actualRegions.get(0)).getRegion().getStartKey(), (byte[])startKey);
                Assert.assertArrayEquals((String)"Single segment should end with last region's end key", (byte[])((HRegionLocation)actualRegions.get(actualRegions.size() - 1)).getRegion().getEndKey(), (byte[])endKey);
                Assert.assertTrue((String)"Should have only one result", (!rs.next() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithDataDistribution() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            int segment;
            CharSequence[] splits = new String[]{"'10'", "'20'", "'30'", "'40'", "'50'", "'60'", "'70'", "'80'", "'90'", "'A0'", "'B0'", "'C0'", "'D0'", "'E0'"};
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR, V2 INTEGER) SPLIT ON (" + String.join((CharSequence)", ", splits) + ")";
            conn.createStatement().execute(createSql);
            try (PreparedStatement insert = conn.prepareStatement("UPSERT INTO " + this.fullTableName + " VALUES (?, ?, ?)");){
                String[] testKeys = new String[]{"05", "15", "25", "35", "45", "55", "65", "75", "85", "95", "A5", "B5", "C5", "D5", "E5", "F5", "2X2903hg", "5Ywoe", "EeEe45", "20", "50", "500", "90", "10"};
                for (int i = 0; i < testKeys.length; ++i) {
                    insert.setString(1, testKeys[i]);
                    insert.setString(2, "Value" + i);
                    insert.setInt(3, i * 10);
                    insert.executeUpdate();
                }
                conn.commit();
            }
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            ConnectionQueryServices services = phoenixConn.getQueryServices();
            byte[] physicalTableName = phoenixConn.getTable(this.fullTableName).getPhysicalName().getBytes();
            List actualRegions = services.getAllTableRegions(physicalTableName, 30000);
            Assert.assertEquals((String)"Should have 15 regions", (long)15L, (long)actualRegions.size());
            String sql1 = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 5";
            try (PreparedStatement stmt = conn.prepareStatement(sql1);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> segments = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    segments.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 5 segments", (long)5L, (long)segments.size());
                Assert.assertArrayEquals((String)"First segment should start with first region", (byte[])((HRegionLocation)actualRegions.get(0)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)0)).startKey);
                Assert.assertArrayEquals((String)"First segment should end with third region", (byte[])((HRegionLocation)actualRegions.get(2)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)0)).endKey);
                Assert.assertArrayEquals((String)"Last segment should start with thirteenth region", (byte[])((HRegionLocation)actualRegions.get(12)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)4)).startKey);
                Assert.assertArrayEquals((String)"Last segment should end with fifteenth region", (byte[])((HRegionLocation)actualRegions.get(14)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)4)).endKey);
            }
            String sql2 = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 7";
            try (PreparedStatement stmt = conn.prepareStatement(sql2);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<RegionInfo> segments = new ArrayList<RegionInfo>();
                while (rs.next()) {
                    byte[] startKey = rs.getBytes(1);
                    byte[] endKey = rs.getBytes(2);
                    startKey = startKey == null ? new byte[]{} : startKey;
                    endKey = endKey == null ? new byte[]{} : endKey;
                    segments.add(new RegionInfo(startKey, endKey));
                }
                Assert.assertEquals((String)"Should return 7 segments for uneven bucketing", (long)7L, (long)segments.size());
                Assert.assertArrayEquals((String)"First segment should span 3 regions", (byte[])((HRegionLocation)actualRegions.get(2)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)0)).endKey);
                Assert.assertArrayEquals((String)"Second segment should start with fourth region", (byte[])((HRegionLocation)actualRegions.get(3)).getRegion().getStartKey(), (byte[])((RegionInfo)segments.get((int)1)).startKey);
                Assert.assertArrayEquals((String)"Second segment should span 2 regions", (byte[])((HRegionLocation)actualRegions.get(4)).getRegion().getEndKey(), (byte[])((RegionInfo)segments.get((int)1)).endKey);
            }
            String dataQuery = "SELECT PK, V1, V2 FROM " + this.fullTableName;
            int totalRowsFound = 0;
            ArrayList<String> totalData = new ArrayList<String>();
            try (PreparedStatement dataStmt = conn.prepareStatement(dataQuery);
                 ResultSet dataRs = dataStmt.executeQuery();){
                while (dataRs.next()) {
                    String pk = this.extractPrimaryKeyValue(dataRs);
                    String v1 = dataRs.getString(2);
                    int v2 = dataRs.getInt(3);
                    ++totalRowsFound;
                    totalData.add(String.format("PK=%s, V1=%s, V2=%d", pk, v1, v2));
                }
            }
            Assert.assertEquals((String)"Total 24 rows", (long)24L, (long)totalRowsFound);
            for (segment = 1; segment < 20; ++segment) {
                String sql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = " + segment;
                ArrayList<String> segmentData = new ArrayList<String>();
                Assert.assertEquals((String)"Total 24 rows", (long)24L, (long)this.getTotalRowsFound(conn, sql, segmentData));
                Assert.assertEquals((String)"All rows should be matching with full table scan", totalData, segmentData);
            }
            for (segment = 1; segment <= 20; ++segment) {
                String segmentSql = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = " + segment;
                int totalCountFromSegments = this.getTotalRowCountFromSegments(conn, segmentSql);
                Assert.assertEquals((String)("Total count from segments should match expected count for " + segment + " segments"), (long)24L, (long)totalCountFromSegments);
            }
        }
    }

    @Test
    public void testTotalSegmentsWithInvalidValues() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTotalSegmentsFunctionIT.getUrl(), props);){
            String createSql = "CREATE TABLE " + this.fullTableName + " (PK " + this.getPrimaryKeyColumnType() + " PRIMARY KEY, V1 VARCHAR)";
            conn.createStatement().execute(createSql);
            String sql0 = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 0";
            try (PreparedStatement stmt = conn.prepareStatement(sql0);){
                stmt.executeQuery();
                Assert.fail((String)"Expected SQLException for TOTAL_SEGMENTS() = 0");
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Expected error code for invalid TOTAL_SEGMENTS value", (long)221L, (long)e.getErrorCode());
                Assert.assertTrue((String)"Expected error message about TOTAL_SEGMENTS value", (boolean)e.getMessage().contains("TOTAL_SEGMENTS() value must be greater than 0"));
            }
            String sqlNegative = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = -1";
            try (PreparedStatement stmt = conn.prepareStatement(sqlNegative);){
                stmt.executeQuery();
                Assert.fail((String)"Expected SQLException for TOTAL_SEGMENTS() = -1");
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Expected error code for invalid TOTAL_SEGMENTS value", (long)221L, (long)e.getErrorCode());
                Assert.assertTrue((String)"Expected error message about TOTAL_SEGMENTS value", (boolean)e.getMessage().contains("TOTAL_SEGMENTS() value must be greater than 0"));
            }
            String sqlNegativeLarge = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = -100";
            try (PreparedStatement stmt = conn.prepareStatement(sqlNegativeLarge);){
                stmt.executeQuery();
                Assert.fail((String)"Expected SQLException for TOTAL_SEGMENTS() = -100");
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Expected error code for invalid TOTAL_SEGMENTS value", (long)221L, (long)e.getErrorCode());
                Assert.assertTrue((String)"Expected error message about TOTAL_SEGMENTS value", (boolean)e.getMessage().contains("TOTAL_SEGMENTS() value must be greater than 0"));
            }
            String sql1 = "SELECT SCAN_START_KEY(), SCAN_END_KEY() FROM " + this.fullTableName + " WHERE TOTAL_SEGMENTS() = 1";
            try (PreparedStatement stmt = conn.prepareStatement(sql1);
                 ResultSet rs = stmt.executeQuery();){
                Assert.assertTrue((String)"Should have exactly one result for TOTAL_SEGMENTS() = 1", (boolean)rs.next());
                Assert.assertFalse((String)"Should have only one result", (boolean)rs.next());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getTotalRowsFound(Connection conn, String sql, List<String> segmentData) throws SQLException {
        int totalRowsFound = 0;
        try (PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            block20: while (rs.next()) {
                byte[] segmentStart = rs.getBytes(1);
                byte[] segmentEnd = rs.getBytes(2);
                String dataQuery = "SELECT PK, V1, V2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
                PreparedStatement dataStmt = conn.prepareStatement(dataQuery);
                try {
                    dataStmt.setBytes(1, segmentStart);
                    dataStmt.setBytes(2, segmentEnd);
                    ResultSet dataRs = dataStmt.executeQuery();
                    try {
                        while (true) {
                            if (!dataRs.next()) continue block20;
                            String pk = this.extractPrimaryKeyValue(dataRs);
                            String v1 = dataRs.getString(2);
                            int v2 = dataRs.getInt(3);
                            ++totalRowsFound;
                            segmentData.add(String.format("PK=%s, V1=%s, V2=%d", pk, v1, v2));
                        }
                    }
                    finally {
                        if (dataRs == null) continue;
                        dataRs.close();
                    }
                }
                finally {
                    if (dataStmt == null) continue;
                    dataStmt.close();
                }
            }
            return totalRowsFound;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getTotalRowCountFromSegments(Connection conn, String segmentSql) throws SQLException {
        int totalCountFromSegments = 0;
        try (PreparedStatement segmentStmt = conn.prepareStatement(segmentSql);
             ResultSet segmentRs = segmentStmt.executeQuery();){
            while (segmentRs.next()) {
                byte[] segmentStart = segmentRs.getBytes(1);
                byte[] segmentEnd = segmentRs.getBytes(2);
                String countQuery = "SELECT COUNT(*) FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
                PreparedStatement countStmt = conn.prepareStatement(countQuery);
                try {
                    countStmt.setBytes(1, segmentStart);
                    countStmt.setBytes(2, segmentEnd);
                    ResultSet countRs = countStmt.executeQuery();
                    try {
                        if (!countRs.next()) continue;
                        totalCountFromSegments += countRs.getInt(1);
                    }
                    finally {
                        if (countRs == null) continue;
                        countRs.close();
                    }
                }
                finally {
                    if (countStmt == null) continue;
                    countStmt.close();
                }
            }
            return totalCountFromSegments;
        }
    }

    protected static class RegionInfo {
        final byte[] startKey;
        final byte[] endKey;

        RegionInfo(byte[] startKey, byte[] endKey) {
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public String toString() {
            return "RegionInfo{startKey=" + Arrays.toString(this.startKey) + ", endKey=" + Arrays.toString(this.endKey) + "}";
        }
    }
}

