/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;

public abstract class BaseTenantSpecificViewIndexIT
extends SplitSystemCatalogIT {
    public static final String NON_STRING_TENANT_ID = "1234";
    protected Set<Pair<String, String>> tenantViewsToDelete = Sets.newHashSet();

    protected void testUpdatableView(Integer saltBuckets) throws Exception {
        this.testUpdatableView(saltBuckets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testUpdatableView(Integer saltBuckets, boolean localIndex) throws Exception {
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        this.createBaseTable(tableName, saltBuckets, true);
        Connection conn = this.createTenantConnection(TENANT1);
        try {
            this.createAndPopulateTenantView(conn, TENANT1, tableName, "", viewName);
            this.createAndVerifyIndex(conn, viewName, tableName, saltBuckets, TENANT1, "", localIndex, 0L);
            this.verifyViewData(conn, viewName, "");
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testUpdatableViewNonString(Integer saltBuckets, boolean localIndex) throws Exception {
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        this.createBaseTable(tableName, saltBuckets, false);
        Connection conn = this.createTenantConnection(NON_STRING_TENANT_ID);
        try {
            this.createAndPopulateTenantView(conn, NON_STRING_TENANT_ID, tableName, "", viewName);
            this.createAndVerifyIndexNonStringTenantId(conn, viewName, tableName, NON_STRING_TENANT_ID, "");
            this.verifyViewData(conn, viewName, "");
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void testUpdatableViewsWithSameNameDifferentTenants(Integer saltBuckets) throws Exception {
        this.testUpdatableViewsWithSameNameDifferentTenants(saltBuckets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testUpdatableViewsWithSameNameDifferentTenants(Integer saltBuckets, boolean localIndex) throws Exception {
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        String viewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        String viewName2 = SchemaUtil.getTableName((String)SCHEMA4, (String)BaseTenantSpecificViewIndexIT.generateUniqueName());
        this.createBaseTable(tableName, saltBuckets, true);
        Connection conn1 = this.createTenantConnection(TENANT1);
        Connection conn2 = this.createTenantConnection(TENANT2);
        try {
            String prefixForTenant1Data = "TI";
            String prefixForTenant2Data = "TII";
            this.createAndPopulateTenantView(conn1, TENANT1, tableName, prefixForTenant1Data, viewName1);
            this.createAndPopulateTenantView(conn2, TENANT2, tableName, prefixForTenant2Data, viewName2);
            this.createAndVerifyIndex(conn1, viewName1, tableName, saltBuckets, TENANT1, prefixForTenant1Data, localIndex, 0L);
            this.createAndVerifyIndex(conn2, viewName2, tableName, saltBuckets, TENANT2, prefixForTenant2Data, localIndex, 1L);
            this.verifyViewData(conn1, viewName1, prefixForTenant1Data);
            this.verifyViewData(conn2, viewName2, prefixForTenant2Data);
        }
        finally {
            try {
                conn1.close();
            }
            catch (Exception exception) {}
            try {
                conn2.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createBaseTable(String tableName, Integer saltBuckets, boolean hasStringTenantId) throws SQLException {
        Connection conn = DriverManager.getConnection(BaseTenantSpecificViewIndexIT.getUrl());
        String tenantIdType = hasStringTenantId ? "VARCHAR" : "BIGINT";
        String ddl = "CREATE TABLE " + tableName + " (t_id " + tenantIdType + " NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\nmulti_tenant=true" + (String)(saltBuckets == null ? "" : ",salt_buckets=" + saltBuckets);
        conn.createStatement().execute(ddl);
        conn.close();
    }

    private String createAndPopulateTenantView(Connection conn, String tenantId, String baseTable, String valuePrefix, String viewName) throws SQLException {
        String ddl = "CREATE VIEW " + viewName + "(v2 VARCHAR) AS SELECT * FROM " + baseTable + " WHERE k1 = 1";
        conn.createStatement().execute(ddl);
        this.tenantViewsToDelete.add((Pair<String, String>)new Pair((Object)tenantId, (Object)viewName));
        for (int i = 0; i < 10; ++i) {
            conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,v1,v2) VALUES(" + i + ",'" + valuePrefix + "v1-" + i % 5 + "','" + valuePrefix + "v2-" + i % 2 + "')");
        }
        conn.commit();
        return viewName;
    }

    private void createAndVerifyIndex(Connection conn, String viewName, String tableName, Integer saltBuckets, String tenantId, String valuePrefix, boolean localIndex, Long expectedIndexIdOffset) throws SQLException {
        String keyRanges;
        String expectedTableName;
        String clientSortAlgo;
        Object iteratorTypeAndScanSize;
        String indexName = BaseTenantSpecificViewIndexIT.generateUniqueName();
        if (localIndex) {
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + viewName + "(v2)");
        } else {
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + viewName + "(v2)");
        }
        conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,v1,v2) VALUES (-1, 'blah', 'superblah')");
        conn.commit();
        ExplainPlan plan = conn.prepareStatement("SELECT k1, k2, v2 FROM " + viewName + " WHERE v2='" + valuePrefix + "v2-1'").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        if (localIndex) {
            iteratorTypeAndScanSize = saltBuckets == null ? "PARALLEL 1-WAY" : "PARALLEL " + saltBuckets + "-WAY";
            clientSortAlgo = "CLIENT MERGE SORT";
            expectedTableName = SchemaUtil.getTableName((String)SchemaUtil.getSchemaNameFromFullName((String)viewName), (String)indexName) + "(" + tableName + ")";
            keyRanges = " [" + (1L + expectedIndexIdOffset) + ",'" + tenantId + "','" + valuePrefix + "v2-1']";
        } else {
            if (saltBuckets == null) {
                iteratorTypeAndScanSize = "PARALLEL 1-WAY";
                clientSortAlgo = null;
                keyRanges = " [" + (-32768L + expectedIndexIdOffset) + ",'" + tenantId + "','" + valuePrefix + "v2-1']";
            } else {
                iteratorTypeAndScanSize = "PARALLEL " + saltBuckets + "-WAY";
                clientSortAlgo = "CLIENT MERGE SORT";
                keyRanges = " [X'00'," + (-32768L + expectedIndexIdOffset) + ",'" + tenantId + "','" + valuePrefix + "v2-1'] - [" + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{(byte)(saltBuckets - 1)}) + "," + (-32768L + expectedIndexIdOffset) + ",'" + tenantId + "','" + valuePrefix + "v2-1']";
            }
            expectedTableName = "_IDX_" + tableName;
        }
        Assert.assertEquals((Object)iteratorTypeAndScanSize, (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)clientSortAlgo, (Object)explainPlanAttributes.getClientSortAlgo());
        Assert.assertEquals((Object)expectedTableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)keyRanges, (Object)explainPlanAttributes.getKeyRanges());
    }

    private void createAndVerifyIndexNonStringTenantId(Connection conn, String viewName, String tableName, String tenantId, String valuePrefix) throws SQLException {
        String indexName = BaseTenantSpecificViewIndexIT.generateUniqueName();
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + viewName + "(v2)");
        conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,v1,v2) VALUES (-1, 'blah', 'superblah')");
        conn.commit();
        ExplainPlan plan = conn.prepareStatement("SELECT k1, k2, v2 FROM " + viewName + " WHERE v2='" + valuePrefix + "v2-1'").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)(SchemaUtil.getTableName((String)SchemaUtil.getSchemaNameFromFullName((String)viewName), (String)indexName) + "(" + tableName + ")"), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)(" [1," + tenantId + ",'" + valuePrefix + "v2-1']"), (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
    }

    private Connection createTenantConnection(String tenantId) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(BaseTenantSpecificViewIndexIT.getUrl(), props);
    }

    private void verifyViewData(Connection conn, String viewName, String valuePrefix) throws SQLException {
        String query = "SELECT k1, k2, v2 FROM " + viewName + " WHERE v2='" + valuePrefix + "v2-1'";
        ResultSet rs = conn.createStatement().executeQuery(query);
        ArrayList expectedResultsA = Lists.newArrayList((Object[])new List[]{Arrays.asList(1, 1, valuePrefix + "v2-1"), Arrays.asList(1, 3, valuePrefix + "v2-1"), Arrays.asList(1, 5, valuePrefix + "v2-1"), Arrays.asList(1, 7, valuePrefix + "v2-1"), Arrays.asList(1, 9, valuePrefix + "v2-1")});
        BaseTenantSpecificViewIndexIT.assertValuesEqualsResultSet(rs, expectedResultsA);
    }
}

