/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class BasePermissionsIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePermissionsIT.class);
    private static final int WAIT_TIME = 10000;
    private static final String SUPER_USER = System.getProperty("user.name");
    static HBaseTestingUtility testUtil;
    private static final Set<String> PHOENIX_SYSTEM_TABLES;
    private static final Set<String> PHOENIX_SYSTEM_TABLES_IDENTIFIERS;
    private static final String SYSTEM_SEQUENCE_IDENTIFIER = "SYSTEM.\"SEQUENCE\"";
    private static final String SYSTEM_MUTEX_IDENTIFIER = "SYSTEM.\"MUTEX\"";
    private static final String SYSTEM_CDC_STREAM_IDENTIFIER = "SYSTEM.\"CDC_STREAM\"";
    static final Set<String> PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES;
    protected static User superUser1;
    protected static User superUser2;
    protected User regularUser1 = null;
    protected User regularUser2 = null;
    protected User regularUser3 = null;
    protected User regularUser4 = null;
    static final String GROUP_SYSTEM_ACCESS = "group_system_access";
    private User groupUser = null;
    User unprivilegedUser = null;
    private static final int NUM_RECORDS = 5;
    boolean isNamespaceMapped;
    private String schemaName;
    private String tableName;
    private String fullTableName;
    private String idx1TableName;
    private String idx2TableName;
    private String idx3TableName;
    private String localIdx1TableName;
    private String view1TableName;
    private String view2TableName;

    BasePermissionsIT(boolean isNamespaceMapped) throws Exception {
        this.isNamespaceMapped = isNamespaceMapped;
        this.tableName = BasePermissionsIT.generateUniqueName();
    }

    static void initCluster(boolean isNamespaceMapped) throws Exception {
        BasePermissionsIT.initCluster(isNamespaceMapped, false);
    }

    static void initCluster(boolean isNamespaceMapped, boolean useCustomAccessController) throws Exception {
        if (null != testUtil) {
            testUtil.shutdownMiniCluster();
            testUtil = null;
        }
        testUtil = new HBaseTestingUtility();
        Configuration config = testUtil.getConfiguration();
        BasePermissionsIT.enablePhoenixHBaseAuthorization(config, useCustomAccessController);
        BasePermissionsIT.configureNamespacesOnServer(config, isNamespaceMapped);
        BasePermissionsIT.configureStatsConfigurations(config);
        config.setBoolean("hbase.localcluster.assign.random.ports", true);
        BaseTest.setPhoenixRegionServerEndpoint(config);
        testUtil.startMiniCluster(1);
        superUser1 = User.createUserForTesting((Configuration)config, (String)SUPER_USER, (String[])new String[0]);
        superUser2 = User.createUserForTesting((Configuration)config, (String)"superUser2", (String[])new String[0]);
    }

    @Before
    public void initUsersAndTables() {
        Configuration configuration = testUtil.getConfiguration();
        this.regularUser1 = User.createUserForTesting((Configuration)configuration, (String)("regularUser1_" + BasePermissionsIT.generateUniqueName()), (String[])new String[0]);
        this.regularUser2 = User.createUserForTesting((Configuration)configuration, (String)("regularUser2_" + BasePermissionsIT.generateUniqueName()), (String[])new String[0]);
        this.regularUser3 = User.createUserForTesting((Configuration)configuration, (String)("regularUser3_" + BasePermissionsIT.generateUniqueName()), (String[])new String[0]);
        this.regularUser4 = User.createUserForTesting((Configuration)configuration, (String)("regularUser4_" + BasePermissionsIT.generateUniqueName()), (String[])new String[0]);
        this.groupUser = User.createUserForTesting((Configuration)testUtil.getConfiguration(), (String)("groupUser_" + BasePermissionsIT.generateUniqueName()), (String[])new String[]{GROUP_SYSTEM_ACCESS});
        this.unprivilegedUser = User.createUserForTesting((Configuration)configuration, (String)("unprivilegedUser_" + BasePermissionsIT.generateUniqueName()), (String[])new String[0]);
        this.schemaName = BasePermissionsIT.generateUniqueName();
        this.tableName = BasePermissionsIT.generateUniqueName();
        this.fullTableName = this.schemaName + "." + this.tableName;
        this.idx1TableName = this.tableName + "_IDX1";
        this.idx2TableName = this.tableName + "_IDX2";
        this.idx3TableName = this.tableName + "_IDX3";
        this.localIdx1TableName = this.tableName + "_LIDX1";
        this.view1TableName = this.tableName + "_V1";
        this.view2TableName = this.tableName + "_V2";
    }

    private static void enablePhoenixHBaseAuthorization(Configuration config, boolean useCustomAccessController) {
        config.set("hbase.superuser", SUPER_USER + ",superUser2");
        config.set("hbase.security.authorization", Boolean.TRUE.toString());
        config.set("hbase.security.exec.permission.checks", Boolean.TRUE.toString());
        if (useCustomAccessController) {
            config.set("hbase.coprocessor.master.classes", CustomAccessController.class.getName());
            config.set("hbase.coprocessor.region.classes", CustomAccessController.class.getName());
            config.set("hbase.coprocessor.regionserver.classes", CustomAccessController.class.getName());
        } else {
            config.set("hbase.coprocessor.master.classes", "org.apache.hadoop.hbase.security.access.AccessController");
            config.set("hbase.coprocessor.region.classes", "org.apache.hadoop.hbase.security.access.AccessController");
            config.set("hbase.coprocessor.regionserver.classes", "org.apache.hadoop.hbase.security.access.AccessController");
        }
        config.set("phoenix.acls.enabled", "true");
        config.set("hbase.regionserver.wal.codec", "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec");
    }

    private static void configureNamespacesOnServer(Configuration conf, boolean isNamespaceMapped) {
        conf.set("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(isNamespaceMapped));
    }

    private static void configureStatsConfigurations(Configuration conf) {
        conf.set("phoenix.stats.guidepost.width", Long.toString(20L));
        conf.set("phoenix.stats.updateFrequency", Long.toString(5L));
        conf.set("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        conf.set("phoenix.use.stats.parallelization", Boolean.toString(true));
    }

    public static HBaseTestingUtility getUtility() {
        return testUtil;
    }

    void grantPermissions(final String toUser, final Set<String> tablesToGrant, final Permission.Action ... actions) throws Throwable {
        BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    for (String table : tablesToGrant) {
                        AccessControlClient.grant((Connection)BasePermissionsIT.getUtility().getConnection(), (TableName)TableName.valueOf((String)table), (String)toUser, null, null, (Permission.Action[])actions);
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
            }
        });
    }

    void grantPermissions(final String toUser, final String namespace, final Permission.Action ... actions) throws Throwable {
        BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Connection)BasePermissionsIT.getUtility().getConnection(), (String)namespace, (String)toUser, (Permission.Action[])actions);
                    return null;
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
            }
        });
    }

    void grantPermissions(final String groupEntry, final Permission.Action ... actions) throws Throwable {
        BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Connection)BasePermissionsIT.getUtility().getConnection(), (String)groupEntry, (Permission.Action[])actions);
                    return null;
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
            }
        });
    }

    void revokePermissions(final String toUser, final Set<String> tablesToGrant, final Permission.Action ... actions) throws Throwable {
        BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    for (String table : tablesToGrant) {
                        AccessControlClient.revoke((Connection)BasePermissionsIT.getUtility().getConnection(), (TableName)TableName.valueOf((String)table), (String)toUser, null, null, (Permission.Action[])actions);
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
            }
        });
    }

    private Properties getClientProperties(String tenantId) {
        Properties props = new Properties();
        if (tenantId != null) {
            props.setProperty("TenantId", tenantId);
        }
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        return props;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    public java.sql.Connection getConnection(String tenantId) throws SQLException {
        return DriverManager.getConnection(BasePermissionsIT.getUrl(), this.getClientProperties(tenantId));
    }

    protected static String getUrl() {
        return "jdbc:phoenix:localhost:" + testUtil.getZkCluster().getClientPort() + ":/hbase";
    }

    private static Set<String> getHBaseTables() throws IOException {
        HashSet<String> tables = new HashSet<String>();
        for (TableName tn : testUtil.getAdmin().listTableNames()) {
            tables.add(tn.getNameAsString());
        }
        return tables;
    }

    AccessTestAction grantPermissions(String actions, Object ug, String tableOrSchemaList, boolean isSchema) throws SQLException {
        return this.grantPermissions(actions, ug, Collections.singleton(tableOrSchemaList), isSchema);
    }

    private AccessTestAction grantPermissions(final String actions, final Object ug, final Set<String> tableOrSchemaList, final boolean isSchema) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                                 Statement stmt = conn.createStatement();){
                                for (String tableOrSchema : tableOrSchemaList) {
                                    String grantStmtSQL = "GRANT '" + actions + "' ON " + (isSchema ? " SCHEMA " : " TABLE ") + tableOrSchema + " TO " + (ug instanceof String ? " GROUP '" + ug + "'" : "'" + ((User)ug).getShortName() + "'");
                                    LOGGER.info("Grant Permissions SQL: " + grantStmtSQL);
                                    Assert.assertFalse((boolean)stmt.execute(grantStmtSQL));
                                }
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            if (t instanceof Exception) {
                                throw (Exception)t;
                            }
                            throw new Exception(t);
                        }
                    }
                });
                return null;
            }
        };
    }

    private AccessTestAction grantPermissions(final String actions, final User user) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                                 Statement stmt = conn.createStatement();){
                                String grantStmtSQL = "GRANT '" + actions + "' TO  '" + user.getShortName() + "'";
                                LOGGER.info("Grant Permissions SQL: " + grantStmtSQL);
                                Assert.assertFalse((boolean)stmt.execute(grantStmtSQL));
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            if (t instanceof Exception) {
                                throw (Exception)t;
                            }
                            throw new Exception(t);
                        }
                    }
                });
                return null;
            }
        };
    }

    private AccessTestAction revokePermissions(Object ug, String tableOrSchemaList, boolean isSchema) throws SQLException {
        return this.revokePermissions(ug, Collections.singleton(tableOrSchemaList), isSchema);
    }

    private AccessTestAction revokePermissions(final Object ug, final Set<String> tableOrSchemaList, final boolean isSchema) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                                 Statement stmt = conn.createStatement();){
                                for (String tableOrSchema : tableOrSchemaList) {
                                    String revokeStmtSQL = "REVOKE ON " + (isSchema ? " SCHEMA " : " TABLE ") + tableOrSchema + " FROM " + (ug instanceof String ? " GROUP '" + ug + "'" : "'" + ((User)ug).getShortName() + "'");
                                    LOGGER.info("Revoke Permissions SQL: " + revokeStmtSQL);
                                    Assert.assertFalse((boolean)stmt.execute(revokeStmtSQL));
                                }
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            if (t instanceof Exception) {
                                throw (Exception)t;
                            }
                            throw new Exception(t);
                        }
                    }
                });
                return null;
            }
        };
    }

    private AccessTestAction revokePermissions(final Object ug) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                BasePermissionsIT.updateACLs(BasePermissionsIT.getUtility(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                                 Statement stmt = conn.createStatement();){
                                String revokeStmtSQL = "REVOKE FROM " + (ug instanceof String ? " GROUP '" + ug + "'" : "'" + ((User)ug).getShortName() + "'");
                                LOGGER.info("Revoke Permissions SQL: " + revokeStmtSQL);
                                Assert.assertFalse((boolean)stmt.execute(revokeStmtSQL));
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            if (t instanceof Exception) {
                                throw (Exception)t;
                            }
                            throw new Exception(t);
                        }
                    }
                });
                return null;
            }
        };
    }

    private AccessTestAction getConnectionAction() throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                if (conn != null) {
                    conn.close();
                }
                return null;
            }
        };
    }

    AccessTestAction createSchema(final String schemaName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                if (BasePermissionsIT.this.isNamespaceMapped) {
                    try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                         Statement stmt = conn.createStatement();){
                        Assert.assertFalse((boolean)stmt.execute("CREATE SCHEMA " + schemaName));
                    }
                }
                return null;
            }
        };
    }

    AccessTestAction dropSchema(final String schemaName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                if (BasePermissionsIT.this.isNamespaceMapped) {
                    try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                         Statement stmt = conn.createStatement();){
                        Assert.assertFalse((boolean)stmt.execute("DROP SCHEMA " + schemaName));
                    }
                }
                return null;
            }
        };
    }

    AccessTestAction createTable(String tableName) throws SQLException {
        return this.createTable(tableName, 5);
    }

    AccessTestAction createTable(final String tableName, final int numRecordsToInsert) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("CREATE TABLE " + tableName + "(pk INTEGER not null primary key, data VARCHAR, val integer)"));
                    try (PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values(?, ?, ?)");){
                        for (int i = 0; i < numRecordsToInsert; ++i) {
                            pstmt.setInt(1, i);
                            pstmt.setString(2, Integer.toString(i));
                            pstmt.setInt(3, i);
                            Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                        }
                    }
                    conn.commit();
                }
                return null;
            }
        };
    }

    AccessTestAction updateStatsOnTable(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("UPDATE STATISTICS " + tableName + " SET \"phoenix.stats.guidepost.width\" = 5"));
                    int retry = 20;
                    while (retry-- > 0) {
                        Thread.sleep(10000L);
                        ResultSet rs = stmt.executeQuery("SELECT count(*) FROM SYSTEM.STATS where PHYSICAL_NAME = '" + SchemaUtil.getPhysicalHBaseTableName((byte[])tableName.getBytes(), (boolean)BasePermissionsIT.this.isNamespaceMapped) + "'");
                        rs.next();
                        if (rs.getInt(1) <= 0) continue;
                        break;
                    }
                }
                return null;
            }
        };
    }

    private AccessTestAction createMultiTenantTable(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("CREATE TABLE " + tableName + "(ORG_ID VARCHAR NOT NULL, PREFIX CHAR(3) NOT NULL, DATA VARCHAR, VAL INTEGER CONSTRAINT PK PRIMARY KEY (ORG_ID, PREFIX))  MULTI_TENANT=TRUE"));
                    try (PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values(?, ?, ?, ?)");){
                        for (int i = 0; i < 5; ++i) {
                            pstmt.setString(1, "o" + i);
                            pstmt.setString(2, "pr" + i);
                            pstmt.setString(3, Integer.toString(i));
                            pstmt.setInt(4, i);
                            Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                        }
                    }
                    conn.commit();
                }
                return null;
            }
        };
    }

    private AccessTestAction dropTable(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute(String.format("DROP TABLE IF EXISTS %s CASCADE", tableName)));
                }
                return null;
            }
        };
    }

    private AccessTestAction deleteDataFromStatsTable() throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    conn.setAutoCommit(true);
                    Assert.assertNotEquals((long)0L, (long)stmt.executeUpdate("DELETE FROM SYSTEM.STATS"));
                }
                return null;
            }
        };
    }

    private AccessTestAction readStatsAfterTableDelete(final String physicalTableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    conn.setAutoCommit(true);
                    ResultSet rs = stmt.executeQuery("SELECT count(*) from SYSTEM.STATS WHERE PHYSICAL_NAME = '" + physicalTableName + "'");
                    rs.next();
                    Assert.assertEquals((long)0L, (long)rs.getInt(1));
                }
                return null;
            }
        };
    }

    private AccessTestAction readTableWithoutVerification(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
                    Assert.assertNotNull((Object)rs);
                    while (rs.next()) {
                    }
                }
                return null;
            }
        };
    }

    private AccessTestAction readTable(String tableName) throws SQLException {
        return this.readTable(tableName, null);
    }

    private AccessTestAction readTable(final String tableName, final String indexName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    String readTableSQL = "SELECT " + (String)(indexName != null ? "/*+ INDEX(" + tableName + " " + indexName + ")*/" : "") + " pk, data, val FROM " + tableName + " where data >= '0'";
                    ResultSet rs = stmt.executeQuery(readTableSQL);
                    Assert.assertNotNull((Object)rs);
                    int i = 0;
                    while (rs.next()) {
                        Assert.assertEquals((long)i, (long)rs.getInt(1));
                        Assert.assertEquals((Object)Integer.toString(i), (Object)rs.getString(2));
                        Assert.assertEquals((long)i, (long)rs.getInt(3));
                        ++i;
                    }
                    Assert.assertEquals((long)5L, (long)i);
                }
                return null;
            }
        };
    }

    private AccessTestAction readMultiTenantTableWithoutIndex(String tableName) throws SQLException {
        return this.readMultiTenantTableWithoutIndex(tableName, null);
    }

    private AccessTestAction readMultiTenantTableWithoutIndex(final String tableName, final String tenantId) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection(tenantId);
                     Statement stmt = conn.createStatement();){
                    String readTableSQL = "SELECT data, val FROM " + tableName;
                    ResultSet rs = stmt.executeQuery(readTableSQL);
                    Assert.assertNotNull((Object)rs);
                    int i = 0;
                    String explainPlan = Joiner.on((String)" ").join((Iterable)((PhoenixStatement)stmt).getQueryPlan().getExplainPlan().getPlanSteps());
                    rs = stmt.executeQuery(readTableSQL);
                    if (tenantId != null) {
                        rs.next();
                        Assert.assertFalse((boolean)explainPlan.contains("_IDX_"));
                        Assert.assertEquals((Object)((PhoenixConnection)conn).getTenantId().toString(), (Object)tenantId);
                        Assert.assertEquals((Object)Character.toString(tenantId.charAt(1)), (Object)rs.getString(1));
                        Assert.assertFalse((boolean)rs.next());
                    } else {
                        while (rs.next()) {
                            Assert.assertEquals((Object)Integer.toString(i), (Object)rs.getString(1));
                            Assert.assertEquals((long)i, (long)rs.getInt(2));
                            ++i;
                        }
                        Assert.assertEquals((long)5L, (long)i);
                    }
                }
                return null;
            }
        };
    }

    private AccessTestAction readMultiTenantTableWithIndex(String tableName) throws SQLException {
        return this.readMultiTenantTableWithIndex(tableName, null);
    }

    private AccessTestAction readMultiTenantTableWithIndex(final String tableName, final String tenantId) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection(tenantId);
                     Statement stmt = conn.createStatement();){
                    String readTableSQL = "SELECT data FROM " + tableName;
                    ResultSet rs = stmt.executeQuery(readTableSQL);
                    Assert.assertNotNull((Object)rs);
                    int i = 0;
                    String explainPlan = Joiner.on((String)" ").join((Iterable)((PhoenixStatement)stmt).getQueryPlan().getExplainPlan().getPlanSteps());
                    Assert.assertTrue((boolean)explainPlan.contains("_IDX_"));
                    rs = stmt.executeQuery(readTableSQL);
                    if (tenantId != null) {
                        rs.next();
                        Assert.assertEquals((Object)((PhoenixConnection)conn).getTenantId().toString(), (Object)tenantId);
                        Assert.assertEquals((Object)Character.toString(tenantId.charAt(1)), (Object)rs.getString(1));
                        Assert.assertFalse((boolean)rs.next());
                    } else {
                        while (rs.next()) {
                            Assert.assertEquals((Object)Integer.toString(i), (Object)rs.getString(1));
                            ++i;
                        }
                        Assert.assertEquals((long)5L, (long)i);
                    }
                }
                return null;
            }
        };
    }

    private AccessTestAction addProperties(final String tableName, final String property, final String value) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("ALTER TABLE " + tableName + " SET " + property + "=" + value));
                }
                return null;
            }
        };
    }

    AccessTestAction addColumn(final String tableName, final String columnName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("ALTER TABLE " + tableName + " ADD " + columnName + " varchar"));
                }
                return null;
            }
        };
    }

    private AccessTestAction dropColumn(final String tableName, final String columnName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("ALTER TABLE " + tableName + " DROP COLUMN " + columnName));
                }
                return null;
            }
        };
    }

    private AccessTestAction createIndex(String indexName, String dataTable) throws SQLException {
        return this.createIndex(indexName, dataTable, null);
    }

    private AccessTestAction createIndex(final String indexName, final String dataTable, final String tenantId) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection(tenantId);
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("CREATE INDEX " + indexName + " on " + dataTable + "(data)"));
                }
                return null;
            }
        };
    }

    private AccessTestAction createLocalIndex(final String indexName, final String dataTable) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("CREATE LOCAL INDEX " + indexName + " on " + dataTable + "(data)"));
                }
                return null;
            }
        };
    }

    private AccessTestAction dropIndex(final String indexName, final String dataTable) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("DROP INDEX " + indexName + " on " + dataTable));
                }
                return null;
            }
        };
    }

    private AccessTestAction rebuildIndex(final String indexName, final String dataTable) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("ALTER INDEX " + indexName + " on " + dataTable + " DISABLE"));
                    Assert.assertFalse((boolean)stmt.execute("ALTER INDEX " + indexName + " on " + dataTable + " REBUILD"));
                }
                return null;
            }
        };
    }

    private AccessTestAction dropView(final String viewName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute(String.format("DROP VIEW %s CASCADE", viewName)));
                }
                return null;
            }
        };
    }

    AccessTestAction createView(String viewName, String dataTable) throws SQLException {
        return this.createView(viewName, dataTable, null);
    }

    private AccessTestAction createView(final String viewName, final String dataTable, final String tenantId) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection(tenantId);
                     Statement stmt = conn.createStatement();){
                    String viewStmtSQL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTable;
                    Assert.assertFalse((boolean)stmt.execute(viewStmtSQL));
                }
                return null;
            }
        };
    }

    void verifyAllowed(AccessTestAction action, User ... users) throws Exception {
        if (users.length == 0) {
            throw new Exception("Action needs at least one user to run");
        }
        for (User user : users) {
            this.verifyAllowed(user, action);
        }
    }

    private void verifyAllowed(User user, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            try {
                List results;
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (obj == null || !(obj instanceof List) || !(results = (List)obj).isEmpty()) continue;
                Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    <T> void verifyDenied(AccessTestAction action, Class<T> exception, User ... users) throws Exception {
        if (users.length == 0) {
            throw new Exception("Action needs at least one user to run");
        }
        for (User user : users) {
            this.verifyDenied(user, exception, action);
        }
    }

    private <T> void verifyDenied(User user, Class<T> exception, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            block7: {
                try {
                    user.runAs((PrivilegedExceptionAction)action);
                    Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
                }
                catch (IOException e) {
                    Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
                }
                catch (UndeclaredThrowableException ute) {
                    Throwable ex = ute.getUndeclaredThrowable();
                    for (Throwable throwable : Throwables.getCausalChain((Throwable)ex)) {
                        if (!exception.equals(throwable.getClass())) continue;
                        if (throwable instanceof AccessDeniedException) {
                            this.validateAccessDeniedException((AccessDeniedException)throwable);
                        }
                        return;
                    }
                }
                catch (RuntimeException ex) {
                    if (!(ex.getCause() instanceof AccessDeniedException)) break block7;
                    this.validateAccessDeniedException((AccessDeniedException)ex.getCause());
                    return;
                }
            }
            Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
        }
    }

    String surroundWithDoubleQuotes(String input) {
        return "\"" + input + "\"";
    }

    private void validateAccessDeniedException(AccessDeniedException ade) {
        String msg = ade.getMessage();
        Assert.assertTrue((String)("Exception contained unexpected message: '" + msg + "'"), (!msg.contains("is not the scanner owner") ? 1 : 0) != 0);
    }

    @Test
    public void testSystemTablePermissions() throws Throwable {
        this.verifyAllowed(this.createTable(this.tableName), superUser1);
        this.verifyAllowed(this.readTable(this.tableName), superUser1);
        Set<String> tables = BasePermissionsIT.getHBaseTables();
        if (this.isNamespaceMapped) {
            Assert.assertTrue((String)("HBase tables do not include expected Phoenix tables: " + tables), (boolean)tables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
        } else {
            Assert.assertTrue((String)("HBase tables do not include expected Phoenix tables: " + tables), (boolean)tables.containsAll(PHOENIX_SYSTEM_TABLES));
        }
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    if (BasePermissionsIT.this.isNamespaceMapped) {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getShortName(), PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, Permission.Action.EXEC, Permission.Action.READ);
                    } else {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getShortName(), PHOENIX_SYSTEM_TABLES, Permission.Action.EXEC, Permission.Action.READ);
                    }
                    BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getShortName(), Collections.singleton(BasePermissionsIT.this.tableName), Permission.Action.READ, Permission.Action.EXEC);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        this.verifyAllowed(this.readTable(this.tableName), this.regularUser1);
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    if (BasePermissionsIT.this.isNamespaceMapped) {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getShortName(), "SYSTEM", Permission.Action.ADMIN);
                    }
                    return null;
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
        if (this.isNamespaceMapped) {
            this.verifyAllowed(() -> {
                Properties props = new Properties();
                props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
                props.setProperty("CurrentSCN", Long.toString(42L));
                try (java.sql.Connection metaConnection = DriverManager.getConnection(BasePermissionsIT.getUrl(), props);
                     Statement stmt = metaConnection.createStatement();){
                    stmt.executeUpdate("CREATE SCHEMA IF NOT EXISTS SYSTEM");
                }
                catch (NewerSchemaAlreadyExistsException newerSchemaAlreadyExistsException) {
                    // empty catch block
                }
                return null;
            }, this.regularUser1);
        }
    }

    private void grantSystemTableAccess(User superUser, User ... users) throws Exception {
        for (User user : users) {
            if (this.isNamespaceMapped) {
                this.verifyAllowed(this.grantPermissions("RX", (Object)user, "SYSTEM", true), superUser);
            } else {
                this.verifyAllowed(this.grantPermissions("RX", (Object)user, PHOENIX_SYSTEM_TABLES_IDENTIFIERS, false), superUser);
            }
            this.verifyAllowed(this.grantPermissions("RWX", (Object)user, SYSTEM_SEQUENCE_IDENTIFIER, false), superUser);
            this.verifyAllowed(this.grantPermissions("RWX", (Object)user, SYSTEM_MUTEX_IDENTIFIER, false), superUser);
            this.verifyAllowed(this.grantPermissions("RWX", (Object)user, SYSTEM_CDC_STREAM_IDENTIFIER, false), superUser);
        }
    }

    private void revokeSystemTableAccess(User superUser, User ... users) throws Exception {
        for (User user : users) {
            if (this.isNamespaceMapped) {
                this.verifyAllowed(this.revokePermissions((Object)user, "SYSTEM", true), superUser);
                this.verifyAllowed(this.revokePermissions((Object)user, SYSTEM_SEQUENCE_IDENTIFIER, false), superUser);
                this.verifyAllowed(this.revokePermissions((Object)user, SYSTEM_MUTEX_IDENTIFIER, false), superUser);
                this.verifyAllowed(this.revokePermissions((Object)user, SYSTEM_CDC_STREAM_IDENTIFIER, false), superUser);
                continue;
            }
            this.verifyAllowed(this.revokePermissions((Object)user, PHOENIX_SYSTEM_TABLES_IDENTIFIERS, false), superUser);
        }
    }

    @Test
    public void aTestRXPermsReqdForPhoenixConn() throws Exception {
        if (this.isNamespaceMapped) {
            this.verifyDenied(this.getConnectionAction(), AccessDeniedException.class, this.regularUser1);
        } else {
            this.verifyDenied(this.getConnectionAction(), TableNotFoundException.class, this.regularUser1);
        }
        try (java.sql.Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("select * from system.catalog");
        }
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2);
        this.verifyAllowed(this.getConnectionAction(), this.regularUser1);
        this.revokeSystemTableAccess(superUser1, this.regularUser2);
        this.verifyDenied(this.getConnectionAction(), AccessDeniedException.class, this.regularUser2);
    }

    @Test
    public void testSuperUserCanChangePerms() throws Throwable {
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2, this.unprivilegedUser);
        this.verifyAllowed(this.grantPermissions("A", this.regularUser1), superUser1);
        this.verifyAllowed(this.readTableWithoutVerification("SYSTEM.\"CATALOG\""), this.regularUser1);
        this.verifyAllowed(this.grantPermissions("A", this.regularUser2), this.regularUser1);
        this.verifyAllowed(this.revokePermissions(this.regularUser1), superUser1);
        this.verifyDenied(this.grantPermissions("A", this.regularUser3), AccessDeniedException.class, this.regularUser1);
        this.verifyAllowed(this.getConnectionAction(), this.unprivilegedUser);
        this.verifyDenied(this.grantPermissions("ARX", this.regularUser4), AccessDeniedException.class, this.unprivilegedUser);
    }

    @Test
    public void testReadPermsOnTableIndexAndView() throws Exception {
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2, this.unprivilegedUser);
        if (this.isNamespaceMapped) {
            this.verifyAllowed(this.createSchema(this.schemaName), superUser1);
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.schemaName, true), superUser1);
        } else {
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.surroundWithDoubleQuotes("default"), true), superUser1);
        }
        this.verifyAllowed(this.createTable(this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.readTable(this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx2TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createLocalIndex(this.localIdx1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createView(this.view1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx3TableName, this.view1TableName), this.regularUser1);
        this.verifyAllowed(this.getConnectionAction(), this.regularUser2);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTable(this.fullTableName, this.idx1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTable(this.view1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser2, this.fullTableName, false), this.regularUser1);
        this.verifyDenied(this.grantPermissions("W", (Object)this.regularUser2, this.schemaName + "." + this.idx1TableName, false), AccessDeniedException.class, this.regularUser1);
        this.verifyDenied(this.grantPermissions("W", (Object)this.regularUser2, this.schemaName + "." + this.view1TableName, false), org.apache.phoenix.schema.TableNotFoundException.class, this.regularUser1);
        this.verifyAllowed(this.readTable(this.fullTableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.idx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.idx2TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.localIdx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.view1TableName), this.regularUser2);
        this.verifyAllowed(this.readMultiTenantTableWithIndex(this.view1TableName), this.regularUser2);
        this.verifyAllowed(this.revokePermissions((Object)this.regularUser2, this.fullTableName, false), this.regularUser1);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), AccessDeniedException.class, this.regularUser2);
    }

    @Test
    public void testReadPermsOnTableIndexAndViewOnLowerCaseSchema() throws Exception {
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2, this.unprivilegedUser);
        this.schemaName = "\"" + this.schemaName.toLowerCase() + "\"";
        this.fullTableName = this.schemaName + "." + this.tableName;
        if (this.isNamespaceMapped) {
            this.verifyAllowed(this.createSchema(this.schemaName), superUser1);
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.schemaName, true), superUser1);
        } else {
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.surroundWithDoubleQuotes("default"), true), superUser1);
        }
        this.verifyAllowed(this.createTable(this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.readTable(this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx2TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createLocalIndex(this.localIdx1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createView(this.view1TableName, this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx3TableName, this.view1TableName), this.regularUser1);
        this.verifyAllowed(this.getConnectionAction(), this.regularUser2);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTable(this.fullTableName, this.idx1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTable(this.view1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), AccessDeniedException.class, this.regularUser2);
        this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser2, this.fullTableName, false), this.regularUser1);
        this.verifyDenied(this.grantPermissions("W", (Object)this.regularUser2, this.schemaName + "." + this.idx1TableName, false), AccessDeniedException.class, this.regularUser1);
        this.verifyDenied(this.grantPermissions("W", (Object)this.regularUser2, this.schemaName + "." + this.view1TableName, false), org.apache.phoenix.schema.TableNotFoundException.class, this.regularUser1);
        this.verifyAllowed(this.readTable(this.fullTableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.idx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.idx2TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.fullTableName, this.localIdx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), this.regularUser2);
        this.verifyAllowed(this.readTable(this.view1TableName), this.regularUser2);
        this.verifyAllowed(this.readMultiTenantTableWithIndex(this.view1TableName), this.regularUser2);
        this.verifyAllowed(this.revokePermissions((Object)this.regularUser2, this.fullTableName, false), this.regularUser1);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.regularUser2);
        this.verifyDenied(this.readTableWithoutVerification(this.schemaName + "." + this.idx1TableName), AccessDeniedException.class, this.regularUser2);
    }

    @Test
    public void testGroupUserPerms() throws Exception {
        if (this.isNamespaceMapped) {
            this.verifyAllowed(this.createSchema(this.schemaName), superUser1);
        }
        this.verifyAllowed(this.createTable(this.fullTableName), superUser1);
        this.verifyAllowed(this.grantPermissions("RX", (Object)GROUP_SYSTEM_ACCESS, PHOENIX_SYSTEM_TABLES_IDENTIFIERS, false), superUser1);
        this.grantSystemTableAccess(superUser1, this.regularUser1);
        this.verifyAllowed(this.grantPermissions("ARX", (Object)GROUP_SYSTEM_ACCESS, this.fullTableName, false), superUser1);
        this.verifyAllowed(this.readTable(this.fullTableName), this.groupUser);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.regularUser1);
        this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser1, this.fullTableName, false), this.groupUser);
        this.verifyAllowed(this.readTable(this.fullTableName), this.regularUser1);
        this.verifyAllowed(this.revokePermissions((Object)GROUP_SYSTEM_ACCESS, this.fullTableName, false), superUser1);
        this.verifyDenied(this.readTable(this.fullTableName), AccessDeniedException.class, this.groupUser);
    }

    @Test
    public void testMultiTenantTables() throws Exception {
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2, this.regularUser3);
        if (this.isNamespaceMapped) {
            this.verifyAllowed(this.createSchema(this.schemaName), superUser1);
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.schemaName, true), superUser1);
        } else {
            this.verifyAllowed(this.grantPermissions("C", (Object)this.regularUser1, this.surroundWithDoubleQuotes("default"), true), superUser1);
        }
        this.verifyAllowed(this.createMultiTenantTable(this.fullTableName), this.regularUser1);
        this.verifyDenied(this.readMultiTenantTableWithoutIndex(this.fullTableName), AccessDeniedException.class, this.regularUser2);
        this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser2, this.fullTableName, false), this.regularUser1);
        this.verifyAllowed(this.readMultiTenantTableWithoutIndex(this.fullTableName), this.regularUser2);
        this.verifyAllowed(this.createView(this.view1TableName, this.fullTableName, "o1"), this.regularUser1);
        this.verifyAllowed(this.createView(this.view2TableName, this.fullTableName, "o2"), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx1TableName, this.view1TableName, "o1"), this.regularUser1);
        this.verifyAllowed(this.createIndex(this.idx2TableName, this.view2TableName, "o2"), this.regularUser1);
        this.verifyAllowed(this.readMultiTenantTableWithIndex(this.view1TableName, "o1"), this.regularUser2);
        this.verifyAllowed(this.readMultiTenantTableWithoutIndex(this.view2TableName, "o2"), this.regularUser2);
    }

    @Test
    public void testCreateViewOnTableWithRXPermsOnSchema() throws Exception {
        this.grantSystemTableAccess(superUser1, this.regularUser1, this.regularUser2, this.regularUser3);
        if (this.isNamespaceMapped) {
            this.verifyAllowed(this.createSchema(this.schemaName), superUser1);
            this.verifyAllowed(this.createTable(this.fullTableName), superUser1);
            this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser1, this.schemaName, true), superUser1);
        } else {
            this.verifyAllowed(this.createTable(this.fullTableName), superUser1);
            this.verifyAllowed(this.grantPermissions("RX", (Object)this.regularUser1, this.surroundWithDoubleQuotes("default"), true), superUser1);
        }
        this.verifyAllowed(this.createView(this.view1TableName, this.fullTableName), this.regularUser1);
    }

    protected void grantSystemTableAccess() throws Exception {
        try (java.sql.Connection conn = this.getConnection();){
            if (this.isNamespaceMapped) {
                this.grantPermissions(this.regularUser1.getShortName(), PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getShortName(), PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(AuthUtil.toGroupEntry((String)GROUP_SYSTEM_ACCESS), PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.regularUser1.getName(), Collections.singleton("SYSTEM:SEQUENCE"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getName(), Collections.singleton("SYSTEM:SEQUENCE"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.regularUser1.getShortName(), Collections.singleton("SYSTEM:MUTEX"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getShortName(), Collections.singleton("SYSTEM:MUTEX"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
            } else {
                this.grantPermissions(this.regularUser1.getName(), PHOENIX_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getName(), PHOENIX_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(AuthUtil.toGroupEntry((String)GROUP_SYSTEM_ACCESS), PHOENIX_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.regularUser1.getName(), Collections.singleton("SYSTEM.SEQUENCE"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getName(), Collections.singleton("SYSTEM:SEQUENCE"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.regularUser1.getShortName(), Collections.singleton("SYSTEM.MUTEX"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
                this.grantPermissions(this.unprivilegedUser.getShortName(), Collections.singleton("SYSTEM.MUTEX"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
    }

    @Test
    public void testAutomaticGrantWithIndexAndView() throws Throwable {
        String schema = "TEST_INDEX_VIEW";
        String tableName = "TABLE_DDL_PERMISSION_IT";
        String phoenixTableName = "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT";
        String indexName1 = "TABLE_DDL_PERMISSION_IT_IDX1";
        String indexName2 = "TABLE_DDL_PERMISSION_IT_IDX2";
        String lIndexName1 = "TABLE_DDL_PERMISSION_IT_LIDX1";
        String viewName1 = "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1";
        String viewName2 = "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V2";
        String viewName3 = "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V3";
        String viewName4 = "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V4";
        String viewIndexName1 = "TABLE_DDL_PERMISSION_IT_VIDX1";
        String viewIndexName2 = "TABLE_DDL_PERMISSION_IT_VIDX2";
        this.grantSystemTableAccess();
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    BasePermissionsIT.this.verifyAllowed(BasePermissionsIT.this.createSchema("TEST_INDEX_VIEW"), superUser1);
                    BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), Permission.Action.ADMIN);
                    if (BasePermissionsIT.this.isNamespaceMapped) {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), "TEST_INDEX_VIEW", Permission.Action.CREATE);
                        BasePermissionsIT.this.grantPermissions(AuthUtil.toGroupEntry((String)BasePermissionsIT.GROUP_SYSTEM_ACCESS), "TEST_INDEX_VIEW", Permission.Action.CREATE);
                    } else {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.CREATE);
                        BasePermissionsIT.this.grantPermissions(AuthUtil.toGroupEntry((String)BasePermissionsIT.GROUP_SYSTEM_ACCESS), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.CREATE);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        this.verifyAllowed(this.createTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.createIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.createLocalIndex("TABLE_DDL_PERMISSION_IT_LIDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.createIndex("TABLE_DDL_PERMISSION_IT_VIDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.createIndex("TABLE_DDL_PERMISSION_IT_VIDX2", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V4", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.readTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyDenied(this.createIndex("TABLE_DDL_PERMISSION_IT_IDX2", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V2", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V3", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.dropView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.dropIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.dropTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.rebuildIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.addColumn("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "val1"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.dropColumn("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "val"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.addProperties("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "GUIDE_POSTS_WIDTH", "100"), AccessDeniedException.class, this.unprivilegedUser);
        this.grantPermissions(this.unprivilegedUser.getShortName(), Collections.singleton(SchemaUtil.getPhysicalHBaseTableName((String)"TEST_INDEX_VIEW", (String)"TABLE_DDL_PERMISSION_IT", (boolean)this.isNamespaceMapped).getString()), Permission.Action.READ, Permission.Action.EXEC);
        this.grantPermissions(AuthUtil.toGroupEntry((String)GROUP_SYSTEM_ACCESS), Collections.singleton(SchemaUtil.getPhysicalHBaseTableName((String)"TEST_INDEX_VIEW", (String)"TABLE_DDL_PERMISSION_IT", (boolean)this.isNamespaceMapped).getString()), Permission.Action.READ, Permission.Action.EXEC);
        this.verifyDenied(this.createIndex("TABLE_DDL_PERMISSION_IT_IDX2", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyAllowed(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V2", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.unprivilegedUser);
        this.verifyAllowed(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V3", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), this.unprivilegedUser);
        if (this.isNamespaceMapped) {
            this.grantPermissions(this.unprivilegedUser.getShortName(), "TEST_INDEX_VIEW", Permission.Action.CREATE);
        } else {
            this.grantPermissions(this.unprivilegedUser.getShortName(), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.CREATE);
        }
        this.verifyAllowed(this.readTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "TABLE_DDL_PERMISSION_IT_IDX1"), this.unprivilegedUser);
        this.verifyAllowed(this.readTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.rebuildIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.addColumn("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "val1"), this.regularUser1);
        this.verifyAllowed(this.addProperties("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "GUIDE_POSTS_WIDTH", "100"), this.regularUser1);
        this.verifyAllowed(this.dropView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.dropView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V2"), this.regularUser1);
        this.verifyAllowed(this.dropColumn("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT", "val1"), this.regularUser1);
        this.verifyAllowed(this.dropIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.dropTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), this.regularUser1);
        this.verifyAllowed(this.createTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), superUser2);
        this.verifyAllowed(this.createIndex("TABLE_DDL_PERMISSION_IT_IDX1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), superUser2);
        this.verifyAllowed(this.createView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1", "TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), superUser2);
        this.verifyAllowed(this.readTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), superUser2);
        this.verifyAllowed(this.dropView("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT_V1"), superUser2);
        this.verifyAllowed(this.dropTable("TEST_INDEX_VIEW.TABLE_DDL_PERMISSION_IT"), superUser2);
    }

    @Test
    public void testDeletingStatsShouldNotFailWithADEWhenTableDropped() throws Throwable {
        String schema = "STATS_ENABLED";
        String tableName = "DELETE_TABLE_IT";
        String phoenixTableName = "STATS_ENABLED.DELETE_TABLE_IT";
        String indexName1 = "DELETE_TABLE_IT_IDX1";
        String lIndexName1 = "DELETE_TABLE_IT_LIDX1";
        String viewName1 = "STATS_ENABLED.DELETE_TABLE_IT_V1";
        String viewIndexName1 = "DELETE_TABLE_IT_VIDX1";
        this.grantSystemTableAccess();
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    BasePermissionsIT.this.verifyAllowed(BasePermissionsIT.this.createSchema("STATS_ENABLED"), superUser1);
                    BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), Permission.Action.ADMIN);
                    if (BasePermissionsIT.this.isNamespaceMapped) {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), "STATS_ENABLED", Permission.Action.CREATE);
                        BasePermissionsIT.this.grantPermissions(AuthUtil.toGroupEntry((String)BasePermissionsIT.GROUP_SYSTEM_ACCESS), "STATS_ENABLED", Permission.Action.CREATE);
                    } else {
                        BasePermissionsIT.this.grantPermissions(BasePermissionsIT.this.regularUser1.getName(), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.CREATE);
                        BasePermissionsIT.this.grantPermissions(AuthUtil.toGroupEntry((String)BasePermissionsIT.GROUP_SYSTEM_ACCESS), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.CREATE);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        this.verifyAllowed(this.createTable("STATS_ENABLED.DELETE_TABLE_IT", 100), this.regularUser1);
        this.verifyAllowed(this.createIndex("DELETE_TABLE_IT_IDX1", "STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        this.verifyAllowed(this.createLocalIndex("DELETE_TABLE_IT_LIDX1", "STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        this.verifyAllowed(this.createView("STATS_ENABLED.DELETE_TABLE_IT_V1", "STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        this.verifyAllowed(this.createIndex("DELETE_TABLE_IT_VIDX1", "STATS_ENABLED.DELETE_TABLE_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.updateStatsOnTable("STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        Thread.sleep(10000L);
        this.verifyDenied(this.deleteDataFromStatsTable(), AccessDeniedException.class, this.regularUser1);
        this.verifyAllowed(this.dropIndex("DELETE_TABLE_IT_VIDX1", "STATS_ENABLED.DELETE_TABLE_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.dropView("STATS_ENABLED.DELETE_TABLE_IT_V1"), this.regularUser1);
        this.verifyAllowed(this.dropIndex("DELETE_TABLE_IT_IDX1", "STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        Thread.sleep(3000L);
        this.verifyAllowed(this.readStatsAfterTableDelete(SchemaUtil.getPhysicalHBaseTableName((String)"STATS_ENABLED", (String)"DELETE_TABLE_IT_IDX1", (boolean)this.isNamespaceMapped).getString()), this.regularUser1);
        this.verifyAllowed(this.dropIndex("DELETE_TABLE_IT_LIDX1", "STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        this.verifyAllowed(this.dropTable("STATS_ENABLED.DELETE_TABLE_IT"), this.regularUser1);
        Thread.sleep(3000L);
        this.verifyAllowed(this.readStatsAfterTableDelete(SchemaUtil.getPhysicalHBaseTableName((String)"STATS_ENABLED", (String)"DELETE_TABLE_IT", (boolean)this.isNamespaceMapped).getString()), this.regularUser1);
    }

    @Test
    public void testUpsertIntoImmutableTable() throws Throwable {
        final String schema = BasePermissionsIT.generateUniqueName();
        String tableName = BasePermissionsIT.generateUniqueName();
        final String phoenixTableName = schema + "." + tableName;
        this.grantSystemTableAccess();
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    BasePermissionsIT.this.verifyAllowed(BasePermissionsIT.this.createSchema(schema), superUser1);
                    BasePermissionsIT.this.verifyAllowed(BasePermissionsIT.this.onlyCreateImmutableTable(phoenixTableName), superUser1);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        if (this.isNamespaceMapped) {
            this.grantPermissions(this.unprivilegedUser.getShortName(), schema, Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
        } else {
            this.grantPermissions(this.unprivilegedUser.getShortName(), NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
        }
        this.verifyAllowed(this.upsertRowsIntoTable(phoenixTableName), this.unprivilegedUser);
        this.verifyAllowed(this.readTable(phoenixTableName), this.unprivilegedUser);
    }

    AccessTestAction onlyCreateImmutableTable(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    Assert.assertFalse((boolean)stmt.execute("CREATE IMMUTABLE TABLE " + tableName + "(pk INTEGER not null primary key, data VARCHAR, val integer)"));
                }
                return null;
            }
        };
    }

    AccessTestAction upsertRowsIntoTable(final String tableName) throws SQLException {
        return new AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (java.sql.Connection conn = BasePermissionsIT.this.getConnection();){
                    try (PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values(?, ?, ?)");){
                        for (int i = 0; i < 5; ++i) {
                            pstmt.setInt(1, i);
                            pstmt.setString(2, Integer.toString(i));
                            pstmt.setInt(3, i);
                            Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                        }
                    }
                    conn.commit();
                }
                return null;
            }
        };
    }

    private static List<AccessController> getAccessControllers(MiniHBaseCluster cluster) {
        ArrayList result = Lists.newArrayList();
        for (JVMClusterUtil.RegionServerThread t : cluster.getLiveRegionServerThreads()) {
            for (HRegion region : t.getRegionServer().getOnlineRegionsLocalContext()) {
                Coprocessor cp = region.getCoprocessorHost().findCoprocessor(AccessController.class.getName());
                if (cp == null) continue;
                result.add((AccessController)cp);
            }
        }
        return result;
    }

    private static Map<AccessController, Long> getAuthManagerMTimes(MiniHBaseCluster cluster) {
        HashMap result = Maps.newHashMap();
        for (AccessController ac : BasePermissionsIT.getAccessControllers(cluster)) {
            result.put(ac, ac.getAuthManager().getMTime());
        }
        return result;
    }

    public static void updateACLs(final HBaseTestingUtility util, Callable c) throws Exception {
        final Map<AccessController, Long> oldMTimes = BasePermissionsIT.getAuthManagerMTimes(util.getHBaseCluster());
        c.call();
        util.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() {
                Map<AccessController, Long> mtimes = BasePermissionsIT.getAuthManagerMTimes(util.getHBaseCluster());
                for (Map.Entry<AccessController, Long> e : mtimes.entrySet()) {
                    if (!oldMTimes.containsKey(e.getKey())) {
                        LOGGER.error("Snapshot of AccessController state does not include instance on region " + e.getKey().getRegion().getRegionInfo().getRegionNameAsString());
                        return false;
                    }
                    long old = (Long)oldMTimes.get(e.getKey());
                    long now = e.getValue();
                    if (now > old) continue;
                    LOGGER.info("AccessController on region " + e.getKey().getRegion().getRegionInfo().getRegionNameAsString() + " has not updated: mtime=" + now);
                    return false;
                }
                return true;
            }
        });
    }

    static {
        PHOENIX_SYSTEM_TABLES = new HashSet<String>(Arrays.asList("SYSTEM.CATALOG", "SYSTEM.SEQUENCE", "SYSTEM.STATS", "SYSTEM.FUNCTION", "SYSTEM.MUTEX", "SYSTEM.CHILD_LINK", "SYSTEM.TRANSFORM", "SYSTEM.CDC_STREAM_STATUS", "SYSTEM.CDC_STREAM"));
        PHOENIX_SYSTEM_TABLES_IDENTIFIERS = new HashSet<String>(Arrays.asList("SYSTEM.\"CATALOG\"", SYSTEM_SEQUENCE_IDENTIFIER, "SYSTEM.\"STATS\"", "SYSTEM.\"FUNCTION\"", SYSTEM_MUTEX_IDENTIFIER, "SYSTEM.\"CHILD_LINK\"", "SYSTEM.\"TRANSFORM\""));
        PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES = new HashSet<String>(Arrays.asList("SYSTEM:CATALOG", "SYSTEM:SEQUENCE", "SYSTEM:STATS", "SYSTEM:FUNCTION", "SYSTEM:MUTEX", "SYSTEM:CHILD_LINK", "SYSTEM:TRANSFORM", "SYSTEM:CDC_STREAM_STATUS", "SYSTEM:CDC_STREAM"));
        superUser1 = null;
        superUser2 = null;
    }

    public static class CustomAccessController
    extends AccessController {
        Configuration configuration;
        boolean aclRegion;

        public void start(CoprocessorEnvironment env) throws IOException {
            super.start(env);
            this.configuration = env.getConfiguration();
            if (env instanceof RegionCoprocessorEnvironment) {
                this.aclRegion = AccessControlClient.ACL_TABLE_NAME.equals((Object)((RegionCoprocessorEnvironment)env).getRegion().getTableDescriptor().getTableName());
            }
        }

        public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
            Connection connection;
            if (this.aclRegion) {
                super.getUserPermissions(controller, request, done);
                return;
            }
            AccessControlProtos.GetUserPermissionsResponse response = null;
            try {
                connection = ConnectionFactory.createConnection((Configuration)this.configuration);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new IOException(e));
                return;
            }
            try {
                ArrayList perms = new ArrayList();
                if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                    TableName table = request.hasTableName() ? ProtobufUtil.toTableName((TableProtos.TableName)request.getTableName()) : null;
                    perms.addAll(AccessControlClient.getUserPermissions((Connection)connection, (String)table.getNameAsString()));
                } else if (request.getType() == AccessControlProtos.Permission.Type.Namespace) {
                    String namespace = request.hasNamespaceName() ? request.getNamespaceName().toStringUtf8() : null;
                    perms.addAll(AccessControlClient.getUserPermissions((Connection)connection, (String)AuthUtil.toGroupEntry((String)namespace)));
                }
                response = AccessControlUtil.buildGetUserPermissionsResponse(perms);
            }
            catch (Throwable ioe) {
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new IOException(ioe));
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            done.run(response);
        }
    }

    static interface AccessTestAction
    extends PrivilegedExceptionAction<Object> {
    }
}

