/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseOrderByWithRegionMovesIT
extends ParallelStatsDisabledWithRegionMovesIT {
    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @Test
    public void testMultiOrderByExpr() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tenantId = BaseOrderByWithRegionMovesIT.getOrganizationId();
        String tableName = BaseOrderByWithRegionMovesIT.initATableValues(tenantId, BaseOrderByWithRegionMovesIT.getDefaultSplits(tenantId), BaseOrderByWithRegionMovesIT.getUrl());
        TABLE_NAMES.add(tableName);
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "B_STRING"})).setFullTableName(tableName).setOrderByClause("B_STRING, ENTITY_ID");
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDescMultiOrderByExpr() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tenantId = BaseOrderByWithRegionMovesIT.getOrganizationId();
        String tableName = BaseOrderByWithRegionMovesIT.initATableValues(tenantId, null, BaseOrderByWithRegionMovesIT.getUrl());
        TABLE_NAMES.add(tableName);
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "B_STRING"})).setFullTableName(tableName).setOrderByClause("B_STRING || ENTITY_ID DESC");
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDescMultiOrderByExprWithSplits() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tenantId = BaseOrderByWithRegionMovesIT.getOrganizationId();
        String tableName = BaseOrderByWithRegionMovesIT.initATableValues(tenantId, BaseOrderByWithRegionMovesIT.getDefaultSplits(tenantId), BaseOrderByWithRegionMovesIT.getUrl());
        TABLE_NAMES.add(tableName);
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "B_STRING"})).setFullTableName(tableName).setOrderByClause("B_STRING || ENTITY_ID DESC");
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testOrderByDifferentColumns() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(tableName);
            String ddl = "CREATE TABLE " + tableName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string))\n";
            BaseOrderByWithRegionMovesIT.createTestTable(BaseOrderByWithRegionMovesIT.getUrl(), ddl);
            String dml = "UPSERT INTO " + tableName + " VALUES(?, ?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "a");
            stmt.setInt(2, 40);
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setInt(2, 20);
            stmt.execute();
            stmt.setString(1, "c");
            stmt.setInt(2, 30);
            stmt.execute();
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"COL1"})).setFullTableName(tableName).setSelectExpression("count(*)").setGroupByClause("COL1").setOrderByClause("COL1");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder = new QueryBuilder();
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_STRING", "COL1"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setOrderByClause("A_STRING");
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_STRING", "COL1"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setOrderByClause("COL1");
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAggregateOrderBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);
        String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        String ddl = "create table " + tableName + " (ID VARCHAR NOT NULL PRIMARY KEY, VAL1 VARCHAR, VAL2 INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("upsert into " + tableName + " values ('ABC','aa123', 11)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABD','ba124', 1)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABE','cf125', 13)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABF','dan126', 4)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABG','elf127', 15)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABH','fan128', 6)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAA','get211', 100)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAB','hat212', 7)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAC','aap12', 2)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAD','ball12', 3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAE','inn2110', 13)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAF','key2112', 40)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2"})).setFullTableName(tableName).setOrderByClause("VAL1").setSelectExpression("DISTINCT(ID)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"ID"})).setWhereClause("ID in ('ABC','ABD','ABE','ABF','ABG','ABH','AAA', 'AAB', 'AAC','AAD','AAE','AAF')");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"ABC", (Object)rs.getString(1));
        Assert.assertEquals((Object)"aa123", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"aap12", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ba124", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ball12", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"cf125", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"dan126", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"elf127", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"fan128", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"get211", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hat212", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"inn2110", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"AAF", (Object)rs.getString(1));
        Assert.assertEquals((Object)"key2112", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testAggregateOptimizedOutOrderBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);
        String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        String ddl = "create table " + tableName + " (K1 VARCHAR NOT NULL, K2 VARCHAR NOT NULL, VAL1 VARCHAR, VAL2 INTEGER, CONSTRAINT pk PRIMARY KEY(K1,K2))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("upsert into " + tableName + " values ('ABC','ABC','aa123', 11)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABD','ABC','ba124', 1)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABE','ABC','cf125', 13)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABF','ABC','dan126', 4)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABG','ABC','elf127', 15)");
        conn.createStatement().execute("upsert into " + tableName + " values ('ABH','ABC','fan128', 6)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAA','ABC','get211', 100)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAB','ABC','hat212', 7)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAC','ABC','aap12', 2)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAD','ABC','ball12', 3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAE','ABC','inn2110', 13)");
        conn.createStatement().execute("upsert into " + tableName + " values ('AAF','ABC','key2112', 40)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2"})).setFullTableName(tableName).setOrderByClause("VAL1").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K2"})).setSelectExpression("DISTINCT(K2)").setWhereClause("K2 = 'ABC'");
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY K2 = 'ABC'", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO DISTINCT ROWS BY [K2, VAL1, VAL2]", (Object)explainPlanAttributes.getServerAggregate());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        Assert.assertNull((Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertNull((Object)explainPlanAttributes.getServerSortedBy());
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"ABC", (Object)rs.getString(1));
        Assert.assertEquals((Object)"aa123", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"aap12", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ba124", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ball12", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"cf125", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"dan126", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"elf127", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"fan128", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"get211", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hat212", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"inn2110", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        BaseOrderByWithRegionMovesIT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"ABC", (Object)rs.getString(1));
        Assert.assertEquals((Object)"key2112", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNullsLastWithDesc() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(tableName);
            String sql = "CREATE TABLE " + tableName + " ( ORGANIZATION_ID VARCHAR,CONTAINER_ID VARCHAR,ENTITY_ID VARCHAR NOT NULL,CONSTRAINT TEST_PK PRIMARY KEY ( ORGANIZATION_ID DESC,CONTAINER_ID DESC,ENTITY_ID))";
            conn.createStatement().execute(sql);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('a',null,'11')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,'2','22')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('c','3','33')");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"CONTAINER_ID", "ORGANIZATION_ID"})).setFullTableName(tableName).setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"2", null}, {null, "a"}, {"3", "c"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}}, tableName);
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}}, tableName);
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}});
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,null,'44')");
            conn.commit();
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{null, null}, {"2", null}, {null, "a"}, {"3", "c"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"2", null}, {null, null}, {null, "a"}, {"3", "c"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{null, "a"}, {"3", "c"}, {null, null}, {"2", null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"3", "c"}, {null, "a"}, {null, null}, {"2", null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}, {null, null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS FIRST,ORGANIZATION_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS FIRST,ORGANIZATION_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS LAST,ORGANIZATION_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"2", null}, {"3", "c"}, {null, null}, {null, "a"}}, tableName);
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS LAST,ORGANIZATION_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{null, "a"}, {null, null}, {"2", null}, {"3", "c"}}, tableName);
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}, {null, null}}, tableName);
        }
    }

    @Test
    public void testOrderByReverseOptimization1() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimization(salted, true, true, true);
            this.doTestOrderByReverseOptimization(salted, true, true, false);
            this.doTestOrderByReverseOptimization(salted, true, false, true);
            this.doTestOrderByReverseOptimization(salted, true, false, false);
        }
    }

    @Test
    public void testOrderByReverseOptimization2() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimization(salted, false, true, true);
            this.doTestOrderByReverseOptimization(salted, false, true, false);
            this.doTestOrderByReverseOptimization(salted, false, false, true);
            this.doTestOrderByReverseOptimization(salted, false, false, false);
        }
    }

    private void doTestOrderByReverseOptimization(boolean salted, boolean desc1, boolean desc2, boolean desc3) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(tableName);
            String sql = "CREATE TABLE " + tableName + " ( ORGANIZATION_ID INTEGER NOT NULL,CONTAINER_ID INTEGER NOT NULL,SCORE INTEGER NOT NULL,ENTITY_ID INTEGER NOT NULL,CONSTRAINT TEST_PK PRIMARY KEY ( ORGANIZATION_ID" + (desc1 ? " DESC" : "") + ",CONTAINER_ID" + (desc2 ? " DESC" : "") + ",SCORE" + (desc3 ? " DESC" : "") + ",ENTITY_ID)) " + (salted ? "SALT_BUCKETS =4" : "split on(4)");
            conn.createStatement().execute(sql);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,1,1,1)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,2,2,2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3,3,3,3)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (4,4,4,4)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (5,5,5,5)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (6,6,6,6)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,1,1,11)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,2,2,22)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3,3,3,33)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (4,4,4,44)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (5,5,5,55)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (6,6,6,66)");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"CONTAINER_ID", "ORGANIZATION_ID"})).setFullTableName(tableName).setGroupByClause("ORGANIZATION_ID, CONTAINER_ID").setOrderByClause("ORGANIZATION_ID ASC, CONTAINER_ID ASC");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}, {5, 5}, {6, 6}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC, CONTAINER_ID DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}, {5, 5}, {6, 6}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC, CONTAINER_ID ASC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{6, 6}, {5, 5}, {4, 4}, {3, 3}, {2, 2}, {1, 1}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC, CONTAINER_ID DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{6, 6}, {5, 5}, {4, 4}, {3, 3}, {2, 2}, {1, 1}});
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ORGANIZATION_ID", "SCORE"}));
            queryBuilder.setGroupByClause("ORGANIZATION_ID, SCORE");
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC, SCORE ASC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}, {5, 5}, {6, 6}});
            queryBuilder.setGroupByClause("ORGANIZATION_ID, SCORE");
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC, SCORE DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}, {5, 5}, {6, 6}});
            queryBuilder.setGroupByClause("ORGANIZATION_ID, SCORE");
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC, SCORE ASC");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{6, 6}, {5, 5}, {4, 4}, {3, 3}, {2, 2}, {1, 1}}, tableName);
            queryBuilder.setGroupByClause("ORGANIZATION_ID, SCORE");
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC, SCORE DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{6, 6}, {5, 5}, {4, 4}, {3, 3}, {2, 2}, {1, 1}});
        }
    }

    @Test
    public void testOrderByReverseOptimizationWithNullsLast1() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, true, true, true);
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, true, true, false);
        }
    }

    @Test
    public void testOrderByReverseOptimizationWithNullsLast2() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, true, false, true);
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, true, false, false);
        }
    }

    @Test
    public void testOrderByReverseOptimizationWithNullsLast3() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, false, true, true);
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, false, true, false);
        }
    }

    @Test
    public void testOrderByReverseOptimizationWithNullsLast4() throws Exception {
        for (boolean salted : new boolean[]{true, false}) {
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, false, false, true);
            this.doTestOrderByReverseOptimizationWithNullsLast(salted, false, false, false);
        }
    }

    private void doTestOrderByReverseOptimizationWithNullsLast(boolean salted, boolean desc1, boolean desc2, boolean desc3) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            String tableName = BaseOrderByWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(tableName);
            String sql = "CREATE TABLE " + tableName + " ( ORGANIZATION_ID VARCHAR,CONTAINER_ID VARCHAR,SCORE VARCHAR,ENTITY_ID VARCHAR NOT NULL,CONSTRAINT TEST_PK PRIMARY KEY ( ORGANIZATION_ID" + (desc1 ? " DESC" : "") + ",CONTAINER_ID" + (desc2 ? " DESC" : "") + ",SCORE" + (desc3 ? " DESC" : "") + ",ENTITY_ID)) " + (salted ? "SALT_BUCKETS =4" : "split on('4')");
            conn.createStatement().execute(sql);
            for (int i = 1; i <= 6; ++i) {
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,'" + i + "','" + i + "','" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,'" + i + "',null,'" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,null,'" + i + "','" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,null,null,'" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + i + "','" + i + "','" + i + "','" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + i + "','" + i + "',null,'" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + i + "',null,'" + i + "','" + i + "')");
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('" + i + "',null,null,'" + i + "')");
            }
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,null,null,'66')");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ORGANIZATION_ID", "CONTAINER_ID"})).setFullTableName(tableName).setGroupByClause("ORGANIZATION_ID, CONTAINER_ID").setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, CONTAINER_ID ASC NULLS FIRST");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}, {"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}, {"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}, {"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}, {null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, CONTAINER_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}, {"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, CONTAINER_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}, {null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}, {"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}, {null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}});
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ORGANIZATION_ID", "SCORE"})).setFullTableName(tableName).setGroupByClause("ORGANIZATION_ID, SCORE").setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, SCORE ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, SCORE ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}, {"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, SCORE ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}, {null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, SCORE ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, SCORE DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST, SCORE DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}, {"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, SCORE DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", null}, {"1", "1"}, {"2", null}, {"2", "2"}, {"3", null}, {"3", "3"}, {"4", null}, {"4", "4"}, {"5", null}, {"5", "5"}, {"6", null}, {"6", "6"}, {null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST, SCORE DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"1", "1"}, {"1", null}, {"2", "2"}, {"2", null}, {"3", "3"}, {"3", null}, {"4", "4"}, {"4", null}, {"5", "5"}, {"5", null}, {"6", "6"}, {"6", null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, SCORE ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, SCORE ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}, {"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}}, tableName);
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, SCORE ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}, {null, null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, SCORE ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "5"}, {null, "6"}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, SCORE DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST, SCORE DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}, {"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, SCORE DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", null}, {"6", "6"}, {"5", null}, {"5", "5"}, {"4", null}, {"4", "4"}, {"3", null}, {"3", "3"}, {"2", null}, {"2", "2"}, {"1", null}, {"1", "1"}, {null, null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST, SCORE DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6", "6"}, {"6", null}, {"5", "5"}, {"5", null}, {"4", "4"}, {"4", null}, {"3", "3"}, {"3", null}, {"2", "2"}, {"2", null}, {"1", "1"}, {"1", null}, {null, "6"}, {null, "5"}, {null, "4"}, {null, "3"}, {null, "2"}, {null, "1"}, {null, null}});
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"SCORE"})).setFullTableName(tableName).setGroupByClause("SCORE").setOrderByClause("SCORE ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null}, {"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}});
            queryBuilder.setOrderByClause("SCORE ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            BaseOrderByWithRegionMovesIT.assertResultSetWithRegionMoves(rs, new Object[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {null}}, tableName);
            queryBuilder.setOrderByClause("SCORE DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{null}, {"6"}, {"5"}, {"4"}, {"3"}, {"2"}, {"1"}});
            queryBuilder.setOrderByClause("SCORE DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{"6"}, {"5"}, {"4"}, {"3"}, {"2"}, {"1"}, {null}});
        }
    }

    @Test
    public void testOrderByNullable() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);){
            String sql = "CREATE TABLE IF NOT EXISTS us_population (state CHAR(2) NOT NULL,city VARCHAR NOT NULL, population BIGINT CONSTRAINT my_pk PRIMARY KEY (state, city))";
            conn.createStatement().execute(sql);
            TABLE_NAMES.add("US_POPULATION");
            sql = "select ORDINAL_POSITION from SYSTEM.CATALOG where TABLE_NAME = 'US_POPULATION'";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            int expected = 0;
            while (rs.next()) {
                ++expected;
            }
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"*"})).setFullTableName("SYSTEM.CATALOG").setWhereClause("TABLE_NAME = 'US_POPULATION'").setOrderByClause("ORDINAL_POSITION");
            rs = this.executeQuery(conn, queryBuilder);
            int linesCount = 0;
            while (rs.next()) {
                ++linesCount;
            }
            Assert.assertEquals((long)expected, (long)linesCount);
            queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"COLUMN_NAME"})).setFullTableName("SYSTEM.CATALOG").setWhereClause("TABLE_NAME = 'US_POPULATION'").setOrderByClause("ORDINAL_POSITION");
            rs = this.executeQuery(conn, queryBuilder);
            linesCount = 0;
            while (rs.next()) {
                ++linesCount;
            }
            Assert.assertEquals((long)expected, (long)linesCount);
        }
    }

    @Test
    public void testPhoenix6999() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseOrderByWithRegionMovesIT.generateUniqueName();
        String descTableName = "TBL_" + BaseOrderByWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullDescTableName = SchemaUtil.getTableName((String)"S", (String)descTableName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullDescTableName);
        try (Connection conn = DriverManager.getConnection(BaseOrderByWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(k1 varchar primary key, v1 varchar, v2 varchar)";
            stmt.execute(ddl);
            ddl = "CREATE TABLE " + fullDescTableName + "(k1 varchar primary key desc, v1 varchar, v2 varchar)";
            stmt.execute(ddl);
            stmt.execute("upsert into " + fullTableName + " values ('a','a','a')");
            stmt.execute("upsert into " + fullTableName + " values ('b','b','b')");
            stmt.execute("upsert into " + fullTableName + " values ('c','c','c')");
            stmt.execute("upsert into " + fullDescTableName + " values ('a','a','a')");
            stmt.execute("upsert into " + fullDescTableName + " values ('b','b','b')");
            stmt.execute("upsert into " + fullDescTableName + " values ('c','c','c')");
            conn.commit();
            String query = "SELECT  *  from " + fullTableName + " where k1='b' order by k1 asc";
            ResultSet rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            query = "SELECT  *  from " + fullTableName + " where k1='b' order by k1 desc";
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            query = "SELECT  *  from " + fullDescTableName + " where k1='b' order by k1 asc";
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            query = "SELECT  *  from " + fullDescTableName + " where k1='b' order by k1 desc";
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        }
    }
}

