/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseAggregateWithRegionMoves2IT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class BaseAggregateWithRegionMoves4IT
extends BaseAggregateWithRegionMoves2IT {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAggregateWithRegionMoves4IT.class);
    private static int countOfValidResults = 0;

    @Override
    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        countOfValidResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.valid.process", TestScanningResultPostValidResultCaller.class.getName());
        BaseAggregateWithRegionMoves4IT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    @Override
    @Test
    public void testAvgGroupByOrderPreservingWithNoStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves4IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves4IT.generateUniqueName();
        this.initAvgGroupTable(conn, tableName, "");
        this.testAvgGroupByOrderPreserving(conn, tableName, 5);
    }

    @Override
    @Test
    public void testSumGroupByOrderPreservingDescWithoutSplit() throws Exception {
        try {
            super.testSumGroupByOrderPreservingDescWithoutSplit();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.testSumGroupByOrderPreservingDescWithoutSplit();
        }
    }

    @Override
    @Test
    public void testGroupByOrderByDescBug3451() throws Exception {
        try {
            super.testGroupByOrderByDescBug3451();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.testGroupByOrderByDescBug3451();
        }
    }

    private static class TestScanningResultPostValidResultCaller
    extends ScanningResultPostValidResultCaller {
        private TestScanningResultPostValidResultCaller() {
        }

        public void postValidRowProcess() {
            if (ParallelStatsDisabledWithRegionMovesIT.hasTestStarted && countOfValidResults <= 1) {
                LOGGER.info("Splitting regions of tables {}. current count of valid results: {}", ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES, (Object)countOfValidResults);
                ++countOfValidResults;
                ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES.forEach(table -> {
                    try {
                        ParallelStatsDisabledWithRegionMovesIT.splitAllRegionsOfTable(table, 2);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

