/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseAggregateIT
extends ParallelStatsDisabledIT {
    private static void initData(Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("create table " + tableName + "   (id varchar not null primary key,\n    uri varchar, appcpu integer)");
        BaseAggregateIT.insertRow(conn, tableName, "Report1", 10, 1);
        BaseAggregateIT.insertRow(conn, tableName, "Report2", 10, 2);
        BaseAggregateIT.insertRow(conn, tableName, "Report3", 30, 3);
        BaseAggregateIT.insertRow(conn, tableName, "Report4", 30, 4);
        BaseAggregateIT.insertRow(conn, tableName, "SOQL1", 10, 5);
        BaseAggregateIT.insertRow(conn, tableName, "SOQL2", 10, 6);
        BaseAggregateIT.insertRow(conn, tableName, "SOQL3", 30, 7);
        BaseAggregateIT.insertRow(conn, tableName, "SOQL4", 30, 8);
        conn.commit();
    }

    private static void insertRow(Connection conn, String tableName, String uri, int appcpu, int id) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO " + tableName + "(id, uri, appcpu) values (?,?,?)");
        statement.setString(1, "id" + id);
        statement.setString(2, uri);
        statement.setInt(3, appcpu);
        statement.executeUpdate();
    }

    @Test
    public void testDuplicateTrailingAggExpr() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.force.rowkeyorder", Boolean.FALSE.toString());
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        conn.createStatement().execute("create table " + tableName + "   (nam VARCHAR(20), address VARCHAR(20), id BIGINT constraint my_pk primary key (id))");
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO " + tableName + "(nam, address, id) values (?,?,?)");
        statement.setString(1, "pulkit");
        statement.setString(2, "badaun");
        statement.setInt(3, 1);
        statement.executeUpdate();
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setDistinct(true).setSelectExpression("'harshit' as TEST_COLUMN, trim(NAM), trim(NAM)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"NAM"})).setFullTableName(tableName);
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"harshit", (Object)rs.getString(1));
        Assert.assertEquals((Object)"pulkit", (Object)rs.getString(2));
        Assert.assertEquals((Object)"pulkit", (Object)rs.getString(3));
        conn.close();
    }

    @Test
    public void testExpressionInGroupBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        String ddl = "create table " + tableName + "(tgb_id integer NOT NULL,utc_date_epoch integer NOT NULL,tgb_name varchar(40),ack_success_count integer,ack_success_one_ack_count integer, CONSTRAINT pk_tgb_counter PRIMARY KEY(tgb_id, utc_date_epoch))";
        BaseAggregateIT.createTestTable(BaseAggregateIT.getUrl(), ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES(?,?,?,?,?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setInt(1, 1);
        stmt.setInt(2, 1000);
        stmt.setString(3, "aaa");
        stmt.setInt(4, 1);
        stmt.setInt(5, 1);
        stmt.execute();
        stmt.setInt(1, 2);
        stmt.setInt(2, 2000);
        stmt.setString(3, "bbb");
        stmt.setInt(4, 2);
        stmt.setInt(5, 2);
        stmt.execute();
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("TGB_ID, TGB_NAME, (UTC_DATE_EPOCH/10)*10 AS UTC_EPOCH_HOUR,SUM(ACK_SUCCESS_COUNT + ACK_SUCCESS_ONE_ACK_COUNT) AS ACK_TX_SUM").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"TGB_ID", "TGB_NAME", "UTC_DATE_EPOCH", "ACK_SUCCESS_COUNT", "ACK_SUCCESS_ONE_ACK_COUNT"})).setGroupByClause("TGB_ID, TGB_NAME, UTC_EPOCH_HOUR").setFullTableName(tableName).setOrderByClause("TGB_ID, UTC_EPOCH_HOUR");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"aaa", (Object)rs.getString(2));
        Assert.assertEquals((double)1000.0, (double)rs.getDouble(3), (double)1.0E-6);
        Assert.assertEquals((long)2L, (long)rs.getLong(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"bbb", (Object)rs.getString(2));
        Assert.assertEquals((double)2000.0, (double)rs.getDouble(3), (double)1.0E-6);
        Assert.assertEquals((long)4L, (long)rs.getLong(4));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        conn.close();
    }

    @Test
    public void testBooleanInGroupBy() throws Exception {
        String[] gbs;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        String ddl = " create table " + tableName + "(id varchar primary key,v1 boolean, v2 integer, v3 integer)";
        BaseAggregateIT.createTestTable(BaseAggregateIT.getUrl(), ddl);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + "(id,v2,v3) VALUES(?,?,?)");
        stmt.setString(1, "a");
        stmt.setInt(2, 1);
        stmt.setInt(3, 1);
        stmt.execute();
        stmt.close();
        stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?,?)");
        stmt.setString(1, "b");
        stmt.setBoolean(2, false);
        stmt.setInt(3, 2);
        stmt.setInt(4, 2);
        stmt.execute();
        stmt.setString(1, "c");
        stmt.setBoolean(2, true);
        stmt.setInt(3, 3);
        stmt.setInt(4, 3);
        stmt.execute();
        conn.commit();
        for (String gb : gbs = new String[]{"V1,V2,V3", "V1,V3,V2", "V2,V1,V3"}) {
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"V1", "V2", "V3"})).setFullTableName(tableName).setGroupByClause(gb);
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("v1"));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)1L, (long)rs.getInt("v2"));
            Assert.assertEquals((long)1L, (long)rs.getInt("v3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("v1"));
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertEquals((long)2L, (long)rs.getInt("v2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("v3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)true, (Object)rs.getBoolean("v1"));
            Assert.assertEquals((long)3L, (long)rs.getInt("v2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("v3"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
        conn.close();
    }

    @Test
    public void testScanUri() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        BaseAggregateIT.initData(conn, tableName);
        Statement stmt = conn.createStatement();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"URI"})).setFullTableName(tableName);
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Report1", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Report2", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Report3", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Report4", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SOQL1", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SOQL2", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SOQL3", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SOQL4", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testCount() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        BaseAggregateIT.initData(conn, tableName);
        Statement stmt = conn.createStatement();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("count(1)").setFullTableName(tableName);
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)8L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testGroupByCase() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.force.rowkeyorder", Boolean.FALSE.toString());
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        BaseAggregateIT.initData(conn, tableName);
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("CASE WHEN URI LIKE 'REPORT%' THEN 'REPORTS' ELSE 'OTHER' END CATEGORY, AVG(APPCPU)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"URI", "APPCPU"})).setFullTableName(tableName).setGroupByClause("CATEGORY");
        this.executeQuery(conn, queryBuilder);
        queryBuilder.setSelectExpression("CASE URI WHEN 'REPORT%' THEN 'REPORTS' ELSE 'OTHER' END CATEGORY, AVG(APPCPU)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"URI", "APPCPU"})).setFullTableName(tableName).setGroupByClause("APPCPU, CATEGORY");
        this.executeQuery(conn, queryBuilder);
        queryBuilder.setSelectExpression("CASE URI WHEN 'Report%' THEN 'Reports' ELSE 'Other' END CATEGORY, AVG(APPCPU)").setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"URI", "APPCPU"})).setFullTableName(tableName).setGroupByClause("AVG(APPCPU), CATEGORY");
        this.executeQueryThrowsException(conn, queryBuilder, "Aggregate expressions may not be used in GROUP BY", "");
        conn.close();
    }

    @Test
    public void testGroupByArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(\n  a VARCHAR NOT NULL,\n  b VARCHAR,\n  c INTEGER,\n  d VARCHAR,\n  e VARCHAR ARRAY,\n  f BIGINT,\n  g BIGINT,\n  CONSTRAINT pk PRIMARY KEY(a)\n)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('1', 'val', 100, 'a', ARRAY ['b'], 1, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('2', 'val', 100, 'a', ARRAY ['b'], 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('3', 'val', 100, 'a', ARRAY ['b','c'], 5, 6)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("C, SUM(F + G) AS SUMONE, D, E").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"A", "B", "C", "F", "G", "D", "E"})).setWhereClause("B = 'val' AND A IN ('1','2','3')").setFullTableName(tableName).setGroupByClause("C, D, E").setOrderByClause("SUMONE desc");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertEquals((long)11L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testGroupByOrderPreserving() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.force.rowkeyorder", Boolean.FALSE.toString());
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(ORGANIZATION_ID char(15) not null, \nJOURNEY_ID char(15) not null, \nDATASOURCE SMALLINT not null, \nMATCH_STATUS TINYINT not null, \nEXTERNAL_DATASOURCE_KEY varchar(30), \nENTITY_ID char(15) not null, \nCONSTRAINT PK PRIMARY KEY (\n    ORGANIZATION_ID, \n    JOURNEY_ID, \n    DATASOURCE, \n    MATCH_STATUS,\n    EXTERNAL_DATASOURCE_KEY,\n    ENTITY_ID))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abc', '666667777788888')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abcd', '666667777788889')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abc', '666667777788899')");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("COUNT(1), EXTERNAL_DATASOURCE_KEY As DUP_COUNT").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"EXTERNAL_DATASOURCE_KEY", "MATCH_STATUS", "JOURNEY_ID", "DATASOURCE", "ORGANIZATION_ID"})).setWhereClause("JOURNEY_ID='333334444455555' AND DATASOURCE=0 AND MATCH_STATUS <= 1 and ORGANIZATION_ID='000001111122222'").setFullTableName(tableName).setGroupByClause("MATCH_STATUS, EXTERNAL_DATASOURCE_KEY").setHavingClause("COUNT(1) > 1");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" ['000001111122222','333334444455555',0,*] - ['000001111122222','333334444455555',0,1]", (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [MATCH_STATUS, EXTERNAL_DATASOURCE_KEY]", (Object)explainPlanAttributes.getServerAggregate());
        Assert.assertEquals((Object)"COUNT(1) > 1", (Object)explainPlanAttributes.getClientFilterBy());
    }

    @Test
    public void testGroupByOrderPreservingDescSort() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 char(1) not null, constraint pk primary key (k1,k2)) split on ('ac','jc','nc')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'd')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'd')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'd')");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,COUNT(*)").setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"K1"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 DESC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
        Assert.assertFalse((String)"Explain plan regionLocation attribute should not be empty", (boolean)explainPlanAttributes.getRegionLocations().isEmpty());
    }

    @Test
    public void testSumGroupByOrderPreservingDesc() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2)) split on (?,?,?)");
        stmt.setBytes(1, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(2, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"j"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(3, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"n"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 4)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,SUM(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 DESC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
        Assert.assertFalse((String)"Explain plan regionLocation attribute should not be empty", (boolean)explainPlanAttributes.getRegionLocations().isEmpty());
    }

    @Test
    public void testAvgGroupByOrderPreservingWithNoStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
        String tableName = BaseAggregateIT.generateUniqueName();
        this.initAvgGroupTable(conn, tableName, "");
        this.testAvgGroupByOrderPreserving(conn, tableName, 4);
    }

    protected void initAvgGroupTable(Connection conn, String tableName, String tableProps) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2)) " + tableProps + " split on (?,?,?)");
        stmt.setBytes(1, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(2, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"j"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(3, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"n"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 6)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 10)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.commit();
    }

    protected void testAvgGroupByOrderPreserving(Connection conn, String tableName, int nGuidePosts) throws SQLException, IOException {
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1, AVG(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((double)3.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((double)5.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((double)4.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((double)2.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
        TestUtil.analyzeTable(conn, tableName);
        List<KeyRange> splits = TestUtil.getAllSplits(conn, tableName);
        Assert.assertEquals((long)4L, (long)splits.size());
        Assert.assertFalse((String)"Explain plan regionLocation attribute should not be empty", (boolean)explainPlanAttributes.getRegionLocations().isEmpty());
    }

    @Test
    public void testDistinctGroupByBug3452WithoutMultiTenant() throws Exception {
        this.doTestDistinctGroupByBug3452("");
    }

    @Test
    public void testDistinctGroupByBug3452WithMultiTenant() throws Exception {
        this.doTestDistinctGroupByBug3452("VERSIONS=1, MULTI_TENANT=TRUE, REPLICATION_SCOPE=1, TTL=31536000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestDistinctGroupByBug3452(String options) throws Exception {
        try (Connection conn = null;){
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
            String tableName = BaseAggregateIT.generateUniqueName();
            conn.createStatement().execute("DROP TABLE if exists " + tableName);
            String sql = "CREATE TABLE " + tableName + " ( ORGANIZATION_ID CHAR(15) NOT NULL,CONTAINER_ID CHAR(15) NOT NULL,ENTITY_ID CHAR(15) NOT NULL,SCORE DOUBLE,CONSTRAINT TEST_PK PRIMARY KEY ( ORGANIZATION_ID,CONTAINER_ID,ENTITY_ID)) " + options;
            conn.createStatement().execute(sql);
            String indexTableName = BaseAggregateIT.generateUniqueName();
            conn.createStatement().execute("DROP INDEX IF EXISTS " + indexTableName + " ON " + tableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + tableName + " (CONTAINER_ID, SCORE DESC, ENTITY_ID DESC)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId6',1.1)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId5',1.2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId4',1.3)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId3',1.4)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId2',1.5)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org1','container1','entityId1',1.6)");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setDistinct(true).setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "SCORE", "ORGANIZATION_ID", "CONTAINER_ID"})).setFullTableName(tableName).setWhereClause("ORGANIZATION_ID = 'org1' AND CONTAINER_ID = 'container1'").setOrderByClause("SCORE DESC");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId1"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.6, (double)1.0E-4);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId2"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.5, (double)1.0E-4);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId3"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.4, (double)1.0E-4);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId4"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.3, (double)1.0E-4);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId5"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.2, (double)1.0E-4);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).equals("entityId6"));
            Assert.assertEquals((double)rs.getDouble(2), (double)1.1, (double)1.0E-4);
            Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGroupByOrderByDescBug3451() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);){
            String tableName = BaseAggregateIT.generateUniqueName();
            String sql = "CREATE TABLE " + tableName + " (\n            ORGANIZATION_ID CHAR(15) NOT NULL,\n            CONTAINER_ID CHAR(15) NOT NULL,\n            ENTITY_ID CHAR(15) NOT NULL,\n            SCORE DOUBLE,\n            CONSTRAINT TEST_PK PRIMARY KEY (\n               ORGANIZATION_ID,\n               CONTAINER_ID,\n               ENTITY_ID\n             )\n         )";
            conn.createStatement().execute(sql);
            String indexName = BaseAggregateIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(ORGANIZATION_ID,CONTAINER_ID, SCORE DESC, ENTITY_ID DESC)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container2','entityId6',1.1)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId5',1.2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container2','entityId4',1.3)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId5',1.2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId3',1.4)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container3','entityId7',1.35)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container3','entityId8',1.45)");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setDistinct(true).setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "SCORE", "ORGANIZATION_ID", "CONTAINER_ID"})).setFullTableName(tableName).setWhereClause("ORGANIZATION_ID = 'org2' AND CONTAINER_ID IN ('container1','container2','container3')").setOrderByClause("SCORE DESC").setLimit(2);
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entityId8", (Object)rs.getString(1));
            Assert.assertEquals((double)1.45, (double)rs.getDouble(2), (double)0.001);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entityId3", (Object)rs.getString(1));
            Assert.assertEquals((double)1.4, (double)rs.getDouble(2), (double)0.001);
            Assert.assertFalse((boolean)rs.next());
            String expectedPhoenixPlan = "";
            BaseAggregateIT.validateQueryPlan(conn, queryBuilder, expectedPhoenixPlan, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByDescColumnWithNullsLastBug3452() throws Exception {
        try (Connection conn = null;){
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
            String tableName = BaseAggregateIT.generateUniqueName();
            String sql = "CREATE TABLE " + tableName + " ( ORGANIZATION_ID VARCHAR,CONTAINER_ID VARCHAR,ENTITY_ID VARCHAR NOT NULL,CONSTRAINT TEST_PK PRIMARY KEY ( ORGANIZATION_ID DESC,CONTAINER_ID DESC,ENTITY_ID))";
            conn.createStatement().execute(sql);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('a',null,'11')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,'2','22')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('c','3','33')");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"CONTAINER_ID", "ORGANIZATION_ID"})).setFullTableName(tableName).setGroupByClause("ORGANIZATION_ID, CONTAINER_ID").setOrderByClause("ORGANIZATION_ID ASC NULLS FIRST");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}});
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,null,'44')");
            conn.commit();
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS FIRST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {null, "a"}, {"3", "c"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID NULLS LAST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {"3", "c"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {"2", null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS FIRST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {null, null}, {"3", "c"}, {null, "a"}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {null, null}, {"2", null}});
            queryBuilder.setOrderByClause("ORGANIZATION_ID DESC NULLS LAST,CONTAINER_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {null, "a"}, {"2", null}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS FIRST,ORGANIZATION_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS FIRST,ORGANIZATION_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS LAST,ORGANIZATION_ID NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID NULLS LAST,ORGANIZATION_ID NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS FIRST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"2", null}, {"3", "c"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID ASC NULLS LAST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"2", null}, {"3", "c"}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID ASC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID ASC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}, {null, null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, null}, {null, "a"}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS FIRST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{null, "a"}, {null, null}, {"3", "c"}, {"2", null}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID DESC NULLS FIRST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, null}, {null, "a"}});
            queryBuilder.setOrderByClause("CONTAINER_ID DESC NULLS LAST,ORGANIZATION_ID DESC NULLS LAST");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new String[][]{{"3", "c"}, {"2", null}, {null, "a"}, {null, null}});
        }
    }

    @Test
    public void testCountNullInEncodedNonEmptyKeyValueCF() throws Exception {
        this.testCountNullInNonEmptyKeyValueCF(1);
    }

    @Test
    public void testCountNullInNonEncodedNonEmptyKeyValueCF() throws Exception {
        this.testCountNullInNonEmptyKeyValueCF(0);
    }

    protected abstract void testCountNullInNonEmptyKeyValueCF(int var1) throws Exception;

    @Test
    public void testGroupByOrderMatchPkColumnOrderBug4690() throws Exception {
        this.doTestGroupByOrderMatchPkColumnOrderBug4690(false, false);
        this.doTestGroupByOrderMatchPkColumnOrderBug4690(false, true);
        this.doTestGroupByOrderMatchPkColumnOrderBug4690(true, false);
        this.doTestGroupByOrderMatchPkColumnOrderBug4690(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestGroupByOrderMatchPkColumnOrderBug4690(boolean desc, boolean salted) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = null;){
            conn = DriverManager.getConnection(BaseAggregateIT.getUrl(), props);
            String tableName = BaseAggregateIT.generateUniqueName();
            String sql = "create table " + tableName + "(  pk1 integer not null ,  pk2 integer not null,  pk3 integer not null, pk4 integer not null, v integer,  CONSTRAINT TEST_PK PRIMARY KEY ( pk1 " + (desc ? "desc" : "") + ", pk2 " + (desc ? "desc" : "") + ", pk3 " + (desc ? "desc" : "") + ", pk4 " + (desc ? "desc" : "") + " )) " + (salted ? "SALT_BUCKETS =4" : "split on(2)");
            conn.createStatement().execute(sql);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,8,10,20,30)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,8,11,21,31)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,9,5 ,22,32)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,9,6 ,12,33)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,9,6 ,13,34)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,9,7 ,8,35)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,3,15,25,35)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,7,16,26,36)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,7,17,27,37)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3,2,18,28,38)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3,2,19,29,39)");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("PK2,PK1,COUNT(V)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "V"})).setFullTableName(tableName).setGroupByClause("PK2, PK1").setOrderByClause("PK2, PK1");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{2, 3, 2L}, {3, 2, 1L}, {7, 2, 2L}, {8, 1, 2L}, {9, 1, 4L}});
            queryBuilder.setSelectExpression("PK1, PK2, COUNT(V)");
            queryBuilder.setOrderByClause("PK1, PK2");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 8, 2L}, {1, 9, 4L}, {2, 3, 1L}, {2, 7, 2L}, {3, 2, 2L}});
            queryBuilder.setSelectExpression("PK2,PK1,COUNT(V)");
            queryBuilder.setOrderByClause("PK2 DESC,PK1 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{9, 1, 4L}, {8, 1, 2L}, {7, 2, 2L}, {3, 2, 1L}, {2, 3, 2L}});
            queryBuilder.setSelectExpression("PK1,PK2,COUNT(V)");
            queryBuilder.setOrderByClause("PK1 DESC,PK2 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{3, 2, 2L}, {2, 7, 2L}, {2, 3, 1L}, {1, 9, 4L}, {1, 8, 2L}});
            queryBuilder.setSelectExpression("PK3,PK2,COUNT(V)");
            queryBuilder.setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "PK3", "V"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setGroupByClause("PK3,PK2");
            queryBuilder.setOrderByClause("PK3,PK2");
            queryBuilder.setWhereClause("PK1=1");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{5, 9, 1L}, {6, 9, 2L}, {7, 9, 1L}, {10, 8, 1L}, {11, 8, 1L}});
            queryBuilder.setSelectExpression("PK2,PK3,COUNT(V)");
            queryBuilder.setOrderByClause("PK2,PK3");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{8, 10, 1L}, {8, 11, 1L}, {9, 5, 1L}, {9, 6, 2L}, {9, 7, 1L}});
            queryBuilder.setSelectExpression("PK3,PK2,COUNT(V)");
            queryBuilder.setOrderByClause("PK3 DESC,PK2 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{11, 8, 1L}, {10, 8, 1L}, {7, 9, 1L}, {6, 9, 2L}, {5, 9, 1L}});
            queryBuilder.setSelectExpression("PK2,PK3,COUNT(V)");
            queryBuilder.setOrderByClause("PK2 DESC,PK3 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{9, 7, 1L}, {9, 6, 2L}, {9, 5, 1L}, {8, 11, 1L}, {8, 10, 1L}});
            queryBuilder.setSelectExpression("PK4,PK3,PK1,COUNT(V)");
            queryBuilder.setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "PK3", "PK4", "V"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setWhereClause("PK2=9 ");
            queryBuilder.setGroupByClause("PK4,PK3,PK1");
            queryBuilder.setOrderByClause("PK4,PK3,PK1");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{8, 7, 1, 1L}, {12, 6, 1, 1L}, {13, 6, 1, 1L}, {22, 5, 1, 1L}});
            queryBuilder.setSelectExpression("PK1,PK3,PK4,COUNT(V)");
            queryBuilder.setOrderByClause("PK1,PK3,PK4");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 5, 22, 1L}, {1, 6, 12, 1L}, {1, 6, 13, 1L}, {1, 7, 8, 1L}});
            queryBuilder.setSelectExpression("PK4,PK3,PK1,COUNT(V)");
            queryBuilder.setOrderByClause("PK4 DESC,PK3 DESC,PK1 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{22, 5, 1, 1L}, {13, 6, 1, 1L}, {12, 6, 1, 1L}, {8, 7, 1, 1L}});
            queryBuilder.setSelectExpression("PK1,PK3,PK4,COUNT(V)");
            queryBuilder.setOrderByClause("PK1 DESC,PK3 DESC,PK4 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 7, 8, 1L}, {1, 6, 13, 1L}, {1, 6, 12, 1L}, {1, 5, 22, 1L}});
        }
    }
}

