/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.phoenix.coprocessor.SystemCatalogRegionObserver;
import org.apache.phoenix.coprocessor.TaskMetaDataEndpoint;
import org.apache.phoenix.end2end.BackwardCompatibilityTestUtil;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SystemTaskSplitPolicy;
import org.apache.phoenix.util.ServerUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class BackwardCompatibilityIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackwardCompatibilityIT.class);
    private final BackwardCompatibilityTestUtil.MavenCoordinates compatibleClientVersion;
    private static Configuration conf;
    private static HBaseTestingUtility hbaseTestUtil;
    private static String zkQuorum;
    private static String url;
    private String tmpDir;

    public BackwardCompatibilityIT(BackwardCompatibilityTestUtil.MavenCoordinates compatibleClientVersion) {
        this.compatibleClientVersion = compatibleClientVersion;
    }

    @Parameterized.Parameters(name="BackwardCompatibilityIT_compatibleClientVersion={0}")
    public static synchronized Collection<BackwardCompatibilityTestUtil.MavenCoordinates> data() throws Exception {
        return BackwardCompatibilityTestUtil.computeClientVersions();
    }

    @Before
    public synchronized void doSetup() throws Exception {
        this.tmpDir = System.getProperty("java.io.tmpdir");
        conf = HBaseConfiguration.create();
        conf.set("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        conf.set("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        hbaseTestUtil = new HBaseTestingUtility(conf);
        BaseTest.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.jdbc.extra.arguments", "");
        hbaseTestUtil.startMiniCluster();
        zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        BackwardCompatibilityTestUtil.checkForPreConditions(this.compatibleClientVersion, conf);
    }

    @After
    public synchronized void cleanUpAfterTest() throws Exception {
        boolean refCountLeaked = BaseTest.isAnyStoreRefCountLeaked(hbaseTestUtil.getAdmin());
        ServerUtil.ConnectionFactory.shutdown();
        try {
            DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        }
        finally {
            hbaseTestUtil.shutdownMiniCluster();
            ServerMetadataCacheTestImpl.resetCache();
        }
        System.setProperty("java.io.tmpdir", this.tmpDir);
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testUpsertWithOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_add", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
    }

    @Test
    public void testCreateDivergedViewWithOldClientReadFromNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testCreateDivergedViewWithOldClientReadWithMaxLookBackAge() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.SET_MAX_LOOK_BACK_AGE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testCreateDivergedViewWithOldClientReadFromOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testCreateDivergedViewWithOldClientReadFromOldClientAfterUpgrade() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_diverged_view", zkQuorum);
        java.sql.Connection conn = DriverManager.getConnection(url);
        if (conn != null) {
            conn.close();
        }
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testCreateDivergedViewWithNewClientReadFromOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_diverged_view", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testCreateDivergedViewWithNewClientReadFromNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
    }

    @Test
    public void testSelectWithOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_add", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
    }

    @Test
    public void testSelectUpsertWithNewClientWithMaxLookBackAge() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_add", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.SET_MAX_LOOK_BACK_AGE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("add_data", url, BackwardCompatibilityTestUtil.UpgradeProps.SET_MAX_LOOK_BACK_AGE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_add_data", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_add_data");
    }

    @Test
    public void testSelectUpsertWithNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_add", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("add_data", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_add_data", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_add_data");
    }

    @Test
    public void testSelectUpsertWithOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_add", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "add_data", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_add_data", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_add_data");
    }

    @Test
    public void testUpsertDeleteWithOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_add", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "add_delete", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_add_delete", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_add_delete");
    }

    @Test
    public void testUpsertDeleteWithNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_add", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_create_add", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_add");
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("add_delete", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_add_delete", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_add_delete");
    }

    @Test
    public void testSplitPolicyAndCoprocessorForSysTask() throws Exception {
        TableDescriptor tableDescriptor;
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_diverged_view", zkQuorum);
        String[] versionArr = this.compatibleClientVersion.getVersion().split("\\.");
        int majorVersion = Integer.parseInt(versionArr[0]);
        int minorVersion = Integer.parseInt(versionArr[1]);
        Connection conn = null;
        Admin admin = null;
        if (majorVersion == 4 && minorVersion == 15) {
            conn = hbaseTestUtil.getConnection();
            admin = conn.getAdmin();
            tableDescriptor = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME));
            Assert.assertNull((String)("split policy should be null with compatible client version: " + this.compatibleClientVersion), (Object)tableDescriptor.getRegionSplitPolicyClassName());
            Assert.assertFalse((String)("Coprocessor " + TaskMetaDataEndpoint.class.getName() + " should not have been added with compatible client version: " + this.compatibleClientVersion), (boolean)tableDescriptor.hasCoprocessor(TaskMetaDataEndpoint.class.getName()));
        }
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_create_diverged_view", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        if (conn == null) {
            conn = hbaseTestUtil.getConnection();
            admin = conn.getAdmin();
        }
        tableDescriptor = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME));
        Assert.assertEquals((String)("split policy not updated with compatible client version: " + this.compatibleClientVersion), (Object)tableDescriptor.getRegionSplitPolicyClassName(), (Object)SystemTaskSplitPolicy.class.getName());
        Assert.assertTrue((String)("Coprocessor " + TaskMetaDataEndpoint.class.getName() + " has not been added with compatible client version: " + this.compatibleClientVersion), (boolean)tableDescriptor.hasCoprocessor(TaskMetaDataEndpoint.class.getName()));
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_create_diverged_view");
        admin.close();
    }

    @Test
    public void testSystemTaskCreationWithIndexAsyncRebuild() throws Exception {
        String[] versionArr = this.compatibleClientVersion.getVersion().split("\\.");
        int majorVersion = Integer.parseInt(versionArr[0]);
        int minorVersion = Integer.parseInt(versionArr[1]);
        if (majorVersion > 4 || majorVersion == 4 && minorVersion >= 15) {
            BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "index_rebuild_async", zkQuorum);
            int retryCount = 0;
            while (true) {
                try {
                    BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_index_rebuild_async", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
                    BackwardCompatibilityTestUtil.assertExpectedOutput("query_index_rebuild_async");
                }
                catch (AssertionError e) {
                    if (retryCount++ > 10) {
                        throw e;
                    }
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testViewIndexIdCreatedWithOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "add_view_index", zkQuorum);
        Connection conn = hbaseTestUtil.getConnection();
        try (Admin admin = conn.getAdmin();){
            TableDescriptor tableDescriptor = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
            Assert.assertTrue((String)("Coprocessor " + SystemCatalogRegionObserver.class.getName() + " has been added with compatible client version: " + this.compatibleClientVersion), (boolean)tableDescriptor.hasCoprocessor(SystemCatalogRegionObserver.class.getName()));
            BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_view_index", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
            BackwardCompatibilityTestUtil.assertExpectedOutput("query_view_index");
            tableDescriptor = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
            Assert.assertTrue((String)("Coprocessor " + SystemCatalogRegionObserver.class.getName() + " has been added with compatible client version: " + this.compatibleClientVersion), (boolean)tableDescriptor.hasCoprocessor(SystemCatalogRegionObserver.class.getName()));
        }
    }

    @Test
    public void testViewIndexIdCreatedWithNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("add_view_index", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_view_index", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_view_index");
    }

    @Test
    public void testUnorderedGroupByAddDataByOldClientReadByNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_unorder_groupby", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_unorder_groupby", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_unorder_groupby");
    }

    @Test
    public void testUnorderedGroupByAddDataByNewClientReadByOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_unorder_groupby", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_unorder_groupby", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_unorder_groupby");
    }

    @Test
    public void testOrderedGroupByAddDataByOldClientReadByNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_ordered_groupby", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_ordered_groupby", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_ordered_groupby");
    }

    @Test
    public void testOrderedGroupByAddDataByNewClientReadByOldClient() throws Exception {
        Assume.assumeTrue((String)"compatible client version should be >= 5.1.3", (boolean)this.isClientCompatibleForOrderedGroupByQuery());
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_ordered_groupby", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_ordered_groupby", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_ordered_groupby");
    }

    @Test
    public void testOffsetAddDataByOldClientReadByNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_offset", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_offset", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_offset");
    }

    @Test
    public void testOffsetAddDataByNewClientReadByOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_offset", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_offset", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_offset");
    }

    @Test
    public void testOrderByNonPkAddDataByOldClientReadByNewClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_orderby_nonpk", zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_orderby_nonpk", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_orderby_nonpk");
    }

    @Test
    public void testOrderByNonPkAddDataByNewClientReadByOldClient() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_orderby_nonpk", url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_orderby_nonpk", zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_orderby_nonpk");
    }

    private boolean isClientCompatibleForOrderedGroupByQuery() {
        String[] clientVersion = this.compatibleClientVersion.getVersion().split("\\.");
        int majorVersion = Integer.parseInt(clientVersion[0]);
        int minorVersion = Integer.parseInt(clientVersion[1]);
        int patchVersion = Integer.parseInt(clientVersion[2]);
        if (majorVersion > 5) {
            return true;
        }
        if (majorVersion < 5) {
            return false;
        }
        if (minorVersion > 1) {
            return true;
        }
        if (minorVersion < 1) {
            return false;
        }
        return patchVersion >= 3;
    }
}

