/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.Collection;
import java.util.HashMap;
import org.apache.phoenix.end2end.BackwardCompatibilityTestUtil;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class BackwardCompatibilityForSplittableSyscatIT
extends SplitSystemCatalogIT {
    private final BackwardCompatibilityTestUtil.MavenCoordinates compatibleClientVersion;
    private String zkQuorum;
    private String url;

    @Parameterized.Parameters(name="BackwardCompatibilityForSplitableSyscatIT_compatibleClientVersion={0}")
    public static synchronized Collection<BackwardCompatibilityTestUtil.MavenCoordinates> data() throws Exception {
        return BackwardCompatibilityTestUtil.computeClientVersions();
    }

    public BackwardCompatibilityForSplittableSyscatIT(BackwardCompatibilityTestUtil.MavenCoordinates compatibleClientVersion) {
        this.compatibleClientVersion = compatibleClientVersion;
    }

    @Before
    public synchronized void setup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        BackwardCompatibilityForSplittableSyscatIT.doSetup(serverProps);
        this.zkQuorum = "localhost:" + BackwardCompatibilityForSplittableSyscatIT.getZKClientPort(config);
        this.url = "jdbc:phoenix:" + this.zkQuorum;
        BackwardCompatibilityTestUtil.checkForPreConditions(this.compatibleClientVersion, config);
    }

    @Test
    public void testSplittableSyscatWithOldClientForAddingDataAndDelete() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_delete_for_splitable_syscat", this.zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_delete_for_splitable_syscat");
    }

    @Test
    public void testSplittableSyscatWithNewClientForAddingDataAndDelete() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_delete_for_splitable_syscat", this.url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_delete_for_splitable_syscat");
    }

    @Test
    public void testSplittableSyscatWithOldClientLoadDataAndNewClientQueryAndDelete() throws Exception {
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "create_tmp_table", this.zkQuorum);
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("query_select_and_drop_table", this.url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_select_and_drop_table");
    }

    @Test
    public void testSplittableSyscatWithNewClientLoadDataAndOldClientQueryAndDelete() throws Exception {
        BackwardCompatibilityTestUtil.executeQueriesWithCurrentVersion("create_tmp_table", this.url, BackwardCompatibilityTestUtil.UpgradeProps.NONE);
        BackwardCompatibilityTestUtil.executeQueryWithClientVersion(this.compatibleClientVersion, "query_select_and_drop_table", this.zkQuorum);
        BackwardCompatibilityTestUtil.assertExpectedOutput("query_select_and_drop_table");
    }
}

