/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AuditLoggingIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyLogging() throws Exception {
        String createqQery = "create table test1 (mykey integer not null primary key, mycolumn varchar)";
        String upsertQuery = "upsert into test1 values (1,'Hello')";
        String selectQuery = "select * from test1";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST1' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute(createqQery);
            stmt.execute(upsertQuery);
            stmt.executeQuery(selectQuery);
            conn.commit();
            Thread.sleep(4000L);
            ResultSet rs = stmt.executeQuery(getLogsQuery);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLoggingSelect() throws Exception {
        String createqQery = "create table test2 (mykey integer not null primary key, mycolumn varchar)";
        String upsertQuery = "upsert into test2 values (1,'Hello')";
        String selectQuery = "select * from test2";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST2' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.log.level", LogLevel.TRACE.name());
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(createqQery);
            stmt.execute(upsertQuery);
            ResultSet rs = stmt.executeQuery(selectQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            int retryCount = 10;
            while (true) {
                try {
                    ResultSet rs2 = stmt.executeQuery(getLogsQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)selectQuery);
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (AssertionError e) {
                    if (retryCount-- <= 0) {
                        throw e;
                    }
                    Thread.sleep(4000L);
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testLoggingDMLAndDDL() throws Exception {
        String createqQery = "create table test3 (mykey integer not null primary key, mycolumn varchar)";
        String upsertQuery = "upsert into test3 values (1,'Hello')";
        String selectQuery = "select * from test3";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST3' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.audit.log.level", LogLevel.INFO.name());
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(createqQery);
            stmt.execute(upsertQuery);
            ResultSet rs = conn.createStatement().executeQuery(selectQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            int retryCount = 10;
            while (true) {
                try {
                    ResultSet rs2 = stmt.executeQuery(getLogsQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)createqQery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)upsertQuery);
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (AssertionError e) {
                    if (retryCount-- <= 0) {
                        throw e;
                    }
                    Thread.sleep(4000L);
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testLoggingDMLAandDDLandSelect() throws Exception {
        String createqQuery = "create table test4 (mykey integer not null primary key, mycolumn varchar)";
        String upsertQuery = "upsert into test4 values (1,'Hello')";
        String selectQuery = "select * from test4";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST4' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.audit.log.level", LogLevel.INFO.name());
        props.setProperty("phoenix.log.level", LogLevel.TRACE.name());
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(createqQuery);
            stmt.execute(upsertQuery);
            ResultSet rs = stmt.executeQuery(selectQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            int retryCount = 10;
            while (true) {
                try {
                    ResultSet rs2 = conn.createStatement().executeQuery(getLogsQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)createqQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)upsertQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)rs2.getString(7), (Object)selectQuery);
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (AssertionError e) {
                    if (retryCount-- <= 0) {
                        throw e;
                    }
                    Thread.sleep(4000L);
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testLogginParameterizedUpsert() throws Exception {
        String createqQery = "create table test5 (mykey integer not null primary key, mycolumn varchar)";
        String upsertQuery = "upsert into test5 values (?, ?)";
        String selectQuery = "select * from test5";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST5' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.audit.log.level", LogLevel.INFO.name());
        props.setProperty("phoenix.log.level", LogLevel.TRACE.name());
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement p = conn.prepareStatement(upsertQuery);){
            conn.setAutoCommit(true);
            stmt.execute(createqQery);
            p.setInt(1, 1);
            p.setString(2, "foo");
            p.execute();
            p.setInt(1, 2);
            p.setString(2, "bar");
            p.execute();
            ResultSet rs = stmt.executeQuery(selectQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            int retryCount = 10;
            while (true) {
                try {
                    ResultSet rs2 = conn.createStatement().executeQuery(getLogsQuery);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)"1,foo", (Object)rs2.getString(13));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)"2,bar", (Object)rs2.getString(13));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (AssertionError e) {
                    if (retryCount-- <= 0) {
                        throw e;
                    }
                    Thread.sleep(4000L);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testlogSamplingRate() throws Exception {
        String createqQery = "create table test6 (mykey integer not null primary key, mycolumn varchar)";
        String selectQuery = "select * from test6";
        String getLogsQuery = "select * from SYSTEM.LOG WHERE TABLE_NAME='TEST6' order by start_time";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.audit.log.level", LogLevel.INFO.name());
        props.setProperty("phoenix.log.level", LogLevel.TRACE.name());
        props.setProperty("phoenix.log.sample.rate", "0.5");
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(AuditLoggingIT.getUrl(), props);){
            Statement stat = conn.createStatement();
            stat.execute(createqQery);
            for (int i = 0; i < 100; ++i) {
                String upsertQuery = "upsert into test6 values (" + i + ",'asd')";
                stat.execute(upsertQuery);
                ResultSet rs = stat.executeQuery(selectQuery);
                Assert.assertTrue((boolean)rs.next());
                rs.close();
            }
            ResultSet rs2 = conn.createStatement().executeQuery(getLogsQuery);
            int numOfUpserts = 0;
            int numOfSelects = 0;
            while (rs2.next()) {
                String query = rs2.getString(7);
                if (query.equals(selectQuery)) {
                    ++numOfSelects;
                    continue;
                }
                if (!query.contains("upsert into test6 values (")) continue;
                ++numOfUpserts;
            }
            Assert.assertEquals((long)numOfUpserts, (long)100L);
            Assert.assertTrue((numOfSelects > 0 && numOfSelects < 100 ? 1 : 0) != 0);
            System.out.println(numOfSelects);
        }
    }
}

