/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ArrayToStringFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;
    private Connection conn;

    @Before
    public void initTables() throws Exception {
        this.conn = DriverManager.getConnection(ArrayToStringFunctionIT.getUrl());
        this.tableName = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + this.tableName + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[],integers INTEGER[],doubles DOUBLE[],bigints BIGINT[],chars CHAR(15)[],double1 DOUBLE,varchar1 VARCHAR,nullcheck INTEGER,chars2 CHAR(15)[])";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.tableName + "(region_name,varchars,integers,doubles,bigints,chars,double1,varchar1,nullcheck,chars2) VALUES('SF Bay Area',ARRAY['2345','46345','23234'],ARRAY[2345,46345,23234,456],ARRAY[23.45,46.345,23.234,45.6,5.78],ARRAY[12,34,56,78,910],ARRAY['a','bbbb','c','ddd','e'],23.45,', ',NULL,ARRAY['a','bbbb','c','ddd','e','foo'])";
        PreparedStatement stmt = this.conn.prepareStatement(dml);
        stmt.execute();
        this.conn.commit();
    }

    @Test
    public void testArrayToStringFunctionVarchar1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(varchars, ',','*') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2345,46345,23234";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionVarchar2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(varchars, ',') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2345,46345,23234";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionVarchar3() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY['hello', 'hello'], ',') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "hello,hello";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInt() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(integers, ',') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2345,46345,23234,456";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionDouble1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(doubles, ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "23.45, 46.345, 23.234, 45.6, 5.78";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionDouble2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[2.3, 4.5], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2.3, 4.5";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionBigint() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(bigints, ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "12, 34, 56, 78, 910";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionChar1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(chars, ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a   , bbbb, c   , ddd , e   ";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionChar2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(chars2, ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a   , bbbb, c   , ddd , e   , foo ";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionChar3() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(chars2, varchar1) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a   , bbbb, c   , ddd , e   , foo ";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNestedFunctions1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[integers[1],integers[1]], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2345, 2345";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNestedFunctions2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[ARRAY_ELEM(ARRAY[2,4],1),ARRAY_ELEM(ARRAY[2,4],2)], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "2, 4";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNestedFunctions3() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[ARRAY_ELEM(doubles, 1), ARRAY_ELEM(doubles, 1)], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "23.45, 23.45";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNestedFunctions4() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_ELEM(ARRAY_APPEND(ARRAY['abc','bcd'], ARRAY_TO_STRING(ARRAY['a','b'], 'c')), 3) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "acb";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsert1() throws Exception {
        String table = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + "(region_name,varchar) VALUES('SF Bay Area',ARRAY_TO_STRING(ARRAY['hello','world'],','))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + table + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "hello,world";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsert2() throws Exception {
        String tableName = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + "(region_name,varchar) VALUES('SF Bay Area',ARRAY_TO_STRING(ARRAY[3, 4, 5],', '))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "3, 4, 5";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsert3() throws Exception {
        String tableName = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + "(region_name,varchar) VALUES('SF Bay Area',ARRAY_TO_STRING(ARRAY[3.1, 4.2, 5.5],', '))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "3.1, 4.2, 5.5";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsert4() throws Exception {
        String tableName = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + "(region_name,varchar) VALUES('SF Bay Area',ARRAY_TO_STRING(ARRAY[true, false, true],', '))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "true, false, true";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsertSelect1() throws Exception {
        String source = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + source + " (region_name VARCHAR PRIMARY KEY,doubles DOUBLE[])";
        this.conn.createStatement().execute(ddl);
        String target = ArrayToStringFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + target + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + source + "(region_name,doubles) VALUES('SF Bay Area', ARRAY[5.67, 7.87])";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + source + "(region_name,doubles) VALUES('SF Bay Area2', ARRAY[9.2, 3.4])";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        dml = "UPSERT INTO " + target + "(region_name, varchar) SELECT region_name, ARRAY_TO_STRING(doubles, ', ') FROM " + source;
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + target);
        Assert.assertTrue((boolean)rs.next());
        String expected = "5.67, 7.87";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        expected = "9.2, 3.4";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsertSelect2() throws Exception {
        String source = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + source + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[])";
        this.conn.createStatement().execute(ddl);
        String target = ArrayToStringFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + target + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + source + "(region_name,varchars) VALUES('SF Bay Area', ARRAY['hello', '-)'])";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + source + "(region_name,varchars) VALUES('SF Bay Area2', ARRAY['hello', '-('])";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        dml = "UPSERT INTO " + target + "(region_name, varchar) SELECT region_name, ARRAY_TO_STRING(varchars, ':') FROM " + source;
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + target);
        Assert.assertTrue((boolean)rs.next());
        String expected = "hello:-)";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        expected = "hello:-(";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithUpsertSelect3() throws Exception {
        String source = ArrayToStringFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + source + " (region_name VARCHAR PRIMARY KEY,booleans BOOLEAN[])";
        this.conn.createStatement().execute(ddl);
        String target = ArrayToStringFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + target + " (region_name VARCHAR PRIMARY KEY,varchar VARCHAR)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + source + "(region_name, booleans) VALUES('SF Bay Area', ARRAY[true, true])";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + source + "(region_name, booleans) VALUES('SF Bay Area2', ARRAY[false, false])";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        dml = "UPSERT INTO " + target + "(region_name, varchar) SELECT region_name, ARRAY_TO_STRING(booleans, ', ') FROM " + source;
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT varchar FROM " + target);
        Assert.assertTrue((boolean)rs.next());
        String expected = "true, true";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        expected = "false, false";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE '2345,46345,23234,456' = ARRAY_TO_STRING(integers,',')");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE 'a,b,c' = ARRAY_TO_STRING(ARRAY['a', 'b', 'c'], ',')");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere3() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE '1.1,2.2,3.3' = ARRAY_TO_STRING(ARRAY[1.1, 2.2, 3.3], ',')");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere4() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE 'true,true,true' = ARRAY_TO_STRING(ARRAY[true, true, true], ',')");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere5() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE 'a, bbbb, c, ddd, e' = ARRAY_TO_STRING(ARRAY['a', 'bbbb', 'c' , 'ddd', 'e'], ', ')");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere6() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY_TO_STRING(ARRAY[1,2,3], varchar1) = '1, 2, 3'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionInWhere7() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY_TO_STRING(varchars, varchar1) = '2345, 46345, 23234'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls1() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY['a', NULL, 'b'], ', ','*') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, *, b";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY['a', NULL, 'b'], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, b";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls3() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[NULL, 'a', 'b'], ', ', '*') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "*, a, b";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls4() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[NULL, 'a', 'b'], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, b";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls5() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY['a', 'b', NULL], ', ', '*') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, b, *";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls6() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY['a', 'b', NULL], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, b";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls7() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[NULL, NULL, 'a', 'b', NULL, 'c', 'd', NULL, 'e', NULL, NULL], ', ', '*') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "*, *, a, b, *, c, d, *, e, *, *";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayToStringFunctionWithNulls8() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT ARRAY_TO_STRING(ARRAY[NULL, NULL, 'a', 'b', NULL, 'c', 'd', NULL, 'e', NULL, NULL], ', ') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        String expected = "a, b, c, d, e";
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

