/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ArrayFillFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;

    @Before
    public void initTable() throws Exception {
        this.tableName = ArrayFillFunctionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String ddl = "CREATE TABLE " + this.tableName + " (region_name VARCHAR PRIMARY KEY,length1 INTEGER, length2 INTEGER,\"DATE\" DATE,\"time\" TIME,\"timestamp\" TIMESTAMP,\"varchar\" VARCHAR,\"integer\" INTEGER,\"double\" DOUBLE,\"bigint\" BIGINT,\"char\" CHAR(15),double1 DOUBLE,char1 CHAR(17),nullcheck INTEGER,chars2 CHAR(15)[], varchars2 VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.tableName + "(region_name,length1,length2,\"DATE\",\"time\",\"timestamp\",\"varchar\",\"integer\",\"double\",\"bigint\",\"char\",double1,char1,nullcheck,chars2,varchars2) VALUES('SF Bay Area',0,-3,to_date('2015-05-20 06:12:14.184'),to_time('2015-05-20 06:12:14.184'),to_timestamp('2015-05-20 06:12:14.184'),'foo',34,23.45,34567,'foo',23.45,'wert',NULL,ARRAY['hello','hello','hello'],ARRAY['hello','hello','hello'])";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.execute();
        conn.commit();
    }

    @Test
    public void testArrayFillFunctionVarchar() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"varchar\",5) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] strings = new String[]{"foo", "foo", "foo", "foo", "foo"};
        Array array = conn.createArrayOf("VARCHAR", strings);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInteger() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"integer\",4) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{34, 34, 34, 34};
        Array array = conn.createArrayOf("INTEGER", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionDouble() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"double\",4) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{23.45, 23.45, 23.45, 23.45};
        Array array = conn.createArrayOf("DOUBLE", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionBigint() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"bigint\",4) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{34567L, 34567L, 34567L, 34567L};
        Array array = conn.createArrayOf("BIGINT", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionChar() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"char\",4) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{"foo", "foo", "foo", "foo"};
        Array array = conn.createArrayOf("CHAR", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionVarChar() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"varchar\",4) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{"foo", "foo", "foo", "foo"};
        Array array = conn.createArrayOf("VARCHAR", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionDate() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"DATE\",3) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{new Date(1432102334184L), new Date(1432102334184L), new Date(1432102334184L)};
        Array array = conn.createArrayOf("DATE", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionTime() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"time\",3) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{new Time(1432102334184L), new Time(1432102334184L), new Time(1432102334184L)};
        Array array = conn.createArrayOf("TIME", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionTimestamp() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"timestamp\",3) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{new Timestamp(1432102334184L), new Timestamp(1432102334184L), new Timestamp(1432102334184L)};
        Array array = conn.createArrayOf("TIMESTAMP", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayFillFunctionInvalidLength1() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"timestamp\",length2) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{new Timestamp(1432102334184L), new Timestamp(1432102334184L), new Timestamp(1432102334184L)};
        Array array = conn.createArrayOf("TIMESTAMP", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayFillFunctionInvalidLength2() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(\"timestamp\",length1) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{new Timestamp(1432102334184L), new Timestamp(1432102334184L), new Timestamp(1432102334184L)};
        Array array = conn.createArrayOf("TIMESTAMP", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithNestedFunctions1() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(ARRAY_ELEM(ARRAY[23,45],1),3) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] integers = new Integer[]{23, 23, 23};
        Array array = conn.createArrayOf("INTEGER", integers);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithNestedFunctions2() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL('hello', ARRAY_LENGTH(ARRAY[34, 45])) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{"hello", "hello"};
        Array array = conn.createArrayOf("VARCHAR", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithNestedFunctions3() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_FILL(3.4, ARRAY_LENGTH(ARRAY[34, 45])) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] objects = new Object[]{BigDecimal.valueOf(3.4), BigDecimal.valueOf(3.4)};
        Array array = conn.createArrayOf("DECIMAL", objects);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithUpsert1() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String regions = ArrayFillFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + regions + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + regions + "(region_name,varchars) VALUES('SF Bay Area',ARRAY_FILL('hello',3))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars FROM " + regions + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] strings = new String[]{"hello", "hello", "hello"};
        Array array = conn.createArrayOf("VARCHAR", strings);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithUpsert2() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String regions = ArrayFillFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + regions + " (region_name VARCHAR PRIMARY KEY,integers INTEGER[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + regions + "(region_name,integers) VALUES('SF Bay Area',ARRAY_FILL(3456,3))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT integers FROM " + regions + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] integers = new Integer[]{3456, 3456, 3456};
        Array array = conn.createArrayOf("INTEGER", integers);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithUpsert3() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String regions = ArrayFillFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + regions + " (region_name VARCHAR PRIMARY KEY,doubles DOUBLE[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + regions + "(region_name,doubles) VALUES('SF Bay Area',ARRAY_FILL(2.5,3))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT doubles FROM " + regions + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Object[] doubles = new Double[]{2.5, 2.5, 2.5};
        Array array = conn.createArrayOf("DOUBLE", doubles);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithUpsertSelect1() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String ddl = "CREATE TABLE source (region_name VARCHAR PRIMARY KEY,doubles DOUBLE[])";
        conn.createStatement().execute(ddl);
        ddl = "CREATE TABLE target (region_name VARCHAR PRIMARY KEY,doubles DOUBLE[],doubles2 DOUBLE[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO source(region_name,doubles) VALUES('SF Bay Area',ARRAY_FILL(3.4,3))";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO source(region_name,doubles) VALUES('SF Bay Area2',ARRAY_FILL(2.3,3))";
        conn.createStatement().execute(dml);
        conn.commit();
        dml = "UPSERT INTO target(region_name, doubles, doubles2) SELECT region_name, doubles,ARRAY_FILL(4.5,5) FROM source";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT doubles, doubles2 FROM target");
        Assert.assertTrue((boolean)rs.next());
        Object[] doubles = new Double[]{3.4, 3.4, 3.4};
        Object[] doubles2 = new Double[]{4.5, 4.5, 4.5, 4.5, 4.5};
        Array array = conn.createArrayOf("DOUBLE", doubles);
        Array array2 = conn.createArrayOf("DOUBLE", doubles2);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertEquals((Object)array2, (Object)rs.getArray(2));
        Assert.assertTrue((boolean)rs.next());
        doubles = new Double[]{2.3, 2.3, 2.3};
        array = conn.createArrayOf("DOUBLE", doubles);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertEquals((Object)array2, (Object)rs.getArray(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionWithUpsertSelect2() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        String source = ArrayFillFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + source + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String target = ArrayFillFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + target + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[],varchars2 VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + source + "(region_name,varchars) VALUES('SF Bay Area',ARRAY_FILL('foo',3))";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + source + "(region_name,varchars) VALUES('SF Bay Area2',ARRAY_FILL('hello',3))";
        conn.createStatement().execute(dml);
        conn.commit();
        dml = "UPSERT INTO " + target + "(region_name, varchars, varchars2) SELECT region_name, varchars,ARRAY_FILL(':-)',5) FROM " + source;
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars, varchars2 FROM " + target);
        Assert.assertTrue((boolean)rs.next());
        Object[] strings = new String[]{"foo", "foo", "foo"};
        Object[] strings2 = new String[]{":-)", ":-)", ":-)", ":-)", ":-)"};
        Array array = conn.createArrayOf("VARCHAR", strings);
        Array array2 = conn.createArrayOf("VARCHAR", strings2);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertEquals((Object)array2, (Object)rs.getArray(2));
        Assert.assertTrue((boolean)rs.next());
        strings = new String[]{"hello", "hello", "hello"};
        array = conn.createArrayOf("VARCHAR", strings);
        Assert.assertEquals((Object)array, (Object)rs.getArray(1));
        Assert.assertEquals((Object)array2, (Object)rs.getArray(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere1() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY[12, 12, 12, 12]=ARRAY_FILL(12,4)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere2() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE \"varchar\"=ANY(ARRAY_FILL('foo',3))");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere3() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY['2345', '2345', '2345', '2345']=ARRAY_FILL('2345', 4)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere4() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY[23.45, 23.45, 23.45]=ARRAY_FILL(23.45, 3)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere5() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY['foo','foo','foo','foo','foo']=ARRAY_FILL(\"varchar\",5)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere6() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE varchars2=ARRAY_FILL('hello',3)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayFillFunctionInWhere7() throws Exception {
        Connection conn = DriverManager.getConnection(ArrayFillFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY[2,2,2,2]=ARRAY_FILL(2,4)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

