/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ArrayIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class Array2IT
extends ArrayIT {
    private static final String TEST_QUERY = "select ?[2] from \"SYSTEM\".\"CATALOG\" limit 1";

    @Test
    public void testFixedWidthCharArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a CHAR(5) ARRAY)");
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.getMetaData().getColumns(null, null, table, "A");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt("COLUMN_SIZE"));
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"1", "2"};
        Array array = conn.createArrayOf("CHAR", s);
        stmt.setArray(2, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        rs = conn.createStatement().executeQuery("SELECT k, a[2] FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"2", (Object)rs.getString(2));
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectArrayUsingUpsertLikeSyntax() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_double_array FROM  " + table + "  WHERE a_double_array = CAST(ARRAY [ 25.343, 36.763, 37.56,386.63] AS DOUBLE ARRAY)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{25.343, 36.763, 37.56, 386.63};
            Array array = conn.createArrayOf("DOUBLE", doubleArr);
            PhoenixArray resultArray = (PhoenixArray)rs.getArray(1);
            Assert.assertEquals((Object)resultArray, (Object)array);
            Assert.assertEquals((Object)"[25.343, 36.763, 37.56, 386.63]", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayIndexUsedInWhereClause() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        int a_index = 0;
        String query = "SELECT a_double_array[2] FROM  " + table + "  where a_double_array[" + a_index + "2]<?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            Object[] doubleArr = new Double[]{40.0};
            conn.createArrayOf("DOUBLE", doubleArr);
            statement.setDouble(1, 40.0);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            doubleArr = new Double[]{36.763};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayIndexUsedInGroupByClause() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_double_array[2] FROM " + table + "  GROUP BY a_double_array[2]";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            Object[] doubleArr = new Double[]{40.0};
            conn.createArrayOf("DOUBLE", doubleArr);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            doubleArr = new Double[]{36.763};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVariableLengthArrayWithNullValue() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, true, Array2IT.getUrl());
        String query = "SELECT a_string_array[2] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            String result = rs.getString(1);
            Assert.assertNull((Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSpecificIndexOfAVariableArrayAlongWithAnotherColumn1() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_string_array[3],A_INTEGER FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            String result = rs.getString(1);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            int a_integer = rs.getInt(2);
            Assert.assertEquals((long)1L, (long)a_integer);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSpecificIndexOfAVariableArrayAlongWithAnotherColumn2() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT A_INTEGER, a_string_array[3] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            int a_integer = rs.getInt(1);
            Assert.assertEquals((long)1L, (long)a_integer);
            String result = rs.getString(2);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectMultipleArrayColumns() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT  a_string_array[3], a_double_array[2] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            Double[] doubleArr = new Double[]{36.763};
            Double a_double = rs.getDouble(2);
            Assert.assertEquals((Object)doubleArr[0], (Object)a_double);
            String result = rs.getString(1);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSameArrayColumnMultipleTimesWithDifferentIndices() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_string_array[1], a_string_array[2], a_string_array[3], a_double_array[1], a_double_array[2], a_double_array[3] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ABC", (Object)rs.getString(1));
            Assert.assertEquals((Object)"CEDF", (Object)rs.getString(2));
            Assert.assertEquals((Object)"XYZWER", (Object)rs.getString(3));
            Assert.assertEquals((double)25.343, (double)rs.getDouble(4), (double)0.0);
            Assert.assertEquals((double)36.763, (double)rs.getDouble(5), (double)0.0);
            Assert.assertEquals((double)37.56, (double)rs.getDouble(6), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSameArrayColumnMultipleTimesWithSameIndices() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_string_array[3], a_string_array[3] FROM " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            String result = rs.getString(1);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            result = rs.getString(2);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSpecificIndexOfAVariableArray() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_string_array[3] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"XYZWER"};
            String result = rs.getString(1);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOutOfRangeIndex() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT a_double_array[100] FROM  " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            PhoenixArray resultArray = (PhoenixArray)rs.getArray(1);
            Assert.assertNull((Object)resultArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayLengthFunctionForVariableLength() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT ARRAY_LENGTH(a_string_array) FROM " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int result = rs.getInt(1);
            Assert.assertEquals((long)result, (long)4L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayLengthFunctionForFixedLength() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Array2IT.initTablesWithArrays(table, tenantId, null, false, Array2IT.getUrl());
        String query = "SELECT ARRAY_LENGTH(a_double_array) FROM " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int result = rs.getInt(1);
            Assert.assertEquals((long)result, (long)4L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySizeRoundtrip() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            ResultSet rs = conn.getMetaData().getColumns(null, null, StringUtil.escapeLike((String)table), StringUtil.escapeLike((String)SchemaUtil.normalizeIdentifier((String)"x_long_array")));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt("ARRAY_SIZE"));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.getMetaData().getColumns(null, null, StringUtil.escapeLike((String)table), StringUtil.escapeLike((String)SchemaUtil.normalizeIdentifier((String)"a_string_array")));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt("ARRAY_SIZE"));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.getMetaData().getColumns(null, null, StringUtil.escapeLike((String)table), StringUtil.escapeLike((String)SchemaUtil.normalizeIdentifier((String)"a_double_array")));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt("ARRAY_SIZE"));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testVarLengthArrComparisonInWhereClauseWithSameArrays() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4])");
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkl"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkl"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k, a_string_array[2] FROM  " + table + "  where a_string_array=b_string_array");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"def", (Object)rs.getString(2));
        conn.close();
    }

    @Test
    public void testVarLengthArrComparisonInWhereClauseWithDiffSizeArrays() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4])");
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jklm"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k, a_string_array[2] FROM  " + table + "  where a_string_array<b_string_array");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"def", (Object)rs.getString(2));
        conn.close();
    }

    @Test
    public void testVarLengthArrComparisonWithNulls() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4])");
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k, a_string_array[2] FROM  " + table + "  where a_string_array>b_string_array");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"def", (Object)rs.getString(2));
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesWithNull() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        String query = "upsert into  " + table + " (ORGANIZATION_ID,ENTITY_ID,a_double_array) values('" + tenantId + "','00A123122312312',null)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            int executeUpdate = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)executeUpdate);
            conn.commit();
            statement.close();
            conn.close();
            props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array2IT.getUrl(), props);
            query = "SELECT ARRAY_ELEM(a_double_array,2) FROM  " + table;
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{0.0};
            conn.createArrayOf("DOUBLE", doubleArr);
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesWithNullUsingPreparedStmt() throws Exception {
        String tenantId = Array2IT.getOrganizationId();
        String table = Array2IT.createTableWithArray(Array2IT.getUrl(), Array2IT.getDefaultSplits(tenantId), null);
        String query = "upsert into  " + table + " (ORGANIZATION_ID,ENTITY_ID,a_string_array) values(?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "00A123122312312");
            statement.setNull(3, 2003);
            int executeUpdate = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)executeUpdate);
            conn.commit();
            statement.close();
            conn.close();
            props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array2IT.getUrl(), props);
            query = "SELECT ARRAY_ELEM(a_string_array,1) FROM  " + table;
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] strArr = new String[]{null};
            conn.createArrayOf("VARCHAR", strArr);
            String result = rs.getString(1);
            Assert.assertEquals((Object)strArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPKWithArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4] \n CONSTRAINT pk PRIMARY KEY (k, b_string_array)) \n");
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k, a_string_array[2] FROM  " + table + "  where b_string_array[8]='xxx'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"def", (Object)rs.getString(2));
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPKWithArrayNotInEnd() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String table = Array2IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE  " + table + "  ( a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4], k VARCHAR  \n CONSTRAINT pk PRIMARY KEY (b_string_array, k))");
            conn.close();
            Assert.fail();
        }
    }

    @Test
    public void testArrayRefToLiteralCharArraySameLengths() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement stmt = conn.prepareStatement(TEST_QUERY);
            Array array = conn.createArrayOf("CHAR", new String[]{"a", "b", "c"});
            stmt.setArray(1, array);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testArrayRefToLiteralCharArrayDiffLengths() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement stmt = conn.prepareStatement(TEST_QUERY);
            Array array = conn.createArrayOf("CHAR", new String[]{"a", "bb", "ccc"});
            stmt.setArray(1, array);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bb", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testArrayRefToLiteralBinaryArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);){
            PreparedStatement stmt = conn.prepareStatement(TEST_QUERY);
            byte[][] bytes = new byte[][]{{0, 0, 1}, {0, 0, 2, 0}, {0, 0, 0, 3, 4}};
            Array array = conn.createArrayOf("BINARY", (Object[])bytes);
            stmt.setArray(1, array);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 2, 0, 0}, (byte[])rs.getBytes(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testArrayConstructorWithMultipleRows1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        String ddl = "CREATE TABLE  " + table + "  (region_name VARCHAR PRIMARY KEY, a INTEGER, b INTEGER)";
        conn.createStatement().execute(ddl);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('a', 6,3)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('b', 2,4)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('c', 6,3)");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT ARRAY[a,b]) from  " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }

    @Test
    public void testArrayConstructorWithMultipleRows2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        String ddl = "CREATE TABLE  " + table + "  (region_name VARCHAR PRIMARY KEY, a INTEGER, b INTEGER)";
        conn.createStatement().execute(ddl);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('a', 6,3)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('b', 2,4)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('c', 6,3)");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY[a,b] from  " + table + " ");
        Assert.assertTrue((boolean)rs.next());
        Array arr = conn.createArrayOf("INTEGER", new Object[]{6, 3});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
        arr = conn.createArrayOf("INTEGER", new Object[]{2, 4});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
        arr = conn.createArrayOf("INTEGER", new Object[]{6, 3});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
    }

    @Test
    public void testArrayConstructorWithMultipleRows3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        String ddl = "CREATE TABLE  " + table + "  (region_name VARCHAR PRIMARY KEY, a VARCHAR, b VARCHAR)";
        conn.createStatement().execute(ddl);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('a', 'foo', 'abc')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('b', 'abc', 'dfg')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('c', 'foo', 'abc')");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY[a,b] from  " + table + " ");
        Assert.assertTrue((boolean)rs.next());
        Array arr = conn.createArrayOf("VARCHAR", new Object[]{"foo", "abc"});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
        arr = conn.createArrayOf("VARCHAR", new Object[]{"abc", "dfg"});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
        arr = conn.createArrayOf("VARCHAR", new Object[]{"foo", "abc"});
        Assert.assertEquals((Object)arr, (Object)rs.getArray(1));
        rs.next();
    }

    @Test
    public void testArrayConstructorWithMultipleRows4() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        String table = Array2IT.generateUniqueName();
        String ddl = "CREATE TABLE  " + table + "  (region_name VARCHAR PRIMARY KEY, a VARCHAR, b VARCHAR)";
        conn.createStatement().execute(ddl);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('a', 'foo', 'abc')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('b', 'abc', 'dfg')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + table + " (region_name, a, b) VALUES('c', 'foo', 'abc')");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array2IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT ARRAY[a,b]) from  " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }
}

