/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.export.DefaultSchemaRegistryRepository;
import org.apache.phoenix.schema.export.DefaultSchemaWriter;
import org.apache.phoenix.schema.export.SchemaRegistryRepositoryFactory;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class AlterTableIT
extends ParallelStatsDisabledIT {
    private String schemaName;
    private String dataTableName;
    private String indexTableName;
    private String dataTableFullName;
    private String indexTableFullName;
    private String tableDDLOptions;
    private final boolean columnEncoded;
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterTableIT.class);

    public AlterTableIT(boolean columnEncoded) {
        this.columnEncoded = columnEncoded;
        this.tableDDLOptions = columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0";
    }

    @Parameterized.Parameters(name="AlterTableIT_columnEncoded={0}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    @Before
    public void setupTableNames() throws Exception {
        this.schemaName = "";
        this.dataTableName = AlterTableIT.generateUniqueName();
        this.indexTableName = "I_" + AlterTableIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.indexTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableWithVarBinaryKey() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn.setAutoCommit(false);
        String ddl = "CREATE TABLE  " + this.dataTableFullName + "  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary)) " + this.tableDDLOptions;
        AlterTableIT.createTestTable(AlterTableIT.getUrl(), ddl);
        conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " SET DISABLE_WAL = true");
        try {
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD b_string VARCHAR NULL PRIMARY KEY";
            PreparedStatement stmt = conn.prepareStatement(ddl);
            stmt.execute();
            Assert.fail((String)"Should have caught bad alter.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VARBINARY_LAST_PK.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableWithBSONKey() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn.setAutoCommit(false);
        String ddl = "CREATE TABLE  " + this.dataTableFullName + "  (a_string varchar not null, a_bson BSON not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_bson)) " + this.tableDDLOptions;
        AlterTableIT.createTestTable(AlterTableIT.getUrl(), ddl);
        conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " SET DISABLE_WAL = true");
        try {
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD b_string VARCHAR NULL PRIMARY KEY";
            PreparedStatement stmt = conn.prepareStatement(ddl);
            stmt.execute();
            Assert.fail((String)"Should have caught bad alter.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.BSON_LAST_PK.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropSystemTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            try {
                conn.createStatement().executeUpdate("DROP TABLE SYSTEM.\"CATALOG\"");
                Assert.fail((String)"Should not be allowed to drop a system table");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddVarCharColToPK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + this.dataTableFullName + " VALUES(?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "b");
            stmt.execute();
            stmt.setString(1, "a");
            stmt.execute();
            conn.commit();
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD  b_string VARCHAR  NULL PRIMARY KEY  ";
            conn.createStatement().execute(ddl);
            query = "SELECT * FROM " + this.dataTableFullName + " WHERE a_string = 'a' AND b_string IS NULL";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            dml = "UPSERT INTO " + this.dataTableFullName + " VALUES(?)";
            stmt = conn.prepareStatement(dml);
            stmt.setString(1, "c");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + this.dataTableFullName + " WHERE a_string = 'c' AND b_string IS NULL";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            dml = "UPSERT INTO " + this.dataTableFullName + "(a_string,col1) VALUES(?,?)";
            stmt = conn.prepareStatement(dml);
            stmt.setString(1, "a");
            stmt.setInt(2, 5);
            stmt.execute();
            conn.commit();
            query = "SELECT a_string,col1 FROM " + this.dataTableFullName + " WHERE a_string = 'a' AND b_string IS NULL";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)5L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAlterTableUpdatesSchemaRegistry() throws Exception {
        String schemaName = AlterTableIT.generateUniqueName();
        String tableName = AlterTableIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableIT.getUrl());){
            String createDdl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) CHANGE_DETECTION_ENABLED=true, SCHEMA_VERSION='OLD', SALT_BUCKETS=4";
            conn.createStatement().execute(createDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertEquals((Object)"OLD", (Object)table.getSchemaVersion());
            String expectedSchemaId = String.format("global*%s*%s*OLD", schemaName, tableName);
            Assert.assertEquals((Object)expectedSchemaId, (Object)table.getExternalSchemaId());
            String alterVersionDdl = "ALTER TABLE " + fullTableName + " SET SCHEMA_VERSION='NEW'";
            conn.createStatement().execute(alterVersionDdl);
            PTable newTable = conn.getTableNoCache(fullTableName);
            AlterTableIT.verifySchemaExport(newTable, AlterTableIT.getUtility().getConfiguration());
            String alterDdl = "ALTER TABLE " + fullTableName + " ADD col3 VARCHAR NULL";
            conn.createStatement().execute(alterDdl);
            newTable = conn.getTableNoCache(fullTableName);
            AlterTableIT.verifySchemaExport(newTable, AlterTableIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testAlterChangeDetectionActivatesSchemaRegistryExport() throws Exception {
        String schemaName = AlterTableIT.generateUniqueName();
        String tableName = AlterTableIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableIT.getUrl());){
            String createDdl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2))  SCHEMA_VERSION='OLD'";
            conn.createStatement().execute(createDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertNull((Object)table.getExternalSchemaId());
            String alterDdl = "ALTER TABLE " + fullTableName + " SET CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(alterDdl);
            PTable alteredTable = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((boolean)alteredTable.isChangeDetectionEnabled());
            AlterTableIT.verifySchemaExport(alteredTable, AlterTableIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testChangeDetectionFalseDoesntExportToSchemaRegistry() throws Exception {
        String schemaName = AlterTableIT.generateUniqueName();
        String tableName = AlterTableIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableIT.getUrl());){
            String createDdl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) CHANGE_DETECTION_ENABLED=false, SCHEMA_VERSION='OLD'";
            conn.createStatement().execute(createDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertFalse((boolean)table.isChangeDetectionEnabled());
            Assert.assertNull((Object)table.getExternalSchemaId());
        }
    }

    public static void verifySchemaExport(PTable newTable, Configuration conf) throws IOException {
        Assert.assertEquals((Object)DefaultSchemaRegistryRepository.getSchemaId((PTable)newTable), (Object)newTable.getExternalSchemaId());
        String expectedSchemaText = new DefaultSchemaWriter().exportSchema(newTable);
        String actualSchemaText = SchemaRegistryRepositoryFactory.getSchemaRegistryRepository((Configuration)conf).getSchemaById(newTable.getExternalSchemaId());
        String pattern = "(?i)\\s*timestamp:\\s\\d*";
        expectedSchemaText = expectedSchemaText.replaceAll(pattern, "");
        actualSchemaText = actualSchemaText.replaceAll(pattern, "");
        String externalSchemaPattern = "(?i)\\s*externalSchemaId:\\s\".*\"";
        expectedSchemaText = expectedSchemaText.replaceAll(externalSchemaPattern, "");
        actualSchemaText = actualSchemaText.replaceAll(externalSchemaPattern, "");
        String baseColumnCountPattern = "(?i)\\s*baseColumnCount:\\s\\d*";
        expectedSchemaText = expectedSchemaText.replaceAll(baseColumnCountPattern, "");
        actualSchemaText = actualSchemaText.replaceAll(baseColumnCountPattern, "");
        Assert.assertEquals((Object)expectedSchemaText, (Object)actualSchemaText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnForNewColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE  " + this.dataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD CF.col2 integer CF.IN_MEMORY=true");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"CF", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
            }
        }
    }

    private String generateDDLOptions(String options) {
        StringBuilder sb = new StringBuilder();
        if (!options.isEmpty()) {
            sb.append(options);
        }
        if (!this.tableDDLOptions.isEmpty()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(this.tableDDLOptions);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSaltedTableAsImmutable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + this.dataTableFullName + "(\n        SENDER_ID UNSIGNED_LONG NOT NULL,\n        RECIPIENT_ID UNSIGNED_LONG NOT NULL,\n        M_TIMESTAMP DATE  NOT NULL,\n        ROW_ID UNSIGNED_LONG NOT NULL,\n        IS_READ TINYINT,\n        IS_DELETED TINYINT,\n        VISIBILITY TINYINT,\n        B.SENDER_IP VARCHAR,\n        B.JSON VARCHAR,\n        B.M_TEXT VARCHAR\n        CONSTRAINT ROWKEY PRIMARY KEY\n(SENDER_ID,RECIPIENT_ID,M_TIMESTAMP DESC,ROW_ID))\n" + this.generateDDLOptions("SALT_BUCKETS=4");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET IMMUTABLE_ROWS=true";
            conn.createStatement().execute(ddl);
            conn.createStatement().executeQuery("select count(*) from " + this.dataTableFullName).next();
        }
    }

    @Test
    public void testSetPropertySchemaVersion() throws Exception {
        Properties props = new Properties();
        String schemaName = AlterTableIT.generateUniqueName();
        String tableName = AlterTableIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper((Connection)conn, schemaName, tableName, "V1.0", null);
            String version = "V1.1";
            String alterSql = "ALTER TABLE " + dataTableFullName + " SET SCHEMA_VERSION='V1.1'";
            conn.createStatement().execute(alterSql);
            PTable table = conn.getTableNoCache(dataTableFullName);
            Assert.assertEquals((Object)"V1.1", (Object)table.getSchemaVersion());
            String topicName = "MyTopicName";
            String alterSql2 = "ALTER TABLE " + dataTableFullName + " SET STREAMING_TOPIC_NAME='MyTopicName'";
            conn.createStatement().execute(alterSql2);
            table = conn.getTableNoCache(dataTableFullName);
            Assert.assertEquals((Object)"MyTopicName", (Object)table.getStreamingTopicName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropColumnFromSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + this.dataTableFullName + " (\n        SENDER_ID UNSIGNED_LONG NOT NULL,\n        RECIPIENT_ID UNSIGNED_LONG NOT NULL,\n        M_TIMESTAMP DATE  NOT NULL,\n        ROW_ID UNSIGNED_LONG NOT NULL,\n        IS_READ TINYINT,\n        IS_DELETED TINYINT,\n        VISIBILITY TINYINT,\n        B.SENDER_IP VARCHAR,\n        B.JSON VARCHAR,\n        B.M_TEXT VARCHAR\n        CONSTRAINT ROWKEY PRIMARY KEY\n(SENDER_ID,RECIPIENT_ID,M_TIMESTAMP DESC,ROW_ID))\n" + this.generateDDLOptions("SALT_BUCKETS=4");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN B.JSON";
            conn.createStatement().execute(ddl);
            conn.createStatement().executeQuery("select count(*) from " + this.dataTableFullName).next();
        }
    }

    @Test
    public void testAddVarCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + this.dataTableFullName + " VALUES(?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "b");
            stmt.execute();
            stmt.setString(1, "a");
            stmt.execute();
            conn.commit();
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + this.dataTableFullName + " WHERE a_string = 'a' ";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD c1.col2 VARCHAR, c1.col3 integer, c2.col4 integer";
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD col5 integer, c1.col2 VARCHAR";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_EXIST_IN_DEF.getErrorCode(), (long)e.getErrorCode());
            }
            query = "SELECT col5 FROM " + this.dataTableFullName;
            try {
                conn.createStatement().executeQuery(query);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 504 (42703): Undefined column."));
            }
            dml = "UPSERT INTO " + this.dataTableFullName + " VALUES(?, ?, ?, ?, ?)";
            stmt = conn.prepareStatement(dml);
            stmt.setString(1, "c");
            stmt.setInt(2, 100);
            stmt.setString(3, "d");
            stmt.setInt(4, 101);
            stmt.setInt(5, 102);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + this.dataTableFullName + " WHERE a_string = 'c' ";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)100L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"d", (Object)rs.getString(3));
            Assert.assertEquals((long)101L, (long)rs.getInt(4));
            Assert.assertEquals((long)102L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT c1.* FROM " + this.dataTableFullName + " WHERE a_string = 'c' ";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((long)101L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD IF NOT EXISTS col5 integer, c1.col2 VARCHAR";
            conn.createStatement().execute(ddl);
            query = "SELECT col5 FROM " + this.dataTableFullName;
            conn.createStatement().executeQuery(query);
            dml = "UPSERT INTO " + this.dataTableFullName + "(a_string, col1, col5) VALUES(?, ?, ?)";
            stmt = conn.prepareStatement(dml);
            stmt.setString(1, "e");
            stmt.setInt(2, 200);
            stmt.setInt(3, 201);
            stmt.execute();
            conn.commit();
            query = "SELECT a_string, col1, col5 FROM " + this.dataTableFullName + " WHERE a_string = 'e' ";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((long)200L, (long)rs.getInt(2));
            Assert.assertEquals((long)201L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropVarCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + this.dataTableFullName + "   (a_string varchar not null, col1 integer, cf1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN col1";
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN cf1.col2";
            conn.createStatement().execute(ddl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowAddingNotNullableColumnNotPartOfPkForExistingTable() throws Exception {
        block11: {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
                conn.setAutoCommit(false);
                try {
                    String ddl = "CREATE TABLE " + this.dataTableFullName + "   (a_string varchar not null, col1 integer, cf1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
                    conn.createStatement().execute(ddl);
                }
                finally {
                    TestUtil.closeStatement(stmt);
                }
                try {
                    stmt = conn.prepareStatement("ALTER TABLE " + this.dataTableFullName + " ADD b_string VARCHAR NOT NULL");
                    stmt.execute();
                    Assert.fail((String)"Should have failed since altering a table by adding a non-nullable column is not allowed.");
                }
                catch (SQLException e) {
                    try {
                        Assert.assertEquals((long)SQLExceptionCode.KEY_VALUE_NOT_NULL.getErrorCode(), (long)e.getErrorCode());
                    }
                    catch (Throwable throwable) {
                        TestUtil.closeStatement(stmt);
                        throw throwable;
                    }
                    TestUtil.closeStatement(stmt);
                    break block11;
                }
                TestUtil.closeStatement(stmt);
            }
            finally {
                TestUtil.closeConnection(conn);
            }
        }
    }

    private void asssertIsWALDisabled(Connection conn, String fullTableName, boolean expectedValue) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Assert.assertEquals((Object)expectedValue, (Object)pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).isWALDisabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableWAL1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("immutable_rows=true, disable_wal=true" + (String)(!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            Connection conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn2.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            this.asssertIsWALDisabled(conn2, this.dataTableFullName, true);
            conn2.close();
            this.asssertIsWALDisabled(conn, this.dataTableFullName, true);
            conn.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + " (col1) include (cf1.col2) SALT_BUCKETS=4");
            conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            query = "SELECT * FROM " + this.indexTableFullName;
            rs = conn2.createStatement().executeQuery(query);
            this.asssertIsWALDisabled(conn2, this.indexTableFullName, false);
            Assert.assertFalse((boolean)rs.next());
            conn2.close();
            this.asssertIsWALDisabled(conn, this.indexTableFullName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableWAL2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string))" + this.generateDDLOptions("immutable_rows=true" + (String)(!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            Connection conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn2.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            this.asssertIsWALDisabled(conn, this.dataTableFullName, false);
            conn2.close();
            this.asssertIsWALDisabled(conn, this.dataTableFullName, false);
            conn.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + " (col1) include (cf1.col2) SALT_BUCKETS=4");
            conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            query = "SELECT * FROM " + this.indexTableFullName;
            rs = conn2.createStatement().executeQuery(query);
            this.asssertIsWALDisabled(conn2, this.indexTableFullName, false);
            Assert.assertFalse((boolean)rs.next());
            conn2.close();
            this.asssertIsWALDisabled(conn, this.indexTableFullName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableWAL3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions);
            Connection conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn2.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            this.asssertIsWALDisabled(conn2, this.dataTableFullName, false);
            conn2.close();
            this.asssertIsWALDisabled(conn, this.dataTableFullName, false);
            conn.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + " (col1) include (cf1.col2) SALT_BUCKETS=4");
            conn2 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
            query = "SELECT * FROM " + this.indexTableFullName;
            rs = conn2.createStatement().executeQuery(query);
            this.asssertIsWALDisabled(conn2, this.indexTableFullName, false);
            Assert.assertFalse((boolean)rs.next());
            conn2.close();
            this.asssertIsWALDisabled(conn, this.indexTableFullName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropColumnsWithImutability() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("immutable_rows=true , SALT_BUCKETS=3 " + (String)(!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            String query = "SELECT * FROM " + this.dataTableFullName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + " (col1) include (cf1.col2) SALT_BUCKETS=4");
            query = "SELECT * FROM " + this.indexTableFullName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            String dml = "UPSERT INTO " + this.dataTableFullName + " VALUES(?,?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "b");
            stmt.setInt(2, 10);
            stmt.setInt(3, 20);
            stmt.setInt(4, 30);
            stmt.setInt(5, 40);
            stmt.execute();
            stmt.setString(1, "a");
            stmt.setInt(2, 101);
            stmt.setInt(3, 201);
            stmt.setInt(4, 301);
            stmt.setInt(5, 401);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + this.dataTableFullName + " order by col1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            String ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN IF EXISTS col2,col3";
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN a_string,col1";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_PK.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN col4,col5";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 504 (42703): Undefined column. columnName=" + this.dataTableFullName + ".COL5"));
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN IF EXISTS col1";
            conn.createStatement().execute(ddl);
            query = "SELECT * FROM " + this.indexTableFullName;
            try {
                rs = conn.createStatement().executeQuery(query);
                Assert.fail();
            }
            catch (TableNotFoundException e) {
                // empty catch block
            }
            query = "select col4 FROM " + this.dataTableFullName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            query = "select col2,col3 FROM " + this.dataTableFullName;
            try {
                rs = conn.createStatement().executeQuery(query);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void alterTableFromDifferentClient() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn3 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        Connection conn1 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn1.createStatement().execute("create table " + this.dataTableFullName + "(id VARCHAR PRIMARY KEY, field1 BIGINT) " + this.tableDDLOptions);
        PreparedStatement stmtInsert1 = conn1.prepareStatement("upsert into " + this.dataTableFullName + " (id, field1) values ( ?, ?)");
        stmtInsert1.setString(1, "key1");
        stmtInsert1.setLong(2, 1L);
        stmtInsert1.execute();
        conn1.commit();
        stmtInsert1.close();
        conn3.createStatement().execute("alter table " + this.dataTableFullName + " add field2 BIGINT");
        PreparedStatement pstmt2 = conn1.prepareStatement("upsert into " + this.dataTableFullName + " (id, field1, field2) values ( ?, ?, ?)");
        pstmt2.setString(1, "key2");
        pstmt2.setLong(2, 2L);
        pstmt2.setLong(3, 2L);
        pstmt2.execute();
        conn1.commit();
        pstmt2.close();
        conn1.close();
    }

    @Test
    public void testAddColumnsUsingNewConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.tableDDLOptions;
        Connection conn1 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD STRING VARCHAR, STRING_DATA_TYPES VARCHAR";
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN STRING, STRING_DATA_TYPES";
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD STRING_ARRAY1 VARCHAR[]";
        conn1.createStatement().execute(ddl);
        conn1.close();
    }

    @Test
    public void testAddColumnWithRetry_PostConcurrentFailureOnFirstTime() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID VARCHAR(15) PRIMARY KEY,\nCOL1 BIGINT) " + this.tableDDLOptions;
        Connection conn1 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        MetaDataEndpointImpl.setFailConcurrentMutateAddColumnOneTimeForTesting((boolean)true);
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD STRING VARCHAR, STRING_DATA_TYPES VARCHAR";
        conn1.createStatement().execute(ddl);
        ResultSet rs = conn1.getMetaData().getColumns("", "", this.dataTableFullName, null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ID", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL1", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"STRING", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"STRING_DATA_TYPES", (Object)rs.getString(4));
    }

    @Test
    public void testAddMultipleColumns() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID VARCHAR(15) PRIMARY KEY,\nCOL1 BIGINT) " + this.tableDDLOptions;
        Connection conn1 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + "(COL1)");
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD COL2 VARCHAR PRIMARY KEY, COL3 VARCHAR PRIMARY KEY";
        conn1.createStatement().execute(ddl);
        ResultSet rs = conn1.getMetaData().getColumns("", "", this.dataTableFullName, null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ID", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL1", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL2", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL3", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        rs = conn1.createStatement().executeQuery("SELECT COLUMN_COUNT FROM \"SYSTEM\".\"CATALOG\"\nWHERE TENANT_ID IS NULL AND\n(TABLE_SCHEM, TABLE_NAME) = ('" + this.schemaName + "','" + this.dataTableName + "') AND\nCOLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn1.createStatement().executeQuery("SELECT COLUMN_COUNT FROM \"SYSTEM\".\"CATALOG\"\nWHERE TENANT_ID IS NULL AND\n(TABLE_SCHEM, TABLE_NAME) = ('" + this.schemaName + "','" + this.indexTableName + "') AND\nCOLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('a',2,'a','b')");
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('b',3,'b','c')");
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('c',4,'c','c')");
        conn1.commit();
        rs = conn1.createStatement().executeQuery("SELECT ID,COL1 FROM " + this.dataTableFullName + " WHERE COL1=3");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn1.close();
    }

    @Test
    public void testDropMultipleColumns() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID VARCHAR(15) PRIMARY KEY,\nCOL1 BIGINT,COL2 BIGINT,COL3 BIGINT,COL4 BIGINT) " + this.tableDDLOptions;
        Connection conn1 = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("CREATE INDEX " + this.indexTableName + " ON " + this.dataTableFullName + "(COL1) INCLUDE (COL2,COL3,COL4)");
        ddl = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN COL2, COL3";
        conn1.createStatement().execute(ddl);
        ResultSet rs = conn1.getMetaData().getColumns("", "", this.dataTableFullName, null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ID", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL1", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"COL4", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        rs = conn1.createStatement().executeQuery("SELECT COLUMN_COUNT FROM \"SYSTEM\".\"CATALOG\"\nWHERE TENANT_ID IS NULL AND\n(TABLE_SCHEM, TABLE_NAME) = ('" + this.schemaName + "','" + this.dataTableName + "') AND\nCOLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn1.createStatement().executeQuery("SELECT COLUMN_COUNT FROM \"SYSTEM\".\"CATALOG\"\nWHERE TENANT_ID IS NULL AND\n(TABLE_SCHEM, TABLE_NAME) = ('" + this.schemaName + "','" + this.indexTableName + "') AND\nCOLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('a',2, 20)");
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('b',3, 30)");
        conn1.createStatement().execute("UPSERT INTO " + this.dataTableFullName + " VALUES ('c',4, 40)");
        conn1.commit();
        rs = conn1.createStatement().executeQuery("SELECT ID,COL1,COL4 FROM " + this.dataTableFullName + " WHERE COL1=3");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getLong(2));
        Assert.assertEquals((long)30L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        conn1.close();
    }

    @Test
    public void testAlterTableOnGlobalIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(false);
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            String tableName = AlterTableIT.generateUniqueName();
            String globalIndexTableName = AlterTableIT.generateUniqueName();
            stmt.execute("CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, COL1 VARCHAR(10), COL2 BOOLEAN)");
            stmt.execute("CREATE INDEX " + globalIndexTableName + " on " + tableName + " (COL2)");
            TableDescriptor originalDesc = admin.getDescriptor(TableName.valueOf((String)globalIndexTableName));
            boolean expectedErrorCode = false;
            try {
                stmt.execute("ALTER TABLE " + globalIndexTableName + " ADD CF1.AGE INTEGER ");
                conn.commit();
                Assert.fail((String)"The alter table did not fail as expected");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode());
            }
            TableDescriptor finalDesc = admin.getDescriptor(TableName.valueOf((String)globalIndexTableName));
            Assert.assertTrue((boolean)finalDesc.equals(originalDesc));
            stmt.execute("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testAlterStoreNulls() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + this.dataTableFullName + " (id SMALLINT PRIMARY KEY, name VARCHAR) " + this.tableDDLOptions);
        ResultSet rs = stmt.executeQuery("SELECT STORE_NULLS FROM \"SYSTEM\".\"CATALOG\" WHERE table_name = '" + this.dataTableFullName + "' AND STORE_NULLS IS NOT NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.execute("ALTER TABLE " + this.dataTableFullName + " SET STORE_NULLS = true");
        rs = stmt.executeQuery("SELECT STORE_NULLS FROM \"SYSTEM\".\"CATALOG\" WHERE table_name = '" + this.dataTableFullName + "' AND STORE_NULLS IS NOT NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddingPkColAndSettingProperties() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            String ddl = "create table " + this.dataTableFullName + " ( k1 char(1) NOT NULL, k2 integer NOT NULL, col1 bigint, CONSTRAINT NAME_PK PRIMARY KEY (k1, k2) ) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD k3 DECIMAL PRIMARY KEY COMPACTION_ENABLED = false";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD k3 DECIMAL PRIMARY KEY REPLICATION_SCOPE = 0";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD k3 DECIMAL PRIMARY KEY DISABLE_WAL = true";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD k3 DECIMAL PRIMARY KEY, col2 bigint, CF.col3 bigint IN_MEMORY = true, CF.IN_MEMORY=false, REPLICATION_SCOPE = 1";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.getMetaData().getPrimaryKeys("", this.schemaName, this.dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"K1", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"K2", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)2L, (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"K3", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)rs.getShort("KEY_SEQ"));
            Assert.assertFalse((boolean)rs.next());
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
                Assert.assertEquals((Object)"CF", (Object)columnFamilies[1].getNameAsString());
                Assert.assertEquals((Object)false, (Object)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[1].getScope());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientCacheUpdatedOnChangingPhoenixTableProperties() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.asssertIsWALDisabled(conn, this.dataTableFullName, false);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET DISABLE_WAL = true";
            conn.createStatement().execute(ddl);
            this.asssertIsWALDisabled(conn, this.dataTableFullName, true);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET DISABLE_WAL = false";
            conn.createStatement().execute(ddl);
            this.asssertIsWALDisabled(conn, this.dataTableFullName, false);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET MULTI_TENANT = true";
            conn.createStatement().execute(ddl);
            PTable t = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.dataTableFullName));
            Assert.assertTrue((boolean)t.isMultiTenant());
            ResultSet rs = conn.createStatement().executeQuery("SELECT DISABLE_WAL, MULTI_TENANT FROM \"SYSTEM\".\"CATALOG\"WHERE table_name = '" + this.dataTableFullName + "' AND DISABLE_WAL IS NOT NULL AND MULTI_TENANT IS NOT NULL");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getBoolean(1));
            Assert.assertTrue((boolean)rs.getBoolean(2));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
    }

    @Test
    public void testIndexColumnAsRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (PK1 DATE NOT NULL, PK2 VARCHAR NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1 ROW_TIMESTAMP, PK2)) " + this.tableDDLOptions);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), this.dataTableFullName));
            Assert.assertTrue((boolean)table.getColumnForColumnName("PK1").isRowTimestamp());
            Assert.assertFalse((boolean)table.getColumnForColumnName("PK2").isRowTimestamp());
            this.assertIsRowTimestampSet(this.schemaName, this.dataTableName, "PK1");
            String dataTableName2 = BaseTest.generateUniqueName();
            String dataTableFullName2 = SchemaUtil.getTableName((String)this.schemaName, (String)dataTableName2);
            conn.createStatement().execute("CREATE IMMUTABLE TABLE " + dataTableFullName2 + " (PK1 VARCHAR, PK2 DATE PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR, KV2 INTEGER)");
            table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), dataTableFullName2));
            Assert.assertFalse((boolean)table.getColumnForColumnName("PK1").isRowTimestamp());
            Assert.assertTrue((boolean)table.getColumnForColumnName("PK2").isRowTimestamp());
            this.assertIsRowTimestampSet(this.schemaName, dataTableName2, "PK2");
            conn.createStatement().execute("CREATE INDEX " + this.indexTableName + "  ON " + dataTableFullName2 + " (KV1) include (KV2)");
            PTable indexTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), this.indexTableFullName));
            String indexColName = IndexUtil.getIndexColumnName((PColumn)table.getColumnForColumnName("PK2"));
            Assert.assertTrue((boolean)indexTable.getColumnForColumnName(indexColName).isRowTimestamp());
            this.assertIsRowTimestampSet(this.schemaName, this.indexTableName, indexColName);
        }
    }

    @Test
    public void testDeclaringColumnAsRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (PK1 DATE NOT NULL, PK2 VARCHAR NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1 ROW_TIMESTAMP, PK2)) " + this.tableDDLOptions);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), this.dataTableFullName));
            Assert.assertTrue((boolean)table.getColumnForColumnName("PK1").isRowTimestamp());
            Assert.assertFalse((boolean)table.getColumnForColumnName("PK2").isRowTimestamp());
            this.assertIsRowTimestampSet(this.schemaName, this.dataTableName, "PK1");
            String dataTableName2 = BaseTest.generateUniqueName();
            String dataTableFullName2 = SchemaUtil.getTableName((String)this.schemaName, (String)dataTableName2);
            conn.createStatement().execute("CREATE IMMUTABLE TABLE " + dataTableFullName2 + " (PK1 VARCHAR, PK2 DATE PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR, KV2 INTEGER)");
            table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), dataTableFullName2));
            Assert.assertFalse((boolean)table.getColumnForColumnName("PK1").isRowTimestamp());
            Assert.assertTrue((boolean)table.getColumnForColumnName("PK2").isRowTimestamp());
            this.assertIsRowTimestampSet(this.schemaName, dataTableName2, "PK2");
            String viewTableName2 = dataTableName2 + "_VIEW";
            String viewTableFullName2 = SchemaUtil.getTableName((String)this.schemaName, (String)viewTableName2);
            try {
                conn.createStatement().execute("CREATE VIEW " + viewTableFullName2 + " (KV3 VARCHAR, KV4 DATE, KV5 INTEGER, CONSTRAINT PK PRIMARY KEY (KV3, KV4 ROW_TIMESTAMP) ) AS SELECT * FROM " + dataTableFullName2);
                Assert.fail((String)"Creating a view with a row_timestamp column in its pk constraint is not allowed");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.ROWTIMESTAMP_NOT_ALLOWED_ON_VIEW.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("CREATE VIEW " + viewTableFullName2 + " (KV3 VARCHAR, KV4 VARCHAR, KV5 INTEGER, CONSTRAINT PK PRIMARY KEY (KV3, KV4)) AS SELECT * FROM " + dataTableFullName2);
            PTable view = phxConn.getTable(new PTableKey(phxConn.getTenantId(), viewTableFullName2));
            Assert.assertNotNull((Object)view.getPKColumn("PK2"));
            Assert.assertTrue((boolean)view.getPKColumn("PK2").isRowTimestamp());
        }
    }

    private void assertIsRowTimestampSet(String schemaName, String tableName, String columnName) throws SQLException {
        String sql = "SELECT IS_ROW_TIMESTAMP FROM \"SYSTEM\".\"CATALOG\" WHERE (TABLE_SCHEM, TABLE_NAME) = ('" + schemaName + "','" + tableName + "') AND\nCOLUMN_FAMILY IS NULL AND COLUMN_NAME = ?";
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, columnName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        }
    }

    @Test
    public void testAddingRowTimestampColumnNotAllowedViaAlterTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (PK1 VARCHAR NOT NULL, PK2 VARCHAR NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2)) " + this.tableDDLOptions);
            try {
                conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD PK3 DATE PRIMARY KEY ROW_TIMESTAMP");
                Assert.fail((String)"Altering table to add a PK column as row_timestamp column should fail");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.ROWTIMESTAMP_CREATE_ONLY.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testCreatingTxnTableFailsIfTxnsDisabled() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.transactions.enabled", Boolean.toString(false));
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            try {
                conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "(k INTEGER PRIMARY KEY, v VARCHAR) " + this.generateDDLOptions("TRANSACTIONAL=true"));
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_IF_TXNS_DISABLED.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "(k INTEGER PRIMARY KEY, v VARCHAR)");
            try {
                conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " SET TRANSACTIONAL=true");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_IF_TXNS_DISABLED.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testMetadataForImmutableTable() throws Exception {
        String schemaName = "XYZ";
        String baseTableName = AlterTableIT.generateUniqueName();
        String viewName = AlterTableIT.generateUniqueName();
        String fullTableName = schemaName + "." + baseTableName;
        String fullViewName = schemaName + "." + viewName;
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + fullTableName + " ( ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, KV1 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY (ID, COL1, COL2) ) " + this.generateDDLOptions("IMMUTABLE_ROWS = true" + (String)(!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            PTable baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            long initBaseTableSeqNumber = baseTable.getSequenceNumber();
            PTable.EncodedCQCounter cqCounter = baseTable.getEncodedCQCounter();
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(12) : null), (Object)cqCounter.getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 12);
            this.assertEncodedCQValue("0", "KV1", schemaName, baseTableName, 11);
            this.assertSequenceNumber(schemaName, baseTableName, initBaseTableSeqNumber);
            String viewDDL = "CREATE VIEW " + fullViewName + " ( VIEW_COL1 INTEGER, A.VIEW_COL2 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(viewDDL);
            baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            PTable view = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullViewName));
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(13) : null), (Object)baseTable.getEncodedCQCounter().getNextQualifier("0"));
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(12) : null), (Object)baseTable.getEncodedCQCounter().getNextQualifier("A"));
            Assert.assertNull((String)"A view should always have the null cq counter", (Object)view.getEncodedCQCounter().getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 13);
            this.assertEncodedCQCounter("A", schemaName, baseTableName, 12);
            this.assertEncodedCQValue("0", "VIEW_COL1", schemaName, viewName, 12);
            this.assertEncodedCQValue("A", "VIEW_COL2", schemaName, viewName, 11);
            this.assertSequenceNumber(schemaName, baseTableName, initBaseTableSeqNumber + (long)(this.columnEncoded ? 1 : 0));
            this.assertSequenceNumber(schemaName, viewName, 0L);
        }
    }

    @Test
    public void testMetadataForMutableTable() throws Exception {
        String schemaName = "XYZ";
        String baseTableName = AlterTableIT.generateUniqueName();
        String viewName = AlterTableIT.generateUniqueName();
        String fullTableName = schemaName + "." + baseTableName;
        String fullViewName = schemaName + "." + viewName;
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + fullTableName + " ( ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, KV1 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY (ID, COL1, COL2) ) " + this.tableDDLOptions);
            PTable baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            long initBaseTableSeqNumber = baseTable.getSequenceNumber();
            PTable.EncodedCQCounter cqCounter = baseTable.getEncodedCQCounter();
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(12) : null), (Object)cqCounter.getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 12);
            this.assertEncodedCQValue("0", "KV1", schemaName, baseTableName, 11);
            this.assertSequenceNumber(schemaName, baseTableName, initBaseTableSeqNumber);
            String viewDDL = "CREATE VIEW " + fullViewName + " ( VIEW_COL1 INTEGER, A.VIEW_COL2 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(viewDDL);
            baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            PTable view = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullViewName));
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(14) : null), (Object)baseTable.getEncodedCQCounter().getNextQualifier("0"));
            Assert.assertNull((String)"A view should always have the null cq counter", (Object)view.getEncodedCQCounter().getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 14);
            this.assertEncodedCQValue("0", "VIEW_COL1", schemaName, viewName, 12);
            this.assertEncodedCQValue("A", "VIEW_COL2", schemaName, viewName, 13);
            this.assertSequenceNumber(schemaName, baseTableName, initBaseTableSeqNumber + (long)(this.columnEncoded ? 1 : 0));
            this.assertSequenceNumber(schemaName, viewName, 0L);
        }
    }

    @Test
    public void testAddingColumnsToTablesAndViews() throws Exception {
        String schemaName = AlterTableIT.generateUniqueName();
        String baseTableName = AlterTableIT.generateUniqueName();
        String viewName = AlterTableIT.generateUniqueName();
        String fullTableName = schemaName + "." + baseTableName;
        String fullViewName = schemaName + "." + viewName;
        Properties props = new Properties();
        props.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE SCHEMA " + schemaName);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " ( ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (ID, COL1, COL2) ) " + this.tableDDLOptions);
            PTable baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            long initBaseTableSeqNumber = baseTable.getSequenceNumber();
            String alterDDL = "ALTER TABLE " + fullTableName + " ADD COL3 VARCHAR PRIMARY KEY, COL4 INTEGER, COL5 VARCHAR, B.COL6 DECIMAL (10, 2)";
            conn.createStatement().execute(alterDDL);
            baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            PTable.EncodedCQCounter encodedCqCounter = baseTable.getEncodedCQCounter();
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(14) : null), (Object)encodedCqCounter.getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 14);
            this.assertEncodedCQValue("0", "COL4", schemaName, baseTableName, 11);
            this.assertEncodedCQValue("0", "COL5", schemaName, baseTableName, 12);
            this.assertEncodedCQValue("B", "COL6", schemaName, baseTableName, 13);
            long baseTableSeqNumBeforeAddingChildCols = initBaseTableSeqNumber + 1L;
            this.assertSequenceNumber(schemaName, baseTableName, baseTableSeqNumBeforeAddingChildCols);
            String viewDDL = "CREATE VIEW " + fullViewName + " ( VIEW_COL1 INTEGER, A.VIEW_COL2 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(viewDDL);
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 16);
            this.assertEncodedCQValue("0", "VIEW_COL1", schemaName, viewName, 14);
            this.assertEncodedCQValue("A", "VIEW_COL2", schemaName, viewName, 15);
            this.assertSequenceNumber(schemaName, baseTableName, this.columnEncoded ? initBaseTableSeqNumber + 2L : baseTableSeqNumBeforeAddingChildCols);
            viewDDL = "ALTER VIEW " + fullViewName + " ADD VIEW_COL3 DECIMAL(10, 2), A.VIEW_COL4 VARCHAR, B.VIEW_COL5 INTEGER";
            conn.createStatement().execute(viewDDL);
            baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            encodedCqCounter = baseTable.getEncodedCQCounter();
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(19) : null), (Object)encodedCqCounter.getNextQualifier("0"));
            PTable view = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullViewName));
            encodedCqCounter = view.getEncodedCQCounter();
            Assert.assertNull((String)"A view should always have the column qualifier counter as null", (Object)view.getEncodedCQCounter().getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 19);
            this.assertEncodedCQValue("0", "VIEW_COL1", schemaName, viewName, 14);
            this.assertEncodedCQValue("A", "VIEW_COL2", schemaName, viewName, 15);
            this.assertEncodedCQValue("0", "VIEW_COL3", schemaName, viewName, 16);
            this.assertEncodedCQValue("A", "VIEW_COL4", schemaName, viewName, 17);
            this.assertEncodedCQValue("B", "VIEW_COL5", schemaName, viewName, 18);
            this.assertSequenceNumber(schemaName, baseTableName, this.columnEncoded ? initBaseTableSeqNumber + 3L : baseTableSeqNumBeforeAddingChildCols);
            this.assertSequenceNumber(schemaName, viewName, 1L);
            alterDDL = "ALTER TABLE " + fullTableName + " ADD COL10 VARCHAR, A.COL11 INTEGER";
            conn.createStatement().execute(alterDDL);
            baseTable = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullTableName));
            encodedCqCounter = baseTable.getEncodedCQCounter();
            Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(21) : null), (Object)encodedCqCounter.getNextQualifier("0"));
            view = phxConn.getTable(new PTableKey(phxConn.getTenantId(), fullViewName));
            encodedCqCounter = view.getEncodedCQCounter();
            Assert.assertNull((String)"A view should always have the column qualifier counter as null", (Object)view.getEncodedCQCounter().getNextQualifier("0"));
            this.assertEncodedCQCounter("0", schemaName, baseTableName, 21);
            this.assertEncodedCQValue("0", "COL10", schemaName, baseTableName, 19);
            this.assertEncodedCQValue("A", "COL11", schemaName, baseTableName, 20);
            this.assertSequenceNumber(schemaName, baseTableName, this.columnEncoded ? initBaseTableSeqNumber + 4L : initBaseTableSeqNumber + 2L);
            this.assertSequenceNumber(schemaName, viewName, 1L);
        }
    }

    @Test
    public void testAddThenDropColumnTableDDLTimestamp() throws Exception {
        String tableDDL = "CREATE TABLE IF NOT EXISTS " + this.dataTableFullName + " ( ENTITY_ID integer NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (ENTITY_ID, COL1, COL2) ) " + this.generateDDLOptions("");
        String columnAddDDL = "ALTER TABLE " + this.dataTableFullName + " ADD COL3 varchar(50) NULL ";
        String columnDropDDL = "ALTER TABLE " + this.dataTableFullName + " DROP COLUMN COL3 ";
        long startTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            conn.createStatement().execute(tableDDL);
            long tableDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(this.dataTableFullName, startTS, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(columnAddDDL);
            tableDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(this.dataTableFullName, tableDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(columnDropDDL);
            CreateTableIT.verifyLastDDLTimestamp(this.dataTableFullName, tableDDLTimestamp + 1L, conn);
        }
    }

    private void assertEncodedCQValue(String columnFamily, String columnName, String schemaName, String tableName, int expectedValue) throws Exception {
        String query = "SELECT COLUMN_QUALIFIER FROM \"SYSTEM\".CATALOG WHERE TABLE_SCHEM = ? AND TABLE_NAME = ?  AND COLUMN_FAMILY = ? AND COLUMN_NAME = ? AND COLUMN_QUALIFIER IS NOT NULL";
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, columnFamily);
            stmt.setString(4, columnName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            if (this.columnEncoded) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(expectedValue), (byte[])rs.getBytes(1)));
            } else {
                Assert.assertTrue((boolean)Bytes.equals((byte[])columnName.getBytes(), (byte[])rs.getBytes(1)));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void assertEncodedCQCounter(String columnFamily, String schemaName, String tableName, int expectedValue) throws Exception {
        String query = "SELECT QUALIFIER_COUNTER FROM \"SYSTEM\".CATALOG WHERE TABLE_SCHEM = ? AND TABLE_NAME = ?  AND COLUMN_FAMILY = ? AND QUALIFIER_COUNTER IS NOT NULL";
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, columnFamily);
            ResultSet rs = stmt.executeQuery();
            if (this.columnEncoded) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)expectedValue, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            } else {
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    private void assertSequenceNumber(String schemaName, String tableName, long expectedSequenceNumber) throws Exception {
        String query = "SELECT TABLE_SEQ_NUM FROM \"SYSTEM\".CATALOG WHERE TABLE_SCHEM = ? AND TABLE_NAME = ? AND TABLE_SEQ_NUM IS NOT NULL AND COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL ";
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)expectedSequenceNumber, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableWithIndexesExtendPk() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        conn.setAutoCommit(false);
        String tableName = AlterTableIT.generateUniqueName();
        String indexName1 = "I_" + AlterTableIT.generateUniqueName();
        String indexName2 = "I_" + AlterTableIT.generateUniqueName();
        try {
            String ddl = "CREATE TABLE " + tableName + " (ORG_ID CHAR(15) NOT NULL, PARTITION_KEY CHAR(3) NOT NULL,  ACTIVITY_DATE DATE NOT NULL,  FK1_ID CHAR(15) NOT NULL,  FK2_ID CHAR(15) NOT NULL,  TYPE VARCHAR NOT NULL,  IS_OPEN BOOLEAN  CONSTRAINT PKVIEW PRIMARY KEY (ORG_ID, PARTITION_KEY, ACTIVITY_DATE, FK1_ID, FK2_ID, TYPE))";
            AlterTableIT.createTestTable(AlterTableIT.getUrl(), ddl);
            String idx1ddl = "CREATE INDEX " + indexName1 + " ON " + tableName + " (FK1_ID, ACTIVITY_DATE DESC) INCLUDE (IS_OPEN)";
            PreparedStatement stmt1 = conn.prepareStatement(idx1ddl);
            stmt1.execute();
            String idx2ddl = "CREATE INDEX " + indexName2 + " ON " + tableName + " (FK2_ID, ACTIVITY_DATE DESC) INCLUDE (IS_OPEN)";
            PreparedStatement stmt2 = conn.prepareStatement(idx2ddl);
            stmt2.execute();
            ddl = "ALTER TABLE " + tableName + " ADD SOURCE VARCHAR(25) NULL PRIMARY KEY";
            PreparedStatement stmt3 = conn.prepareStatement(ddl);
            stmt3.execute();
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testAddNonPKColumnWhenlastPKIsVARBINARYOrARRAY() throws Exception {
        String tableName1 = AlterTableIT.generateUniqueName();
        String tableName2 = AlterTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + tableName1 + " (id VARBINARY PRIMARY KEY, col1 INTEGER)";
            stmt.execute(ddl);
            String alterDdl = "ALTER TABLE " + tableName1 + " ADD col2 INTEGER";
            stmt.execute(alterDdl);
            String ddl2 = "CREATE TABLE " + tableName2 + " (id INTEGER ARRAY PRIMARY KEY, col1 INTEGER)";
            stmt.execute(ddl2);
            String alterDdl2 = "ALTER TABLE " + tableName2 + " ADD col2 INTEGER";
            stmt.execute(alterDdl2);
        }
    }

    @Test
    public void testTableExists() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
            String tableName = "randomTable";
            Table randomTable = cqs.getTable(Bytes.toBytes((String)tableName));
            Assert.assertNotNull((Object)randomTable);
            Assert.assertEquals((Object)randomTable.getName(), (Object)TableName.valueOf((String)tableName));
            try {
                cqs.getTableIfExists(Bytes.toBytes((String)tableName));
                Assert.fail((String)"Should have thrown TableNotFoundException");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)tableName, (Object)e.getTableName());
            }
            String fullTableName1 = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
            String ddl = "CREATE TABLE " + fullTableName1 + " (col1 INTEGER PRIMARY KEY, col2 INTEGER)";
            conn.createStatement().execute(ddl);
            String schemaName2 = AlterTableIT.generateUniqueName();
            String tableName2 = AlterTableIT.generateUniqueName();
            String fullTableName2 = SchemaUtil.getTableName((String)schemaName2, (String)tableName2);
            ddl = "CREATE TABLE " + fullTableName2 + " (col1 INTEGER PRIMARY KEY, col2 INTEGER)";
            conn.createStatement().execute(ddl);
            Table table1 = cqs.getTable(Bytes.toBytes((String)fullTableName1));
            Assert.assertNotNull((Object)table1);
            try {
                cqs.getTableIfExists(Bytes.toBytes((String)fullTableName1));
            }
            catch (TableNotFoundException e) {
                Assert.fail((String)"Should not throw TableNotFoundException");
            }
            AlterTableIT.disableAndDropNonSystemTables();
            Table t1 = cqs.getTable(Bytes.toBytes((String)fullTableName1));
            Assert.assertEquals((Object)t1.getName().getNameAsString(), (Object)fullTableName1);
            Table t2 = cqs.getTable(Bytes.toBytes((String)fullTableName2));
            Assert.assertEquals((Object)t2.getName().getNameAsString(), (Object)fullTableName2);
            try {
                cqs.getTableIfExists(Bytes.toBytes((String)fullTableName1));
                Assert.fail((String)"Should have thrown TableNotFoundException");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)this.dataTableName, (Object)e.getTableName());
                Assert.assertEquals((Object)this.schemaName, (Object)e.getSchemaName());
            }
            try {
                cqs.getTableIfExists(Bytes.toBytes((String)fullTableName2));
                Assert.fail((String)"Should have thrown TableNotFoundException");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)tableName2, (Object)e.getTableName());
                Assert.assertEquals((Object)schemaName2, (Object)e.getSchemaName());
            }
        }
    }

    @Test
    public void testAlterTableWithColumnQualifiers() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(AlterTableIT.getUrl(), props);
        String tableName = AlterTableIT.generateUniqueName();
        String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 12, INT3 INTEGER ENCODED_QUALIFIER 14) " + this.generateDDLOptions("IMMUTABLE_ROWS = true" + (String)(!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")) + " COLUMN_QUALIFIER_COUNTER ('0'=15)";
        conn.createStatement().execute(ddl);
        String addDdl = "ALTER TABLE \"" + tableName + "\" ADD CHAR1 char(10)";
        conn.createStatement().execute(addDdl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        if (this.columnEncoded) {
            Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        } else {
            Assert.assertEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        }
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((Object)(this.columnEncoded ? Integer.valueOf(16) : null), (Object)cqCounter.getNextQualifier("0"));
        if (this.columnEncoded) {
            Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
            Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
            Assert.assertEquals((long)14L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
            Assert.assertEquals((long)15L, (long)encodingScheme.decode(table.getColumnForColumnName("CHAR1").getColumnQualifierBytes()));
        }
    }

    @Test
    public void testChangePropertiesUpdatesLASTDDLTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableIT.getUrl());){
            String ddl = "CREATE TABLE  " + this.dataTableFullName + "  (a_string varchar not null, a_binary VARCHAR not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary)) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), this.dataTableFullName));
            long oldLastDDLTimestamp = table.getLastDDLTimestamp();
            LOGGER.info("Last DDL timestamp before changing property: " + oldLastDDLTimestamp);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " SET DISABLE_WAL = true");
            table = phxConn.getTable(new PTableKey(null, this.dataTableFullName));
            long newLastDDLTimestamp = table.getLastDDLTimestamp();
            LOGGER.info("Last DDL timestamp after changing property : " + newLastDDLTimestamp);
            Assert.assertTrue((String)"LastDDLTimestamp should have been updated", (newLastDDLTimestamp > oldLastDDLTimestamp ? 1 : 0) != 0);
        }
    }
}

