/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AlterSessionIT
extends ParallelStatsDisabledIT {
    private String tableName;

    @Before
    public void initTable() throws Exception {
        this.tableName = AlterSessionIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterSessionIT.getUrl(), props);){
            conn.createStatement().execute("create table " + this.tableName + " (col1 varchar primary key)");
        }
    }

    @Test
    public void testUpdateConsistency() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterSessionIT.getUrl(), props);){
            Statement st = conn.createStatement();
            st.execute("alter session set Consistency = 'timeline'");
            ResultSet rs = st.executeQuery("explain select * from " + this.tableName);
            Assert.assertEquals((Object)Consistency.TIMELINE, (Object)conn.unwrap(PhoenixConnection.class).getConsistency());
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((queryPlan.indexOf("TIMELINE") > 0 ? 1 : 0) != 0);
            st.execute("alter session set Consistency = 'strong'");
            rs = st.executeQuery("explain select * from " + this.tableName);
            queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((queryPlan.indexOf("TIMELINE") < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetConsistencyInURL() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AlterSessionIT.getUrl() + ";Consistency=TIMELINE", props);){
            Assert.assertEquals((Object)Consistency.TIMELINE, (Object)((PhoenixConnection)conn).getConsistency());
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery("explain select * from " + this.tableName);
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((queryPlan.indexOf("TIMELINE") > 0 ? 1 : 0) != 0);
            conn.close();
        }
    }
}

