/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.AlterTableIT;
import org.apache.phoenix.end2end.AlterTableWithViewsIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class AlterMultiTenantTableWithViewsIT
extends SplitSystemCatalogIT {
    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl(), tenantProps);
    }

    private static long getTableSequenceNumber(PhoenixConnection conn, String tableName) throws SQLException {
        PTable table = conn.getTable(new PTableKey(conn.getTenantId(), SchemaUtil.normalizeIdentifier((String)tableName)));
        return table.getSequenceNumber();
    }

    private static short getMaxKeySequenceNumber(PhoenixConnection conn, String tableName) throws SQLException {
        PTable table = conn.getTable(new PTableKey(conn.getTenantId(), SchemaUtil.normalizeIdentifier((String)tableName)));
        return SchemaUtil.getMaxKeySeq((PTable)table);
    }

    private static void verifyNewColumns(ResultSet rs, String ... values) throws SQLException {
        Assert.assertTrue((boolean)rs.next());
        int i = 1;
        for (String value : values) {
            Assert.assertEquals((Object)value, (Object)rs.getString(i++));
        }
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((long)values.length, (long)(i - 1));
    }

    @Test
    public void testCreateAndAlterViewsWithChangeDetectionEnabled() throws Exception {
        String tenantId = "TE_" + AlterMultiTenantTableWithViewsIT.generateUniqueName();
        String schemaName = "S_" + AlterMultiTenantTableWithViewsIT.generateUniqueName();
        String tableName = "T_" + AlterMultiTenantTableWithViewsIT.generateUniqueName();
        String globalViewName = "GV_" + AlterMultiTenantTableWithViewsIT.generateUniqueName();
        String tenantViewName = "TV_" + AlterMultiTenantTableWithViewsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullGlobalViewName = SchemaUtil.getTableName((String)schemaName, (String)globalViewName);
        String fullTenantViewName = SchemaUtil.getTableName((String)schemaName, (String)tenantViewName);
        PTable globalView = null;
        PTable alteredGlobalView = null;
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((boolean)table.isChangeDetectionEnabled());
            AlterTableIT.verifySchemaExport(table, AlterMultiTenantTableWithViewsIT.getUtility().getConfiguration());
            String globalViewDdl = "CREATE VIEW " + fullGlobalViewName + " (id2 CHAR(12) NOT NULL PRIMARY KEY, col3 BIGINT NULL)  AS SELECT * FROM " + fullTableName + " CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(globalViewDdl);
            globalView = conn.getTableNoCache(fullGlobalViewName);
            Assert.assertTrue((boolean)globalView.isChangeDetectionEnabled());
            PTableImpl.Builder builder = PTableImpl.builderFromExisting((PTable)globalView);
            builder.setBaseColumnCount(table.getColumns().size());
            globalView = builder.setColumns((Collection)globalView.getColumns()).build();
            AlterTableIT.verifySchemaExport(globalView, AlterMultiTenantTableWithViewsIT.getUtility().getConfiguration());
            String alterViewDdl = "ALTER VIEW " + fullGlobalViewName + " ADD id3 VARCHAR(12) NULL PRIMARY KEY,  col4 BIGINT NULL";
            conn.createStatement().execute(alterViewDdl);
            alteredGlobalView = conn.getTableNoCache(fullGlobalViewName);
            Assert.assertTrue((boolean)alteredGlobalView.isChangeDetectionEnabled());
            AlterTableIT.verifySchemaExport(alteredGlobalView, AlterMultiTenantTableWithViewsIT.getUtility().getConfiguration());
        }
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        try (PhoenixConnection tenantConn = (PhoenixConnection)DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl(), props);){
            String tenantViewDdl = "CREATE VIEW " + fullTenantViewName + " (col5 VARCHAR NULL)  AS SELECT * FROM " + fullGlobalViewName + " CHANGE_DETECTION_ENABLED=true";
            tenantConn.createStatement().execute(tenantViewDdl);
            PTable tenantView = tenantConn.getTableNoCache(fullTenantViewName);
            Assert.assertTrue((boolean)tenantView.isChangeDetectionEnabled());
            PTable tenantViewWithParents = ViewUtil.addDerivedColumnsFromParent((PhoenixConnection)tenantConn, (PTable)tenantView, (PTable)alteredGlobalView);
            AlterTableIT.verifySchemaExport(tenantViewWithParents, AlterMultiTenantTableWithViewsIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testAddDropColumnToBaseTablePropagatesToEntireViewHierarchy() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view3 = SchemaUtil.getTableName((String)SCHEMA4, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view4 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenant1 = TENANT1;
        String tenant2 = TENANT2;
        try (Connection conn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            conn.createStatement().execute(baseTableDDL);
            try (Connection tenant1Conn = this.getTenantConnection(tenant1);){
                String view1DDL = "CREATE VIEW " + view1 + " AS SELECT * FROM " + baseTable;
                tenant1Conn.createStatement().execute(view1DDL);
                String view2DDL = "CREATE VIEW " + view2 + " AS SELECT * FROM " + view1;
                tenant1Conn.createStatement().execute(view2DDL);
            }
            try (Connection tenant2Conn = this.getTenantConnection(tenant2);){
                String view3DDL = "CREATE VIEW " + view3 + " AS SELECT * FROM " + baseTable;
                tenant2Conn.createStatement().execute(view3DDL);
            }
            String view4DDL = "CREATE VIEW " + view4 + " AS SELECT * FROM " + baseTable;
            conn.createStatement().execute(view4DDL);
            String alterBaseTable = "ALTER TABLE " + baseTable + " ADD V3 VARCHAR";
            conn.createStatement().execute(alterBaseTable);
            conn.createStatement().execute("SELECT V3 FROM " + view4);
            try (Connection tenant1Conn = this.getTenantConnection(tenant1);){
                tenant1Conn.createStatement().execute("SELECT V3 from " + view1);
                tenant1Conn.createStatement().execute("SELECT V3 from " + view2);
            }
            try (Connection tenant2Conn2 = this.getTenantConnection(tenant2);){
                tenant2Conn2.createStatement().execute("SELECT V3 from " + view3);
            }
            alterBaseTable = "ALTER TABLE " + baseTable + " DROP COLUMN V1";
            conn.createStatement().execute(alterBaseTable);
            try {
                conn.createStatement().execute("SELECT V1 FROM " + view4);
                Assert.fail();
            }
            catch (ColumnNotFoundException tenant2Conn2) {
                // empty catch block
            }
            tenant1Conn = this.getTenantConnection(tenant1);
            try {
                try {
                    tenant1Conn.createStatement().execute("SELECT V1 from " + view1);
                    Assert.fail();
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                try {
                    tenant1Conn.createStatement().execute("SELECT V1 from " + view2);
                    Assert.fail();
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
            }
            finally {
                if (tenant1Conn != null) {
                    tenant1Conn.close();
                }
            }
            tenant2Conn2 = this.getTenantConnection(tenant2);
            try {
                try {
                    tenant2Conn2.createStatement().execute("SELECT V1 from " + view3);
                    Assert.fail();
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
            }
            finally {
                if (tenant2Conn2 != null) {
                    tenant2Conn2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangingPKOfBaseTableChangesPKForAllViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view3 = SchemaUtil.getTableName((String)SCHEMA4, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view4 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenant1 = TENANT1;
        String tenant2 = TENANT2;
        Connection tenant1Conn = null;
        Connection tenant2Conn = null;
        try (Connection globalConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            globalConn.createStatement().execute(baseTableDDL);
            tenant1Conn = this.getTenantConnection(tenant1);
            String view1DDL = "CREATE VIEW " + view1 + " AS SELECT * FROM " + baseTable;
            tenant1Conn.createStatement().execute(view1DDL);
            String view2DDL = "CREATE VIEW " + view2 + " AS SELECT * FROM " + view1;
            tenant1Conn.createStatement().execute(view2DDL);
            tenant2Conn = this.getTenantConnection(tenant2);
            String view3DDL = "CREATE VIEW " + view3 + " AS SELECT * FROM " + baseTable;
            tenant2Conn.createStatement().execute(view3DDL);
            String view4DDL = "CREATE VIEW " + view4 + " AS SELECT * FROM " + baseTable;
            globalConn.createStatement().execute(view4DDL);
            String alterBaseTable = "ALTER TABLE " + baseTable + " ADD NEW_PK varchar primary key ";
            globalConn.createStatement().execute(alterBaseTable);
            globalConn.createStatement().execute("SELECT * FROM " + baseTable);
            Assert.assertTrue((boolean)this.checkColumnPartOfPk(globalConn.unwrap(PhoenixConnection.class), "NEW_PK", baseTable));
            tenant1Conn.createStatement().execute("SELECT * FROM " + view1);
            Assert.assertTrue((boolean)this.checkColumnPartOfPk(tenant1Conn.unwrap(PhoenixConnection.class), "NEW_PK", view1));
            tenant1Conn.createStatement().execute("SELECT * FROM " + view2);
            Assert.assertTrue((boolean)this.checkColumnPartOfPk(tenant1Conn.unwrap(PhoenixConnection.class), "NEW_PK", view2));
            tenant2Conn.createStatement().execute("SELECT * FROM " + view3);
            Assert.assertTrue((boolean)this.checkColumnPartOfPk(tenant2Conn.unwrap(PhoenixConnection.class), "NEW_PK", view3));
            globalConn.createStatement().execute("SELECT * FROM " + view4);
            Assert.assertTrue((boolean)this.checkColumnPartOfPk(globalConn.unwrap(PhoenixConnection.class), "NEW_PK", view4));
        }
        finally {
            if (tenant1Conn != null) {
                try {
                    tenant1Conn.close();
                }
                catch (Throwable throwable) {}
            }
            if (tenant2Conn != null) {
                try {
                    tenant2Conn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private boolean checkColumnPartOfPk(PhoenixConnection conn, String columnName, String tableName) throws SQLException {
        String normalizedTableName = SchemaUtil.normalizeIdentifier((String)tableName);
        PTable table = conn.getTable(new PTableKey(conn.getTenantId(), normalizedTableName));
        List pkCols = table.getPKColumns();
        String normalizedColumnName = SchemaUtil.normalizeIdentifier((String)columnName);
        for (PColumn pkCol : pkCols) {
            if (!pkCol.getName().getString().equals(normalizedColumnName)) continue;
            return true;
        }
        return false;
    }

    private int getIndexOfPkColumn(PhoenixConnection conn, String columnName, String tableName) throws SQLException {
        String normalizedTableName = SchemaUtil.normalizeIdentifier((String)tableName);
        PTable table = conn.getTable(new PTableKey(conn.getTenantId(), normalizedTableName));
        List pkCols = table.getPKColumns();
        String normalizedColumnName = SchemaUtil.normalizeIdentifier((String)columnName);
        int i = 0;
        for (PColumn pkCol : pkCols) {
            if (pkCol.getName().getString().equals(normalizedColumnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Test
    public void testAddPKColumnToBaseTableWhoseViewsHaveIndices() throws Exception {
        PhoenixConnection phxConn;
        ResultSet rs;
        Statement stmt;
        String upsert;
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view3 = SchemaUtil.getTableName((String)SCHEMA4, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view2Schema = SCHEMA3;
        String view3Schema = SCHEMA4;
        String tenant1 = TENANT1;
        String tenant2 = TENANT2;
        String view2Index = AlterMultiTenantTableWithViewsIT.generateUniqueName() + "_IDX";
        String view3Index = AlterMultiTenantTableWithViewsIT.generateUniqueName() + "_IDX";
        try (Connection globalConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            globalConn.createStatement().execute("CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, K1 varchar not null, V1 VARCHAR, V2 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, K1)) MULTI_TENANT = true ");
        }
        String fullView2IndexName = SchemaUtil.getTableName((String)view2Schema, (String)view2Index);
        try (Connection viewConn = this.getTenantConnection(tenant1);){
            viewConn.createStatement().execute("CREATE VIEW " + view1 + " AS SELECT * FROM " + baseTable);
            PhoenixConnection phxConn2 = viewConn.unwrap(PhoenixConnection.class);
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn2, view1));
            Assert.assertEquals((long)2L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn2, view1));
            viewConn.createStatement().execute("CREATE VIEW " + view2 + " AS SELECT * FROM " + view1);
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn2, view2));
            Assert.assertEquals((long)2L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn2, view2));
            viewConn.createStatement().execute("CREATE INDEX " + view2Index + " ON " + view2 + " (v1) include (v2)");
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn2, fullView2IndexName));
            Assert.assertEquals((long)4L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn2, fullView2IndexName));
        }
        String fullView3IndexName = SchemaUtil.getTableName((String)view3Schema, (String)view3Index);
        try (Connection viewConn = this.getTenantConnection(tenant2);){
            viewConn.createStatement().execute("CREATE VIEW " + view3 + " AS SELECT * FROM " + baseTable);
            PhoenixConnection phxConn3 = viewConn.unwrap(PhoenixConnection.class);
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn3, view3));
            Assert.assertEquals((long)2L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn3, view3));
            viewConn.createStatement().execute("CREATE INDEX " + view3Index + " ON " + view3 + " (v1) include (v2)");
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn3, fullView3IndexName));
            Assert.assertEquals((long)4L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn3, fullView3IndexName));
        }
        try (Connection globalConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            globalConn.createStatement().execute("ALTER TABLE " + baseTable + " ADD v3 VARCHAR, k2 VARCHAR PRIMARY KEY, k3 VARCHAR PRIMARY KEY");
            Assert.assertEquals((long)4L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(globalConn.unwrap(PhoenixConnection.class), baseTable));
            upsert = "UPSERT INTO " + baseTable + " (TENANT_ID, K1, K2, K3, V1, V2, V3) VALUES (?, ?, ?, ?, ?, ?, ?)";
            stmt = globalConn.prepareStatement(upsert);
            stmt.setString(1, tenant1);
            stmt.setString(2, "K1");
            stmt.setString(3, "K2");
            stmt.setString(4, "K3");
            stmt.setString(5, "V1");
            stmt.setString(6, "V2");
            stmt.setString(7, "V3");
            stmt.executeUpdate();
            stmt.setString(1, tenant2);
            stmt.setString(2, "K11");
            stmt.setString(3, "K22");
            stmt.setString(4, "K33");
            stmt.setString(5, "V11");
            stmt.setString(6, "V22");
            stmt.setString(7, "V33");
            stmt.executeUpdate();
            globalConn.commit();
        }
        viewConn = this.getTenantConnection(tenant1);
        try {
            rs = viewConn.createStatement().executeQuery("SELECT K2, K3, V3 FROM " + view1);
            phxConn = viewConn.unwrap(PhoenixConnection.class);
            Assert.assertEquals((long)2L, (long)this.getIndexOfPkColumn(phxConn, "k2", view1));
            Assert.assertEquals((long)3L, (long)this.getIndexOfPkColumn(phxConn, "k3", view1));
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn, view1));
            Assert.assertEquals((long)4L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn, view1));
            AlterMultiTenantTableWithViewsIT.verifyNewColumns(rs, "K2", "K3", "V3");
            rs = viewConn.createStatement().executeQuery("SELECT K2, K3, V3 FROM " + view2);
            Assert.assertEquals((long)2L, (long)this.getIndexOfPkColumn(phxConn, "k2", view2));
            Assert.assertEquals((long)3L, (long)this.getIndexOfPkColumn(phxConn, "k3", view2));
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn, view2));
            Assert.assertEquals((long)4L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn, view2));
            AlterMultiTenantTableWithViewsIT.verifyNewColumns(rs, "K2", "K3", "V3");
            Assert.assertEquals((long)4L, (long)this.getIndexOfPkColumn(phxConn, IndexUtil.getIndexColumnName(null, (String)"k2"), fullView2IndexName));
            Assert.assertEquals((long)5L, (long)this.getIndexOfPkColumn(phxConn, IndexUtil.getIndexColumnName(null, (String)"k3"), fullView2IndexName));
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn, fullView2IndexName));
            Assert.assertEquals((long)6L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn, fullView2IndexName));
        }
        finally {
            if (viewConn != null) {
                viewConn.close();
            }
        }
        viewConn = this.getTenantConnection(tenant2);
        try {
            rs = viewConn.createStatement().executeQuery("SELECT K2, K3, V3 FROM " + view3);
            phxConn = viewConn.unwrap(PhoenixConnection.class);
            Assert.assertEquals((long)2L, (long)this.getIndexOfPkColumn(phxConn, "k2", view3));
            Assert.assertEquals((long)3L, (long)this.getIndexOfPkColumn(phxConn, "k3", view3));
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn, view3));
            AlterMultiTenantTableWithViewsIT.verifyNewColumns(rs, "K22", "K33", "V33");
            Assert.assertEquals((long)4L, (long)this.getIndexOfPkColumn(phxConn, IndexUtil.getIndexColumnName(null, (String)"k2"), fullView3IndexName));
            Assert.assertEquals((long)5L, (long)this.getIndexOfPkColumn(phxConn, IndexUtil.getIndexColumnName(null, (String)"k3"), fullView3IndexName));
            Assert.assertEquals((long)0L, (long)AlterMultiTenantTableWithViewsIT.getTableSequenceNumber(phxConn, fullView3IndexName));
            Assert.assertEquals((long)6L, (long)AlterMultiTenantTableWithViewsIT.getMaxKeySequenceNumber(phxConn, fullView3IndexName));
        }
        finally {
            if (viewConn != null) {
                viewConn.close();
            }
        }
        viewConn = this.getTenantConnection(tenant1);
        try {
            upsert = "UPSERT INTO " + view2 + " (K1, K2, K3, V1, V2, V3) VALUES ('key1', 'key2', 'key3', 'value1', 'value2', 'value3')";
            viewConn.createStatement().executeUpdate(upsert);
            viewConn.commit();
            stmt = viewConn.createStatement();
            String sql = "SELECT V2 FROM " + view2 + " WHERE V1 = 'value1' AND K3 = 'key3'";
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(sql);
            Assert.assertEquals((Object)fullView2IndexName, (Object)plan.getTableRef().getTable().getName().getString());
            ResultSet rs2 = viewConn.createStatement().executeQuery(sql);
            AlterMultiTenantTableWithViewsIT.verifyNewColumns(rs2, "value2");
        }
        finally {
            if (viewConn != null) {
                viewConn.close();
            }
        }
    }

    @Test
    public void testAddingPkAndKeyValueColumnsToBaseTableWithDivergedView() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String divergedView = SchemaUtil.getTableName((String)SCHEMA4, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String divergedViewSchemaName = SchemaUtil.getSchemaNameFromFullName((String)divergedView);
        String divergedViewIndex = AlterMultiTenantTableWithViewsIT.generateUniqueName() + "_IDX";
        String tenant1 = TENANT1;
        String tenant2 = TENANT2;
        try (Connection conn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());
             Connection tenant1Conn = this.getTenantConnection(tenant1);
             Connection tenant2Conn = this.getTenantConnection(tenant2);){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            conn.createStatement().execute(baseTableDDL);
            String view1DDL = "CREATE VIEW " + view1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 CHAR(256)) AS SELECT * FROM " + baseTable;
            tenant1Conn.createStatement().execute(view1DDL);
            String divergedViewDDL = "CREATE VIEW " + divergedView + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 CHAR(256)) AS SELECT * FROM " + baseTable;
            tenant2Conn.createStatement().execute(divergedViewDDL);
            tenant2Conn.createStatement().execute("ALTER VIEW " + divergedView + " DROP COLUMN V2");
            String indexDDL = "CREATE INDEX " + divergedViewIndex + " ON " + divergedView + " (V1) include (V3)";
            tenant2Conn.createStatement().execute(indexDDL);
            String alterBaseTable = "ALTER TABLE " + baseTable + " ADD KV VARCHAR, PK2 VARCHAR PRIMARY KEY";
            conn.createStatement().execute(alterBaseTable);
            tenant1Conn.createStatement().execute("SELECT KV from " + view1);
            tenant1Conn.createStatement().execute("SELECT PK2 from " + view1);
            tenant2Conn.createStatement().execute("SELECT PK2 from " + divergedView);
            try {
                tenant2Conn.createStatement().execute("SELECT KV FROM " + divergedView);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            String upsert = "UPSERT INTO " + divergedView + " (PK1, PK2, V1, V3) VALUES ('PK1', 'PK2', 'V1', 'V3')";
            try (Connection viewConn = this.getTenantConnection(tenant2);){
                viewConn.createStatement().executeUpdate(upsert);
                viewConn.commit();
                Statement stmt = viewConn.createStatement();
                String sql = "SELECT V3 FROM " + divergedView + " WHERE V1 = 'V1' AND PK2 = 'PK2'";
                QueryPlan plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(sql);
                Assert.assertEquals((Object)SchemaUtil.getTableName((String)divergedViewSchemaName, (String)divergedViewIndex), (Object)plan.getTableRef().getTable().getName().getString());
                ResultSet rs = viewConn.createStatement().executeQuery(sql);
                AlterMultiTenantTableWithViewsIT.verifyNewColumns(rs, "V3");
            }
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant1Conn, view1, PTableType.VIEW, baseTable, 0, 7, 5, "PK1", "V1", "V2", "V3", "KV", "PK2", "VIEW_COL1", "VIEW_COL2");
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant2Conn, divergedView, PTableType.VIEW, baseTable, 1, 6, -100, "PK1", "V1", "V3", "PK2", "VIEW_COL1", "VIEW_COL2");
            try {
                alterBaseTable = "ALTER TABLE " + baseTable + " ADD VIEW_COL2 CHAR(256)";
                conn.createStatement().execute(alterBaseTable);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testAddColumnsToSaltedBaseTableWithViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenant = TENANT1;
        try (Connection conn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());
             Connection tenant1Conn = this.getTenantConnection(tenant);){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true, SALT_BUCKETS = 4";
            conn.createStatement().execute(baseTableDDL);
            String view1DDL = "CREATE VIEW " + view1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 CHAR(256)) AS SELECT * FROM " + baseTable;
            tenant1Conn.createStatement().execute(view1DDL);
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(conn, baseTable, PTableType.TABLE, null, 1, 6, -1, "TENANT_ID", "PK1", "V1", "V2", "V3");
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant1Conn, view1, PTableType.VIEW, baseTable, 0, 8, 6, "PK1", "V1", "V2", "V3", "VIEW_COL1", "VIEW_COL2");
            String alterBaseTable = "ALTER TABLE " + baseTable + " ADD KV VARCHAR, PK2 VARCHAR PRIMARY KEY";
            conn.createStatement().execute(alterBaseTable);
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(conn, baseTable, PTableType.TABLE, null, 2, 7, -1, "TENANT_ID", "PK1", "V1", "V2", "V3", "KV", "PK2");
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant1Conn, view1, PTableType.VIEW, baseTable, 0, 8, 6, "PK1", "V1", "V2", "V3", "KV", "PK2", "VIEW_COL1", "VIEW_COL2");
            tenant1Conn.createStatement().execute("SELECT KV from " + view1);
            tenant1Conn.createStatement().execute("SELECT PK2 from " + view1);
        }
    }

    @Test
    public void testDropColumnsFromSaltedBaseTableWithViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenant = TENANT1;
        try (Connection conn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());
             Connection tenant1Conn = this.getTenantConnection(tenant);){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true , SALT_BUCKETS = 4";
            conn.createStatement().execute(baseTableDDL);
            String view1DDL = "CREATE VIEW " + view1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 CHAR(256)) AS SELECT * FROM " + baseTable;
            tenant1Conn.createStatement().execute(view1DDL);
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(conn, baseTable, PTableType.TABLE, null, 1, 6, -1, "TENANT_ID", "PK1", "V1", "V2", "V3");
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant1Conn, view1, PTableType.VIEW, baseTable, 0, 8, 6, "PK1", "V1", "V2", "V3", "VIEW_COL1", "VIEW_COL2");
            String alterBaseTable = "ALTER TABLE " + baseTable + " DROP COLUMN V2";
            conn.createStatement().execute(alterBaseTable);
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(conn, baseTable, PTableType.TABLE, null, 2, 4, -1, "TENANT_ID", "PK1", "V1", "V3");
            AlterMultiTenantTableWithViewsIT.assertTableDefinition(tenant1Conn, view1, PTableType.VIEW, baseTable, 0, 8, 6, "PK1", "V1", "V3", "VIEW_COL1", "VIEW_COL2");
            try {
                conn.createStatement().execute("SELECT V2 from " + baseTable);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                tenant1Conn.createStatement().execute("SELECT V2 from " + view1);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testAlteringViewConditionallyModifiesHTableMetadata() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenant = TENANT1;
        try (Connection conn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            conn.createStatement().execute(baseTableDDL);
            TableDescriptor tableDesc1 = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin().getDescriptor(TableName.valueOf((String)baseTable));
            try (Connection tenant1Conn = this.getTenantConnection(tenant);){
                String view1DDL = "CREATE VIEW " + view1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 CHAR(256)) AS SELECT * FROM " + baseTable;
                tenant1Conn.createStatement().execute(view1DDL);
                String alterView = "ALTER VIEW " + view1 + " ADD NEWCOL1 VARCHAR";
                tenant1Conn.createStatement().execute(alterView);
                TableDescriptor tableDesc2 = tenant1Conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin().getDescriptor(TableName.valueOf((String)baseTable));
                Assert.assertEquals((Object)tableDesc1, (Object)tableDesc2);
                alterView = "ALTER VIEW " + view1 + " ADD CF.NEWCOL2 VARCHAR";
                tenant1Conn.createStatement().execute(alterView);
                tableDesc2 = tenant1Conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin().getDescriptor(TableName.valueOf((String)baseTable));
                Assert.assertFalse((boolean)tableDesc2.equals(tableDesc1));
                Assert.assertNotNull((Object)tableDesc2.getColumnFamily(Bytes.toBytes((String)"CF")));
                alterView = "ALTER VIEW " + view1 + " ADD CF.NEWCOL3 VARCHAR";
                tenant1Conn.createStatement().execute(alterView);
                TableDescriptor tableDesc3 = tenant1Conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin().getDescriptor(TableName.valueOf((String)baseTable));
                Assert.assertTrue((boolean)tableDesc3.equals(tableDesc2));
                Assert.assertNotNull((Object)tableDesc3.getColumnFamily(Bytes.toBytes((String)"CF")));
            }
        }
    }

    @Test
    public void testCacheInvalidatedAfterAddingColumnToBaseTableWithViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenantId = TENANT1;
        try (Connection globalConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String tableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true";
            globalConn.createStatement().execute(tableDDL);
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl(), tenantProps);){
                String viewDDL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + baseTable;
                tenantConn.createStatement().execute(viewDDL);
                globalConn.createStatement().execute("ALTER TABLE " + baseTable + " ADD NEW_COL VARCHAR");
                tenantConn.createStatement().execute("SELECT NEW_COL FROM " + viewName);
                tenantConn.createStatement().execute("SELECT NEW_COL FROM " + baseTable);
            }
        }
    }

    @Test
    public void testCacheInvalidatedAfterDroppingColumnFromBaseTableWithViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterMultiTenantTableWithViewsIT.generateUniqueName());
        String tenantId = TENANT1;
        try (Connection globalConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl());){
            String tableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true";
            globalConn.createStatement().execute(tableDDL);
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(AlterMultiTenantTableWithViewsIT.getUrl(), tenantProps);){
                String viewDDL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + baseTable;
                tenantConn.createStatement().execute(viewDDL);
                globalConn.createStatement().execute("ALTER TABLE " + baseTable + " DROP COLUMN V1");
                try {
                    tenantConn.createStatement().execute("SELECT V1 FROM " + viewName);
                    Assert.fail();
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                try {
                    tenantConn.createStatement().execute("SELECT V1 FROM " + baseTable);
                    Assert.fail();
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public static void assertTableDefinition(Connection conn, String fullTableName, PTableType tableType, String parentTableName, int sequenceNumber, int columnCount, int baseColumnCount, String ... columnName) throws Exception {
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableName);
        PreparedStatement p = conn.prepareStatement("SELECT * FROM \"SYSTEM\".\"CATALOG\" WHERE TABLE_SCHEM=? AND TABLE_NAME=? AND TABLE_TYPE=?");
        p.setString(1, schemaName);
        p.setString(2, tableName);
        p.setString(3, tableType.getSerializedValue());
        ResultSet rs = p.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in BaseColumnCount"), (long)baseColumnCount, (long)rs.getInt("BASE_COLUMN_COUNT"));
        Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in columnCount"), (long)columnCount, (long)rs.getInt("COLUMN_COUNT"));
        Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in sequenceNumber"), (long)sequenceNumber, (long)rs.getInt("TABLE_SEQ_NUM"));
        rs.close();
        ResultSet parentTableColumnsRs = null;
        if (parentTableName != null) {
            parentTableColumnsRs = conn.getMetaData().getColumns(null, null, parentTableName, null);
            parentTableColumnsRs.next();
        }
        ResultSet viewColumnsRs = conn.getMetaData().getColumns(null, schemaName, tableName, null);
        for (int i = 0; i < columnName.length; ++i) {
            if (columnName[i] == null) continue;
            Assert.assertTrue((boolean)viewColumnsRs.next());
            Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in columnName: i=" + i), (Object)columnName[i], (Object)viewColumnsRs.getString("COLUMN_NAME"));
            int viewColOrdinalPos = viewColumnsRs.getInt("ORDINAL_POSITION");
            Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in ordinalPosition: i=" + i), (long)(i + 1), (long)viewColOrdinalPos);
            if (parentTableColumnsRs == null || parentTableColumnsRs.isAfterLast()) continue;
            ResultSetMetaData parentTableColumnsMetadata = parentTableColumnsRs.getMetaData();
            Assert.assertEquals((long)parentTableColumnsMetadata.getColumnCount(), (long)viewColumnsRs.getMetaData().getColumnCount());
            int parentTableColOrdinalRs = parentTableColumnsRs.getInt("ORDINAL_POSITION");
            Assert.assertEquals((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, "Mismatch in ordinalPosition of view and base table for i=" + i), (long)parentTableColOrdinalRs, (long)viewColOrdinalPos);
            for (int columnIndex = 1; columnIndex < parentTableColumnsMetadata.getColumnCount(); ++columnIndex) {
                String parentTableColumnValue;
                String viewColumnValue = viewColumnsRs.getString(columnIndex);
                if (Objects.equal((Object)viewColumnValue, (Object)(parentTableColumnValue = parentTableColumnsRs.getString(columnIndex))) || !parentTableColumnsMetadata.getColumnName(columnIndex).equals("TABLE_NAME")) continue;
                Assert.assertEquals((Object)parentTableName, (Object)parentTableColumnValue);
                Assert.assertEquals((Object)fullTableName, (Object)viewColumnValue);
            }
            parentTableColumnsRs.next();
        }
        Assert.assertFalse((String)AlterTableWithViewsIT.getSystemCatalogEntriesForTable(conn, fullTableName, ""), (boolean)viewColumnsRs.next());
    }
}

