/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.HashMap;
import org.apache.phoenix.end2end.AggregateWithRegionMovesIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class AggregateWithRegionMoves2IT
extends AggregateWithRegionMovesIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateWithRegionMoves2IT.class);
    private static int countOfValidResults = 0;

    @Override
    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        countOfValidResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        props.put("phoenix.scanning.result.post.valid.process", TestScanningResultPostValidResultCaller.class.getName());
        AggregateWithRegionMoves2IT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (ParallelStatsDisabledWithRegionMovesIT.hasTestStarted && ParallelStatsDisabledWithRegionMovesIT.countOfDummyResults++ % 3 == 0 && (ParallelStatsDisabledWithRegionMovesIT.countOfDummyResults < 17 || ParallelStatsDisabledWithRegionMovesIT.countOfDummyResults > 28 && ParallelStatsDisabledWithRegionMovesIT.countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES, (Object)ParallelStatsDisabledWithRegionMovesIT.countOfDummyResults);
                ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES.forEach(table -> {
                    try {
                        ParallelStatsDisabledWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }

    private static class TestScanningResultPostValidResultCaller
    extends ScanningResultPostValidResultCaller {
        private TestScanningResultPostValidResultCaller() {
        }

        public void postValidRowProcess() {
            if (ParallelStatsDisabledWithRegionMovesIT.hasTestStarted && (countOfValidResults < 17 || countOfValidResults > 28 && countOfValidResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of valid results: {}", ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES, (Object)countOfValidResults);
                ++countOfValidResults;
                ParallelStatsDisabledWithRegionMovesIT.TABLE_NAMES.forEach(table -> {
                    try {
                        ParallelStatsDisabledWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

